import QtQuick 2.3
import AdaptDemoSystem 1.0

// Screen Space Reflection as done in Reflexion/Adapt 2013...
// assumes to have depth R and normal GB textureRT named "depth"
Effect {
    id: reflect
    name: "reflect"
    effectName: "Reflect"

    Blit {
        textureRT: "bg"
        blitRT: 0
    }
    Shader {
        file: "fx/_SharedQML/reflect"
    }
    Texture {
        textureUnit: 0
        textureRT: "bg"
      //  textureRT: "prevNormal"
      //  textureRT: "prevBlur"
    }
    Texture {
        textureUnit: 1
        textureRT: "depth"
    }
    Texture {
        textureUnit: 2
        textureRT: "mainDepth"
     //   textureRT: "prevNormal"
    }
    Texture {
        textureUnit: 3
        textureRT: "prev"
    }

    Texture { textureUnit: 5; textureRT: "pardexMask" }

    DrawVB {
        ShaderParam { paramName: "flip"; paramValue: 0.0 }
        ShaderParam { paramName: "g_reflectAmount"; syncName: ns("amount"); syncDefault: 0.5 }
        ShaderParam { paramName: "g_addBlend"; syncName: ns("addBlend"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_distFade"; syncName: ns("distFade"); syncDefault: 0.5 }
        ShaderParam { paramName: "g_distBase"; syncName: ns("distBase"); syncDefault: 0.9 }
        ShaderParam { paramName: "g_fakeAO"; syncName: ns("fakeAO"); syncDefault: 0.82 }
        ShaderParam { paramName: "g_prevRefl"; syncName: ns("prevRefl"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_noise"; syncName: ns("noise"); syncDefault: 0.02 }
        ShaderParam { paramName: "g_maxDist"; syncName: ns("maxDist"); syncDefault: 0.2 }
        ShaderParam { paramName: "g_bgBaseAmount"; paramValue: 1.0-sync("reflectBlur.ON") }
        ShaderParam { paramName: "g_loops"; syncName: ns("loops"); syncDefault: 32 }
        ShaderParam { paramName: "g_noisePhase"; syncName: ns("noise.phase"); syncDefault: 0.0 }

        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }

    BlurReflect {
    }

}
