import QtQuick 2.3
import AdaptDemoSystem 1.0
import QtGraphicalEffects 1.0
import "../"
import "../_SharedQML"

Effect {
    id: fx
    name: "textor"
    effectName: "Textor"

    enabled: syncRootOn(fx.name, effectName)

    // RT>0: render effect to rendertarget with name "fxRT"+RT & "fxRTP"+RT
    property int effectRT: s("RT", 0)
    property string effectRTName: "fxRT"+(effectRT.toString())
    property string effectRTPrevName: "fxRTP"+(effectRT.toString())
    property bool clearRT: s("RT.clear", 1.0) > 0.5

    property real ofsX: sf("posX")
    property real ofsY: sf("posY")

//    property var txts: [
//        "A D A P T",  // 0
//        "PRESENTS",
//        "A DEMO",     // 2
//        "OF THE 2020",
//        "
//:<br>A D A P T<br>
//:<br>
//.2020<br>
//.<br>
//-= deepr -=- mistral =-<br>-=- basscadet -=- legend =-<br>-= felor -=- minomus =-<br>"
//    ]


        property var txts: [
            "KINGDOM OF<br>FIRE",  // 0
            "DEEPR", // 1
            "BASSCADET",     // 2
            "MISTRAL", // 3
            "LEGEND", // 4
            "FELOR", // 5
            "MINOMUS", // 6
            "HUMANOID", // 7
            "WAKE UP",  // 8
            "King", // 9
            "of", // 10
            "rock", // 11
            "King of rock", // 12
            "BRIMSTONE", // 13
            "W A K E  U P", // 14
            "D R E A M", // 15
            "E M B E R", // 16
            "A D A P T", // 17
            "ADAPT ON FIRE", // 18
            "CHOOSE Fire", // 19
            "KING OF ROCK", // 20
            "APTDACOTL", // 21
            "2 0 2 0", // 22
            "THE DEMO", // 23
            "OF THE", // 24
            "ADAPT", // 25
            "EMBER", // 26
            "DREAM", // 27
            "U' Choose", // 28
        ]

    property string txtShuf: ""

    property real charsRandom: s("chars.state")
    property real charsOfs: s("chars.ofs")
    property real charsSwitchRandom: s("chars.switchRandom", 5.0)
    property real charsSwitchWidth: s("chars.switchWidth", 3.0)

    function getRandomInt(maxValue) {
        return Math.floor(Math.random() * maxValue);
    }

    property var rnds: {[]}
    property int rndsInited: 0

    Component.onCompleted: {
        rnds = [];
        for (var i=0; i<1000; i++) {
            rnds.push(Math.random());
        }
        rndsInited = 1000;
    }

    function getRandomFC(i, maxValue) {
        if (rndsInited <= i) return 0;
        // return 0;
        return Math.floor(rnds[Math.floor(maxValue)%1000]*Math.floor(maxValue*0.50));
    }

    property int txtSel: Math.min(Math.max(s("text"), 0), txts.length);

    function updateShuf() {
        var txtRes = "";

        var txtOrig = txts[txtSel];

        if (txtOrig === undefined) {
          txtShuf = txtRes;
          return;
        }

        var len = txtOrig.length;

        for (var i=0; i<len; i++) {
            var crr = 1.0;
            if (charsRandom < 0.0) {
                crr = Math.max(-charsRandom*len-(i), 0.0);
            } else {
                crr = Math.max(charsRandom*len-(len-i), 0.0);
            }

            if (crr > charsSwitchWidth || txtOrig.charAt(i) === " ") {
                txtRes += "&nbsp;";
                //txtShuf += " ";
                continue;
            }
            crr *= charsSwitchRandom;
            //  txtRes += "-";
            txtRes += String.fromCharCode(txtOrig.charCodeAt(i)+charsOfs+getRandomFC(i, crr));
        }

        txtShuf = txtRes;
    }

    onCharsRandomChanged: {
        updateShuf();
    }
    onCharsOfsChanged: {
        updateShuf();
    }

    property string txt: txtShuf

    //    FontLoader {
    //        name: "Expansiva"
    //        source: "../../fonts/expansiva/Expansiva.otf"
    //    }


//    RenderTarget {
//        enabled: effectRT>0
//        RenderTargetLayer {
//            textureRT: effectRTName; format: "RGBA32F";
//            width: effectWidth; height: effectHeight
//            Clear {
//                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
//            }
//        }
//    }

    RenderTarget {
        enabled: effectRT>0 && clearRT
        RenderTargetLayer {
            textureRT: effectRTPrevName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
        DrawRT {
            textureRT: effectRTName
            drawBuffers: 1
        }
    }

    RenderTarget {
        enabled: effectRT>0
        RenderTargetLayer {
            textureRT: effectRTName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                enabled: clearRT
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
            mode: 1 // mode 1 = start render to the effect RT
        }
    }


    FontLoader {
        name: "Telegrama"; source: "../../fonts/telegrama/telegrama_render.otf"
    }
    FontLoader {
        name: "Play Pretend"; source: "../../fonts/play_pretend/Play Pretend.otf"
    }
    FontLoader {
        name: "Lequire DEMO"; source: "../../fonts/Lequire.otf"
    }
    FontLoader {
        name: "Lucid Streams"; source: "../../fonts/LucidStreams.otf"
    }
    FontLoader {
        name: "Nomark"; source: "../../fonts/Nomark.otf"
    }
    FontLoader {
        name: "Shaker Rocker"; source: "../../fonts/ShakerRocker.ttf"
    }
    FontLoader {
        name: "Almere Script"; source: "../../fonts/Almere Script.ttf"
    }
    FontLoader {
        name: "FORCED SQUARE"; source: "../../fonts/FORCED SQUARE.ttf"
    }

    Item {
        visible: false
        enabled: false
        id: infoText
        layer.enabled: true
        width: demo.windowWidth
        height: demo.windowHeight
        Item {
            id: texts
            anchors.fill: parent
            Text {
                id: textu
                x: ofsX*demo.windowWidth
                y: ofsY*demo.windowHeight
                // ShaderParam { paramName: "zoom"; paramValue: s("draw.zoom", 1.0) }
                opacity: s("alpha", 1.0)
                font.pixelSize: s("font.size")*(demo.windowWidth/1280.0)
                color: s("color", 0.0) < 0.5 ? "white" : "black"
                font.family: {
                    var fontIndex = s("font.type", 0);
                    if (fontIndex === 0) return "Telegrama";
                    if (fontIndex === 1) return "Play Pretend";
                    if (fontIndex === 2) return "Lequire DEMO";
                    if (fontIndex === 3) return "Lucid Streams";
                    if (fontIndex === 4) return "Nomark";
                    if (fontIndex === 5) return "Shaker Rocker";
                    if (fontIndex === 6) return "Almere Script";
                    if (fontIndex === 7) return "FORCED SQUARE";

                    return "Telegrama";
                }
                text: txt
                width: (1280.0-0.0)*(demo.windowWidth/1280.0)
                height: demo.windowHeight
                wrapMode: Text.WordWrap
                //textFormat: Text.PlainText
                textFormat: Text.RichText
                //textFormat: Text.StyledText

                antialiasing: true
                smooth: true
                // anchors.horizontalCenter : parent.horizontalCenter
            }

        }
    }

    TextureSel { id: texOvlSel; textureUnit: 0; nameOverride: fx.name+".ovl.texInd";  }
    property real ovlScale: s("ovl.scale", 1.0);
    property real ovlPosX: s("ovl.posX", 0.0);
    property real ovlPosY: s("ovl.posY", 0.0);
    DrawRT {
      enabled: texOvlSel.texInd > 0
    //  property real size: 0.5 //  1024.0/1280.0
      center: Qt.vector2d(ovlPosX, ovlPosY)
      sca: Qt.vector2d(ovlScale, ovlScale)
     // sca: texPreviewAspect < 16.0/9.0 ? Qt.vector2d(size*texPreviewTextureSel.texWidth/texPreviewTextureSel.texHeight*9.0/16.0, -size) : Qt.vector2d(size, -size*texPreviewTextureSel.texHeight/texPreviewTextureSel.texWidth*16.0/9.0)
      blendMode: "off"
      flip: false
    }

    DrawRT {
        visible: s("ON") > 0.5
        enabled: s("ON") > 0.5
        textureItem: infoText
        flip: false
    }



    RenderTarget {
        enabled: effectRT>0
        RenderTargetLayer {
            textureRT: effectRTName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            mode: 2 // mode 2 = end render to the effect RT
        }
    }



}

