#version 430

// layout (location=0) in vec3 vertexPosition;

layout(binding=0) uniform sampler2D texPartPos;
layout(binding=1) uniform sampler2D texPartCol;

out vec2 posV;
out vec4 colV;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float g_time;

uniform float effectWidth;
uniform float effectHeight;

void main() {
  vec4 vp = vec4(0.0);

  float id = float(gl_VertexID);
  vp = vec4(0.0, 0.0, 0.0, 1.0);
  float idq = id; // quad index

  vec2 fpt;
  ivec2 pt;
  fpt.y = floor(idq/effectWidth);
  fpt.x = idq-fpt.y*effectWidth;
  pt = ivec2(fpt);

  vec4 pp = texelFetch(texPartPos, pt, 0);
  vec4 pc = texelFetch(texPartCol, pt, 0);
  //vec4 pp = texture2D(tex, fpt/vec2(effectWidth, effectHeight));

  vp.xy += pp.xy*1.0+0.0*(fpt.xy/effectWidth*2.0-vec2(1.0));

  if (pp.z < 0.01) vp.xy*=0.0;

  float fd = 1.0;
  if (pp.z > 2.0) {
    fd = 1.0-min(pp.z-2.0, 1.0);
    fd *= fd;
  } else if (pp.z > 0.0) {
    fd = pp.z;
    fd *= fd;
  }

  vp.xy *= 1.0;

  posV = vp.xy;
  colV = vec4(1.0)*fd;
  colV.z = fd;
  colV.w = 1.0;
  if (pp.z < 0.01) colV.w = 0.0;
}
