import QtQuick 2.3
import "../"
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    id: skene

    Defaults {}

    Texture { textureUnit: 3; textureRT: "prev" }
    Texture { textureUnit: 4; textureRT: "prevBlur" }
    Texture { textureUnit: 5; textureRT: "prevNormal" }

    property int pardexTransmitRes: 16 // 4096x4096

    property var flyCam

    Group {
        id: sb
    }

    Item {

    }

    Connections {
        target: root
        onReloadEffects: {
            loadBlocks();
        }
    }

    property var sbi

    function createEffect(effectName, effectId, st, et) {
        var fxScript = "../_SharedQML/"+effectName+".qml";
        console.log("loading fx:"+fxScript);
        var component = Qt.createComponent(fxScript);
        if (component.status === Component.Error) {
            console.log("component load error")
        }
        return component.createObject(sb, {name: effectId, startTime: st, endTime: et});
    }

    function loadBlocks() {

        console.log("SKENE RELOAD, child items count: "+sb.children.length)

        if (sbi === undefined) {
            sbi = {}
        } else {
            // reload
            var sbik = Object.keys(sbi);
            for (var i=0; i<sbik.length; i++) {
                sbi[sbik[i]].destroy(0);
                sbi[sbik[i]] = undefined;
            }
            sb.children = [];
            sbi = {}
        }
        for (var bi=0; bi<demoBlocks.length; bi++) {
            var sbk = demoBlocks[bi].id;
            var effectName = demoBlocks[bi].effect;

            var startTime = demoBlocks[bi].startTime;
            var endTime = demoBlocks[bi].endTime;

            if (effectName === "Camera") {
                effectName = "FlyCamera";
            }

            var preEffectName = "";
            if (effectName === "Lighter") {
                preEffectName = "LighterView";
            }

            if (preEffectName !== "") {
                sbi[sbk+"_pre"] = createEffect(preEffectName, sbk);
            }
            sbi[sbk] = createEffect(effectName, sbk);

            if (effectName === "FlyCamera") {
                flyCam = sbi[sbk];
            }
        }
    }
    //    if (component.status === Component.Loading) {
    //        console.log("component still loading")
    //    }



    Component.onCompleted: {
        console.log("LOAD BLOCKS for SKENE")
        loadBlocks();
    }

    // Circlos { id: circlos; name: "circlos1" }
    // Textor { id: textor; name: "textor1" }
    // Partiklos { id: partiklos; name: "partiklos1" }
    // Partor { name: "partor1" }
    // Edges { name: "edges1" }
    // Distancer { name: "distancer1" }

    // FlatMesh { name: "flatMesh1" }

    //    FlyCamera { id: flyCam; name: "camera1" }
    //    Mesh { name: "mesh1" }
    //    Tonemap { name: "tonemap1" }

    // Feed { name: "feed1" }

    // §Credits { name: "credits1" }

    SMAA {}
}
