import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
    id: effect
    name: "ballex"

    Shader { file: "ballex" }
    TextureSel { id: tex; name: effect.name; textureUnit: 0; }

    property int bumpTex: s("bump.texInd")
    property string bumpTexNameOverride:  effect.name+".bump.texInd"
    TextureSel { id: texBump; nameOverride:  bumpTex>=0 ? (effect.name+".bump.texInd") : effect.name+".texInd0"; textureUnit: 1; }

    TextureSel { id: texHill; nameOverride: effect.name+".hill.texInd"; textureUnit: 2; }

    property real div: s("div")

    DrawVB {
        type: "emptyVBO"
        primType: "triangles"
        vboId: sceneName+effect.name+"ballex"
        depthTest: true; depthWrite: true
        blendMode: "off"

     //   drawNumPoints: 6*6*effect.div*effect.div  // cube
        drawNumPoints: 6*effect.div*effect.div  // ball

        Pos { x: s("x"); y: s("y"); z: s("z")}
        Rot { d: s("rot.x"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: s("rot.y"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: s("rot.z"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync(effect.name+".scale"); x: 1.0; y: 1.0; z: 1.0 }

        ShaderParam { paramName: "div"; paramValue: div }
        ShaderParam { paramName: "noiseAmp"; paramValue: s("noise.amp") }
        ShaderParam { paramName: "noiseOfsX"; paramValue: s("noise.ofs.x") }
        ShaderParam { paramName: "noiseOfsY"; paramValue: s("noise.ofs.y") }
        ShaderParam { paramName: "noiseOfsZ"; paramValue: s("noise.ofs.z") }
        ShaderParam { paramName: "noisePos"; paramValue: s("noise.pos") }
        ShaderParam { paramName: "noiseFreq"; paramValue: s("noise.freq") }
        ShaderParam { paramName: "noiseExp"; paramValue: s("noise.exp") }
        ShaderParam { paramName: "noiseSub"; paramValue: s("noise.sub") }
        ShaderParam { paramName: "noiseOct"; paramValue: s("noise.oct.num") }
        ShaderParam { paramName: "noiseOctMul"; paramValue: s("noise.oct.mul") }
        ShaderParam { paramName: "noiseOctAmp"; paramValue: s("noise.oct.amp") }

        ShaderParam { paramName: "minLim"; paramValue: s("minLim") }
        ShaderParam { paramName: "fadeArea"; paramValue: s("fadeArea") }
        ShaderParam { paramName: "fadeAmp"; paramValue: s("fadeAmp") }
        ShaderParam { paramName: "splineEnabled"; paramValue: s("splineEnabled") }

        ShaderParam { paramName: "hillBrightMul"; paramValue: s("hill.bright.mul") }
        ShaderParam { paramName: "hillBrightOfs"; paramValue: s("hill.bright.ofs") }
        ShaderParam { paramName: "hillBrightExp"; paramValue: s("hill.bright.exp") }
        ShaderParam { paramName: "hillTexFade"; paramValue: s("hill.tex.fade") }
        ShaderParam { paramName: "hillTexFadeExp"; paramValue: s("hill.tex.fadeExp") }
        ShaderParam { paramName: "hillTexFadeOfs"; paramValue: s("hill.tex.fadeOfs") }

        ShaderParam { paramName: "explo"; paramValue: s("explo") }

        ShaderParam { paramName: "subAmp"; paramValue: s("sub.amp") }
        ShaderParam { paramName: "subFreq"; paramValue: s("sub.freq") }
        ShaderParam { paramName: "subSinFreq"; paramValue: s("sub.sinFreq") }
        ShaderParam { paramName: "subEps"; paramValue: s("sub.eps") }
        ShaderParam { paramName: "subPos"; paramValue: s("sub.pos") }
        ShaderParam { paramName: "subBaseNorm"; paramValue: s("sub.baseNorm") }

        ShaderParam { paramName: "specAmp"; paramValue: s("spec.amp") }
        ShaderParam { paramName: "specExp"; paramValue: s("spec.exp") }
        ShaderParam { paramName: "diffAmp"; paramValue: s("diff.amp") }
        ShaderParam { paramName: "diffExp"; paramValue: s("diff.exp") }
        ShaderParam { paramName: "ambient"; paramValue: s("ambient") }
        ShaderParam { paramName: "texAmount"; paramValue: s("texAmount") }

        ShaderParam { paramName: "uvScale"; paramValue: s("uvScale") }

        ShaderParam { paramName: "bumpUvScale"; paramValue: s("bump.uvScale") }
        ShaderParam { paramName: "bumpStrength"; paramValue: s("bump.strength") }
        ShaderParam { paramName: "bumpTexDelta"; paramValue: s("bump.texDelta") }

        ShaderParam { paramName: "bumpTexInd"; paramValue: bumpTex }

        ShaderParam { paramName: "scaleX"; paramValue: s("scale.x") }
        ShaderParam { paramName: "scaleY"; paramValue: s("scale.y") }
        ShaderParam { paramName: "scaleZ"; paramValue: s("scale.z") }

    }
}
