import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

Group {
    id: partSim
    name: "partSim"
    property string forceName: "partSim"
    property string simShader: "simPart"
    property alias simShaderParams: simPar.delegate
    property string drawShader: "partWater"
    property alias drawShaderParams: drawPar.delegate
    property string drawBlendMode: "add"
    property int gridDimension: 600
    property int drawNumPoints: 100*100
    property bool drawEnabled: true
    property bool drawDepthEnabled: sync(partSim.name+".draw.depthEnabled") > 0.5

//    property string texture0: "../../images/particles_64_2048.png"

    property real partSize: 0.50

//    property string texture2: "../../images/adapt_logo2_full.png"

    property int particleCount: advanceSim.particleCount


    onParticleCountChanged: {
        root.setCustomText(name, name+": particle count", "Particle count:"+particleCount);
    }

    signal particleCountTo(int pc)

    Blit {
        textureRT: "screenBuffer"
    }

//    Texture {
//        textureUnit: 0
//        textureItem: particleTexture
//        Image {
//            id: particleTexture
//            source: texture0
//        }
//    }

    property alias tex0: t0.delegate
    Repeater { id: t0; model: 1 }

//    property alias tex1: t1.delegate
//    Repeater { id: t1; model: 1 }

   Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "../../images/system/random16.png"
        }
    }

   property alias tex2: t2.delegate
   Repeater { id: t2; model: 1 }


//    Texture {
//        textureUnit: 2
//        textureItem: particleAgeSwipe
//        Image {
//            id: particleAgeSwipe
//            visible: false
//            source: texture2

//        }
//    }

    Texture {
        textureUnit: 3
        textureRT: "depth" // world space normal in rgb components
    }


    Texture {
        textureUnit: 4
        textureRT: "mainDepth"
    }

    //    Texture {
    //        textureUnit: 2
    //        textureRT: "screenBuffer"
    //    }

//    Texture {
//        textureUnit: 3
//        textureItem: particleEnv
//        Image {
//            id: particleEnv
//            visible: false
//            source: "../../images/Bright-roof-multi.jpg"
//        }
//    }


    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------

    property string shaderVaryings: "
        vec3 posG;
        vec2 uvG;
        vec3 velG;
        float ageG;
        float recG;
        float ageSplitG;"
     //   vec4 posInitG;"

    Shader {
        file: sceneDir+simShader
        tfVaryings: shaderVaryings
    }

    VariClock {
        id: simNoiseMoveX
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.x")
        reset: sync(spaceVortex.name+".sim.reset")
    }
    VariClock {
        id: simNoiseMoveY
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.y")
        reset: sync(spaceVortex.name+".sim.reset")
    }
    VariClock {
        id: simNoiseMoveZ
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.z")
        reset: sync(spaceVortex.name+".sim.reset")
    }

/*
    DrawVB {
        id: advanceSim
        enabled: true
        type: "pointGrid"
        vboId: sceneName+partSim.name

        property real resetOn: sync(partSim.name+".sim.reset")

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
            } else {
                reset = 0.0;
            }
        }

        onParticleCountChanged: {
            particleCountTo(particleCount);
        }

        tfVaryings: shaderVaryings

        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        depthTest: false; depthWrite: false

        ShaderParam { paramName: "g_gridDim"; paramValue: partSim.gridDimension }
        ShaderParam { paramName: "g_velDamping"; paramValue: sync(partSim.name+".sim.velDamping") }
        ShaderParam { paramName: "g_noiseScale"; paramValueVec4: sync(partSim.forceName+".simNoiseScale.x")+","+sync(partSim.forceName+".simNoiseScale.y")+","+sync(partSim.forceName+".simNoiseScale.z") }
        ShaderParam { paramName: "g_noiseMove"; paramValueVec4: simNoiseMoveX.time+","+simNoiseMoveY.time+","+simNoiseMoveZ.time }
        ShaderParam { paramName: "g_noiseOfs"; paramValueVec4: sync(partSim.name+".simDirForce.x")+","+sync(partSim.name+".simDirForce.y")+","+sync(partSim.name+".simDirForce.z") }
        ShaderParam { paramName: "g_force"; paramValue: sync(partSim.forceName+".sim.force") }
        ShaderParam { paramName: "g_noiseFreq"; paramValue: sync(partSim.forceName+".sim.noiseFreq") }
        ShaderParam { paramName: "g_speed"; paramValue: sync(partSim.forceName+".sim.speed") }
        ShaderParam { paramName: "g_maxAge"; paramValue: sync(partSim.name+".sim.maxAge") }
        ShaderParam { paramName: "g_elasticity"; paramValue: sync(partSim.name+".sim.elasticity") }
        ShaderParam { paramName: "g_splitThr"; paramValue: sync(partSim.name+".sim.splitThr") }
        ShaderParam { paramName: "g_splitAmpRand"; paramValue: sync(partSim.name+".sim.splitAmpRand") }
        ShaderParam { paramName: "g_splitAmpNorm"; paramValue: sync(partSim.name+".sim.splitAmpNorm") }
        ShaderParam { paramName: "g_noiseSpeed"; paramValue: sync(partSim.name+".sim.noiseSpeed") }

        // inject custom shader params
        Repeater { id: simPar; model: 1 }

    }
*/
    DrawVB {
        id: advanceSim
        type: "drawStart"; primType: "points"; vboId: sceneName+partSim.name; tfVaryings: shaderVaryings;
        enabled: true
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints
        depthTest: false; depthWrite: false
        ShaderParam { paramName: "g_emit"; paramValue: 1.0}
        property real resetOn: sync(partSim.name+".sim.reset")
        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
            } else {
                reset = 0.0;
            }
        }
        onParticleCountChanged: {
            particleCountTo(particleCount);
        }
        // Repeater { id: tsp; model: 1 }
        // inject custom shader params
        Repeater { id: simPar; model: 1 }

        ShaderParam { paramName: "g_emit"; paramValue: 1.0}
        ShaderParam { paramName: "g_gridDim"; paramValue: partSim.gridDimension }
        ShaderParam { paramName: "g_velDamping"; paramValue: sync(partSim.name+".sim.velDamping") }
        ShaderParam { paramName: "g_noiseScale"; paramValueVec4: sync(partSim.forceName+".simNoiseScale.x")+","+sync(partSim.forceName+".simNoiseScale.y")+","+sync(partSim.forceName+".simNoiseScale.z") }
        ShaderParam { paramName: "g_noiseMove"; paramValueVec4: simNoiseMoveX.time+","+simNoiseMoveY.time+","+simNoiseMoveZ.time }
        ShaderParam { paramName: "g_noiseOfs"; paramValueVec4: sync(partSim.name+".simDirForce.x")+","+sync(partSim.name+".simDirForce.y")+","+sync(partSim.name+".simDirForce.z") }
        ShaderParam { paramName: "g_force"; paramValue: sync(partSim.forceName+".sim.force") }
        ShaderParam { paramName: "g_noiseFreq"; paramValue: sync(partSim.forceName+".sim.noiseFreq") }
        ShaderParam { paramName: "g_speed"; paramValue: sync(partSim.forceName+".sim.speed") }
        ShaderParam { paramName: "g_maxAge"; paramValue: sync(partSim.name+".sim.maxAge") }
        ShaderParam { paramName: "g_elasticity"; paramValue: sync(partSim.name+".sim.elasticity") }
        ShaderParam { paramName: "g_splitThr"; paramValue: sync(partSim.name+".sim.splitThr") }
        ShaderParam { paramName: "g_splitAmpRand"; paramValue: sync(partSim.name+".sim.splitAmpRand") }
        ShaderParam { paramName: "g_splitAmpNorm"; paramValue: sync(partSim.name+".sim.splitAmpNorm") }
        ShaderParam { paramName: "g_noiseSpeed"; paramValue: sync(partSim.name+".sim.noiseSpeed") }

    }


    DrawVB {
        id: advanceSim2
        enabled: true
        type: "pointGridDraw"
        primType: "points"
        vboId: sceneName+partSim.name

        property real resetOn: sync(partSim.name+".sim.reset")

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
            } else {
                reset = 0.0;
            }
        }

        onParticleCountChanged: {
            particleCountTo(particleCount);
        }

        tfVaryings: shaderVaryings

        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        depthTest: false; depthWrite: false

        ShaderParam { paramName: "g_emit"; paramValue: 1.0}
        ShaderParam { paramName: "g_gridDim"; paramValue: partSim.gridDimension }
        ShaderParam { paramName: "g_velDamping"; paramValue: sync(partSim.name+".sim.velDamping") }
        ShaderParam { paramName: "g_noiseScale"; paramValueVec4: sync(partSim.forceName+".simNoiseScale.x")+","+sync(partSim.forceName+".simNoiseScale.y")+","+sync(partSim.forceName+".simNoiseScale.z") }
        ShaderParam { paramName: "g_noiseMove"; paramValueVec4: simNoiseMoveX.time+","+simNoiseMoveY.time+","+simNoiseMoveZ.time }
        ShaderParam { paramName: "g_noiseOfs"; paramValueVec4: sync(partSim.name+".simDirForce.x")+","+sync(partSim.name+".simDirForce.y")+","+sync(partSim.name+".simDirForce.z") }
        ShaderParam { paramName: "g_force"; paramValue: sync(partSim.forceName+".sim.force") }
        ShaderParam { paramName: "g_noiseFreq"; paramValue: sync(partSim.forceName+".sim.noiseFreq") }
        ShaderParam { paramName: "g_speed"; paramValue: sync(partSim.forceName+".sim.speed") }
        ShaderParam { paramName: "g_maxAge"; paramValue: sync(partSim.name+".sim.maxAge") }
        ShaderParam { paramName: "g_elasticity"; paramValue: sync(partSim.name+".sim.elasticity") }
        ShaderParam { paramName: "g_splitThr"; paramValue: sync(partSim.name+".sim.splitThr") }
        ShaderParam { paramName: "g_splitAmpRand"; paramValue: sync(partSim.name+".sim.splitAmpRand") }
        ShaderParam { paramName: "g_splitAmpNorm"; paramValue: sync(partSim.name+".sim.splitAmpNorm") }
        ShaderParam { paramName: "g_noiseSpeed"; paramValue: sync(partSim.name+".sim.noiseSpeed") }

        // inject custom shader params
        Repeater { id: simPar2; model: 1 }

    }


    DrawVB {
        enabled: true
        type: "drawStop"; primType: "points"; vboId: sceneName+partSim.name; tfVaryings: shaderVaryings;
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints
    }




    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: sceneDir+drawShader
    }
    DrawVB {
        enabled: drawEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: true
        depthWrite: false

       // blendMode: "normal"
        blendMode: drawBlendMode
       // blendMode: "off"

        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

//        ShaderParam {
//            paramName: "g_pikselos"
//            paramValue: sync("pikselos")
//        }
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }

        ShaderParam {
            paramName: "g_maxAge"
            paramValue: sync(partSim.name+".sim.maxAge")
        }


        ShaderParam { paramName: "g_scale"; paramValue: sync(partSim.name+".draw.globalScale") }


        // inject custom shader params
        Repeater { id: drawPar; model: 1 }

        drawBuffers: 2
    }

    Shader {
        file: sceneDir+"partDepthOnly"
    }
    DrawVB { // depth only draw
        enabled: drawDepthEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: true
        depthWrite: true
       // blendMode: "normal"
        blendMode: "add"
       // blendMode: "off"
        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }
        drawBuffers: 1
    }

}
