import QtQuick 2.4
import AdaptDemoSystem 1.0

ParamGroup {

    id: sp

    property string paramName
    property string syncName
    property string syncFFTName
    property real syncDefault
    property real paramValue
    property string paramValueVec4

    property var spe: undefined

    Component.onCompleted: {
//        if (syncName !== "") {
//            if (fxFromTL("", syncName)) {
//                speTimeLiner.createObject(sp)
//            } else {
//                speRocket.createObject(sp)
//            }
//        }
        if (spe === undefined) {
            spe = speRocket.createObject(sp)
        }
    }

    onSyncNameChanged: {
        if (syncName !== "") {
            console.log("syncName set to:"+syncName)
            addEffectTrack(effectName, getTN1(syncName), syncDefault);

            if (fxFromTL("", syncName)) {
                console.log("creating speTimeLiner, previous spe:"+spe)
                if (spe !== undefined) {
                    spe.destroy();
                    spe = undefined;
                }
                spe = speTimeLiner.createObject(sp);
            }
        }
    }

    Component {
        id: speRocket
        ShaderParamEngine {
            id: spe
          //  enabled: !fxFromTL(effectName, syncName) && syncName!==""
            paramName: sp.paramName
            syncName: sp.syncName
            syncFFTName: sp.syncFFTName
            syncDefault: sp.syncDefault

            paramValue: sp.paramValue
            paramValueVec4: sp.paramValueVec4
        }
    }

    Component {
        id: speTimeLiner
        ShaderParamEngine {
            id: spe
          //  enabled: !fxFromTL(effectName, syncName) && syncName!==""
            paramName: sp.paramName
          //  syncName: sp.syncName
          //  syncFFTName: sp.syncFFTName
          //  syncDefault: sp.syncDefault

            paramValue: sp.syncName!=="" ? fxV(sp.syncName) : sp.paramValue
            paramValueVec4: sp.paramValueVec4
        }
    }
//    property string snTL


    property string efn: effectName

    onEfnChanged: {
//        if (syncName !== "") {
//            snTL = syncName;
//        }
    //    syncTimeLiner = true;
//        console.log("EFN: "+effectName+" "+syncName)
        addEffectTrack(effectName, getTN1(syncName), syncDefault);
    }


    onSyncFFTNameChanged: {
        if (syncFFTName !== "") {
//            snTL = syncFFTName;
            addEffectTrack(effectName, getTN1(syncFFTName), syncDefault);
            addEffectTrack(effectName, getTN1(syncFFTName)+".fftInd", syncDefault);

            syncName = syncFFTName;

            if (fxFromTL("", syncName)) {
                console.log("creating speTimeLiner, previous spe:"+spe)
                if (spe !== undefined) {
                    spe.destroy();
                    spe = undefined;
                }
                spe = speTimeLiner.createObject(sp);
            }
        }
    }

    function getTN(sn) {
      var s = sn;
      var sa = s.split(".");
      if (sa.length > 2) {
        var tn = "";
        for (var i=2; i<sa.length; i++) {
           tn += sa[i];
           if (i !== (sa.length-1)) {
               tn += ".";
           }
        }
        return tn;
      }
      return "";
    }

    function getTN1(sn) {
      var s = sn;
      var sa = s.split(".");
      if (sa.length > 1) {
        var tn = "";
        for (var i=1; i<sa.length; i++) {
           tn += sa[i];
           if (i !== (sa.length-1)) {
               tn += ".";
           }
        }
        return tn;
      }
      return "";
    }




}
