#version 430



layout(points) in;
layout(triangle_strip, max_vertices = 4) out;


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;
uniform mat4 viewMatrix;


uniform float g_time;
uniform float g_timeStep;

uniform float windowWidth;
uniform float windowHeight;

layout(binding=0) uniform sampler2D tex;


layout(binding=0, rgba32f) uniform image2D pardexPos;
layout(binding=3, rgba32f) uniform image2D pardexAge;
layout(binding=4, rgba32f) uniform image2D pardexVel;


in int qiG[1];
in int idG[1];


out vec2 uv;
out float br;
out vec2 puv;
//out float foc;
out vec3 pw;
out vec3 pv;

out vec3 prevPw;

out vec3 pView;

out float maxAge;


out vec4 ain;


uniform float drawSize = 1.0;
uniform float simMode = 0.0;


ivec2 getTrip(int idt) {
    ivec2 triBufSize = imageSize(pardexPos)/2;
    ivec2 trip;
    trip.y = idt/triBufSize.x;
    trip.x = idt-trip.y*triBufSize.x;
   // trip.y = 0;
    return trip;
}


vec4 vpa[4] = {
    vec4(0.0, 0.0, 0.0, 1.0),
    vec4(1.0, 0.0, 0.0, 1.0),
    vec4(0.0, 1.0, 0.0, 1.0),
    vec4(1.0, 1.0, 0.0, 1.0)
    };

uniform float activeParticlesNum = 0.0;


void main(void) {

        int qi = qiG[0];

//        if (qiG[0] > int(activeParticlesNum)) {
//            //return;
//        }

        ivec2 tr = getTrip(qi);


        float ageLeft = 1.0;
        maxAge = 1.0;
        if (simMode > 0.5) {
            vec4 ages = imageLoad(pardexAge, tr);
            ageLeft = ages.x;
            maxAge = ages.y;
            if (ageLeft < 0.010) {
                return;
            }
        }

        ivec2 triBufSize = imageSize(pardexPos)/2;


        vec4 pp = imageLoad(pardexPos, tr);
        pw = pp.xyz;

        ain = imageLoad(pardexPos, tr+triBufSize.xy);
//        scrollPos = ain.x;

        prevPw = pp.xyz-imageLoad(pardexVel, tr).xyz*g_timeStep;

        br = ageLeft;

        for (int i=0; i<4; ++i) {
            vec4 vp = vpa[i];

            puv = vp.xy;

            vp.xy -= vec2(0.50);
            vp.xyz *= drawSize;

            vec4 vpo = vp;
            vp.xzy = vp.xyz;

            vp.xyz += pp.xyz;

          //  float qit = -qi;
          //  uv = vec2((qit)*0.01, (qit)*0.02);
            uv = vec2(0.0, 0.0);

            vp = viewMatrix*vec4(vp.xyz, 1.0);

            pv = vp.xyz;

            vp = viewMatrix*vec4(pp.xyz, 1.0);
            vp.xyz += vpo.xyz;

            pView = vp.xyz;

            vp = projectionMatrix*vp;

            gl_Position = vp;
            EmitVertex();
        }
        EndPrimitive();
}
