#version 430

// layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNoise;
// layout(binding=2) uniform sampler2D texEmitShape;
layout(binding=3) uniform sampler2D texDepth; // world space normal in rgb
layout(binding=4) uniform sampler2D texMainDepth; // depth in r


// no texture2D in geometry shaders, so use this instead!!
vec4 tex2D(sampler2D s, vec2 c) {
    ivec2 ts = textureSize(s, 0);
    return texelFetch(s, ivec2(c.x*ts.x, c.y*ts.y), 0);
  //return texture2D(s, c);
}

// in int gl_PrimitiveIDIn;


vec4 rotateXZ(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.z;
r.z = sin(a)*p.x + cos(a)*p.z;
return r;
}

vec3 rotateXteXZ3(vec3 p, float a) {
return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}


vec3 rotateXY(vec3 p, float a) {
vec3 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}


vec4 rotateYZ(vec4 p, float a) {
vec4 r = p;
r.y = cos(a)*p.y - sin(a)*p.z;
r.z = sin(a)*p.y + cos(a)*p.z;
return r;
}

// interpolated perlin noise, from http://glslsandbox.com/e#34573.4
float hash(in vec2 p) {
  float h = dot(p,vec2(127.1,311.7));
  return fract(sin(h)*43758.5453123);
}
// computed non-texture based interpolated noise
float noiseC(in vec2 p) {
  vec2 i = floor( p );
  vec2 f = fract( p );
  vec2 u = f*f*(3.0-2.0*f);
  return -1.0+2.0*mix( mix( hash( i + vec2(0.0,0.0) ),
                   hash( i + vec2(1.0,0.0) ), u.x),
              mix( hash( i + vec2(0.0,1.0) ),
                   hash( i + vec2(1.0,1.0) ), u.x), u.y);
}

float nois(in vec3 x) //3d noise from iq
{
    vec3 p = floor(x);
    vec3 f = fract(x);
      //  f = f*f*(3.0-2.0*f);
        vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
        vec2 rg = tex2D(texNoise, fract((uv)/256.0)+vec2(0.0)).yx;
        rg -= vec2(0.435);
    //    rg = pow(rg, vec2(2.0));
        return mix( rg.x, rg.y, f.z );
}

uniform float g_noiseOctFreq = 4.0;

float fbm(in vec3 x)
{
    float rz = 0.0;
    float a = 0.50;
    int no = 4; // int(g_noiseOctaves);
    for (int i = 0; i<no; i++)
    {
        rz += nois(x)*a;
        a*=.5;
        x*=g_noiseOctFreq;
    }
    return rz;
}

float fbmm(in vec3 x)
{
    float rz = 1.0;
    float a = 2.0;
    for (int i = 0; i<4; i++)
    {
        rz *= nois(x)*a;
        a*=.95;
        x*= 2.;
    }
    return rz;
}


// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(points) in;
layout(points) out;
layout(max_vertices = 2) out;

//layout(line_strip, max_vertices = 15) out;

in vec3 posV[];
in vec2 uvV[];
in vec3 velV[];
in vec3 colV[];
in float ageV[];
in float recV[];
in float ageSplitV[];
in vec4 paramsV[];


out vec3 posG;
out vec2 uvG;
out vec3 velG;
out vec3 colG;
out float ageG;
out float recG;
out float ageSplitG;
out vec4 paramsG;


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform mat4 projectionInvMatrix;
uniform mat4 modelViewInvMatrix;

uniform float g_time;
uniform float g_timeStep;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;


layout(binding=0, rgba16f) uniform image2D emittedPartPos;
layout(binding=1, rgba16f) uniform image2D emittedPartVel;
layout(binding=2, rgba16f) uniform image2D emittedPartCol;
layout(binding=0, offset=0) uniform atomic_uint ac;
layout(binding=2, offset=0) uniform atomic_uint acPartGrid;
layout(binding=3, r32i) uniform iimage2D partGridIds;

layout(binding=5, rgba32f) uniform image2D voxelVel;

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}
// result suitable for assigning to gl_FragDepth
float depthSample(float linearDepth) {
    float nonLinearDepth = (zFar+zNear-2.0*zNear*zFar/linearDepth)/(zFar-zNear);
    nonLinearDepth = (nonLinearDepth+1.0)/2.0;
    return nonLinearDepth;
}

float zn = 0.0;
float zf = 1.0;

vec4 CalcEyeFromWindow(in vec3 windowSpace) {
    vec3 ndcPos;
    vec4 viewport = vec4(0.0, 0.0, g_windowWidth, g_windowHeight);
    ndcPos.xy = ((2.0 * windowSpace.xy) - (2.0 * viewport.xy)) / (viewport.zw) - 1;
    ndcPos.z = (2.0 * windowSpace.z - zn - zf) / (zf - zn);
    vec4 clipPos;
    clipPos.w = projectionMatrix[3][2]/(ndcPos.z-(projectionMatrix[2][2]/projectionMatrix[2][3]));
    clipPos.xyz = ndcPos * clipPos.w;
    return projectionInvMatrix * clipPos;
}

uniform float g_partGridDim;
uniform float g_partGridAreaSize;

void main(void) {

    vec3 pos = posV[0];
    vec2 uv = uvV[0];

    vec3 vel = velV[0];
    vec3 col = colV[0];
    float age = ageV[0];
    float rec = recV[0];

    float ageSplit = ageSplitV[0];


//    vec4 pos4 = vec4(pos, 1.0);
//    pos4.w = 1.0;
//    vec4 posScreen = mvp*pos4;
//    vec2 scrTexPos = posScreen.xy/posScreen.w*0.5+vec2(0.5, 0.5);
//    float da = posScreen.z/posScreen.w;

    float vd2 = g_partGridDim*g_partGridDim;
    int vd3 = int(vd2*g_partGridDim);
    vec3 cell = pos/g_partGridAreaSize*0.5+vec3(0.5, 0.5, 0.5)-vec3(0.0/vd2);
    cell = floor(cell*vd2);
    float cellzy = floor(cell.z/g_partGridDim);
    float cellzx = cell.z-cellzy*g_partGridDim;
    ivec2 cellUV = ivec2(cell.x+cellzx*vd2, cell.y+cellzy*vd2);
//    vec3 voxVel = imageLoad(voxelVel, cellUV).xyz;
//    posNois.xyz += voxVel*g_stirHitVelScale;

    posG = pos;
    uvG = uv;
    velG = vel;
    colG = col;

    paramsG = paramsV[0];

    ageG = age;
    recG = rec;
    ageSplitG = ageSplit;

    EmitVertex();
    EndPrimitive();



}
