import QtQuick 2.4
import AdaptDemoSystem 1.0

Group {
    id: boxGrower
    name: "boxGrower"
    enabled: syncRoot(boxGrower.name+".ON")

    Shader { file: "smPlastic" }

    // diffuse texture
    TextureSel { textureUnit: 0; name: parent.name }
  //  TextureImage { textureUnit: 0; file: "../../images/apo69.png"}

    // from root to leaves emit time based swipe palette triggered with swipe.trigger track
    TextureSel { textureUnit: 1; name: parent.name }
  //  TextureImage { textureUnit: 1; file: "../../images/palette_shot1.png"}

    // time since birth / age based swiper palette
    TextureSel { textureUnit: 2; name: parent.name }
   // TextureImage { textureUnit: 2; file: "../../images/palette_shot1.png"}

    // palette gradient defining the grow "plane" (if one of the moveX, Y or Z is set to zero or near zero).
    // Applied with amplitude .grow.movePalAmp and the x offset in palette image is moved in time with
    // .grow.movePalFreq, .grow.movePalFreqPlane, .grow.movePalOfs, .grow.movePalOfsPlane,
    // .grow.movePalAge (how the age of the box effects the palette offset).
    // The effect for move X, Y and Z is achieved through swizzle of the moveX, moveY & moveZ in following way:
    // (all values from green channel)
    //  if palette 0.0 >= .g < 0.333 then moveXYZ (XY plane)
    //  if palette 0.333 >= .g < 0.667 then moveZXY (XZ plane)
    //  if palette 0.667 >= .g <= 1.0 then moveYZX (YZ plane)
    // TextureImage { textureUnit: 3; file: "../../images/palette_shot5.png"}
    TextureSel { textureUnit: 3; name: parent.name }

    property real swipeFadeTrigger: syncTrigger(boxGrower.name+".swipeFade.trigger")

    VariClockTrigger {
        id: boxGrowerSwipeTime
        clockSpeed: sync(boxGrower.name+".swipe.speed")
        reset: syncTrigger(boxGrower.name+".swipeSpeed.reset")+swipeFadeTrigger
     //   resetTime: sync(boxGrower.name+".swipeSpeed.resetTime")
    }

    VariClockTrigger {
        id: boxGrowerSwipeFadeTime
        clockSpeed: sync(boxGrower.name+".swipe.fadeSpeed")
        reset: syncTrigger(boxGrower.name+".swipeSpeed.reset")+swipeFadeTrigger
     //   resetTime: sync(boxGrower.name+".swipeSpeed.resetTime")
    }

    Trigger {
        id: boxSwipeFadeTrigger
        reset: swipeFadeTrigger
    }

    DrawTrans2 {
      id: drawTransBG; name: "grow"; emitIntervalMS: sync(boxGrower.name+".emitNewInterval", 800.0);
      file: meshSel(boxGrower.name);
     // file: "mesh/dode.lwo";
     // file: "mesh/boxcut.lwo";
     // file: "mesh/adapt.obj";
     // file: "mesh/plane.x"
     //  file: "mesh/ball.lwo";

      syncBaseName: boxGrower.name

      transPack: true
      shaderVaryings: "uvec2 positionGI; uvec2 normalGI; uint uvGI; uvec2 tangentGI; uvec2 origCenterGI; uvec2 genInfoGI; uvec2 emitInfoGI; uvec2 branchInfoGI;"
      zoomPercent: sync(boxGrower.name+".zoomPercent");
      drawBlendMode: "normal"
      // transShader contains both emit & advance code

      transShader: "branchTransInt";
      transParams: ParamGroup {
          ShaderParam { paramName: "g_discardEdgeLen"; paramValue: sync(boxGrower.name+".grow.discardEdgeLen", 2.0) }
          ShaderParam { paramName: "g_maxDist"; paramValue: sync(boxGrower.name+".grow.maxDist", 300.0) }
          ShaderParam { paramName: "g_branchRateMS"; paramValue: sync(boxGrower.name+".grow.branchRateMS", 1200.0) }
          ShaderParam { paramName: "g_branchRateVar"; paramValue: sync(boxGrower.name+".grow.branchRateVar", 400.0) }
          ShaderParam { paramName: "g_branchRateVFreq"; paramValue: sync(boxGrower.name+".grow.branchRateVFreq", 10.0) }
          ShaderParam { paramName: "g_branchMax"; paramValue: sync(boxGrower.name+".grow.maxBranch", 8.0) }
          ShaderParam { paramName: "g_maxLevel"; paramValue: sync(boxGrower.name+".grow.maxLevel", 4.0) }
          ShaderParam { paramName: "g_maxAge"; paramValue: sync(boxGrower.name+".grow.maxAgeSec", 11.0) }
          ShaderParam { paramName: "g_maxEmitTime"; paramValue: sync(boxGrower.name+".grow.maxEmitTimeSec", 8.0) }
          ShaderParam { paramName: "g_branchMoveFreq"; paramValue: sync(boxGrower.name+".grow.moveFreq", 0.7) }
          ShaderParam { paramName: "g_branchMoveFreqVar"; paramValue: sync(boxGrower.name+".grow.moveFreqVar", 1.0) }
          ShaderParam { paramName: "g_branchGrowScale"; paramValue: sync(boxGrower.name+".grow.sca", 1.01) }
          ShaderParam { paramName: "g_branchGrowScaleVar"; paramValue: sync(boxGrower.name+".grow.scaVar", 0.0) }
          ShaderParam { paramName: "g_branchGrowScaleVarFreq"; paramValue: sync(boxGrower.name+".grow.scaVarFreq", 5.0) }
          ShaderParam { paramName: "g_branchGrowScaleVarPhase"; paramValue: sync(boxGrower.name+".grow.scaVarPhase", 1.0) }
          ShaderParam { paramName: "g_branchMove"; paramValueVec4: sync(boxGrower.name+".grow.move", 10.0)*0.10+","+sync(boxGrower.name+".grow.moveX", 1.2)*0.10+","+sync(boxGrower.name+".grow.moveY", 0.2)*0.10+","+sync(boxGrower.name+".grow.moveZ", 1.2)*0.10 }
          ShaderParam { paramName: "g_branchMovePal"; paramValueVec4: sync(boxGrower.name+".grow.movePalAmp", 0.2)+","+sync(boxGrower.name+".grow.movePalAge", 1.0)+","+sync(boxGrower.name+".grow.moveY", 0.2)+","+sync(boxGrower.name+".grow.moveZ", 1.2) }
          ShaderParam { paramName: "g_branchMovePalFreqOfs"; paramValueVec4: sync(boxGrower.name+".grow.movePalFreq", 1.0)+","+sync(boxGrower.name+".grow.movePalFreqLevel", 0.0)+","+sync(boxGrower.name+".grow.movePalOfs", 0.0)+","+sync(boxGrower.name+".grow.movePalOfsLevel", 0.0) }
          ShaderParam { paramName: "g_branchMovePerLevel"; paramValue: sync(boxGrower.name+".grow.movePerLevel", 2.0)*0.10 }
          ShaderParam { paramName: "g_branchMoveMulLevel"; paramValue: sync(boxGrower.name+".grow.moveMulLevel", 1.0) }
          ShaderParam { paramName: "g_branchMoveOfs"; paramValue: sync(boxGrower.name+".grow.moveOfs", 0.0)*0.10 }
          ShaderParam { paramName: "g_branchMoveOfsPerLevel"; paramValue: sync(boxGrower.name+".grow.moveOfsPerLevel", 0.0)*0.10 }
          ShaderParam { paramName: "g_branchScalePerLevel"; paramValue: sync(boxGrower.name+".grow.scalePerLevel", 0.7) }
          ShaderParam { paramName: "g_emitRateMS"; paramValue: sync(boxGrower.name+".grow.emitRateMS", 40.0) }
          ShaderParam { paramName: "g_branchRot1"; paramValue: sync(boxGrower.name+".grow.rot1", 1.2) }
          ShaderParam { paramName: "g_branchRot2"; paramValue: sync(boxGrower.name+".grow.rot2", 2.3) }
          ShaderParam { paramName: "g_branchRot1Level"; paramValue: sync(boxGrower.name+".grow.rot1Level", -0.3) }
          ShaderParam { paramName: "g_branchRot2Level"; paramValue: sync(boxGrower.name+".grow.rot2Level", -0.3) }
          ShaderParam { paramName: "g_branchAngle"; paramValueVec4: sync(boxGrower.name+".grow.branchAng", 0.3)+","+sync(boxGrower.name+".grow.branchAngVar", 0.5)+","+sync(boxGrower.name+".grow.branchAngVarFreq", 4.0) }
          ShaderParam { paramName: "g_rotAmount"; paramValue: sync(boxGrower.name+".grow.rotAmount", 0.05) }
          ShaderParam { paramName: "g_rotAmountLevel"; paramValue: sync(boxGrower.name+".grow.rotAmountLevel", 0.18) }
          ShaderParam { paramName: "g_maxSca"; paramValue: sync(boxGrower.name+".grow.maxSca", 0.7) }
          ShaderParam { paramName: "g_maxScaSmooth"; paramValue: sync(boxGrower.name+".grow.maxScaSmooth", 1.0) }
          ShaderParam { paramName: "g_scaleMove"; paramValue: sync(boxGrower.name+".grow.moveScale", 10.0) }
          ShaderParam { paramName: "g_maxScaMove"; paramValue: sync(boxGrower.name+".grow.maxScaMove", 0.0) }
          ShaderParam { paramName: "g_maxScaMoveSmooth"; paramValue: sync(boxGrower.name+".grow.maxScaMoveSmooth", 1.1) }

          ShaderParam { paramName: "g_zoomRot"; paramValueVec4: sync(boxGrower.name+".zoomRotX")+","+sync(boxGrower.name+".zoomRotY")+","+sync(boxGrower.name+".zoomRotZ")+","+sync(boxGrower.name+".zoomRotAmp") }
          ShaderParam { paramName: "g_zoomAcc"; paramValueVec4: sync(boxGrower.name+".zoomAccX")+","+sync(boxGrower.name+".zoomAccY")+","+sync(boxGrower.name+".zoomAccZ")+","+sync(boxGrower.name+".zoomAccAmp") }
          ShaderParam { paramName: "g_zoomRotMax"; paramValue: sync(boxGrower.name+".zoomRotMax") }
      }

      drawShader: "branchDrawInt";
      drawParams: ParamGroup {
          Pos { x: 0.0; y: 0.0; z: 0.0 }
          Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
          Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
          ShaderParam { paramName: "g_discardEdgeLen"; paramValue: sync(boxGrower.name+".grow.discardEdgeLen", 2.0) }
          ShaderParam { paramName: "g_discardEdgeFade"; paramValue: 1.0-sync(boxGrower.name+".grow.discEdgeFade", 0.5) }
          ShaderParam { paramName: "g_discardEdgeFadeSpeed"; paramValue: sync(boxGrower.name+".grow.discEdgeFadeSpeed", 1.0) }
          ShaderParam { paramName: "g_bump"; paramValue: 1.0}
          ShaderParam { paramName: "g_texBrightness"; paramValue: 0.50 }
          ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
          ShaderParam { paramName: "g_uvScale"; paramValue: 1.0 }
          ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0" }
          ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount", 2.50) }
          ShaderParam { paramName: "g_bright"; paramValue: 1.0}
          ShaderParam { paramName: "g_palSwipeFreq"; paramValue: sync(boxGrower.name+".swipe.freq", 0.15) }
          ShaderParam { paramName: "g_palSwipeOfs"; paramValue: sync(boxGrower.name+".swipe.ofs", 0.0)+boxGrowerSwipeTime.time }
          ShaderParam { paramName: "g_palSwipeZero"; paramValue: sync(boxGrower.name+".swipe.zeroColor", 0.05)}
          ShaderParam { paramName: "g_palSwipeIntensity"; paramValue: sync(boxGrower.name+".swipe.colIntensity", 2.0)}
          ShaderParam { paramName: "g_palSwipeColorPow"; paramValue: sync(boxGrower.name+".swipe.colPow", 1.0)}
          ShaderParam { paramName: "g_palSwipeFadeFreq"; paramValue: sync(boxGrower.name+".swipe.fadeFreq", 0.8)}
          ShaderParam { paramName: "g_palSwipeFadeOfs"; paramValue: sync(boxGrower.name+".swipe.fadeOfs", 2.4)+boxGrowerSwipeFadeTime.time}
          ShaderParam { paramName: "g_palSwipeFadePerc"; paramValue: sync(boxGrower.name+".swipe.fadeCutoff", 0.5)}
          ShaderParam { paramName: "g_palSwipeTimeOfs"; paramValue: boxSwipeFadeTrigger.time }
          ShaderParam { paramName: "g_swipeRadAmp"; paramValue: sync(boxGrower.name+".swipe.radAmp", 2.3) }

          ShaderParam { paramName: "g_agePalFreq"; paramValue: sync(boxGrower.name+".agePal.freq", 1.1) }
          ShaderParam { paramName: "g_agePalOfs"; paramValue: sync(boxGrower.name+".agePal.ofs", 0.26) }
          ShaderParam { paramName: "g_agePalIntensity"; paramValue: sync(boxGrower.name+".agePal.intensity", 8.5) }

      }

      drawMesh: DrawMesh {
          // draw one bigger mesh
          file: drawTransBG.file; Pos { x: drawTransBG.er*Math.sin(drawTransBG.ki)+drawTransBG.pr*Math.cos(drawTransBG.kii*2.3); y: Math.abs(0.0*(Math.sin(drawTransBG.ki*0.9+Math.cos(drawTransBG.kii*1.5)))); z: drawTransBG.er*Math.cos(drawTransBG.ki)+drawTransBG.pr*Math.sin(drawTransBG.kii*3.43)}
          halfFloats: drawTransBG.transPack
          intPack: drawTransBG.transPack
          autoCenter: false; autoScale: false
          Rot { d: 0.0; ax: 1.0; ay: 1.0; az: 0.0 }
          // Pos { x: 10.0 }
          Sca { s: sync(boxGrower.name+".grow.emitMeshScale", 0.50); x: 1.0; y: 1.0; z: 1.0 }
          ShaderParam { paramName: "g_emit"; paramValue: 1.0}
          ShaderParam { paramName: "g_bright"; paramValue: drawTransBG.drawIndex%2 < 1 ? 1.0 : 1.0 }
          ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
          blendMode: "off"; depthTest: true; depthWrite: true; triggeredRender: true
          cullBack: true
          cull: true
          property real kic: drawTransBG.ki
        }
    }
}
