import QtQuick 2.4
import AdaptDemoSystem 1.0

Effect {
    id: box
  //  name: "mesh"
    effectName: "Mesh"

    VariClockTrigger {
        id: animFrame
        clockSpeed: syncIn(box.name+".anim.FPS", 0.0)
        reset: syncTrigger(box.name+".anim.reset")
    }
    property real animFramesPerRow: s("anim.numCols", 1.0)
    property real animRows: syncIn(box.name+".anim.numRows", 1.0)
    property int animFrames: Math.max(1.0, syncIn(box.name+".anim.frames", 1.0))
    property int animFrameInt: (animFrame.time.toFixed(0)/animFrames-Math.floor(animFrame.time.toFixed(0)/animFrames))*(animFrames-1)

    property real uvScale: syncIn(box.name+".mat.texAll.uvScale", 1.0);

 //   property alias meshParams: meshiParams.delegate
    property bool setShader: true
    property var depthTestIn: undefined
    property bool depthTestActive: (depthTestIn !== undefined) ? depthTestIn : (s("draw.depthEnabled", 1.0) > 0.5)

    property var depthWriteIn: undefined
    property bool depthWriteActive: (depthWriteIn !== undefined) ? depthWriteIn : true

    property var fixedTimeStepIn: undefined

    Texture { textureUnit: 3; textureRT: "prev" }
    Texture { textureUnit: 4; textureRT: "prevBlur" }
    Texture { textureUnit: 5; textureRT: "prevNormal" }


    TextureSel { id: texBump; nameOverride: box.name+".mat.bump.texInd"; textureUnit: 1; }
    property int bumpTex: s("mat.bump.texInd")

    TextureSel { nameOverride: box.name+".mat.texLay1.texInd"; textureUnit: 0; }
    property int texLay1: s("mat.texLay1.texInd", 0.0)
    TextureSel { nameOverride: box.name+".mat.texLay2.texInd"; textureUnit: 2; }
    property int texLay2: s("mat.texLay2.texInd", 0.0)
    TextureSel { nameOverride: box.name+".mat.texLay3.texInd"; textureUnit: 7; }
    property int texLay3: s("mat.texLay3.texInd", 0.0)

    TextureSel { id: texMul; nameOverride: box.name+".mat.mulTex.texInd"; textureUnit: 6; }

//    Texture { textureUnit: 7;  textureRT: "mainDepth" }

    property bool meshIsMorph: false

    Shader {
      enabled: setShader
      file: {
            //if (meshi.isMorph) {
            if (meshIsMorph) {
              return "smMeshMotionMorph";
            }
            return "smMeshMotion";
        }
    }

    property real pcx: sf("trans.posCenX", 0.0)
    property real pcy: sf("trans.posCenY", 0.0)
    property real pcz: sf("trans.posCenZ", 0.0)

    property bool origScale: s("draw.origScale", 0.0) < 0.5
    property real meshMorph: sf("draw.meshMorph", 0.0)
    DrawMesh {
        id: meshi
        property string name: box.name
        file: meshSel(box.name+".draw")
        file2: meshSel2(box.name+".draw")
    //    depthTest: depthTestIn !== undefined ? depthTestIn : (s("draw.depthEnabled", 1.0) > 0.5)
    //    depthWrite: meshi.depthTest

        onEffectRender: {
          if (isMorph) {
            meshIsMorph = isMorph;
          }
        }

        depthTest: depthTestActive
        depthWrite: depthWriteActive


        blendMode: blendSel(box.name+".draw")

       // meshTexture: true

        drawBuffers: 4

        cull: s("draw.cull", 0.0) > 0.5
        cullBack: true

        reDrawGroups: box.reDrawGroups

        autoCenter: origScale; autoScale: origScale

        smoothNormals: true; normalSmoothAngle: 80;

        ShaderParam { paramName: "g_meshMorph"; paramValue: meshMorph }

        Pos { x: sf("trans.posX", 0.0); y: sf("trans.posY", 0.0); z: sf("trans.posZ", 0.0)}
        Pos { x: -pcx; y: -pcy; z: -pcz}
        Rot { d: syncIn(box.name+".trans.rotX", 0.0); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: syncFFTIn(box.name+".trans.rotY", 0.0); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: syncIn(box.name+".trans.rotZ", 0.0); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: syncFFTIn(box.name+".trans.scale", 1.0); x: syncIn(box.name+".trans.scaleX", 1.0); y: syncIn(box.name+".trans.scaleY", 1.0); z: syncIn(box.name+".trans.scaleZ", 1.0) }
        Pos { x: pcx; y: pcy; z: pcz}


        ShaderParam { paramName: "g_alpha"; syncName: ns("mat.alpha"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_alphaSub"; syncName: ns("mat.alphaSub"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; syncName: ns("mat.prevBlur"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_prevBlurType"; syncName: ns("mat.prevBlurType"); syncDefault: 0.0 }

        ShaderParam { paramName: "g_mulTexAmp"; syncName: ns("mat.mulTex.amp"); syncDefault: 0.0 }

        ShaderParam { paramName: "g_emitThr"; syncName: ns("palaEmit.thr"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_emitAmp"; syncFFTName: ns("palaEmit.amp"); syncDefault: 1.0 }


        ShaderParam { paramName: "g_animInfo"; paramValueVec4: animFramesPerRow+","+animFrames+","+animRows+","+animFrameInt }
        ShaderParam { paramName: "g_animLoopFadeFrames"; syncName: ns("anim.loopFadeFrames"); syncDefault: 1.0 }


        ShaderParam { paramName: "bumpTexInd"; paramValue: bumpTex }
        ShaderParam { paramName: "g_bump"; syncName: ns("mat.bump"); syncDefault: 0.0 }

        // mat.texAll master settings
        ShaderParam { paramName: "g_texBrightness"; syncName: ns("mat.texAll.amp"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_genUV"; syncName: ns("mat.texAll.genUV"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValueVec4: (uvScale*s("mat.texAll.uvAspect", 1.0))+","+(uvScale+","+uvScale)}
        ShaderParam { paramName: "g_uvOfsX"; syncFFTName: ns("mat.texAll.uvOfsX"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_uvOfsY"; syncFFTName: ns("mat.texAll.uvOfsY"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repPow"; syncName: ns("mat.texAll.pow"); syncDefault: 1.0 }

        // mat.texLay1 settings
        ShaderParam { paramName: "g_repTex1"; paramValue: texLay1 }
        ShaderParam { paramName: "g_repUVBase1"; syncName: ns("mat.texLay1.base"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVOp1"; syncName: ns("mat.texLay1.op"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVAmp1"; syncName: ns("mat.texLay1.amp"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVSca1"; syncName: ns("mat.texLay1.sca"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVOfsX1"; syncName: ns("mat.texLay1.ofsX"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVOfsY1"; syncName: ns("mat.texLay1.ofsY"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVRot1"; syncName: ns("mat.texLay1.rot"); syncDefault: 0.0 }

        // mat.texLay2 settings
        ShaderParam { paramName: "g_repTex2"; paramValue: texLay2 }
        ShaderParam { paramName: "g_repUVBase2"; syncName: ns("mat.texLay2.base"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVOp2"; syncName: ns("mat.texLay2.op"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVAmp2"; syncName: ns("mat.texLay2.amp"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVSca2"; syncName: ns("mat.texLay2.sca"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVOfsX2"; syncName: ns("mat.texLay2.ofsX"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVOfsY2"; syncName: ns("mat.texLay2.ofsY"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVRot2"; syncName: ns("mat.texLay2.rot"); syncDefault: 0.0 }

        // mat.texLay3 settings
        ShaderParam { paramName: "g_repTex3"; paramValue: texLay3 }
        ShaderParam { paramName: "g_repUVBase3"; syncName: ns("mat.texLay3.base"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVOp3"; syncName: ns("mat.texLay3.op"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVAmp3"; syncName: ns("mat.texLay3.amp"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVSca3"; syncName: ns("mat.texLay3.sca"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVOfsX3"; syncName: ns("mat.texLay3.ofsX"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVOfsY3"; syncName: ns("mat.texLay3.ofsY"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVRot3"; syncName: ns("mat.texLay3.rot"); syncDefault: 0.0 }

        ShaderParam { paramName: "emitAmount"; syncFFTName: ns("pardEmit.amount"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitAmountFromBright"; syncFFTName: ns("pardEmit.amount.fromBright"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitAge"; syncFFTName: ns("pardEmit.age"); syncDefault: 1.0 }
        ShaderParam { paramName: "emitAgeFromBright"; syncFFTName: ns("pardEmit.age.fromBright"); syncDefault: 0.0 }

        ShaderParam { paramName: "emitVelDirAmp"; syncFFTName: ns("pardEmit.velDir.amp"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirX"; syncName: ns("pardEmit.velDir.x"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirY"; syncName: ns("pardEmit.velDir.y"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirZ"; syncName: ns("pardEmit.velDir.z"); syncDefault: 0.0 }

        ShaderParam { paramName: "g_timeStep"; paramValue: fixedTimeStepIn !== undefined ? fixedTimeStepIn : rocket.timeStep }

        ShaderParam { paramName: "emitIntersect"; syncName: ns("pardEmit.intersect"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitIntExp"; syncName: ns("pardEmit.intersect.exp"); syncDefault: 1.0 }

      //  Repeater { id: meshiParams; model: 1 }

        //ShaderParam { paramName: "g_uvOfsY"; paramValue: syncIn(box.name+".uvOfsY", 0.0) }

//        SavePoint {
//            target: meshInst.name+"_SP"
//            x: meshInst.posX+syncIn(meshInst.name+".spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+syncIn(meshInst.name+".spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+syncIn(meshInst.name+".spz");
//        }

    }



}
