#version 430

// layout (location=0) in vec3 vertexPosition;

out vec2 uv;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float g_time;


void main() {
  vec4 vp = vec4(0.0);

  float id = float(gl_VertexID);

  float id3 = fract(id/3.0)*3.0; // index of the vertex in a triangle 0,1,2
  if (id3 < 0.50) {
      vp = vec4(0.0, 0.0, 0.0, 1.0);
  } else if (id3 < 1.5) {
      vp = vec4(1.0, 0.0, 0.0, 1.0);
  } else if (id3 < 2.5) {
      vp = vec4(0.0, 1.0, 0.0, 1.0);
  }
  vp.xy -= vec2(0.50);

  vp.xyz *= 0.015;

  //vp *= 0.0;

  float idv = floor((id/3.0-fract(id/3.0))+0.5); // triangle index 0,1,2,3,...

 // vp.x += idv*0.11;
  vp.x += sin(idv*0.1);
  vp.y += cos(idv*0.112);

  gl_Position = vp;
  uv = vec2(0.0);
}
