import QtQuick 2.4

Group {
    id: effect
    property string effectName

    property bool enabledIn: true
    enabled: syncRootOn(effect.name, effectName) & enabledIn;

    property var syncIn: sync
    property var syncFFTIn: syncFFT
    property var syncOscIn: syncOsc
    property var syncOscFFTIn: syncOscFFT

    property string sceneEffectName: sceneName+"."+effect.name+"."

    function ns(n) { return sceneEffectName+n; }
    function nse(e, n) { return sceneName+"."+e+"."+n; }
    function s(n, d) { return syncIn(effect.name+"."+n, d); }
    function sf(n, d) { return syncFFTIn(effect.name+"."+n, d); }
    function so(n, d) { return syncOscIn(effect.name+"."+n, d); }
    function sof(n, d) { return syncOscFFTIn(effect.name+"."+n, d); }

    function sti(n, t) { return syncTime(effect.name+"."+n, t); }
    function strti(n, t) { return syncTriggerTime(effect.name+"."+n, t); }

    function v(a, b, c, d) {
        if (b === undefined) b = 0.0;
        if (c === undefined) c = 0.0;
        if (d === undefined) d = 0.0;
        return a+","+b+","+c+","+d;
    }
}
