/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.util.TransportListener;
import java.util.concurrent.CopyOnWriteArrayList;

public class TransportModel {
    public static final int STATE_STOPPED = 0;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_RUNNING = 2;
    private CopyOnWriteArrayList<TransportListener> listeners = new CopyOnWriteArrayList();
    private int state = 0;
    private long position;

    public void addTransportListener(TransportListener transportListener) {
        this.listeners.add(transportListener);
    }

    public void removeTransportListener(TransportListener transportListener) {
        this.listeners.remove(transportListener);
    }

    public void setState(int n) {
        this.state = n;
        this.fireStateChanged(n);
    }

    public int getState() {
        return this.state;
    }

    public void setPosition(long l) {
        this.position = l;
        this.firePositionChanged(l);
    }

    public long getPosition() {
        return this.position;
    }

    public void fireStateChanged(int n) {
        for (TransportListener transportListener : this.listeners) {
            transportListener.stateChanged(this, n);
        }
    }

    public void firePositionChanged(long l) {
        for (TransportListener transportListener : this.listeners) {
            transportListener.positionChanged(this, l);
        }
    }
}

