/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.scope.AudioScopeModel;
import com.jsyn.scope.WaveTraceModel;
import com.jsyn.swing.ExponentialRangeModel;
import java.awt.Color;
import javax.swing.JToggleButton;

public class AudioScopeProbe {
    private WaveTraceModel waveTraceModel;
    private AudioScopeModel audioScopeModel;
    private UnitOutputPort source;
    private int partIndex;
    private Color color;
    private ExponentialRangeModel verticalScaleModel;
    private JToggleButton.ToggleButtonModel autoScaleButtonModel;
    private double MIN_RANGE = 0.01;
    private double MAX_RANGE = 100.0;

    public AudioScopeProbe(AudioScopeModel audioScopeModel, UnitOutputPort unitOutputPort, int n) {
        this.audioScopeModel = audioScopeModel;
        this.source = unitOutputPort;
        this.partIndex = n;
        this.verticalScaleModel = new ExponentialRangeModel("VScale", 1000, this.MIN_RANGE, this.MAX_RANGE, this.MIN_RANGE);
        this.autoScaleButtonModel = new JToggleButton.ToggleButtonModel();
        this.autoScaleButtonModel.setSelected(true);
    }

    public WaveTraceModel getWaveTraceModel() {
        return this.waveTraceModel;
    }

    public void setWaveTraceModel(WaveTraceModel waveTraceModel) {
        this.waveTraceModel = waveTraceModel;
    }

    public UnitOutputPort getSource() {
        return this.source;
    }

    public int getPartIndex() {
        return this.partIndex;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setAutoScaleEnabled(boolean bl) {
        this.autoScaleButtonModel.setSelected(bl);
    }

    public void setVerticalScale(double d) {
        this.verticalScaleModel.setDoubleValue(d);
    }

    public ExponentialRangeModel getVerticalScaleModel() {
        return this.verticalScaleModel;
    }

    public JToggleButton.ToggleButtonModel getAutoScaleButtonModel() {
        return this.autoScaleButtonModel;
    }
}

