/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.util.PseudoRandom;

public class BrownNoise
extends UnitGenerator
implements UnitSource {
    private PseudoRandom randomNum = new PseudoRandom();
    public UnitInputPort damping = new UnitInputPort("Damping");
    public UnitInputPort amplitude;
    public UnitOutputPort output;
    private double previous;

    public BrownNoise() {
        this.addPort(this.damping);
        this.damping.setup(1.0E-4, 0.01, 0.1);
        this.amplitude = new UnitInputPort("Amplitude", 0.999969482421875);
        this.addPort(this.amplitude);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int n, int n2) {
        double[] dArray = this.amplitude.getValues();
        double[] dArray2 = this.output.getValues();
        double d = 1.0 - this.damping.getValues()[0];
        for (int i = n; i < n2; ++i) {
            double d2 = this.randomNum.nextRandomDouble() * dArray[i];
            dArray2[i] = this.previous = d * this.previous + d2;
        }
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }
}

