; Cloudy by Abaddon
; code: TomCat
; cloud texture idea: Geoffrey Y. Gardner (1985)

XPHASE EQU SI
YPHASE EQU SI+1

ORG 256
 DW 127                 ; constant 127 -> amplitude for sinus table
 DW 3C00H               ; constant 1/128 -> calculating PI/128 for sinus table

 MOV FS,AX
 MOV AL,13H
colors:
 INT 10H
 MOV CH,48
 IMUL DX,BX,64
 MOV AX,1010H
 INC BL
 JNZ colors
 CWD
 MOV CH,45
 INT 10H

 MOV BH,80H
 MOV GS,BX
costab:
 FLDPI                  ; PI
 FMUL DWORD [SI]        ; PI/128
 FIMUL WORD [DI]        ; counter*PI/128
 FCOS                   ; COS(counter*PI/128)
 FIMUL WORD [SI]        ; 127*COS(counter*PI/128)
 FISTP WORD [BX+SI]     ; -
 INC BX
 INC BYTE [DI]          ; loop 256x
 JNZ costab             ; BX = cosinus table

 MOV DX,logo
 MOV AH,9
 INT 21H
 PUSH 0A000H
 POP ES
copytext:
 MOV CL,[ES:SI]
 MOV DX,7F80H
 SHR DX,CL
 MOV [DI+2+186*320+76-200],DX
 INC DI
 CMPSB
 DEC AX
 JNZ copytext

nextpixel:              ; XPhase=0.9, YPhase=0.7
 MOV AX,0CCCDH
 MUL DI
 SUB DH,200+29H
 NEG DH
 MOV AX,1329H           ; Hello Hellmood, Memories is so great!
 div dh                 ; reverse divide AL = C/Y'
 xchg dx,ax             ; DL = C/Y', AL = X
 mul dl                 ; AH = CX/Y'
 ADD DL,[FS:46CH]
 MOV DH,AH

 MOV WORD [XPHASE],37+256*29
 MOV BP,77*77           ; BP:Amplitude*Amplitude=0.3*0.3
 MOV CX,6+256*5         ; CL:XFreq=2*PI*0.023, CH:YFreq=2*PI*0.021
 SUB AX,AX
fori:
 PUSH DX
 PUSH AX
 MOV AL,[XPHASE]
 ADD AL,DL
 MUL CL
 CALL cosine
 XCHG DX,AX
 MOV AL,[YPHASE]
 ADD AL,AH
 MUL CH
 CALL cosine
 IMUL DX
 IMUL BP
 POP AX
 ADD DX,AX
 POP AX
 PUSH AX
 PUSH DX
 MOV BL,AH
 MUL CL
 XCHG AL,BL
 MOV DH,[BX]
 MUL CH
 MOV BL,AL
 MOV DL,[BX]
 MOV [XPHASE],DX
 POP AX
 POP DX

 SHR BP,1
 SHL CX,1
 JNS fori

 NEG AH                 ; AL:CLAMP(0..255)
 JZ .1
 CWD
 XCHG AX,DX
.1:

 MOV [GS:DI],AL
 INC DI
nextframe:
 JNZ nextpixel

 PUSH GS
 POP DS

 XCHG AX,DI
 MOV CX,3
blur:
 ADD AL,[DI+1]          ; AL contains 0 at start, and last color later
 ADC AH,CH              ; summing the 4 neighbours
 ADD AL,[DI+320]
 ADC AH,CH
 ADD AL,[DI-320]
 ADC AH,CH
 SHR AX,2               ; dividing by 4

 MOV [DI],AL
 INC DI
 JNZ blur
 LOOP blur

 PUSH CS
 POP DS

copy:
 CMP DI,186*320+76-200
 JB .1
 SALC
 XOR AL,[DI]
 JPE .2
.1:
 GS
.2:
 MOV AL,[DI]
 STOSB
 LOOP copy

 IN AL,60H
 DEC AX
 JNZ nextframe

cosine:
 MOV BL,AL
 MOV AL,[BX]
 CBW
 ADD AX,54
RETN

logo:
 DB 'ABADDON$'
