#version 330 core
out vec4 FragColor;
in vec3  fColor;
in vec2  texCoord;

uniform sampler2D particleTexture;
uniform float     particleCycle;
uniform int       useTextureAtlas;

void main()
{
    if (useTextureAtlas == 1)
    {
        vec4 color = texture2D(particleTexture, texCoord.st);
        FragColor  = vec4(color.xyz, 1.0);
    }
    else
    {
        FragColor = vec4(fColor, 1.0);
    }
}
