;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;______________________________________________________
;
; Cyberpunk 6502 (procedural gfx for Decrunch 2020 party)
; 2kb (2048b) size vs. 4096b compo limit 
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Cracow


MYBASE	equ $50

DLIST_L	equ $80
DLIST_H equ $81
FRMCNT	equ $82

; raycast data on ZP
distx	equ $d4
disty	equ $d5
xcal_h	equ $d6 ; xcalcd MCB
xcal_l	equ $d7 ; xcalcd LSB
ycal_h	equ $d8 
ycal_l	equ $d9
xcalcd	equ $da
ycalcd	equ $db
xpix	equ $dc ; ray x coord
ypix	equ $dd	; ray y coord
pixval	equ $de
pixfin	equ $df ; final value of the pixel
yrow	equ $e0

; for depack only
sindex	equ $d8 ; used only for depack of dither pattern
tindex	equ $d9 ; used only for depack of dither pattern	


curad_h equ $e1 ; current screen line address
curad_l	equ $e2
depth	equ $e3 ; temporary for distance
temp1	equ $e4
disort1	equ $e5
temp2	equ $e5 ; temporary for horizon filler loop

; horizon filler data on ZP
hors_l	equ $e6
hors_h	equ $e7
hort_l	equ $e8
hort_h	equ $e9
horcnt	equ $ea ; how many fills
horline	equ $eb
horpat	equ $ec
horp_l	equ $ed
horp_h	equ $ee
holpix	equ $ef

; horizon generator data
hort0	equ $3000
hort1	equ $3100
hort2	equ $3200

; general data
gpriort	equ $3300 ; gprior table for the screen
		  ; one page skip, so we are not overwriting stuff in a single loop
flarept	equ $3500 ; sun and flare position table

; OS, etc.
VCOUNT	equ $D40B
WSYNC	equ $D40a



	opt h+
		
	org $2000

	; create/setup mode f, using OS routines, and we are going to mess with it later (multimode, move to a different place in memory)

	lda #8
	jsr $EF9C
	
	;lda #64 ;set GTIA9 (16 shades of color)
	;sta $26f ; GPRIOR

	; modify dlist, to have regular 4 colors below horizon and push it into a fixed memory location (regardless of BASIC on/off)
	lda $230
	sta DLIST_L
	lda $231
	sta DLIST_H
	
	; put the whole screen into fixed location (so no difference between BASIC on/off)
	; in the 'header'
	ldy #4
	lda #$50
	sta (DLIST_L),y
	iny
	lda #$81
	sta (DLIST_L),y
	; midscreen
	ldy #$64
	lda #$00
	sta sindex ; init for depacking
	sta curad_h ; init for depacking	
	sta (DLIST_L),y
	iny 
	lda #$90
	sta (DLIST_L),y


	; randomize some shit
;	ldy #31
;randshit:
;	lda $D20a
;	sta $2c00,y
;	sta MYBASE*256+1024+256+256+256+161,y
;	dey
;	bpl randshit		

; depack some patterns

; depacking stuff...
; initialize
	;lda #0
	;sta sindex
	;sta curad_h
	lda #$2e
	sta curad_l
; depack 		
dpack
	ldy sindex 
	lax cloudpack,y ; load it to accu, but also store it for 2nd half in X reg
	lsr
	lsr
	lsr
	lsr
	ldy #0
	sta (curad_h),y
	inc curad_h
	bne skip_curadl_inc1
	inc curad_l
skip_curadl_inc1:
	;jsr storev
	txa ; now second half
	and #%00001111	; take first half
	;jsr storev
	sta (curad_h),y
	inc curad_h
	bne skip_curadl_inc2
	inc curad_l
skip_curadl_inc2:
	lda #(128+41) ; 128 vals for cloud pattern + 40 vals for 1st layer pattern)
	isb sindex ; nice illegal, increases mem, and subs from accu
	bne dpack		

; generate/populate gprior tab

;gpriortab values
;:32	     dta b(1+0);
;:121	     dta b(1+64); for the sky
;:72	     dta b(1+0); for the rest we simply disable the GTIA mode

; flare pt positions
;:171	     dta b(173)
;:10	     dta b(153)
;:10	     dta b(149)
;:10	     dta b(145);	 

; darkness1sky bands
;:8	     dta b($1E); horizon 	
;:12	     dta b($06); layer 1
;:20          dta b($04); layer 2
;:14	     dta b($02); layer 3
;:17          dta b($02); black
;:25	     dta b($0);
	
	;ldy #255
	dey ; as its 0 in Y
gpriorloop:
	lda #1
	sta $D00a ; use it for PMG2 x2 scale
	sta gpriort-1,y
	lda #1+64
	sta gpriort-1+32,y
	lda #1
	sta gpriort-1+32+121,y
	lda #173
	sta flarept-1,y
	lda #153
	sta flarept-1+171,y
	lda #149
	sta flarept-1+171+10,y
	lda #145
	sta flarept-1+171+10+10,y
	lda #$1e
	sta darkness1sky-1+121,y
	lda #$06
	sta 708
	sta darkness1sky-1+121+8,y
	lda #$04
	sta 709
	sta darkness1sky-1+121+8+12,y
	lda #$02
	sta darkness1sky-1+121+8+12+20,y
	sta 710
	lda #$00
	sta darkness1sky-1+121+8+12+20+31,y
	sta $2b20,y ; to populate the upper side of darkness sky (to avoid random numbers)
	sta MYBASE*256+1024+256+256+256,y ; to clean sun sprite	
	dey
	bne gpriorloop	

; horizon generator
	; l0
	;lda >hort0
	;sta fillhz+2
	;lda #0
	;sta fillhz+1
	;lda #<h0len ; this initialization is not needed, as this is the default :P	
	;sta flen+1
	;lda #<h0hgh
	;sta fhigh+1
	jsr horgen

	; l1
	;lda >hort1
	;sta fillhz+2
	inc fillhz+2
	;lda #0
	;sta fillhz+1
	lda #<h1len	
	sta flen+1
	lda #<h1hgh
	sta fhigh+1
	jsr horgen

	; l2
	;lda >hort2
	;sta fillhz+2
	inc fillhz+2
	;lda #0
	;sta fillhz+1
	lda #<h2len	
	sta flen+1
	lda #<h2hgh
	sta fhigh+1
	jsr horgen

; h2 bumps
	jsr h2bumps

; levels 1-3 horizon filler/renderer

	;lda #0
	stx temp2 ; as there is X=0 at this point

hfillerloop:
	ldx temp2      
	lda #0
	sta hors_l
	lda horts,x
	;lda hort0
	sta hors_h
	lda hor_l,x
	sta hort_l
	lda hor_h,x
	sta hort_h
	lda horcol,x
	sta horpat
	jsr fillhor
	inc temp2
	lda temp2
	cmp #3
	bne hfillerloop
	

; level 4 hires horizon filler
	lda <hort3
	sta hors_l
	;lda >(hor3-60)
	lda >hort3
	sta hors_h
	lda hor_l+3
	sta hort_l
	lda hor_h+3
	sta hort_h
	; color value/pattern	
	jsr hires_fillhor

; level 0 antennas
	lda #5
	sta temp1
	jsr r_antennas
; level 1 antennas  	
	lda #4
	sta temp1
	jsr r_antennas	
; level 2 antennas
	jsr l0antenna
	jsr l0antenna


; render rails on multiple layers
	ldx #12
railsegloop:
     	ldy #20
     	lda rails_l,x
     	sta curad_h
     	lda rails_h,x
     	sta curad_l
railsfilloop:
	lda rails_v,x
    	ora (curad_h),y
    	sta (curad_h),y 
    	dey
    	bpl railsfilloop
    	dex
    	bpl railsegloop

		
	;jmp raycastend ; skip raycasted sky, for development purposes (as it takes time), to test/tweak city generators
; ------------------------------------
; raycast

	; below is messed up the _l and _h order, meh, old code reuse... :/
	lda #$50
	sta curad_h
	sta $D407 ; set PMBase (reuse the value)
	lda #$81
	sta curad_l

	;lda #0
	sty yrow
lines: 
	ldy #40
		 
pixels:	
	; call raycast for right side of pixel
	tya
	asl
	adc #1
	; disort
	;sty temp1
	;ldy yrow
	;adc disort,y
	sta xpix
	;ldy temp1
	lda yrow
	sta ypix
	jsr rcast
	; store right side of the pixel in pixfin
	lda pixval
	sta pixfin
	; call raycast for right side of pixel
	tya
	asl
	sta xpix 
	jsr rcast	
	lda pixval
	; combine two pixels into one byte
	asl
	asl
	asl
	asl
	ora pixfin 
	sta (curad_h),Y	
	dey
	bne pixels
	; one more line increase address
	clc
	lda curad_h
	adc #40
	sta curad_h
	lda curad_l
	adc #0
	sta curad_l
	lda yrow
	adc #1
	cmp #110
	beq raycastend
	sta yrow
	jmp lines

; ------------------------------------
; raycast end

raycastend:
			
	;ldx #(64+7) ; no hires at the end
	;ldy #(12*16+6) ; no hires at the end
	; w/ hires at the end
	ldx #(32+8) ; no hires at the end
	ldy #(10*16+7) ; no hires at the end

dlistmod:
	lda #$e
	; color of the sun (pmg3)
	;lda #$0f
	sta 707	
	sta (DLIST_L),y
	dey
	dex
	bne dlistmod

; set colors for city layers - set already nicely in the gprior loop above
	;lda #$6
	;sta 708
	;lda #$4
	;sta 709
	;lda #$2
	;lsr
	;sta 710 ; set in ships loop below
	
; generate small ships on horizon
	ldx #16
	
shipsloop:
	; l3
	lda $D20a
	and #%00111111
	tay
	lda #%01000000
	sta $8150+(121*40+10),y
	; l2	
	lda $D20a
	and #%00111111	
	tay
	lda #%00000010
	sta $8150+(130*40+10),y
	; randomize a bit l2 buildings
	lda #%10000010
	and $8150+(135*40+10),y
	sta $8150+(135*40+10),y		
	; l1
	lda $D20a
	and #%00011111	
	tay
	lda #%00000011
	;lda #3 ; enable players and missiles
	sta $D01D	
	ora $8150+(147*40+10),y
	sta $8150+(147*40+10),y
	; randomize a bit l1 buildings
	lda #%11000011
	and $8150+(157*40+10),y
	sta $8150+(157*40+10),y
	
	;l0
	lda $D20a
	and #%00011111	
	tay	
	lda #%0011100
	ora $8150+(170*40+15),y
	sta $8150+(170*40+15),y

; now flare
	lda sunflr-1,x
	sta MYBASE*256+1024+256+256+256+176,x ; so it starts from 176+16 (192)
		
	dex
	bne shipsloop	

; l0 ship (front layer)

;124,58,94
	lda #124
	sta $8150+(172*40+8)
	lda #58
	sta $8150+(173*40+8)
	lda #94
	sta $8150+(174*40+8)

			
; enable PMG
		 
	lda #62 ; narrow screen, PM enabled, single line PMG
	sta 559
		
	;lda #MYBASE ; set the pmbase
	;sta $D407	
	
	
	; now populate the players

; sun on the horizon
;	ldy #16
;fillsun:
;	lda sunflr-1,y
;	sta MYBASE*256+1024+256+256+256+176,y ; so it starts from 176+16 (192)
;	dey
;	bne fillsun	

; flar to 
	ldy #69
	;ldy #75
	;ldy #(75+21)	
upflarloop:
	lda upflar-1,y
	sta MYBASE*256+1024+256+256+256+136-40,y ; so it starts from 96 +75 (171) + 16 = 187 (so 5 padding 0s)
; full pmg	
	lda #$ff
	sta MYBASE*256+1024+200,y
	lda #%00001111
	sta MYBASE*256+1024+256+256+182,y
; skyscrapers
	lda scr1,y
	sta MYBASE*256+1024+140+14,y
	lda scr2,y
	sta MYBASE*256+1024+256+140+1,y
	
	dey
	bne upflarloop	
	

	; fill full pmg - right side	
	ldy #22
fillpmg_q:
	lda #$ff
	;sta MYBASE*256+1024+256+256+188,y ; fill PMG2 down to earth
	sta MYBASE*256+1024+140+14+29,y ; fill PMG0 down to earth
	sta MYBASE*256+1024+256+140+1+48,y ; fill PMG1 down to earth
	; rails main
	sta $8150+(176*40+10),y
	sta $8150+(168*40+30),y
	; 2nd layer rails	
	sta $8150+(151*40)-1,y
	sta $8150+(151*40)-1+10,y					
	lda scr3-1,y ; populate PMG2
	sta MYBASE*256+1024+256+256+171,y
	dey
	bne fillpmg_q
		
	lda #44 ; set pos for pmg0
	sta $D000 ; player 0
	lda #(44+10) ; set pos for pmg1
	sta $D001 ; player 1
	lda #(199) ; set pos for pmg2
	sta $D002 ; player 2

	;lda #1 ; x2 size for player2 (right building)
	;sta $D00a
	  
; glow around the sun, just some touches

	ldy #10
sunglow:
	lda h2hgh,y
	adc $8150+109*40+25,y
	sta $8150+109*40+25,y
	adc $8150+110*40+22,y
	sta $8150+110*40+22,y
	sta $8150+115*40+23,y
	sta $8150+115*40+30,y
	ora $8150+111*40+28,y
	sta $8150+111*40+28,y
	ora $8150+112*40+23,y
	sta $8150+112*40+23,y													
	sta $8150+113*40+26,y
	ora $8150+113*40+26,y
	sta $8150+114*40+24,y
	sta $8150+117*40+25,y
	dey
	bne sunglow

; now just the endless loop, to display it 
		  
frame:
	; wait for frame
	lax VCOUNT ; X=0 used in several effects reached by jsr
	bne frame ; wait for new frame

	;ldy #0	
frameloop:	
	;lda gpriortab,y
	lda gpriort,x
	;sta $26f ; GPRIOR
	sta $D01B
 	;lda darkness1sky,y
	lda $2c00,x
 	sta $D01A
 	;lda flarepos,y
	lda flarept,x
 	sta $D003
 	;cpy #(32+121+40)
	cpx #(32+121+40)
 	bne skiphireschange
	lda #$02
	sta $D018
	lda #$0
	sta $D017
skiphireschange: 	
 	sta WSYNC 	
 	;iny
	inx
 	bne frameloop
 	
	beq frame		

rcast:	
	sty temp1
	ldy yrow
	lda disort,y ; wiggle the pattern a bit
	;lda #0
	asl
	asl
	asl
	sta xcal_l
	ldy temp1
	lda #0
	;sta xcal_l ; if uncommented - no distort
	sta xcal_h
	sta ycal_l
	sta ycal_h
		
        lda xpix
        sbc #75
        bcs xnoneg	; xpix > castx
	;lda xpix
	lda #75 
        sec
	sbc xpix	 	       
xnoneg:	sta xcalcd
	sec
        lda ypix
        ;sbc #24
	sbc #126
        bcs ynoneg	; xpix > castx
	;lda #24
	lda #126
        sec
	sbc ypix        
ynoneg:	sta ycalcd

	ldx #0	; for i = 255
cast:   
	; this section is to be corrected!
 	; x     
	lda xcal_l	; distx = xcalc>>6
        rol
        lda xcal_h
        rol
	;lsr 
        sta distx
        lda xcal_l
        rol
        rol
        lda distx
        rol
        sta distx        
        ; 
	lda ycal_l	; disty = ycalc>>6
        rol
        lda ycal_h
        rol 
        sta disty
        lda ycal_l
        rol
        rol
        lda disty
        rol
        sta disty
        ; this section is to be corrected!
                   
        cmp #24     ; if (distx>22 || disty>16) break
        bcs dist
        lda distx
        cmp #96
        bcs dist                    
	;cld			; xcalc+=xcalcd
        clc 
	lda xcalcd
	adc xcal_l        
	sta xcal_l
        lda xcal_h
        adc #0 ; just the carry flag
        sta xcal_h
        
        clc ; ycalc+=ycalcd 
	lda ycalcd
	adc ycal_l        
	sta ycal_l
        lda ycal_h
        adc #0 ; just the carry flag
        sta ycal_h

	inx ; if depth > 255 = 0
        bne cast	
        
dist:
	; depthmap = (depth^distx^disty)/16
	txa ; depth -> a
	stx depth ; store depth
	and #%00001111
	asl
	asl
	asl
	asl
	sta temp1
        ;eor distx
        ;eor disty
	lda distx	
	;and #%00001111
	ora temp1
	;eor disty 
        ;lsr
        ;lsr
        ;lsr
        ;lsr
	; now fetch from lookup table
	tax
	;lda cloudpat,x
	lda $2e00,x
        sta pixval
        ldx depth ; restore depth in X reg
        rts

; ------------------------------------------------------------------------------
; horizon generation procedure	
; ------------------------------------------------------------------------------
horgen:
	lda #0
	sta horcnt
	;sty horcnt ; as there is Y=0 at this point

gensection:	
	lda $D20a ; load random number
	and #%00001111
	tay
flen:	
	lda h0len,y
	tax
	lda $D20a ; load random number
	and #%00001111
	tay	
fhigh:	
	lda h0hgh,y
fillhz:
	sta hort0
	inc fillhz+1
	inc horcnt
	dex
	bne fillhz
	sec	
	lda horcnt
	cmp #160
	bcc gensection		
	lda #0
	sta fillhz+1
	rts


; ------------------------------------------------------------------------------
; HORIZON filler procedure
; ------------------------------------------------------------------------------
fillhor:
	lda #0
	sta horcnt	
fillline: ; fill line of 4-col sections
	lda #0 ; keep the column index in temp1
	sta temp1
fillsection:	
	ldy temp1
	lda horpat
	and mask,y ; so we've got the right color
	sta holpix ; in holpix
	; now get the the colheight
	ldy horcnt
	lda (hors_l),y
	beq skipfill
x2scaler:	
	;asl ; $0a
	;nop ; $ea
	tax ; so in x we keep the count of lines to fill
	ldy #0
	; now the address for the final pixel
	lda hort_l
	sta horp_l
	lda hort_h
	sta horp_h  
filler:
	lda (horp_l),y
	ora holpix
	sta (horp_l),y
	lda horp_l
	sec
	sbc #40
	bcs noborrow; no borrow
	dec horp_h
noborrow:
	sta horp_l		
	dex
	bne filler

skipfill:
	; move to the next target pixel (in the next section)
	; inc general column done
	inc horcnt	

	inc temp1
	lda temp1
	cmp #4
	bne fillsection
	; move right on the pixel target
	inc hort_l
	bne skipinchort_h
	inc hort_h  
skipinchort_h:	
	; section ended, check if it was the last one  
	lda horcnt
	cmp #160
	bne fillline	
	rts

; ------------------------------------------------------------------------------
; HORIZON filler procedure - hires
; ------------------------------------------------------------------------------
hires_fillhor:
	;lda #0
	;sta horcnt
	stx horcnt ; X=0?
hires_fillsection:	
	ldy horcnt
	;lda walls,y
	lda $2f00+40,y
	sta temp1
	lda (hors_l),y
	beq hires_skipfill
	tax ; so in x we keep the count of lines to fill
	ldy #0
	; now the address for the final pixel
	lda hort_l
	sta horp_l
	lda hort_h
	sta horp_h  
hires_filler:
	txa
	and temp1
	bne regular_fill
	lda #%01000010
	sta (horp_l),y
	jmp filldone
regular_fill:	
	;lda walls,x
	lda #$ff	
	sta (horp_l),y
filldone:	
	lda horp_l
	sec
	sbc #40
	bcs hires_noborrow; no borrow
	dec horp_h
hires_noborrow:
	sta horp_l		
	dex
	bne hires_filler

	ldx horcnt
	;lda roofs,x
	lda $2f00,x
	tax	
	; fill the last line 
	lda roof1,x
	sta (horp_l),y

	; and top roof antennas
	lda horp_l
	sec
	sbc #40
	bcs hires_noborrow2; no borrow
	dec horp_h
hires_noborrow2:
	sta horp_l		
	lda roof2,x
	sta (horp_l),y

	lda horp_l
	sec
	sbc #40
	bcs hires_noborrow3; no borrow
	dec horp_h
hires_noborrow3:
	sta horp_l		
	lda roof3,x
	sta (horp_l),y
	
	
hires_skipfill:
	; move to the next target pixel (in the next section)
	; inc general column done
	inc horcnt	
	; move right on the pixel target
	inc hort_l
	bne hires_skipinchort_h
	inc hort_h  
hires_skipinchort_h:	
	; section ended, check if it was the last one  
	lda horcnt
	cmp #40
	bne hires_fillsection	
	rts

; ------------------------------------------------------------------------------
; ANTENNA filler procedure
; ------------------------------------------------------------------------------

l0antenna:
	lda hor_l
	sta horp_l
l0antenna_h:	
	lda hor_h
	sta horp_h
	;lda $D20a
	;and #%00011111
	;adc #4
	;tay
h1pos:
	ldy h1antennas
	ldx #8
fillantenna:
	;lda (horp_l),y
	lda h1ant1-1,x
	sta (horp_l),y
	lda horp_l
	sec
	sbc #40
	bcs noborrow2; no borrow
	dec horp_h
noborrow2:
	sta horp_l		
	dex
	bne fillantenna
	; move to the next antenna on next iteration
	lda fillantenna+1
	clc
	adc #8
	sta fillantenna+1
	inc h1pos+1  			
	rts

r_antennas:
antennaloop:
	jsr l0antenna
	dec temp1
	bne antennaloop	
	inc l0antenna+1; reorient to 2nd line
	inc l0antenna_h+1	
	rts	
; ------------------------------------------------------------------------------
; horizon level 2 bumps procedure
; ------------------------------------------------------------------------------

h2bumps:
	ldx #160

	ldy #5
	lda #8
	sta temp1
h2bumpsloop:	
	dey
	bne skipb1
	inc hort2,x
	inc hort2,x
	ldy #5
skipb1:	
	dec temp1
	bne skipb2
	lda hort2,x
	beq skipb2
	dec hort2,x
	lda #8
	sta temp1
skipb2:	
	dex
	bne h2bumpsloop
	
	rts

; horizons filler data 
; screen addresses 
hor_l	dta b(<($8150+128*40),<($8150+140*40),<($8150+160*40),<($8150+191*40));
hor_h	dta b(>($8150+128*40),>($8150+140*40),>($8150+160*40),>($8150+191*40));

; colors
horcol	dta b(%01010101,%10101010,%11111111);

; masks (for 4 columns per byte
mask	dta b(%11000000,%00110000,%00001100, %00000011);
	
;gpriortab - generated above 
;:32	     dta b(1+0);
;:121	     dta b(1+64); for the sky
;:72	     dta b(1+0); for the rest we simply disable the GTIA mode

;flarepos - generated above
;:171	     dta b(173)
;:10	     dta b(153)
;:10	     dta b(149)
;:10	     dta b(145);	 
;:50	     dta b(132);


; scrapers PMG data	
scr1	;dta b(0,0,0,0,0,0,0,0,0,0,0,0,0,0);
	dta b(64,32,96,32,96,40,96,104,96,248,204,254,195,255,195,255,129,255,255,159,255,159,255,254,255,254,255,254,255,254);
	;dta b(255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);
disort 	dta b(23,17,28,22,26,25,25,24,19,22);
	dta b(25,17,25,15,22,26,16,20,22,21);
	dta b(25,19,20,19,24,21,15,19,22,17);
	dta b(23,17,19,23,18,17,18,20,18,19);
	dta b(21,20,15,17,22,16,16,19,15,19);
	dta b(19,20,18,17,20,15,17,20,15,15);
	dta b(19,18,18,17,18,17,14,15,15,18);
	dta b(18,15,16,17,17,16,17,16,16,15);
	dta b(16,16,15,15,15,15);
	;dta b(15,15,15,15);
scr2	dta b(16,0,16,16,16,80,16,80,80,80,120,252,254,243,255,189,255,189,255,191,255,191,255,159,255,207,255,255,255,249,255,250,254,250,254,250,254,254,126,255,249,255,122,254,250,254,254,254,254);
	;dta b(255,255,255,255,255,255,255,255,255,255,255);
scr3	;dta b(129,0,195,255,255,255,126,255,126,255,126,102,126,66,126,66,126,126,126); 19px
        dta b(153,8,219,255,255,231,126,239,126,255,126,102,126,66,126,66,126,126,126,255,126,126); 19px - alternative version

; rails data
rails_v	dta b(16,24,8,8,8,16,16,3,3,1,3,3);
rails_l	dta b(<($8150+(172*40+10)),<($8150+(165*40+30)),<($8150+(173*40+10)),<($8150+(174*40+10)),<($8150+(175*40+10)),<($8150+(166*40+30)),<($8150+(167*40+30)),<($8150+(177*40+10)),<($8150+(169*40+30)),<($8150+(178*40+10)),<($8150+(150*40)-1),<($8150+(150*40)-1+10));
rails_h	dta b(>($8150+(172*40+10)),>($8150+(165*40+30)),>($8150+(173*40+10)),>($8150+(174*40+10)),>($8150+(175*40+10)),>($8150+(166*40+30)),>($8150+(167*40+30)),>($8150+(177*40+10)),>($8150+(169*40+30)),>($8150+(178*40+10)),>($8150+(150*40)-1),>($8150+(150*40)-1+10));

; horizon target pages
horts	dta b($30,$31,$32);

; RAYCASTER data (clouds)

; packed data
cloudpack:
	; skypat - 1/2 seamless
	dta b($24,$33,$21,$10,$10,$23,$44,$44);
	dta b($34,$44,$33,$11,$20,$03,$54,$33);
	dta b($44,$43,$44,$21,$32,$00,$34,$12);
	dta b($32,$33,$44,$31,$33,$11,$12,$22);
	dta b($41,$13,$34,$32,$23,$11,$23,$32);
	dta b($41,$12,$34,$42,$12,$21,$33,$43);
	dta b($31,$12,$33,$42,$11,$22,$33,$34);
	dta b($22,$23,$32,$21,$22,$23,$33,$44);
	dta b($53,$44,$42,$11,$23,$33,$34,$53);
	dta b($32,$35,$54,$10,$22,$33,$44,$54);
	dta b($42,$35,$54,$32,$32,$34,$43,$45);
	dta b($42,$25,$55,$32,$33,$34,$45,$45);
	dta b($53,$23,$65,$42,$34,$34,$45,$65);
	dta b($42,$23,$54,$32,$23,$42,$45,$55);
	dta b($23,$42,$23,$33,$22,$43,$12,$21);
	dta b($14,$52,$02,$22,$11,$13,$34,$32);

roofs	dta b($01,$23,$13,$03,$13,$02,$32,$23,$32,$33,$00,$21,$12,$10,$31,$31,$23,$31,$02,$30);
walls	dta b($77,$77,$77,$73,$77,$77,$27,$75,$77,$67,$77,$73,$77,$77,$27,$77,$76,$77,$77,$56);

;upflar including the sun itself
upflar  dta b(16,0,0,0,0,16,0,0,0,0,16,0,0,0,16,0,16,16,0,16,16,0,16,16,16,0,16,16,16,0,16,16,16,16,24,16,24,24,24,24,24,60,126,126,114,255,255,207,63,254,255,126,126,112,60,24,24,24,16,24,16,8,16,0,16,0,0,0,16); 69 vals
sunflr	dta b(8,20,20,8,0,0,0,24,36,36,36,24,0,0,0,8);

	org $2a00
	; 16 byte tables used in city randomizer/generator
	; l0 - horizon, 8pix height) 
h0hgh	dta b(0,6,2,3,4,5,2,4,3,7,1,0,1,6,6,7,8);
h0len	dta b(1,1,1,1,2,1,2,1,1,1,1,1,2,1,1,1,2); good
h1hgh	dta b(0,2,4,5,7,8,0,11,5,9,11,9,10,2,5,6,4); 
h1len	dta b(2,3,4,3,4,5,2,3,4,5,3,2,4,5,4,3,4); original
h2hgh	dta b(0,12,8,5,7,8,15,18,5,9,17,15,19,10,13,8,6);
h2len	dta b(4,5,6,7,4,5,6,7,4,5,6,7,4,5,6,7,4);

h1ant1	dta b(80,64,80,64,80,64,80,80); level 0
h1ant2	dta b(20,68,84,69,85,69,85,69);
h1ant3  dta b(64,80,80,68,84,65,85,85);
h1ant4  dta b(84,68,16,84,68,84,68,84);
h1ant5  dta b(20,85,20,85,20,85,20,85);
h1ant6  dta b(170,130,170,130,40,130,170,170); level 1
hlant7  dta b(8,8,42,136,8,42,8,8);
hlant8	dta b(2,10,34,138,170,162,130,130);
hlant9  dta b(128,160,160,136,168,130,170,170);
hlant10 dta b(60,255,195,195,255,195,255,255); level 2, quarters.A
hlant11 dta b(60,255,195,255,195,255,255,252); level 2, quarters.B

h1antennas 
	dta b(5,29,19,34,10,13,18,22,30,9,10); positions



; frontlayer/hires skyline (max is 31px/lines), 40 vals
hort3	dta b(25,23,23,25,15,27,15,16,5,5,27,25,27,15,25,25,25,20,10,10,1,13,15,22,22,10,10,15,15,25,23,25,17,22,22,10,20,26,27,27);
  
roof1	dta b(93,133,233,254);
roof2	dta b(38,255,112,164);
roof3	dta b(60,32,80,255);

; 121 lines of sky
	org $2c00+32
darkness1sky ;dta b($0,$0,$0,0,0,0,0,0,0,0,0,0,0,0,0,0);
	     ;dta b($0,$0,$0,0,0,0,0,0,0,0,0,0,0,0,0,0);
	     dta b($06,$26,$26,$26,$06,$26,$28,$26,$26,$28,$26,$28,$26,$28,$26,$28); x 121
	     dta b($26,$28,$26,$28,$26,$28,$26,$28,$26,$28,$28,$26,$28,$28,$28,$28);
	     dta b($28,$28,$28,$28,$28,$28,$28,$28,$28,$28,$28,$28,$28,$28,$28,$28);
	     dta b($2A,$28,$28,$1A,$28,$2A,$28,$1A,$28,$2A,$28,$2A,$1A,$2A,$28,$2A);
	     dta b($1A,$2A,$2A,$1A,$2A,$2A,$2A,$1A,$2A,$2A,$2A,$2A,$2A,$1C,$2A,$2A);
	     dta b($1C,$2A,$1C,$2A,$1C,$1C,$2A,$1C,$1C,$2C,$1C,$1C,$1C,$2C,$1E,$1C);
	     dta b($1E,$2C,$1E,$1E,$1E,$2C,$1E,$1E,$1E,$2E,$1E,$2E,$1E,$2E,$2E,$2E); 7x16
	     dta b($2E,$1E,$0E,$1E,$2E,$1E,$2E,$1E,$1E);			   ; + 9 = 121 
	     ;dta b($2E,$1E,$0E,$1E,$2E,$1E,$2E,$0,$0);
	     ; here $e starts
; bands generated above	
;:4	     dta b($0)	
;:8	     dta b($1E); horizon 	
;:12	     dta b($06); layer 1
;:20          dta b($04); layer 2
;:14	     dta b($02); layer 3
;:17          dta b($02); black
;:25	     dta b($0);

	run $2000 
	
	end