#include "data/newyear_nam.h"

const unsigned char star_palette_1[16]={ 0x03,0x13,0x22,0x30,0x03,0x14,0x22,0x30,0x03,0x12,0x22,0x30,0x03,0x14,0x22,0x30 };
const unsigned char star_palette_2[16]={ 0x02,0x12,0x22,0x30,0x02,0x13,0x22,0x30,0x02,0x14,0x22,0x30,0x02,0x16,0x22,0x30 };
const unsigned char star_palette_3[16]={ 0x03,0x14,0x24,0x30,0x03,0x12,0x24,0x30,0x03,0x13,0x24,0x30,0x03,0x29,0x24,0x30 };
const unsigned char star_palette_4[16]={ 0x04,0x15,0x25,0x30,0x04,0x13,0x25,0x30,0x04,0x14,0x25,0x30,0x04,0x11,0x25,0x30 };



const unsigned char meta_newyear_l[]={
	-16,-32,0x01,0,
	- 8,-32,0x02,0,
	  0,-32,0x03,0,
	-24,-24,0x04,0,
	-16,-24,0x05,0,
	  0,-24,0x06,0,
	-24,-16,0x07,0,
	- 8,-16,0x08,0,
	  0,-16,0x09,0,
	-24,- 8,0x0e,0,
	-16,- 8,0x0f,0,
	- 8,- 8,0x10,0,
	  0,- 8,0x11,0,
	-16,  0,0x16,0,
	- 8,  0,0x17,0,
	  0,  0,0x18,0,
	  0,  8,0x1d,0,
	- 8, 16,0x0f,0,
	  0, 16,0x22,0,
	  8, 16,0x23,0,
	- 8, 24,0x25,0,
	  0, 24,0x26,0,
	  8, 24,0x27,0,
	128
};

const unsigned char meta_newyear_r[]={
	-16,-16,0x0a,0,
	- 8,-16,0x0b,0,
	  0,-16,0x0c,0,
	  8,-16,0x0d,0,
	-16,- 8,0x12,0,
	- 8,- 8,0x13,0,
	  0,- 8,0x14,0,
	  8,- 8,0x15,0,
	-16,  0,0x19,0,
	- 8,  0,0x1a,0,
	  0,  0,0x1b,0,
	  8,  0,0x1c,0,
	-16,  8,0x1e,0,
	- 8,  8,0x1f,0,
	  0,  8,0x20,0,
	  8,  8,0x21,0,
	- 8, 16,0x24,0,
	128
};

const unsigned char newyear_sine[64]={
	0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,4,4,5,5,5,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,5,5,5,4,4,4,3,3,2,2,2,1,1,1,0,0,0,0,0,0,0,
};

const unsigned char spark_anim[]={
	0x80,0x82,0x84,0x86,0x88,0x8a,0x8c,0x8e,
	0x8c,0x8a,0x88,0x86,0x84,0x82,0x80
};



#define SPARK_ALL	6


#pragma bssseg (push,"SHAREDRAM1")
#pragma dataseg(push,"SHAREDRAM1")

unsigned char spark_x    [SPARK_ALL];
unsigned int  spark_y    [SPARK_ALL];
  signed char spark_dy   [SPARK_ALL];
unsigned char spark_frame[SPARK_ALL];
unsigned char spark_delay[SPARK_ALL];

unsigned char star_anim_frame;

unsigned int star_small_anim[8];
unsigned int star_small_anim_dx[8];

unsigned int star_scroll_top;
unsigned int star_scroll_bottom;
signed int star_scroll_top_dx;
signed int star_scroll_bottom_dx;
unsigned char star_scroll_top_dir;
unsigned char star_scroll_bottom_dir;

#pragma dataseg(pop);
#pragma bssseg (pop);



void set_spark(void)
{
	spark_x    [_i]=16+(rand8()%224);
	spark_frame[_i]=0;
	spark_delay[_i]=32+(rand8()&31);
	
	if(rand8()&64)
	{
		spark_y [_i]=(rand8()&7)<<3;
		spark_dy[_i]=(rand8()&15)+1;
	}
	else
	{
		spark_y [_i]=(224-(rand8()&7))<<3;
		spark_dy[_i]=-((rand8()&15)+1);
	}
}



void spark_update(unsigned char spawn)
{
	unsigned char add;
	
	add=0;
	
	for(_i=0;_i<SPARK_ALL;++_i)
	{
		if(spark_delay[_i])
		{
			--spark_delay[_i];
			
			continue;
		}
		
		_spr=spark_frame[_i];
		
		if(_spr>=sizeof(spark_anim)*2)	//change
		{
			if(!add&&spawn)
			{
				++add;
				set_spark();
			}
			
			continue;
		}
		
		_sx=spark_x[_i];
		_sy=spark_y[_i]>>3;
		_tile=spark_anim[_spr>>1];
		
		oam_spr(_sx+0,_sy+0,_tile+0x00,0,oam_off+0*4);
		oam_spr(_sx+8,_sy+0,_tile+0x01,0,oam_off+1*4);
		oam_spr(_sx+0,_sy+8,_tile+0x10,0,oam_off+2*4);
		oam_spr(_sx+8,_sy+8,_tile+0x11,0,oam_off+3*4);
		
		oam_off+=4*4;
		
		++spark_frame[_i];
		spark_y[_i]+=spark_dy[_i];
	}
}



void e_star(void)
{
	unsigned char newyear_sy,step,flash,ny_anim,ny_anim_dx,palc,paln,out;
	signed int star_frame,star_frame_dx,star_scroll_speed,star_scroll_speed_max;

	bank_bg(1);
	bank_spr(0);
	
	oam_clear_fast();
	oam_size(0);
	oam_update();

	_chr=CHR_SPRITES;
	
	mmc3_chr_bank(_chr+0,0);
	mmc3_chr_bank(_chr+2,1);
		
	_chr=CHR_STAR_LARGE;
	
	mmc3_chr_bank(_chr,2);
	
	_chr=CHR_STAR_SMALL;
	
	mmc3_chr_bank(_chr,3);
	
	_chr=CHR_NEWYEAR_BG;
	
	mmc3_chr_bank(_chr+0,4);
	mmc3_chr_bank(_chr+1,5);
	
	mmc3_set_mirroring(M_HORIZONTAL);
	
	star_anim_frame=0;
	
	pal_clear();
	
	for(_i=0;_i<16;++_i)
	{
		if(_i<2||_i>=4)
		{
			pal_req[_i]=star_palette_1[0];
		}
		else
		{
			pal_req[_i]=star_palette_1[_i];
		}
	}
	
	for(_i=0;_i<SPARK_ALL;++_i)
	{
		spark_frame[_i]=255;
	}
	
	vram_adr(NAMETABLE_A);
	vram_write((unsigned char*)newyear_nam,1024);
	vram_adr(NAMETABLE_C);
	vram_write((unsigned char*)newyear_nam,1024);

	for(_i=0;_i<8;++_i)
	{
		star_small_anim[_i]=_i*64*256;
		star_small_anim_dx[_i]=0;
	}
	
	star_scroll_top=0;
	star_scroll_bottom=0;
	star_scroll_top_dx=0;
	star_scroll_bottom_dx=0;
	star_scroll_top_dir=0;
	star_scroll_bottom_dir=1;
	star_scroll_speed=2;
	star_scroll_speed_max=256*2;
	
	scroll(0,0);
	
	memfill(update_list,0,sizeof(update_list));
	
	star_frame=0;
	star_frame_dx=0;
	newyear_sy=0;
	step=0;
	flash=0;
	ny_anim=0;
	ny_anim_dx=1;
	palc=0;
	paln=0;
	out=FALSE;
	
	_frame=0;
	_bright=0;
	_done=0;
	
	set_irq_handler(IRQ_STAR);
	set_nmi_handler(NMI_STAR);		
	mmc3_irq_enable(31);
	
	pal_bright(_bright);
	ppu_on_all();
	
	ft_prev_frame=ft_current_frame;
	ft_prev_row=ft_current_row;
	
	while(!_done||_bright)
	{
		if(step==3&&ft_current_row>=48&&ft_current_row<56)
		{
			for(_i=0;_i<16;++_i) pal_req[_i]=0x0f;
				
			pal_req[2]=0x10;
			pal_req[3]=0x30;
				
			out=TRUE;
		}
		
		if(step>=2&&!flash&&!out)
		{
			++palc;
			
			if(palc>=320/8)
			{
				palc=0;
				++paln;
				
				if(paln>=4) paln=0;
				
				switch(paln)
				{
				case 0: memcpy(pal_req,star_palette_1,sizeof(pal_req)); break;
				case 1: memcpy(pal_req,star_palette_2,sizeof(pal_req)); break;
				case 2: memcpy(pal_req,star_palette_3,sizeof(pal_req)); break;
				case 3: memcpy(pal_req,star_palette_4,sizeof(pal_req)); break;
				}
			}
		}
		
		if(out)
		{
			if(!(_frame&15)) morph_palette();
		}
		else
		{
			memcpy(pal_scr,pal_req,sizeof(pal_scr));
		}
		
		pal_bg (pal_scr);
		pal_spr(pal_scr);
		
		oam_off=0;

		spark_update(out^1);
		
		newyear_sy=newyear_sine[ny_anim&63];
		
		oam_off=oam_meta_spr( 72,128-newyear_sy,oam_off,meta_newyear_l);
		oam_off=oam_meta_spr(192,128-newyear_sy,oam_off,meta_newyear_r);
		
		if(oam_off) oam_hide_rest(oam_off);
		
		oam_update();
		
		_chr=CHR_NEWYEAR_BG+newyear_sy*2;
	
		mmc3_chr_bank(_chr+0,4);
		mmc3_chr_bank(_chr+1,5);
	
		star_anim_frame=(star_frame>>8)&31;
		
		mmc3_chr_bank(CHR_STAR_LARGE+star_anim_frame,2);
		
		if(!flash)
		{
			if(!_done)
			{
				if(!(_frame&7))
				{
					if(_bright<4)
					{
						++_bright;
						pal_bright(_bright);
					}
				}
			}
			else
			{
				if(!(_frame&15))
				{
					if(_bright>0)
					{
						--_bright;
						pal_bright(_bright);
					}
				}
			}
		}
		else
		{
			if(!(_frame&3))
			{
				if(flash==1)
				{
					++_bright;
					
					if(_bright==8)
					{
						flash=2;
						
						switch(step)
						{
							case 1:
							{
								for(_i=4;_i<12;++_i) pal_req[_i]=star_palette_1[_i];
								
								for(_i=0;_i<8;++_i)
								{	
									if(_i<4)
									{
										star_small_anim_dx[_i]=-64;
									}
									else
									{
										star_small_anim_dx[_i]=64;
									}
								}
							}
							break;
							
							case 2:
							{
								for(_i=0;_i<8;++_i)
								{	
									if(_i<4)
									{
										star_small_anim_dx[_i]=-(128+_i*64);
									}
									else
									{
										star_small_anim_dx[_i]=128+(7-_i)*64;
									}
								}
	
								pal_req[1]=star_palette_1[1];
								
								ny_anim_dx=2;
							}
							break;
							
							case 3:
							{
								star_frame_dx=256;
								star_scroll_speed=4;
								star_scroll_speed_max=256*4;
							}
							break;
						}
					}
				}
				else
				{
					--_bright;
					
					if(_bright==4)
					{
						flash=0;
					}
				}
				
				pal_bright(_bright);
			}
		}

		set_vram_update();
		
		ppu_wait_nmi();

		for(_i=0;_i<8;++_i) star_small_anim[_i]+=star_small_anim_dx[_i];
		
		star_scroll_top+=star_scroll_top_dx;
		star_scroll_bottom+=star_scroll_bottom_dx;
		
		if(star_scroll_top_dir)
		{
			if(star_scroll_top_dx<star_scroll_speed_max) star_scroll_top_dx+=star_scroll_speed; else star_scroll_top_dir^=1;
		}
		else
		{
			if(star_scroll_top_dx>-star_scroll_speed_max) star_scroll_top_dx-=star_scroll_speed; else star_scroll_top_dir^=1;
		}
		
		if(star_scroll_bottom_dir)
		{
			if(star_scroll_bottom_dx<star_scroll_speed_max) star_scroll_bottom_dx+=star_scroll_speed; else star_scroll_bottom_dir^=1;
		}
		else
		{
			if(star_scroll_bottom_dx>-star_scroll_speed_max) star_scroll_bottom_dx-=star_scroll_speed; else star_scroll_bottom_dir^=1;
		}
		
		star_frame+=star_frame_dx;
		
		ny_anim+=ny_anim_dx;
		
		if(ft_current_row!=ft_prev_row)
		{
			ft_prev_row=ft_current_row;

			if(step<3)
			{
				if(ft_prev_row==60)
				{
					++step;
					flash=1;
				}
			}
			else
			{
				if(ft_prev_row==54)
				{
					_done=1;
				}
			}
		}
		
		++_frame;
	}
	
	ppu_off();
	
	mmc3_irq_enable(0);
}