.autoimport

.segment "ZEROPAGE"

NMI_CALL:				.res 3
JSR_CALL:				.res 3

.segment "FIXED"

nmi_handlers_list:

	.word nmi_empty							;0
	.word nmi_normal						;1	
	.word nmi_star							;2
	.word nmi_year							;3
	

;------------------------------------------------------------------------------

;void __fastcall__ set_nmi_handler(unsigned char id);

.export _set_nmi_handler

_set_nmi_handler:

	asl a
	tax
	lda nmi_handlers_list+0,x
	ldy nmi_handlers_list+1,x
	ldx #$40					;RTI
	stx <NMI_CALL+0
	sta <NMI_CALL+1
	sty <NMI_CALL+2
	lda #$4c					;JMP
	sta <NMI_CALL+0

	rts

	

;------------------------------------------------------------------------------

nmi_empty:

	inc <FRAME_CNT1
	rti
	
	
;------------------------------------------------------------------------------

nmi_normal:

	sta MMC3_IRQ_DISABLE
	
	pha
	txa
	pha
	tya
	pha

	lda <PPU_MASK_VAR	;if rendering is disabled, do not access the VRAM at all
	and #%00011000
	bne @doUpdate
	jmp	@skipAll

@doUpdate:

	lda <OAM_UPDATE
	beq @skipOAM
	dec <OAM_UPDATE

	lda #>OAM_BUF
	sta PPU_OAM_DMA

@skipOAM:

	lda <PAL_UPDATE			;update palette if needed
	bne @updPal
	jmp @updVRAM

@updPal:

	ldx #0
	stx <PAL_UPDATE

	lda #$3f
	sta PPU_ADDR
	stx PPU_ADDR			;X has to be zero

	.repeat 4,I
	ldy PAL_BUF+I
	lda (PAL_BG_PTR),y
	sta PPU_DATA
	.endrepeat

	ldy PAL_BUF
	lda (PAL_BG_PTR),y
	tax
	
	.repeat 3,J
	stx PPU_DATA
	.repeat 3,I
	ldy PAL_BUF+5+(J*4)+I
	lda (PAL_BG_PTR+(J+1)*2),y
	sta PPU_DATA
	.endrepeat
	.endrepeat

	.repeat 4,J
	stx PPU_DATA
	.repeat 3,I
	ldy PAL_BUF+17+(J*4)+I
	lda (PAL_SPR_PTR+J*2),y
	sta PPU_DATA
	.endrepeat
	.endrepeat
	

@updVRAM:

	lda <NAME_UPD_ENABLE
	beq @skipUpd
	
	jsr _flush_vram_update_nmi
	
	lda #0
	sta <NAME_UPD_ENABLE

@skipUpd:

	lda #0
	sta PPU_ADDR
	sta PPU_ADDR

	lda <SCROLL_X
	sta PPU_SCROLL
	lda <SCROLL_Y
	sta PPU_SCROLL

	lda <PPU_CTRL_VAR
	sta PPU_CTRL

@skipAll:

	ldx <IRQ_START_LINE
	beq :+
	stx MMC3_IRQ_DISABLE	;any value to disable
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
:

	;set CHR

	ldx #0					;first 4K
	lda <MMC3_CHR_SLOTS+0
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+1
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+2
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+3
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+4
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+5
	stx MMC3_CTRL
	sta MMC3_DATA

	lda <MMC3_CTRL_VAR
	sta MMC3_CTRL

	lda <PPU_MASK_VAR
	sta <PPU_MASK_VAR1
	sta PPU_MASK
	
	jsr IRQ_INIT

	inc <FRAME_CNT1

	lda <MUSIC_PLAY
	beq @skipmusic

	jsr ft_music_play_buf

@skipmusic:
	
	jsr mmc3_restore_prg
	
	pla
	tay
	pla
	tax
	pla

    rti


	
;------------------------------------------------------------------------------

star_anim_frames:

	.word star_frame_0,star_frame_1,star_frame_2,star_frame_3
	.word star_frame_4,star_frame_5,star_frame_6,star_frame_7
	.word star_frame_8,star_frame_9,star_frame_10,star_frame_11
	.word star_frame_12,star_frame_13,star_frame_14,star_frame_15
	.word star_frame_16,star_frame_17,star_frame_18,star_frame_19
	.word star_frame_20,star_frame_21,star_frame_22,star_frame_23
	.word star_frame_24,star_frame_25,star_frame_26,star_frame_27
	.word star_frame_28,star_frame_29,star_frame_30,star_frame_31

star_anim_pages:

	.repeat 16
	.byte PRG_STAR_ANIM
	.endrepeat
	.repeat 16
	.byte PRG_STAR_ANIM+1
	.endrepeat
	

	
nmi_star:

	sta MMC3_IRQ_DISABLE
	
	pha
	txa
	pha
	tya
	pha

	lda <PPU_MASK_VAR	;if rendering is disabled, do not access the VRAM at all
	and #%00011000
	bne @doUpdate
	jmp	@skipAll

@doUpdate:

	lda <OAM_UPDATE
	beq @skipOAM
	dec <OAM_UPDATE

	lda #>OAM_BUF
	sta PPU_OAM_DMA

@skipOAM:

	lda <PAL_UPDATE			;update palette if needed
	bne @updPal
	jmp @updVRAM

@updPal:

	ldx #0
	stx <PAL_UPDATE

	lda #$3f
	sta PPU_ADDR
	stx PPU_ADDR			;X has to be zero

	.repeat 4,I
	ldy PAL_BUF+I
	lda (PAL_BG_PTR),y
	sta PPU_DATA
	.endrepeat

	ldy PAL_BUF
	lda (PAL_BG_PTR),y
	tax
	
	.repeat 3,J
	stx PPU_DATA
	.repeat 3,I
	ldy PAL_BUF+5+(J*4)+I
	lda (PAL_BG_PTR),y
	sta PPU_DATA
	.endrepeat
	.endrepeat

	.repeat 4,J
	stx PPU_DATA
	.repeat 3,I
	ldy PAL_BUF+17+(J*4)+I
	lda (PAL_SPR_PTR),y
	sta PPU_DATA
	.endrepeat
	.endrepeat
	

@updVRAM:

	lda <NAME_UPD_ENABLE
	beq @skipUpd
	
	ldx _star_anim_frame
	lda star_anim_pages,x
	jsr mmc3_set_prg_temp
	
	lda _star_anim_frame	
	asl a
	tax
	lda #$4c	;JMP
	sta JSR_CALL+0
	lda star_anim_frames+0,x
	sta JSR_CALL+1
	lda star_anim_frames+1,x
	sta JSR_CALL+2
	jsr JSR_CALL

	lda #0
	sta <NAME_UPD_ENABLE
	
@skipUpd:

	lda #0
	sta PPU_ADDR
	sta PPU_ADDR

	;lda <SCROLL_X
	lda _star_scroll_top+1
	sta PPU_SCROLL
	lda <SCROLL_Y
	sta PPU_SCROLL

	lda <PPU_CTRL_VAR
	sta PPU_CTRL

@skipAll:

	ldx <IRQ_START_LINE
	beq :+
	stx MMC3_IRQ_DISABLE	;any value to disable
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
:

	;set CHR

	ldx #0					;first 4K
	lda <MMC3_CHR_SLOTS+0
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+1
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	
	lda _star_small_anim+0*2+1
	and #31
	clc
	adc #CHR_STAR_SMALL
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda _star_small_anim+1*2+1
	and #31
	clc
	adc #CHR_STAR_SMALL
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda _star_small_anim+2*2+1
	and #31
	clc
	adc #CHR_STAR_SMALL
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda _star_small_anim+3*2+1
	and #31
	clc
	adc #CHR_STAR_SMALL
	stx MMC3_CTRL
	sta MMC3_DATA

	lda <MMC3_CTRL_VAR
	sta MMC3_CTRL

	lda <PPU_MASK_VAR
	sta <PPU_MASK_VAR1
	sta PPU_MASK
	
	jsr IRQ_INIT

	inc <FRAME_CNT1

	lda <MUSIC_PLAY
	beq @skipmusic

	jsr ft_music_play_buf
	
@skipmusic:
	
	jsr mmc3_restore_prg
	
	pla
	tay
	pla
	tax
	pla

    rti

	
	
;------------------------------------------------------------------------------

nmi_year:

	sta MMC3_IRQ_DISABLE
	
	pha
	txa
	pha
	tya
	pha

	lda <PPU_MASK_VAR	;if rendering is disabled, do not access the VRAM at all
	and #%00011000
	bne @doUpdate
	jmp	@skipAll

@doUpdate:

	lda <OAM_UPDATE
	beq @skipOAM
	dec <OAM_UPDATE

	lda #>OAM_BUF
	sta PPU_OAM_DMA

@skipOAM:

	lda <PAL_UPDATE			;update palette if needed
	bne @updPal
	jmp @updVRAM

@updPal:

	ldx #0
	stx <PAL_UPDATE

	lda #$3f
	sta PPU_ADDR
	stx PPU_ADDR			;X has to be zero

	.repeat 4,I
	ldy PAL_BUF+I
	lda (PAL_BG_PTR),y
	sta PPU_DATA
	.endrepeat

	ldy PAL_BUF
	lda (PAL_BG_PTR),y
	tax
	
	.repeat 3,J
	stx PPU_DATA
	.repeat 3,I
	ldy PAL_BUF+5+(J*4)+I
	lda (PAL_BG_PTR),y
	sta PPU_DATA
	.endrepeat
	.endrepeat

	.repeat 4,J
	stx PPU_DATA
	.repeat 3,I
	ldy PAL_BUF+17+(J*4)+I
	lda (PAL_SPR_PTR),y
	sta PPU_DATA
	.endrepeat
	.endrepeat
	

@updVRAM:

	lda <NAME_UPD_ENABLE
	beq @skipUpd
	
	ldx _star_anim_frame
	lda star_anim_pages,x
	jsr mmc3_set_prg_temp
	
	lda _star_anim_frame	
	asl a
	tax
	lda #$4c	;JMP
	sta JSR_CALL+0
	lda star_anim_frames+0,x
	sta JSR_CALL+1
	lda star_anim_frames+1,x
	sta JSR_CALL+2
	jsr JSR_CALL

	lda #0
	sta <NAME_UPD_ENABLE
	
@skipUpd:

	lda #0
	sta PPU_ADDR
	sta PPU_ADDR

	;lda <SCROLL_X
	lda _year_scroll+1+0*2
	sta PPU_SCROLL
	lda <SCROLL_Y
	sta PPU_SCROLL

	lda <PPU_CTRL_VAR
	sta PPU_CTRL

@skipAll:

	ldx <IRQ_START_LINE
	beq :+
	stx MMC3_IRQ_DISABLE	;any value to disable
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
:

	;set CHR

	ldx #0					;first 4K
	lda <MMC3_CHR_SLOTS+0
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+1
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	
	lda #CHR_SPRITES
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	stx MMC3_CTRL
	sta MMC3_DATA

	lda <MMC3_CTRL_VAR
	sta MMC3_CTRL

	lda <PPU_MASK_VAR
	sta <PPU_MASK_VAR1
	sta PPU_MASK
	
	jsr IRQ_INIT

	inc <FRAME_CNT1

	lda <MUSIC_PLAY
	beq @skipmusic

	jsr ft_music_play_buf
	
@skipmusic:
	
	jsr mmc3_restore_prg
	
	pla
	tay
	pla
	tax
	pla

    rti

