
	org #8000

	;test code

begin

	ld hl,music_data
	call play
	ret
	
	
	
	;engine code

;squat by Shiru, 06'17
;Squeeker like, just without the output value table
;4 channels of tone with different duty cycle
;sample drums, non-interrupting
;customizeable noise percussion, interrupting


;music data is all 16-bit words, first control then a few optional ones

;control word is PSSSSSSS DDDN4321, where P=percussion,S=speed, D=drum, N=noise mode, 4321=channels
;D triggers non-interruping sample drum
;P trigger
;if 1, channel 1 freq follows
;if 2, channel 2 freq follows
;if 3, channel 3 freq follows
;if 4, channel 4 freq follows
;if N, channel 4 mode follows, it is either #0000 (normal) or #04cb (noise)
;if P, percussion follows, LSB=volume, MSB=pitch



RLC_H equ #04cb			;to enable noise mode
NOP_2 equ #0000			;to disable noise mode
RLC_HL equ #06cb		;to enable sample reading
ADD_IX_IX equ #29dd		;to disable sample reading


play

	di
    exx
    push hl
    push iy
    exx
    ld (oldSP),sp
	
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (loop_ptr),de
	
	ld (pattern_ptr),hl
	
	ld hl,ADD_IX_IX
	ld (sample_read),hl
	ld hl,NOP_2					;normal mode
	ld (noise_mode),hl
	
	ld ix,0						;needs to be 0 to skip sample reading

	ld c,0
	exx
	ld de,#0808					;sample bit counter and reload value

play_loop

pattern_ptr equ $+1
	ld sp,0
	
return_loop

	pop bc						;control word
								;B=duration of the row (0=loop)
								;C=flags DDDN4321 (Drum, Noise, 1-4 channel update)
	ld a,b
	or a
	jp nz,no_loop
	
loop_ptr equ $+1
	ld sp,0
	
	jp exit
	
no_loop

	ld a,c
	
	rra
	jr nc,skip_note_0
	
	pop hl
	ld (ch0_add),hl
	
skip_note_0

	rra
	jr nc,skip_note_1

	pop hl
	ld (ch1_add),hl
	
skip_note_1

	rra
	jr nc,skip_note_2
	
	pop hl
	ld (ch2_add),hl
	
skip_note_2

	rra
	jr nc,skip_note_3
	
	pop hl
	ld (ch3_add),hl
	
skip_note_3

	rra
	jr nc,skip_mode_change
	
	pop hl						;nop:nop or rlc h
	ld (noise_mode),hl

skip_mode_change

	and 7
	jp z,skip_drum
	
	ld hl,sample_list-2
	add a,a
	add a,l
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl)
	ld l,a
	ld (sample_ptr),hl
	ld hl,RLC_HL
	ld (sample_read),hl

skip_drum

	bit 7,b						;check percussion flag
	jp z,skip_percussion

	res 7,b						;clear percussion flag
	dec b						;compensate speed

	ld (noise_bc),bc
	ld (noise_de),de

	pop hl						;read percussion parameters

	ld a,l						;noise volume
	ld (noise_volume),a
	ld b,h						;noise pitch
	ld c,h
	ld de,#2174					;utz's rand seed			
	exx
	ld bc,811					;noise duration, takes as long as inner sound loop

noise_loop

	exx							;4
	dec c						;4
	jr nz,noise_skip			;7/12
	ld c,b						;4
	add hl,de					;11
	rlc h						;8		utz's noise generator idea
	inc d						;4		improves randomness
	jp noise_next				;10
	
noise_skip

	jr $+2						;12
	jr $+2						;12
	nop							;4
	nop							;4
	
noise_next

	ld a,h						;4
	
noise_volume equ $+1
	cp #80						;7
	sbc a,a						;4
	out (#fe),a					;11
	exx							;4

	dec bc						;6
	ld a,b						;4
	or c						;4
	jp nz,noise_loop			;10=106t

	exx

noise_bc equ $+1
	ld bc,0
noise_de equ $+1
	ld de,0



skip_percussion

	ld (pattern_ptr),sp

sample_ptr equ $+1
	ld hl,0

	ld c,0						;internal loop runs 256 times

sound_loop

sample_read equ $
	rlc (hl)					;15 	rotate sample bits in place, rl (hl) or add ix,ix (dummy operation)
	sbc a,a						;4		sbc a,a to make bit into 0 or 255, or xor a to keep it 0

	dec e						;4--+	count bits
	jp z,sample_cycle			;10 |
	jp sample_next				;10

sample_cycle

	ld e,d						;4	|	reload counter
	inc hl						;6--+	advance pointer --24t

sample_next

	exx							;4		squeeker type unrolled code
	ld b,a						;4		sample mask
	xor a						;4
	
	ld sp,sound_list			;10
		
	pop de						;10		ch0_acc
	pop hl						;10		ch0_add
	add hl,de					;11
	rla							;4
	ld (ch0_acc),hl				;16
						
	pop de						;10		ch1_acc
	pop hl						;10		ch1_add
	add hl,de					;11
	rla							;4
	ld (ch1_acc),hl				;16
	
	pop de						;10		ch2_acc
	pop hl						;10		ch2_add
	add hl,de					;11
	rla							;4
	ld (ch2_acc),hl				;16

	pop de						;10		ch3_acc
	pop hl						;10		ch3_add
	add hl,de					;11
	
noise_mode equ $
	ds 2,0						;8		rlc h for noise effects

	rla							;4
	ld (ch3_acc),hl				;16

	add a,c						;4		no table like in Squeeker, channels summed as is, for uneven 'volume'
	add a,#ff					;7
	sbc a,#ff					;7
	ld c,a						;4
	sbc a,a						;4

	or b						;4		mix sample
	
	out (#fe),a					;11
		
	exx							;4

	dec c						;4
	jp nz,sound_loop			;10=336t


	dec hl						;last byte of a 256 byte sample packet is 0 means it was the last packet
	ld a,(hl)
	inc hl
	or a						;check for 0
	jr nz,sample_no_stop

	ld hl,ADD_IX_IX
	ld (sample_read),hl			;disable sample reading

sample_no_stop

	djnz sound_loop

	ld (sample_ptr),hl
	
	jp play_loop
	
exit
oldSP equ $+1
    ld sp,0
    pop iy
    pop hl
    exx
    ei
    ret
	
	;; align 2
    org $ + ($ & 1)

sample_list

	dw sample_1
	dw sample_2
	dw sample_3
	dw sample_4
	dw sample_5
	dw sample_6
	dw sample_7
	
;variables in the sound_list can't be reordered because of stack-based fetching

sound_list

ch0_add		dw 0
ch0_acc		dw 0
ch1_add		dw 0
ch1_acc		dw 0
ch2_add		dw 0
ch2_acc		dw 0
ch3_add		dw 0
ch3_acc		dw 0


;sample data

	;; align 256
    org #8200
sample_1
	db 128,18,72,178,75,0,0,0,0,0,240,255,255,255,255,31
	db 0,0,0,0,0,0,0,192,255,255,255,255,255,127,0,0
	db 0,0,0,0,0,0,0,0,224,255,255,255,255,255,1,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
sample_2
	db 128,255,255,0,0,0,240,255,255,63,0,0,0,248,255,255
	db 7,0,0,0,255,255,255,0,0,0,224,255,255,31,0,0
	db 0,248,255,255,7,0,0,0,254,255,255,0,0,0,128,255
	db 255,63,0,0,0,224,255,255,7,0,0,0,252,255,255,1
	db 0,0,0,255,255,63,0,0,0,128,255,255,15,0,0,0
	db 240,255,255,3,0,0,0,248,255,255,0,0,0,0,255,255
	db 7,0,0,0,128,255,255,3,0,0,0,224,255,31,0,0
	db 0,0,240,255,63,0,0,0,0,252,255,1,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
sample_3
	db 0,252,255,255,7,0,0,0,0,0,252,255,255,255,255,3
	db 0,0,0,0,0,128,255,255,255,255,255,15,0,0,0,0
	db 0,0,255,255,255,255,255,31,0,0,0,0,0,0,252,255
	db 255,255,255,63,0,0,0,0,0,0,240,255,255,255,255,255
	db 1,0,0,0,0,0,0,255,255,255,255,255,3,0,0,0
	db 0,0,0,255,255,255,255,255,31,0,0,0,0,0,0,240
	db 255,255,255,255,31,0,0,0,0,0,0,128,255,255,255,255
	db 255,1,0,0,0,0,0,0,254,255,255,255,255,7,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
sample_4
	db 0,50,128,3,64,224,4,2,224,2,52,128,5,28,128,64
	db 0,112,128,83,34,29,128,8,72,0,66,1,64,34,64,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
sample_5
sample_6
sample_7


;compiled music data

music_data
	dw .loop
.pattern
.loop
	dw #258,#1344,RLC_H
	dw #218,#0,NOP_2
	dw #200
	dw #200
	dw #240
	dw #200
	dw #240
	dw #200
	dw #278,#1344,RLC_H
	dw #218,#0,NOP_2
	dw #200
	dw #200
	dw #260
	dw #200
	dw #260
	dw #200
	dw #22f,#103,#206,#40c,#4d1
	dw #200
	dw #200
	dw #202,#0
	dw #20f,#103,#206,#0,#0
	dw #203,#0,#0
	dw #283,#103,#206
	dw #203,#0,#0
	dw #23b,#103,#206,#737,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #202,#0
	dw #28f,#103,#206,#40c,#4d1
	dw #203,#0,#0
	dw #28f,#103,#206,#48b,#568
	dw #203,#0,#0
	dw #22f,#103,#206,#4d1,#611
	dw #200
	dw #20c,#0,#0
	dw #202,#0
	dw #20f,#103,#206,#48b,#568
	dw #203,#0,#0
	dw #28f,#103,#206,#0,#0
	dw #203,#0,#0
	dw #23f,#103,#206,#40c,#737,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #202,#0
	dw #28f,#134,#268,#611,#268
	dw #203,#0,#0
	dw #283,#134,#268
	dw #203,#0,#0
	dw #22f,#134,#268,#0,#0
	dw #200
	dw #200
	dw #203,#0,#0
	dw #203,#134,#268
	dw #203,#0,#0
	dw #203,#134,#268
	dw #203,#0,#0
	dw #23b,#134,#268,#737,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#134,#268,#40c,#4d1
	dw #203,#0,#0
	dw #28f,#134,#268,#0,#0
	dw #203,#0,#0
	dw #22f,#134,#268,#4d1,#611
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#134,#268,#48b,#568
	dw #203,#0,#0
	dw #28f,#134,#268,#0,#0
	dw #203,#0,#0
	dw #23f,#134,#268,#40c,#737,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#11a,#245,#568,#66e
	dw #203,#0,#0
	dw #283,#11a,#245
	dw #203,#0,#0
	dw #22f,#11a,#245,#0,#0
	dw #200
	dw #200
	dw #203,#0,#0
	dw #203,#11a,#245
	dw #203,#0,#0
	dw #203,#11a,#245
	dw #203,#0,#0
	dw #23b,#11a,#245,#737,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#11a,#245,#40c,#4d1
	dw #203,#0,#0
	dw #28f,#11a,#245,#0,#0
	dw #203,#0,#0
	dw #22f,#11a,#245,#4d1,#611
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#11a,#245,#48b,#568
	dw #203,#0,#0
	dw #28f,#11a,#245,#0,#0
	dw #203,#0,#0
	dw #23f,#11a,#245,#40c,#737,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#fb,#1fe,#48b,#611
	dw #207,#0,#0,#4d1
	dw #283,#fb,#1fe
	dw #203,#0,#0
	dw #223,#fb,#1fe
	dw #200
	dw #200
	dw #203,#0,#0
	dw #20f,#fb,#1fe,#40c,#4d1
	dw #203,#0,#0
	dw #28f,#fb,#1fe,#0,#0
	dw #203,#0,#0
	dw #23f,#fb,#1fe,#40c,#737,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#fb,#1fe,#39b,#48b
	dw #203,#0,#0
	dw #28f,#fb,#1fe,#0,#0
	dw #203,#0,#0
	dw #22f,#fb,#1fe,#39b,#48b
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #28f,#fb,#1fe,#40c,#4d1
	dw #203,#0,#0
	dw #20f,#fb,#1fe,#0,#0
	dw #203,#0,#0
	dw #23f,#1fe,#404,#40c,#737,RLC_H
	dw #21b,#0,#0,#0,NOP_2
	dw #21b,#1fe,#404,#737,RLC_H
	dw #203,#0,#0
	dw #21f,#1fe,#404,#0,#0,NOP_2
	dw #203,#0,#0
	dw #203,#1fe,#404
	dw #203,#0,#0
	dw #22f,#103,#206,#40c,#9a2
	dw #200
	dw #200
	dw #203,#0,#0
	dw #20f,#103,#206,#0,#0
	dw #203,#0,#0
	dw #283,#103,#206
	dw #203,#0,#0
	dw #23b,#103,#206,#e6e,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#103,#206,#40c,#9a2
	dw #203,#0,#0
	dw #28f,#103,#206,#48b,#ad0
	dw #203,#0,#0
	dw #22f,#103,#206,#4d1,#c23
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#103,#206,#48b,#ad0
	dw #203,#0,#0
	dw #28f,#103,#206,#0,#0
	dw #203,#0,#0
	dw #23f,#103,#206,#40c,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#134,#268,#40c,#c23
	dw #203,#0,#0
	dw #283,#134,#268
	dw #203,#0,#0
	dw #22f,#134,#268,#0,#0
	dw #200
	dw #200
	dw #203,#0,#0
	dw #203,#134,#268
	dw #203,#0,#0
	dw #203,#134,#268
	dw #203,#0,#0
	dw #23b,#134,#268,#e6e,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#134,#268,#40c,#9a2
	dw #203,#0,#0
	dw #28f,#134,#268,#0,#0
	dw #203,#0,#0
	dw #22f,#134,#268,#4d1,#c23
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#134,#268,#48b,#ad0
	dw #203,#0,#0
	dw #28f,#134,#268,#0,#0
	dw #203,#0,#0
	dw #23f,#134,#268,#40c,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#122,#245,#568,#cdc
	dw #203,#0,#0
	dw #283,#122,#245
	dw #203,#0,#0
	dw #22f,#122,#245,#0,#0
	dw #200
	dw #200
	dw #203,#0,#0
	dw #203,#122,#245
	dw #203,#0,#0
	dw #203,#122,#245
	dw #203,#0,#0
	dw #23b,#122,#245,#e6e,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#122,#245,#40c,#9a2
	dw #203,#0,#0
	dw #28f,#122,#245,#48b,#ad0
	dw #203,#0,#0
	dw #22f,#122,#245,#4d1,#c23
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#122,#245,#48b,#ad0
	dw #203,#0,#0
	dw #28f,#122,#245,#0,#0
	dw #203,#0,#0
	dw #23f,#122,#245,#40c,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#103,#206,#4d1,#c23
	dw #203,#0,#0
	dw #283,#103,#206
	dw #203,#0,#0
	dw #223,#103,#206
	dw #200
	dw #200
	dw #203,#0,#0
	dw #20f,#103,#206,#40c,#9a2
	dw #203,#0,#0
	dw #28f,#103,#206,#0,#0
	dw #203,#0,#0
	dw #23f,#103,#206,#40c,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#103,#206,#39b,#917
	dw #203,#0,#0
	dw #28f,#103,#206,#0,#0
	dw #203,#0,#0
	dw #22f,#103,#206,#39b,#917
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#103,#206,#40c,#9a2
	dw #203,#0,#0
	dw #20f,#103,#206,#0,#0
	dw #203,#0,#0
	dw #23f,#103,#206,#40c,#737,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #23f,#103,#206,#0,#737,RLC_H
	dw #203,#0,#0
	dw #29b,#103,#206,#0,NOP_2
	dw #283,#0,#0
	dw #22f,#184,#308,#819,#9a2
	dw #200
	dw #200
	dw #202,#0
	dw #20f,#184,#308,#0,#0
	dw #203,#0,#0
	dw #283,#184,#308
	dw #203,#0,#0
	dw #23b,#184,#308,#e6e,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#184,#308,#819,#9a2
	dw #203,#0,#0
	dw #28f,#184,#308,#917,#ad0
	dw #203,#0,#0
	dw #22f,#184,#308,#9a2,#c23
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#184,#308,#917,#ad0
	dw #203,#0,#0
	dw #28f,#184,#308,#0,#0
	dw #203,#0,#0
	dw #23f,#184,#308,#819,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #202,#0
	dw #28f,#184,#308,#4d1,#819
	dw #203,#0,#0
	dw #283,#184,#308
	dw #203,#0,#0
	dw #22f,#184,#308,#0,#0
	dw #200
	dw #200
	dw #202,#0
	dw #203,#184,#308
	dw #203,#0,#0
	dw #203,#184,#308
	dw #203,#0,#0
	dw #23b,#184,#308,#e6e,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#184,#308,#819,#9a2
	dw #203,#0,#0
	dw #28f,#184,#308,#917,#ad0
	dw #203,#0,#0
	dw #22f,#184,#308,#9a2,#c23
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#184,#308,#917,#ad0
	dw #203,#0,#0
	dw #28f,#184,#308,#0,#0
	dw #203,#0,#0
	dw #23f,#184,#308,#819,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#819,#c23
	dw #203,#0,#0
	dw #283,#15a,#2b4
	dw #203,#0,#0
	dw #22f,#15a,#2b4,#0,#0
	dw #200
	dw #200
	dw #203,#0,#0
	dw #203,#15a,#2b4
	dw #203,#0,#0
	dw #203,#15a,#2b4
	dw #203,#0,#0
	dw #23b,#15a,#2b4,#e6e,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#819,#9a2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#917,#ad0
	dw #203,#0,#0
	dw #22f,#15a,#2b4,#9a2,#c23
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#15a,#2b4,#917,#ad0
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#0,#0
	dw #203,#0,#0
	dw #23f,#15a,#2b4,#819,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#9a2,#c23
	dw #203,#0,#0
	dw #283,#15a,#2b4
	dw #203,#0,#0
	dw #223,#15a,#2b4
	dw #200
	dw #200
	dw #203,#0,#0
	dw #20f,#15a,#2b4,#819,#9a2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#0,#0
	dw #203,#0,#0
	dw #23f,#15a,#2b4,#819,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#737,#917
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#0,#0
	dw #203,#0,#0
	dw #22f,#15a,#2b4,#737,#917
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#15a,#2b4,#819,#9a2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#0,#0
	dw #203,#0,#0
	dw #23f,#15a,#2b4,#819,#e6e,RLC_H
	dw #218,#0,NOP_2
	dw #218,#e6e,RLC_H
	dw #203,#0,#0
	dw #29f,#15a,#2b4,#0,#0,NOP_2
	dw #203,#0,#0
	dw #283,#15a,#2b4
	dw #283,#0,#0
	dw #22f,#184,#308,#40c,#9a2
	dw #200
	dw #200
	dw #203,#0,#0
	dw #20f,#184,#308,#0,#0
	dw #203,#0,#0
	dw #283,#184,#308
	dw #203,#0,#0
	dw #23b,#184,#308,#e6e,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#184,#308,#40c,#9a2
	dw #203,#0,#0
	dw #28f,#184,#308,#48b,#ad0
	dw #203,#0,#0
	dw #22f,#184,#308,#4d1,#c23
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#184,#308,#48b,#ad0
	dw #203,#0,#0
	dw #28f,#184,#308,#0,#0
	dw #203,#0,#0
	dw #23f,#184,#308,#40c,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#611,#9a2
	dw #203,#0,#0
	dw #283,#15a,#2b4
	dw #203,#0,#0
	dw #22f,#15a,#2b4,#0,#0
	dw #200
	dw #200
	dw #203,#0,#0
	dw #203,#15a,#2b4
	dw #203,#0,#0
	dw #203,#15a,#2b4
	dw #203,#0,#0
	dw #23b,#15a,#2b4,#e6e,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#40c,#9a2
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#48b,#ad0
	dw #203,#0,#0
	dw #22f,#15a,#2b4,#4d1,#c23
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#15a,#2b4,#48b,#ad0
	dw #203,#0,#0
	dw #28f,#15a,#2b4,#0,#0
	dw #203,#0,#0
	dw #23f,#15a,#2b4,#40c,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#134,#268,#4d1,#c23
	dw #203,#0,#0
	dw #283,#134,#268
	dw #203,#0,#0
	dw #22f,#134,#268,#0,#0
	dw #200
	dw #200
	dw #203,#0,#0
	dw #203,#134,#268
	dw #203,#0,#0
	dw #203,#134,#268
	dw #203,#0,#0
	dw #23b,#134,#268,#e6e,RLC_H
	dw #200
	dw #218,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#134,#268,#40c,#9a2
	dw #203,#0,#0
	dw #28f,#134,#268,#48b,#ad0
	dw #203,#0,#0
	dw #22f,#134,#268,#4d1,#c23
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#134,#268,#48b,#ad0
	dw #203,#0,#0
	dw #28f,#134,#268,#0,#0
	dw #203,#0,#0
	dw #23f,#134,#268,#40c,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#122,#245,#4d1,#c23
	dw #203,#0,#0
	dw #283,#122,#245
	dw #203,#0,#0
	dw #223,#122,#245
	dw #200
	dw #200
	dw #203,#0,#0
	dw #20f,#122,#245,#40c,#9a2
	dw #203,#0,#0
	dw #28f,#122,#245,#0,#0
	dw #203,#0,#0
	dw #23f,#122,#245,#40c,#e6e,RLC_H
	dw #200
	dw #21c,#0,#0,NOP_2
	dw #203,#0,#0
	dw #28f,#122,#245,#39b,#917
	dw #203,#0,#0
	dw #28f,#122,#245,#0,#0
	dw #203,#0,#0
	dw #22f,#122,#245,#39b,#917
	dw #200
	dw #20c,#0,#0
	dw #203,#0,#0
	dw #20f,#122,#245,#40c,#9a2
	dw #203,#0,#0
	dw #28f,#122,#245,#0,#0
	dw #203,#0,#0
	dw #25f,#122,#245,#40c,#e6e,RLC_H
	dw #218,#0,NOP_2
	dw #258,#e6e,RLC_H
	dw #203,#0,#245
	dw #27f,#122,#225,#0,#0,NOP_2
	dw #203,#0,#206
	dw #263,#122,#1e9
	dw #203,#0,#1cd
	dw #22f,#103,#206,#9a2,#9a2
	dw #208,#0
	dw #208,#c23
	dw #20a,#0,#0
	dw #20e,#206,#0,#ad0
	dw #20a,#0,#0
	dw #28a,#206,#c23
	dw #20a,#0,#0
	dw #23a,#206,#9a2,RLC_H
	dw #218,#0,NOP_2
	dw #208,#c23
	dw #20a,#0,#0
	dw #28e,#206,#819,#ad0
	dw #20a,#0,#0
	dw #28e,#206,#917,#c23
	dw #20a,#0,#0
	dw #22e,#206,#9a2,#9a2
	dw #208,#0
	dw #20c,#0,#c23
	dw #20a,#0,#0
	dw #20e,#206,#917,#ad0
	dw #20a,#0,#0
	dw #28e,#206,#0,#c23
	dw #20a,#0,#0
	dw #23e,#206,#819,#9a2,RLC_H
	dw #218,#0,NOP_2
	dw #20c,#0,#c23
	dw #20a,#0,#0
	dw #28e,#206,#c23,#ad0
	dw #20a,#0,#0
	dw #28a,#206,#c23
	dw #20a,#0,#0
	dw #22e,#206,#0,#9a2
	dw #208,#0
	dw #208,#c23
	dw #20a,#0,#0
	dw #20a,#206,#ad0
	dw #20a,#0,#0
	dw #20a,#206,#c23
	dw #20a,#0,#0
	dw #23a,#206,#9a2,RLC_H
	dw #218,#0,NOP_2
	dw #208,#c23
	dw #20a,#0,#0
	dw #28e,#206,#819,#ad0
	dw #20a,#0,#0
	dw #28e,#206,#0,#c23
	dw #20a,#0,#0
	dw #22e,#206,#9a2,#9a2
	dw #208,#0
	dw #20c,#0,#c23
	dw #20a,#0,#0
	dw #20e,#206,#917,#ad0
	dw #20a,#0,#0
	dw #28e,#206,#0,#c23
	dw #20a,#0,#0
	dw #23e,#206,#819,#9a2,RLC_H
	dw #218,#0,NOP_2
	dw #20c,#0,#c23
	dw #20a,#0,#0
	dw #28e,#206,#ad0,#ad0
	dw #20a,#0,#0
	dw #28a,#206,#c23
	dw #20a,#0,#0
	dw #22e,#206,#0,#9a2
	dw #208,#0
	dw #208,#c23
	dw #20a,#0,#0
	dw #20a,#206,#ad0
	dw #20a,#0,#0
	dw #20a,#206,#c23
	dw #20a,#0,#0
	dw #23a,#206,#9a2,RLC_H
	dw #218,#0,NOP_2
	dw #208,#c23
	dw #20a,#0,#0
	dw #28e,#206,#819,#ad0
	dw #20a,#0,#0
	dw #28e,#206,#0,#c23
	dw #20a,#0,#0
	dw #22e,#206,#9a2,#9a2
	dw #208,#0
	dw #20c,#0,#c23
	dw #20a,#0,#0
	dw #20e,#206,#917,#ad0
	dw #20a,#0,#0
	dw #28e,#206,#0,#c23
	dw #20a,#0,#0
	dw #23e,#206,#819,#9a2,RLC_H
	dw #218,#0,NOP_2
	dw #20c,#0,#c23
	dw #20a,#0,#0
	dw #28e,#206,#9a2,#ad0
	dw #20a,#0,#0
	dw #28a,#206,#c23
	dw #20a,#0,#0
	dw #22a,#206,#9a2
	dw #208,#0
	dw #208,#c23
	dw #20a,#0,#0
	dw #20e,#206,#819,#ad0
	dw #20a,#0,#0
	dw #28e,#206,#0,#c23
	dw #20a,#0,#0
	dw #23e,#206,#819,#9a2,RLC_H
	dw #218,#0,NOP_2
	dw #20c,#0,#c23
	dw #20a,#0,#0
	dw #28e,#206,#737,#ad0
	dw #20a,#0,#0
	dw #28e,#206,#0,#c23
	dw #20a,#0,#0
	dw #22e,#206,#737,#9a2
	dw #208,#0
	dw #20c,#0,#c23
	dw #20a,#0,#0
	dw #20f,#206,#206,#819,#ad0
	dw #20a,#0,#0
	dw #28e,#206,#0,#c23
	dw #20a,#0,#0
	dw #23e,#206,#819,#9a2,RLC_H
	dw #218,#0,NOP_2
	dw #218,#c23,RLC_H
	dw #21a,#0,#0,NOP_2
	dw #22e,#206,#0,#ad0
	dw #20a,#0,#0
	dw #20a,#206,#c23
	dw #20a,#0,#0
	dw #22f,#103,#206,#40c,#9a2
	dw #208,#40c
	dw #208,#c23
	dw #20a,#0,#40c
	dw #20e,#206,#0,#ad0
	dw #20a,#0,#40c
	dw #28a,#206,#c23
	dw #20a,#0,#40c
	dw #23a,#206,#9a2,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#c23
	dw #20a,#0,#40c
	dw #28e,#206,#40c,#ad0
	dw #20a,#0,#40c
	dw #28e,#206,#48b,#c23
	dw #20a,#0,#48b
	dw #22e,#206,#4d1,#9a2
	dw #208,#4d1
	dw #20c,#0,#c23
	dw #20a,#0,#40c
	dw #20e,#206,#48b,#ad0
	dw #20a,#0,#40c
	dw #28e,#206,#0,#c23
	dw #20a,#0,#40c
	dw #23e,#206,#40c,#9a2,RLC_H
	dw #218,#40c,NOP_2
	dw #20c,#0,#c23
	dw #20a,#0,#40c
	dw #28e,#206,#611,#ad0
	dw #20a,#0,#40c
	dw #28a,#206,#c23
	dw #20a,#0,#40c
	dw #22e,#206,#0,#9a2
	dw #208,#40c
	dw #208,#c23
	dw #20a,#0,#40c
	dw #20a,#206,#ad0
	dw #20a,#0,#40c
	dw #20a,#206,#c23
	dw #20a,#0,#40c
	dw #23a,#206,#9a2,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#c23
	dw #20a,#0,#40c
	dw #28e,#206,#40c,#ad0
	dw #20a,#0,#40c
	dw #28e,#206,#0,#c23
	dw #20a,#0,#40c
	dw #22e,#206,#4d1,#9a2
	dw #208,#40c
	dw #20c,#0,#c23
	dw #20a,#0,#40c
	dw #20e,#206,#48b,#ad0
	dw #20a,#0,#40c
	dw #28e,#206,#0,#c23
	dw #20a,#0,#40c
	dw #23e,#206,#40c,#9a2,RLC_H
	dw #218,#40c,NOP_2
	dw #20c,#0,#c23
	dw #20a,#0,#40c
	dw #28e,#206,#568,#ad0
	dw #20a,#0,#40c
	dw #28a,#206,#c23
	dw #20a,#0,#40c
	dw #22f,#206,#103,#0,#9a2
	dw #208,#40c
	dw #208,#c23
	dw #209,#0,#40c
	dw #209,#206,#ad0
	dw #209,#0,#40c
	dw #209,#206,#40c
	dw #209,#0,#819
	dw #239,#206,#9a2,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#c23
	dw #209,#0,#40c
	dw #28d,#206,#40c,#ad0
	dw #209,#0,#40c
	dw #289,#206,#c23
	dw #20d,#0,#48b,#40c
	dw #22d,#206,#4d1,#9a2
	dw #208,#40c
	dw #20c,#0,#c23
	dw #209,#0,#40c
	dw #20d,#206,#48b,#ad0
	dw #209,#0,#40c
	dw #28d,#206,#0,#c23
	dw #209,#0,#40c
	dw #23d,#206,#40c,#9a2,RLC_H
	dw #218,#40c,NOP_2
	dw #20c,#0,#c23
	dw #209,#0,#40c
	dw #28f,#206,#103,#4d1,#ad0
	dw #20b,#0,#0,#40c
	dw #28b,#206,#103,#c23
	dw #20b,#0,#0,#40c
	dw #22b,#206,#103,#9a2
	dw #208,#40c
	dw #208,#c23
	dw #20b,#0,#0,#40c
	dw #20f,#206,#103,#40c,#ad0
	dw #20b,#0,#0,#40c
	dw #28f,#206,#103,#0,#c23
	dw #20b,#0,#0,#40c
	dw #23f,#206,#103,#40c,#9a2,RLC_H
	dw #218,#40c,NOP_2
	dw #20c,#0,#c23
	dw #20b,#0,#0,#40c
	dw #28f,#206,#103,#39b,#ad0
	dw #20b,#0,#0,#40c
	dw #28f,#206,#103,#0,#c23
	dw #20b,#0,#0,#40c
	dw #22f,#206,#206,#39b,#9a2
	dw #208,#40c
	dw #20c,#0,#c23
	dw #20b,#0,#0,#40c
	dw #20f,#206,#206,#40c,#ad0
	dw #20b,#0,#0,#40c
	dw #28f,#206,#206,#0,#c23
	dw #20b,#0,#0,#40c
	dw #25f,#337,#206,#40c,#9a2,RLC_H
	dw #219,#308,#40c,NOP_2
	dw #259,#2dd,#c23,RLC_H
	dw #21b,#2b4,#0,#40c,NOP_2
	dw #26f,#28d,#206,#0,#ad0
	dw #20b,#268,#0,#40c
	dw #26b,#245,#206,#c23
	dw #20b,#225,#0,#40c
	dw #22f,#103,#206,#99a,#9a2
	dw #20c,#811,#819
	dw #22c,#c1b,#c23
	dw #20e,#0,#811,#819
	dw #20e,#206,#ac8,#ad0
	dw #20e,#0,#811,#819
	dw #28e,#206,#c1b,#c23
	dw #20e,#0,#811,#819
	dw #23e,#206,#99a,#9a2,RLC_H
	dw #21c,#811,#819,NOP_2
	dw #20c,#c1b,#c23
	dw #20e,#0,#811,#819
	dw #22e,#206,#ac8,#ad0
	dw #20e,#0,#811,#819
	dw #28e,#206,#c1b,#c23
	dw #20e,#0,#90f,#917
	dw #22e,#206,#99a,#9a2
	dw #20c,#99a,#9a2
	dw #20c,#c1b,#c23
	dw #20e,#0,#811,#819
	dw #20e,#206,#ac8,#ad0
	dw #20e,#0,#811,#819
	dw #28e,#206,#c1b,#c23
	dw #20e,#0,#811,#819
	dw #23e,#206,#99a,#9a2,RLC_H
	dw #21c,#811,#819,NOP_2
	dw #20c,#c1b,#c23
	dw #20e,#0,#811,#819
	dw #20e,#206,#ac8,#ad0
	dw #20e,#0,#811,#819
	dw #20e,#206,#c1b,#c23
	dw #20e,#0,#811,#917
	dw #22e,#206,#99a,#9a2
	dw #20c,#811,#9a2
	dw #20c,#c1b,#c23
	dw #20e,#0,#811,#819
	dw #28e,#206,#ac8,#ad0
	dw #20e,#0,#811,#819
	dw #28e,#206,#c1b,#c23
	dw #20e,#0,#811,#819
	dw #23e,#206,#99a,#9a2,RLC_H
	dw #21c,#811,#819,NOP_2
	dw #20c,#c1b,#c23
	dw #20e,#0,#811,#819
	dw #28e,#206,#ac8,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #20e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #28e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #28e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #20e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #28e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20f,#206,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #21c,#c23,#c23,RLC_H
	dw #21e,#0,#819,#819,NOP_2
	dw #22e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #22e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22f,#103,#206,#737,#72f
	dw #20c,#611,#609
	dw #20c,#917,#90f
	dw #20e,#0,#611,#609
	dw #20e,#206,#819,#811
	dw #20e,#0,#611,#609
	dw #28e,#206,#917,#90f
	dw #20e,#0,#611,#609
	dw #23e,#206,#737,#72f,RLC_H
	dw #21c,#611,#609,NOP_2
	dw #20c,#917,#90f
	dw #20e,#0,#611,#609
	dw #28e,#206,#819,#811
	dw #20e,#0,#611,#609
	dw #22e,#206,#917,#90f
	dw #20e,#0,#6cf,#6c7
	dw #22e,#206,#737,#72f
	dw #20c,#737,#72f
	dw #20c,#917,#90f
	dw #20e,#0,#611,#609
	dw #20e,#206,#819,#811
	dw #20e,#0,#611,#609
	dw #28e,#206,#917,#90f
	dw #20e,#0,#611,#609
	dw #23e,#206,#737,#72f,RLC_H
	dw #21c,#611,#609,NOP_2
	dw #20c,#917,#90f
	dw #20e,#0,#611,#609
	dw #28e,#206,#819,#811
	dw #20e,#0,#611,#609
	dw #28e,#206,#917,#90f
	dw #20e,#0,#611,#609
	dw #22e,#206,#737,#72f
	dw #20c,#611,#609
	dw #20c,#917,#90f
	dw #20e,#0,#611,#609
	dw #20e,#206,#819,#811
	dw #20e,#0,#611,#609
	dw #28e,#206,#917,#90f
	dw #20e,#0,#611,#609
	dw #23e,#206,#737,#72f,RLC_H
	dw #21c,#611,#609,NOP_2
	dw #20c,#917,#90f
	dw #20e,#0,#611,#609
	dw #28e,#206,#819,#811
	dw #20e,#0,#611,#609
	dw #28e,#206,#917,#90f
	dw #20e,#0,#611,#609
	dw #22e,#206,#737,#72f
	dw #20c,#611,#609
	dw #20c,#917,#90f
	dw #20e,#0,#611,#609
	dw #20e,#206,#819,#811
	dw #20e,#0,#611,#609
	dw #28e,#206,#917,#90f
	dw #20e,#0,#611,#611
	dw #23e,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20e,#0,#611,#611
	dw #28e,#206,#819,#819
	dw #20e,#0,#611,#611
	dw #28e,#206,#917,#917
	dw #20e,#0,#611,#611
	dw #22e,#206,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20e,#0,#611,#611
	dw #20e,#206,#819,#819
	dw #20e,#0,#611,#611
	dw #28e,#206,#917,#917
	dw #20e,#0,#611,#611
	dw #23e,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20e,#0,#611,#611
	dw #28e,#206,#819,#819
	dw #20e,#0,#611,#611
	dw #28e,#206,#917,#917
	dw #20e,#0,#611,#611
	dw #22e,#206,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20e,#0,#611,#611
	dw #20e,#206,#819,#819
	dw #20e,#0,#611,#611
	dw #28e,#206,#917,#917
	dw #20e,#0,#611,#611
	dw #23e,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20e,#0,#611,#611
	dw #28e,#206,#819,#819
	dw #20e,#0,#611,#611
	dw #28e,#206,#917,#917
	dw #20e,#0,#611,#611
	dw #22e,#206,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20e,#0,#611,#611
	dw #20e,#206,#819,#819
	dw #20e,#0,#611,#611
	dw #28e,#206,#917,#917
	dw #20e,#0,#611,#611
	dw #23e,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20e,#0,#611,#611
	dw #28e,#206,#819,#819
	dw #20e,#0,#611,#611
	dw #28e,#206,#917,#917
	dw #20e,#0,#611,#611
	dw #22f,#134,#268,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20e,#0,#611,#611
	dw #20e,#268,#819,#819
	dw #20e,#0,#611,#611
	dw #28e,#268,#917,#917
	dw #20e,#0,#611,#611
	dw #25f,#122,#245,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #25c,#917,#917,RLC_H
	dw #21e,#0,#611,#611,NOP_2
	dw #26e,#245,#819,#819
	dw #20e,#0,#611,#611
	dw #26e,#245,#917,#917
	dw #20e,#0,#611,#611
	dw #22f,#fb,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#917,#917
	dw #22e,#206,#9a2,#9a2
	dw #20c,#9a2,#9a2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #20e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #28e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #28e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #20e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #28e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #28e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #20e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #28e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22e,#206,#9a2,#9a2
	dw #20c,#819,#819
	dw #20c,#c23,#c23
	dw #20e,#0,#819,#819
	dw #20f,#206,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #28e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #23e,#206,#9a2,#9a2,RLC_H
	dw #21c,#819,#819,NOP_2
	dw #21c,#c23,#c23,RLC_H
	dw #21e,#0,#819,#819,NOP_2
	dw #22e,#206,#ad0,#ad0
	dw #20e,#0,#819,#819
	dw #22e,#206,#c23,#c23
	dw #20e,#0,#819,#819
	dw #22f,#206,#1fe,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #20d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #23d,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #28d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #22d,#206,#917,#917
	dw #20d,#0,#6cf,#6cf
	dw #22d,#206,#737,#737
	dw #20c,#737,#737
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #20d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #23d,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #28d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #22d,#206,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #20d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #23d,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #28d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #22d,#206,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #20d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #23d,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #28d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #22d,#206,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #20d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #23d,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #28d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #22d,#206,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #20d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #23d,#206,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #28d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #22f,#1fe,#1fe,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #20d,#206,#819,#819
	dw #20d,#0,#611,#611
	dw #28d,#206,#917,#917
	dw #20d,#0,#611,#611
	dw #23f,#1ee,#1f6,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #20c,#917,#917
	dw #20d,#0,#611,#611
	dw #28f,#1de,#1ee,#819,#819
	dw #20d,#0,#611,#611
	dw #28f,#1d6,#1e6,#917,#917
	dw #20d,#0,#611,#611
	dw #22f,#184,#308,#737,#737
	dw #20c,#611,#611
	dw #20c,#917,#917
	dw #20e,#0,#611,#611
	dw #20e,#308,#819,#819
	dw #20e,#0,#611,#611
	dw #28e,#308,#917,#917
	dw #20e,#0,#611,#611
	dw #25f,#15a,#2b4,#737,#737,RLC_H
	dw #21c,#611,#611,NOP_2
	dw #25c,#917,#917,RLC_H
	dw #21e,#0,#611,#611,NOP_2
	dw #26e,#819,#2b4,#819
	dw #20c,#0,#611
	dw #26e,#2b4,#9a2,#917
	dw #20e,#0,#9a2,#611
	dw #23f,#103,#206,#1033,#9a2,RLC_H
	dw #218,#9a2,NOP_2
	dw #228,#c23
	dw #20a,#0,#9a2
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #22a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#917
	dw #22a,#206,#9a2
	dw #208,#9a2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #20a,#206,#c23
	dw #20a,#0,#917
	dw #22a,#206,#9a2
	dw #208,#9a2
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20e,#0,#0,#1033
	dw #22f,#122,#245,#819,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#245,#ad0
	dw #20a,#0,#819
	dw #28a,#245,#c23
	dw #20a,#0,#819
	dw #23a,#245,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#245,#ad0
	dw #20a,#0,#819
	dw #20a,#245,#c23
	dw #20a,#0,#819
	dw #22f,#134,#268,#e2e,#9a2
	dw #20c,#e6e,#819
	dw #208,#c23
	dw #20a,#0,#cdc
	dw #28a,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #23a,#268,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #22a,#268,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #23a,#268,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#268,#ad0
	dw #20a,#0,#819
	dw #20a,#268,#c23
	dw #20a,#0,#819
	dw #22a,#268,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #23a,#268,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #22a,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #22a,#268,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #20b,#268,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #23a,#268,#9a2,RLC_H
	dw #21c,#819,#e6e,NOP_2
	dw #21c,#c23,#c23,RLC_H
	dw #21e,#0,#819,#e6e,NOP_2
	dw #226,#268,#ad0
	dw #206,#0,#819
	dw #226,#268,#c23
	dw #206,#0,#819
	dw #22f,#15a,#2b4,#cdc,#72f
	dw #208,#e66
	dw #208,#90f
	dw #20a,#0,#e66
	dw #20a,#2b4,#811
	dw #20a,#0,#e66
	dw #28a,#2b4,#90f
	dw #20a,#0,#609
	dw #23a,#2b4,#72f,RLC_H
	dw #218,#609,NOP_2
	dw #208,#90f
	dw #20a,#0,#609
	dw #28a,#2b4,#811
	dw #20a,#0,#609
	dw #22a,#2b4,#90f
	dw #20a,#0,#609
	dw #22e,#2b4,#e6e,#72f
	dw #208,#cd4
	dw #208,#90f
	dw #20a,#0,#cd4
	dw #20a,#2b4,#811
	dw #20a,#0,#cd4
	dw #28a,#2b4,#90f
	dw #20a,#0,#609
	dw #23a,#2b4,#72f,RLC_H
	dw #218,#609,NOP_2
	dw #208,#90f
	dw #20a,#0,#609
	dw #28a,#2b4,#811
	dw #20a,#0,#609
	dw #28a,#2b4,#90f
	dw #20a,#0,#609
	dw #22a,#2b4,#72f
	dw #208,#609
	dw #208,#90f
	dw #20a,#0,#609
	dw #20a,#2b4,#811
	dw #20a,#0,#609
	dw #28a,#2b4,#90f
	dw #20a,#0,#609
	dw #23a,#2b4,#72f,RLC_H
	dw #218,#609,NOP_2
	dw #208,#90f
	dw #20a,#0,#609
	dw #28a,#2b4,#811
	dw #20a,#0,#609
	dw #28a,#2b4,#90f
	dw #20a,#0,#609
	dw #22a,#2b4,#72f
	dw #208,#609
	dw #208,#90f
	dw #20a,#0,#609
	dw #20a,#2b4,#811
	dw #20e,#0,#0,#e66
	dw #28e,#2b4,#c94,#90f
	dw #20e,#0,#cdc,#e6e
	dw #23a,#2b4,#737,RLC_H
	dw #218,#e6e,NOP_2
	dw #208,#917
	dw #20a,#0,#e6e
	dw #28a,#2b4,#819
	dw #20a,#0,#611
	dw #28a,#2b4,#917
	dw #20a,#0,#611
	dw #22f,#134,#268,#c23,#737
	dw #208,#cdc
	dw #208,#917
	dw #20a,#0,#cdc
	dw #20e,#268,#ad0,#819
	dw #20a,#0,#c23
	dw #28a,#268,#917
	dw #20a,#0,#c23
	dw #23e,#268,#c23,#737,RLC_H
	dw #218,#ad0,NOP_2
	dw #208,#917
	dw #20a,#0,#ad0
	dw #28a,#268,#819
	dw #20a,#0,#611
	dw #28a,#268,#917
	dw #20a,#0,#ad0
	dw #22a,#268,#737
	dw #208,#611
	dw #208,#917
	dw #20a,#0,#611
	dw #20a,#268,#819
	dw #20a,#0,#611
	dw #28a,#268,#917
	dw #20a,#0,#611
	dw #23a,#268,#737,RLC_H
	dw #218,#611,NOP_2
	dw #208,#917
	dw #20a,#0,#611
	dw #28a,#268,#819
	dw #20a,#0,#611
	dw #28a,#268,#917
	dw #20a,#0,#611
	dw #22b,#122,#245,#737
	dw #208,#611
	dw #208,#917
	dw #20a,#0,#611
	dw #20a,#245,#819
	dw #20a,#0,#611
	dw #28a,#245,#917
	dw #20a,#0,#611
	dw #23a,#245,#737,RLC_H
	dw #218,#611,NOP_2
	dw #208,#917
	dw #20a,#0,#611
	dw #28a,#245,#819
	dw #20a,#0,#611
	dw #28a,#245,#917
	dw #20a,#0,#611
	dw #22b,#245,#2b4,#737
	dw #208,#611
	dw #208,#917
	dw #20a,#0,#611
	dw #20a,#2b4,#819
	dw #20a,#0,#611
	dw #28a,#2b4,#917
	dw #20a,#0,#611
	dw #25a,#28d,#737,RLC_H
	dw #218,#c23,NOP_2
	dw #258,#917,RLC_H
	dw #21a,#0,#c23,NOP_2
	dw #26e,#28d,#819,#819
	dw #20e,#0,#819,#611
	dw #26e,#28d,#c23,#917
	dw #20e,#0,#c23,#611
	dw #22f,#103,#206,#1033,#9a2
	dw #208,#c23
	dw #228,#819
	dw #20a,#0,#c23
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #22a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#917
	dw #22a,#206,#9a2
	dw #208,#9a2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #20a,#206,#c23
	dw #20a,#0,#917
	dw #22a,#206,#9a2
	dw #208,#9a2
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #28e,#206,#ad0,#1033
	dw #206,#0,#819
	dw #286,#206,#c23
	dw #206,#0,#819
	dw #22f,#122,#245,#e6e,#9a2
	dw #208,#1033
	dw #208,#c23
	dw #20a,#0,#1033
	dw #20a,#245,#ad0
	dw #20a,#0,#819
	dw #28a,#245,#c23
	dw #20a,#0,#819
	dw #23a,#245,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#245,#ad0
	dw #20a,#0,#819
	dw #20a,#245,#c23
	dw #20a,#0,#819
	dw #22f,#134,#268,#c23,#9a2
	dw #208,#e6e
	dw #208,#c23
	dw #20a,#0,#e6e
	dw #28a,#268,#ad0
	dw #20a,#0,#e6e
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #23a,#268,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #22a,#268,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #23a,#268,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#268,#ad0
	dw #20a,#0,#819
	dw #20a,#268,#c23
	dw #20a,#0,#819
	dw #22a,#268,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #23a,#268,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #22a,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #22a,#268,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #20b,#268,#268,#ad0
	dw #20a,#0,#819
	dw #28a,#268,#c23
	dw #20a,#0,#819
	dw #23a,#268,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #218,#c23,RLC_H
	dw #21a,#0,#819,NOP_2
	dw #22a,#268,#ad0
	dw #20a,#0,#819
	dw #22a,#268,#c23
	dw #20a,#0,#819
	dw #22f,#15a,#2b4,#112a,#72f
	dw #20c,#120f,#c1b
	dw #20c,#122f,#90f
	dw #20a,#0,#c1b
	dw #20a,#2b4,#811
	dw #20a,#0,#c1b
	dw #28a,#2b4,#90f
	dw #20a,#0,#c1b
	dw #23a,#2b4,#72f,RLC_H
	dw #218,#c1b,NOP_2
	dw #208,#90f
	dw #20a,#0,#c1b
	dw #28a,#2b4,#811
	dw #20a,#0,#c1b
	dw #22a,#2b4,#90f
	dw #20a,#0,#6c7
	dw #22e,#2b4,#1033,#72f
	dw #208,#72f
	dw #208,#1227
	dw #20a,#0,#609
	dw #20a,#2b4,#1227
	dw #20a,#0,#609
	dw #28a,#2b4,#1227
	dw #20a,#0,#609
	dw #23a,#2b4,#72f,RLC_H
	dw #218,#609,NOP_2
	dw #208,#90f
	dw #20a,#0,#609
	dw #28a,#2b4,#811
	dw #20a,#0,#609
	dw #28a,#2b4,#90f
	dw #20a,#0,#609
	dw #22a,#2b4,#1122
	dw #208,#1227
	dw #208,#1227
	dw #20a,#0,#1227
	dw #20a,#2b4,#811
	dw #20a,#0,#1227
	dw #28a,#2b4,#90f
	dw #20a,#0,#1227
	dw #23a,#2b4,#72f,RLC_H
	dw #218,#1227,NOP_2
	dw #208,#90f
	dw #20a,#0,#1227
	dw #28a,#2b4,#811
	dw #20a,#0,#609
	dw #28a,#2b4,#90f
	dw #20a,#0,#609
	dw #22e,#2b4,#ad0,#102b
	dw #208,#102b
	dw #208,#90f
	dw #20a,#0,#102b
	dw #20a,#2b4,#811
	dw #20a,#0,#102b
	dw #28e,#2b4,#ad0,#90f
	dw #20a,#0,#611
	dw #23a,#2b4,#737,RLC_H
	dw #218,#611,NOP_2
	dw #208,#917
	dw #20a,#0,#611
	dw #28a,#2b4,#819
	dw #20a,#0,#611
	dw #28a,#2b4,#917
	dw #20a,#0,#611
	dw #22f,#134,#268,#c23,#737
	dw #208,#1033
	dw #208,#917
	dw #20a,#0,#1033
	dw #20e,#268,#cdc,#819
	dw #20a,#0,#c23
	dw #28a,#268,#917
	dw #20a,#0,#c23
	dw #23e,#268,#c23,#737,RLC_H
	dw #218,#cdc,NOP_2
	dw #208,#917
	dw #20a,#0,#cdc
	dw #28a,#268,#819
	dw #20a,#0,#cdc
	dw #28a,#268,#917
	dw #20a,#0,#611
	dw #22a,#268,#737
	dw #208,#611
	dw #208,#917
	dw #20a,#0,#611
	dw #20a,#268,#819
	dw #20a,#0,#611
	dw #28a,#268,#917
	dw #20a,#0,#611
	dw #23a,#268,#737,RLC_H
	dw #218,#611,NOP_2
	dw #208,#917
	dw #20a,#0,#611
	dw #28a,#268,#819
	dw #20a,#0,#611
	dw #28a,#268,#917
	dw #20a,#0,#611
	dw #22b,#122,#245,#737
	dw #208,#611
	dw #208,#917
	dw #20a,#0,#611
	dw #20a,#245,#819
	dw #20a,#0,#611
	dw #28a,#245,#917
	dw #20a,#0,#611
	dw #23a,#245,#737,RLC_H
	dw #218,#611,NOP_2
	dw #208,#917
	dw #20a,#0,#611
	dw #28a,#245,#819
	dw #20a,#0,#611
	dw #28a,#245,#917
	dw #20a,#0,#611
	dw #22b,#245,#2b4,#737
	dw #208,#611
	dw #208,#917
	dw #20a,#0,#611
	dw #20a,#2b4,#819
	dw #20a,#0,#611
	dw #28a,#2b4,#917
	dw #20a,#0,#611
	dw #25a,#28d,#737,RLC_H
	dw #218,#611,NOP_2
	dw #258,#917,RLC_H
	dw #21a,#0,#611,NOP_2
	dw #26a,#28d,#819
	dw #20a,#0,#611
	dw #26a,#28d,#917
	dw #20a,#0,#611
	dw #22f,#103,#206,#40c,#c23
	dw #208,#c23
	dw #228,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#c23
	dw #28a,#206,#c23
	dw #20a,#0,#c23
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #22a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#917
	dw #22a,#206,#9a2
	dw #208,#9a2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #20a,#206,#c23
	dw #20a,#0,#917
	dw #22a,#206,#9a2
	dw #208,#9a2
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #22a,#206,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #20a,#206,#c23
	dw #20a,#0,#819
	dw #22a,#206,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #22a,#206,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #20a,#206,#ad0
	dw #20a,#0,#819
	dw #20a,#206,#c23
	dw #20a,#0,#819
	dw #22a,#206,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #28a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #208,#c23
	dw #20a,#0,#819
	dw #22a,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #22a,#206,#9a2
	dw #208,#819
	dw #208,#c23
	dw #20a,#0,#819
	dw #20b,#206,#206,#ad0
	dw #20a,#0,#819
	dw #28a,#206,#c23
	dw #20a,#0,#819
	dw #23a,#206,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #218,#c23,RLC_H
	dw #21a,#0,#819,NOP_2
	dw #22a,#206,#ad0
	dw #20a,#0,#819
	dw #22a,#206,#c23
	dw #20a,#0,#819
	dw #20f,#103,#206,#206,#4d1
	dw #208,#40c
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#206,#568
	dw #20a,#0,#40c
	dw #20a,#206,#611
	dw #20a,#0,#40c
	dw #21b,#0,#206,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#206,#568
	dw #20a,#0,#40c
	dw #20a,#206,#611
	dw #20a,#0,#48b
	dw #20a,#206,#4d1
	dw #208,#4d1
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#206,#568
	dw #20a,#0,#40c
	dw #20a,#206,#611
	dw #20a,#0,#40c
	dw #21a,#206,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#206,#568
	dw #20a,#0,#40c
	dw #20a,#206,#611
	dw #20a,#0,#48b
	dw #20a,#206,#4d1
	dw #208,#4d1
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#206,#568
	dw #20a,#0,#40c
	dw #20a,#206,#611
	dw #20a,#0,#40c
	dw #21a,#206,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#206,#568
	dw #20a,#0,#40c
	dw #20a,#206,#611
	dw #20a,#0,#40c
	dw #20a,#206,#4d1
	dw #208,#40c
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#206,#568
	dw #20a,#0,#40c
	dw #20a,#206,#611
	dw #20a,#0,#40c
	dw #21a,#206,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#206,#568
	dw #20a,#0,#40c
	dw #20a,#206,#611
	dw #20a,#0,#40c
	dw #20b,#0,#103,#4d1
	dw #208,#40c
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#103,#568
	dw #20a,#0,#40c
	dw #20a,#103,#611
	dw #20a,#0,#40c
	dw #21a,#103,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#103,#568
	dw #20a,#0,#40c
	dw #20a,#103,#611
	dw #20a,#0,#40c
	dw #20a,#103,#4d1
	dw #208,#40c
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#103,#568
	dw #20a,#0,#40c
	dw #20a,#103,#611
	dw #20a,#0,#40c
	dw #21a,#103,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#103,#568
	dw #20a,#0,#40c
	dw #20a,#103,#611
	dw #20a,#0,#40c
	dw #20a,#103,#4d1
	dw #208,#40c
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#103,#568
	dw #20a,#0,#40c
	dw #20a,#103,#611
	dw #20a,#0,#40c
	dw #21a,#103,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #208,#611
	dw #20a,#0,#40c
	dw #20a,#103,#568
	dw #20a,#0,#40c
	dw #20a,#103,#611
	dw #20a,#0,#40c
	dw #20a,#103,#4d1
	dw #208,#40c
	dw #208,#611
	dw #20a,#0,#40c
	dw #20b,#206,#103,#568
	dw #20a,#0,#40c
	dw #20a,#103,#611
	dw #20a,#0,#40c
	dw #21a,#103,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #218,#611,RLC_H
	dw #21a,#0,#40c,NOP_2
	dw #20a,#103,#568
	dw #20a,#0,#40c
	dw #20a,#103,#611
	dw #20a,#0,#40c
	dw #20f,#103,#103,#819,#1033
	dw #20c,#0,#40c
	dw #208,#611
	dw #208,#40c
	dw #20c,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#1033
	dw #208,#40c
	dw #28c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#c23
	dw #208,#40c
	dw #20c,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#ad0
	dw #208,#48b
	dw #20c,#819,#1033
	dw #20c,#0,#4d1
	dw #208,#c23
	dw #208,#40c
	dw #20c,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#1033
	dw #208,#40c
	dw #28c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#c23
	dw #208,#40c
	dw #20c,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#ad0
	dw #208,#48b
	dw #20c,#819,#1033
	dw #20c,#0,#4d1
	dw #208,#c23
	dw #208,#40c
	dw #20c,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#1033
	dw #208,#40c
	dw #28c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#c23
	dw #208,#40c
	dw #20c,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#ad0
	dw #208,#40c
	dw #20c,#819,#1033
	dw #20c,#0,#40c
	dw #208,#c23
	dw #208,#40c
	dw #20c,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#1033
	dw #208,#40c
	dw #28c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#c23
	dw #208,#40c
	dw #20c,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#ad0
	dw #208,#40c
	dw #208,#4d1
	dw #208,#40c
	dw #208,#c23
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #288,#4d1
	dw #208,#40c
	dw #288,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #288,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #288,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #209,#206,#568
	dw #208,#40c
	dw #288,#611
	dw #208,#40c
	dw #258,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #258,#611,RLC_H
	dw #218,#40c,NOP_2
	dw #268,#568
	dw #208,#40c
	dw #268,#611
	dw #208,#40c
	dw #28f,#103,#103,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#611
	dw #208,#40c
	dw #20c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#c23
	dw #208,#40c
	dw #28c,#819,#819
	dw #20c,#0,#40c
	dw #208,#ad0
	dw #208,#40c
	dw #20c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#819
	dw #208,#48b
	dw #20c,#c23,#c23
	dw #20c,#0,#4d1
	dw #208,#ad0
	dw #208,#40c
	dw #20c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#c23
	dw #208,#40c
	dw #28c,#819,#819
	dw #20c,#0,#40c
	dw #208,#ad0
	dw #208,#40c
	dw #20c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#819
	dw #208,#48b
	dw #20c,#c23,#c23
	dw #20c,#0,#4d1
	dw #208,#ad0
	dw #208,#40c
	dw #20c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#c23
	dw #208,#40c
	dw #28c,#819,#819
	dw #20c,#0,#40c
	dw #208,#ad0
	dw #208,#40c
	dw #20c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#819
	dw #208,#40c
	dw #20c,#c23,#c23
	dw #20c,#0,#40c
	dw #208,#ad0
	dw #208,#40c
	dw #20c,#ad0,#ad0
	dw #20c,#0,#40c
	dw #208,#c23
	dw #208,#40c
	dw #28c,#819,#819
	dw #20c,#0,#40c
	dw #208,#ad0
	dw #208,#40c
	dw #20c,#9a2,#9a2
	dw #20c,#0,#40c
	dw #208,#819
	dw #208,#40c
	dw #20c,#819,#c23
	dw #20c,#0,#40c
	dw #208,#9a2
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#819
	dw #208,#40c
	dw #288,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #288,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #288,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #208,#4d1
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #209,#206,#568
	dw #208,#40c
	dw #208,#611
	dw #208,#40c
	dw #258,#4d1,RLC_H
	dw #218,#40c,NOP_2
	dw #258,#611,RLC_H
	dw #218,#40c,NOP_2
	dw #268,#568
	dw #208,#40c
	dw #268,#611
	dw #208,#40c
	dw #22f,#15a,#15a,#ad0,#15a0
	dw #20c,#0,#568
	dw #208,#819
	dw #208,#568
	dw #20c,#1033,#1033
	dw #20c,#0,#568
	dw #208,#15a0
	dw #208,#568
	dw #28c,#e6e,#e6e
	dw #20c,#0,#568
	dw #208,#1033
	dw #208,#568
	dw #20c,#1033,#1033
	dw #20c,#0,#568
	dw #208,#e6e
	dw #208,#568
	dw #20c,#ad0,#15a0
	dw #20c,#0,#611
	dw #208,#1033
	dw #208,#611
	dw #20c,#1033,#1033
	dw #20c,#0,#611
	dw #208,#15a0
	dw #208,#611
	dw #28c,#e6e,#e6e
	dw #20c,#0,#611
	dw #208,#1033
	dw #208,#611
	dw #20c,#1033,#1033
	dw #20c,#0,#611
	dw #208,#e6e
	dw #208,#611
	dw #20c,#ad0,#15a0
	dw #20c,#0,#66e
	dw #208,#1033
	dw #208,#66e
	dw #20c,#1033,#1033
	dw #20c,#0,#66e
	dw #208,#15a0
	dw #208,#66e
	dw #28c,#e6e,#e6e
	dw #20c,#0,#66e
	dw #208,#1033
	dw #208,#66e
	dw #20c,#1033,#1033
	dw #20c,#0,#66e
	dw #208,#e6e
	dw #208,#66e
	dw #20c,#ad0,#15a0
	dw #20c,#0,#737
	dw #208,#1033
	dw #208,#737
	dw #20c,#1033,#1033
	dw #20c,#0,#737
	dw #208,#15a0
	dw #208,#737
	dw #28c,#e6e,#e6e
	dw #20c,#0,#737
	dw #288,#1033
	dw #208,#737
	dw #20c,#1033,#1033
	dw #20c,#0,#737
	dw #208,#e6e
	dw #208,#737
	dw #208,#66e
	dw #208,#568
	dw #208,#1033
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #288,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #288,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #288,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #209,#2b4,#737
	dw #208,#568
	dw #288,#819
	dw #208,#568
	dw #258,#66e,RLC_H
	dw #218,#568,NOP_2
	dw #258,#819,RLC_H
	dw #218,#568,NOP_2
	dw #268,#737
	dw #208,#568
	dw #268,#819
	dw #208,#568
	dw #28f,#15a,#15a,#1033,#1033
	dw #20c,#0,#568
	dw #208,#819
	dw #208,#568
	dw #20c,#e6e,#e6e
	dw #20c,#0,#568
	dw #208,#1033
	dw #208,#568
	dw #28c,#ad0,#ad0
	dw #20c,#0,#568
	dw #208,#e6e
	dw #208,#568
	dw #20c,#e6e,#e6e
	dw #20c,#0,#568
	dw #208,#ad0
	dw #208,#568
	dw #20c,#1033,#1033
	dw #20c,#0,#611
	dw #208,#e6e
	dw #208,#611
	dw #20c,#e6e,#e6e
	dw #20c,#0,#611
	dw #208,#1033
	dw #208,#611
	dw #28c,#ad0,#ad0
	dw #20c,#0,#611
	dw #208,#e6e
	dw #208,#611
	dw #20c,#e6e,#e6e
	dw #20c,#0,#611
	dw #208,#ad0
	dw #208,#611
	dw #20c,#1033,#1033
	dw #20c,#0,#66e
	dw #208,#e6e
	dw #208,#66e
	dw #20c,#e6e,#e6e
	dw #20c,#0,#66e
	dw #208,#1033
	dw #208,#66e
	dw #28c,#ad0,#ad0
	dw #20c,#0,#66e
	dw #208,#e6e
	dw #208,#66e
	dw #20c,#e6e,#e6e
	dw #20c,#0,#66e
	dw #208,#ad0
	dw #208,#66e
	dw #20c,#1033,#1033
	dw #20c,#0,#737
	dw #208,#e6e
	dw #208,#737
	dw #20c,#e6e,#e6e
	dw #20c,#0,#737
	dw #208,#1033
	dw #208,#737
	dw #28c,#ad0,#ad0
	dw #20c,#0,#737
	dw #208,#e6e
	dw #208,#737
	dw #20c,#e6e,#e6e
	dw #20c,#0,#737
	dw #208,#ad0
	dw #208,#737
	dw #20c,#1033,#66e
	dw #20c,#0,#568
	dw #208,#e6e
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#1033
	dw #208,#568
	dw #288,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #288,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #20a,#152,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #288,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #208,#66e
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #209,#2b4,#737
	dw #208,#568
	dw #208,#819
	dw #208,#568
	dw #258,#66e,RLC_H
	dw #218,#568,NOP_2
	dw #208,#819
	dw #258,#568,RLC_H
	dw #218,#737,NOP_2
	dw #268,#568
	dw #208,#819
	dw #208,#568
	dw #22f,#103,#1f6,#819,#1033
	dw #20c,#0,#819
	dw #288,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#1033
	dw #208,#819
	dw #28c,#ad0,#ad0
	dw #20c,#0,#819
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#ad0
	dw #208,#917
	dw #20c,#819,#1033
	dw #20c,#0,#9a2
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#1033
	dw #208,#819
	dw #28c,#ad0,#ad0
	dw #20c,#0,#819
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#ad0
	dw #208,#917
	dw #20c,#819,#1033
	dw #20c,#0,#9a2
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#1033
	dw #208,#819
	dw #28c,#ad0,#ad0
	dw #20c,#0,#819
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#ad0
	dw #208,#819
	dw #20c,#819,#1033
	dw #20c,#0,#819
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#1033
	dw #208,#819
	dw #28c,#ad0,#ad0
	dw #20c,#0,#819
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #20b,#fb,#1ee,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #288,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #288,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #288,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #258,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #258,#c23,RLC_H
	dw #218,#819,NOP_2
	dw #268,#ad0
	dw #208,#819
	dw #268,#c23
	dw #208,#819
	dw #22f,#103,#f3,#819,#1033
	dw #20c,#0,#819
	dw #288,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#1033
	dw #208,#819
	dw #21c,#ad0,#ad0,RLC_H
	dw #21c,#0,#819,NOP_2
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#ad0
	dw #208,#917
	dw #20c,#819,#1033
	dw #20c,#0,#9a2
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#1033
	dw #208,#819
	dw #28c,#ad0,#ad0
	dw #20c,#0,#819
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#ad0
	dw #208,#917
	dw #20c,#819,#1033
	dw #20c,#0,#9a2
	dw #208,#c23
	dw #208,#819
	dw #20e,#e3,#c23,#c23
	dw #20c,#0,#819
	dw #208,#1033
	dw #208,#819
	dw #28c,#ad0,#ad0
	dw #20c,#0,#819
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#ad0
	dw #208,#819
	dw #20c,#819,#1033
	dw #20c,#0,#819
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#1033
	dw #208,#819
	dw #28c,#ad0,#ad0
	dw #20c,#0,#819
	dw #208,#c23
	dw #208,#819
	dw #20c,#c23,#c23
	dw #20c,#0,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #288,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #288,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #288,#9a2
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #208,#ad0
	dw #208,#819
	dw #208,#c23
	dw #208,#819
	dw #20b,#308,#308,#9a2
	dw #20a,#184,#819
	dw #208,#c23
	dw #20b,#c2,#c2,#819
	dw #20b,#308,#308,#ad0
	dw #20b,#c2,#c2,#819
	dw #20b,#308,#308,#c23
	dw #20b,#c2,#c2,#819
	dw #25b,#2b4,#2b4,#9a2,RLC_H
	dw #218,#819,NOP_2
	dw #258,#c23,RLC_H
	dw #21b,#ad,#ad,#819,NOP_2
	dw #26b,#2b4,#2b4,#ad0
	dw #20b,#ad,#ad,#819
	dw #26b,#2b4,#2b4,#c23
	dw #20b,#ad,#ad,#819
	dw #23f,#206,#103,#206,#1344,RLC_H
	dw #200
	dw #298,#0,NOP_2
	dw #200
	dw #204,#0
	dw #201,#0
	dw #203,#103,#0
	dw #201,#0
	dw #200
	dw #200
	dw #200
	dw #200
	dw #200
	dw #200
	dw #200
	dw #200
	dw 0
