#include <string.h>
#include <stdlib.h>

#include <MKL25Z4.h>

#include "input.h"
#include "pantalla.h"
#include "tetris_defs.h"

void configCPU() ;
void configGpios() ;
	



unsigned char buffer_imagen[64*32*3] ;
unsigned char pieza_cae[4][4] ;
unsigned char tablero[TAMY_TABLERO+4][TAMX_TABLERO] ;

float velocidad = 0.0f ;

int posx = POSX_INICIAL ;
float fposy = POSY_INICIAL ;
int posy = POSY_INICIAL ;

int old_posy = POSY_INICIAL ;

int rotacion = 0 ;
int tipo_pieza = 0 ;

int game_over = 0 ;







volatile struct INPUT input_cnt ;
volatile struct INPUT old_input_cnt ;

volatile struct INPUT input_trg ;


// -------------------------------------------------------------------------------------------
//
//
void init_input()
{
	memset(&input_cnt, 0, sizeof(input_cnt)) ;
	memset(&old_input_cnt, 0, sizeof(input_cnt)) ;
	memset(&input_trg, 0, sizeof(input_cnt)) ;
}



// -------------------------------------------------------------------------------------------
//
//
void tick_input()
{
	int var1 ;
	
	old_input_cnt = input_cnt ;
	
	memset(&input_cnt, 0, sizeof(input_cnt)) ;
	
	for(var1 = 0; var1 < 100; var1++) {
	
		input_cnt.up           |= (GPIOA_PDIR & (1 << BIT_UP)) == 0 ;
		input_cnt.down         |= (GPIOE_PDIR & (1 << BIT_DOWN)) == 0 ;
		input_cnt.left         |= (GPIOD_PDIR & (1 << BIT_LEFT)) == 0 ;
		input_cnt.right        |= (GPIOD_PDIR & (1 << BIT_RIGHT)) == 0 ;
		
		input_cnt.button1      |= (GPIOE_PDIR & (1 << BIT_BUTTON1)) == 0 ;
		input_cnt.button2      |= (GPIOE_PDIR & (1 << BIT_BUTTON2)) == 0 ;
		
		input_cnt.button_start |= (GPIOD_PDIR & (1 << BIT_BUTTON_START)) == 0 ;
	}	

	input_trg.up = (!old_input_cnt.up && input_cnt.up) ; 
	input_trg.down = (!old_input_cnt.down && input_cnt.down) ; 
	input_trg.left = (!old_input_cnt.left && input_cnt.left) ; 
	input_trg.right = (!old_input_cnt.right && input_cnt.right) ; 
	
	input_trg.button1 = (!old_input_cnt.button1 && input_cnt.button1) ; 
	input_trg.button2 = (!old_input_cnt.button2 && input_cnt.button2) ;
	
	input_trg.button_start = (!old_input_cnt.button_start && input_cnt.button_start) ;
}




// -------------------------------------------------------------------------------------------
//
//
void init_tetris()
{
	game_over = 0 ;
	
	init_input() ;

	memset(tablero, 0, sizeof(tablero)) ;
	memset(buffer_imagen, 0, 64*32*3) ;
	dibujar_marcos() ;
	
	proxima_pieza() ;
	

	velocidad = 0.0f ;

	posx = POSX_INICIAL ;

	fposy = POSY_INICIAL ;
	posy = POSY_INICIAL ;

	old_posy = POSY_INICIAL ;

	rotacion = 0 ;
	tipo_pieza = 0 ;
}






// -------------------------------------------------------------------------------------------
//
//
void proxima_pieza()
{
	tipo_pieza = rand() % NUM_PIEZAS ;
	//tipo_pieza = 4 ;
	rotacion = 0 ;
	posx = POSX_INICIAL ;
	fposy = POSY_INICIAL ;
}



// -------------------------------------------------------------------------------------------
//
//
int linea_esta_completa(int posy)
{
	int varx ;
	
	for(varx = 0; varx < TAMX_TABLERO; varx++) {
	
		if(tablero[posy][varx] == 0) return 0 ;
	}

	return 1 ;
}



// -------------------------------------------------------------------------------------------
//
//
void comer_linea(int posy)
{
	int varx, vary ;
	
	for(vary = posy; vary < (TAMY_TABLERO - 1); vary++) {
	
		for(varx = 0; varx < TAMX_TABLERO; varx++) {
		
			tablero[vary][varx] = tablero[vary + 1][varx] ; 
		}
	}
	
	for(varx = 0; varx < TAMX_TABLERO; varx++) {
	
		tablero[TAMY_TABLERO - 1][varx] = 0 ; 
	}
	
	return 1 ;
}



// -------------------------------------------------------------------------------------------
//
//
void planchar_pieza()
{
	
	//tablero[old_posy][posx] = 1 ;
	
	int varx, vary ;
	
	for(vary = 0; vary < 4; vary++) {

		
		for(varx = 0; varx < 4; varx++) {

			if(modelos_piezas[tipo_pieza][rotacion][3 - vary][varx] != 0) { 
				
				if(old_posy + vary >= TAMY_TABLERO) game_over = 0 ;
				else tablero[old_posy + vary][posx + varx] = tipo_pieza ; 
			}
		}
	}
	
	for(vary = 3; vary >= 0; vary--) {
		
		if(linea_esta_completa(old_posy + vary)) {
			
			comer_linea(old_posy + vary) ;
			game_over = 0 ;
		
		}
	}
}



// -------------------------------------------------------------------------------------------
//
//
int posicion_valida(int posx, int posy, int rotacion)
{
	int varx, vary ;
	
	//if(posx < 0) return 0 ;
	//if(posy < 0) return 0 ;
	
	for(vary = 0; vary < 4; vary++) {
		
		for(varx = 0; varx < 4; varx++) {
			
			int posx_tablero = posx + varx ;
			int posy_tablero = posy + vary ;
			
			
			if(modelos_piezas[tipo_pieza][rotacion][3 - vary][varx] != 0) { 

				if(posx_tablero < 0) return 0 ;
				if(posy_tablero < 0) return 0 ;
				
				if(posx_tablero >= TAMX_TABLERO) return 0 ;
				if(posy_tablero >= TAMY_TABLERO) return 0 ;
				
				if(tablero[posy_tablero][posx_tablero] != 0) return 0  ; 
			}
		}
	}
	
	
	return 1 ;
}



// -------------------------------------------------------------------------------------------
//
//
void rotar_left()
{
  int rotacion_temp = (rotacion - 1) & 3 ;
  if(posicion_valida(posx, posy, rotacion_temp)) rotacion = rotacion_temp ;
}

// -------------------------------------------------------------------------------------------
//
//
void rotar_right()
{
  int rotacion_temp = (rotacion + 1) & 3 ;
  if(posicion_valida(posx, posy, rotacion_temp)) rotacion = rotacion_temp ;
}



#define PUTPIXEL(x, y, r, g, b) buffer_imagen[((y) * 64 * 3) + ((x) * 3) + 0] = (r) ; 	buffer_imagen[((y) * 64 * 3) + ((x) * 3) + 1] = (g) ; 	buffer_imagen[((y) * 64 * 3) + ((x) * 3) + 2] = (b) ;
	
#define PUTPIXEL_ROTADO(y, x, r, g, b) buffer_imagen[((31-(y)) * 64 * 3) + ((63-(x)) * 3) + 0] = (r) ; 	buffer_imagen[((31-(y)) * 64 * 3) + ((63-(x)) * 3) + 1] = (g) ; 	buffer_imagen[((31-(y)) * 64 * 3) + ((63-(x)) * 3) + 2] = (b) ;

// -------------------------------------------------------------------------------------------
//
//
void putpixel_seguro(int x, int y, int r, int g, int b)
{
	if(x < 0) return ;
	if(y < 0) return ;
	
	if(x > 63) return ;
	if(y > 31) return ;
	
	buffer_imagen[(y * 64 * 3) + (x * 3) + 0] = r ;
	buffer_imagen[(y * 64 * 3) + (x * 3) + 1] = g ;
	buffer_imagen[(y * 64 * 3) + (x * 3) + 2] = b ;
}




// -------------------------------------------------------------------------------------------
//
//
void putpixel_rotado_seguro(int x, int y, int r, int g, int b)
{
	if(x < 0) return ;
	if(y < 0) return ;
	
	if(x > 63) return ;
	if(y > 31) return ;
	
	buffer_imagen[(y * 64 * 3) + (x * 3) + 0] = r ;
	buffer_imagen[(y * 64 * 3) + (x * 3) + 1] = g ;
	buffer_imagen[(y * 64 * 3) + (x * 3) + 2] = b ;
	
}




// -------------------------------------------------------------------------------------------
//
//
void putpixel(int x, int y, int r, int g, int b)
{
	if(x < 0) return ;
	if(y < 0) return ;
	
	if(x > 63) return ;
	if(y > 31) return ;
	
	buffer_imagen[(y * 64 * 3) + (x * 3) + 0] = r ;
	buffer_imagen[(y * 64 * 3) + (x * 3) + 1] = g ;
	buffer_imagen[(y * 64 * 3) + (x * 3) + 2] = b ;
	
}




#define DRAW_BLOQUE(X, Y, R, G, B)  PUTPIXEL_ROTADO(1 + ((X) * 3), 1 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 1 + ((X) * 3), 1 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 2 + ((X) * 3), 1 + ((Y) * 3), (R), (G), (B)) ; \
                                  	                                                                    \
		                            PUTPIXEL_ROTADO(1 + ((X) * 3),     1 + 2 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 1 + ((X) * 3), 1 + 2 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 2 + ((X) * 3), 1 + 2 + ((Y) * 3), (R), (G), (B)) ; \
                                  	\
                                  	PUTPIXEL_ROTADO(1 + 0 + ((X) * 3), 1 + 1 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 1 + ((X) * 3), 1 + 1 + ((Y) * 3), 0, 0, 0) ; \
                                  	PUTPIXEL_ROTADO(1 + 2 + ((X) * 3), 1 + 1 + ((Y) * 3), (R), (G), (B)) ; \

#define DRAW_BLOQUE_CAE(X, Y, R, G, B)  PUTPIXEL_ROTADO(1 + ((X) * 3), 1 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 1 + ((X) * 3), 1 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 2 + ((X) * 3), 1 + ((Y) * 3), (R), (G), (B)) ; \
                                  	                                                                    \
		                            PUTPIXEL_ROTADO(1 + ((X) * 3),     1 + 2 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 1 + ((X) * 3), 1 + 2 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 2 + ((X) * 3), 1 + 2 + ((Y) * 3), (R), (G), (B)) ; \
                                  	\
                                  	PUTPIXEL_ROTADO(1 + 0 + ((X) * 3), 1 + 1 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 1 + ((X) * 3), 1 + 1 + ((Y) * 3), (R), (G), (B)) ; \
                                  	PUTPIXEL_ROTADO(1 + 2 + ((X) * 3), 1 + 1 + ((Y) * 3), (R), (G), (B)) ; \






// -------------------------------------------------------------------------------------------
//
//
void dibujar_pieza_cae()
{
	//PUTPIXEL_ROTADO(posx + 1, posy + 1, 0, 1, 0) ;
	int varx, vary ;
	
	for(vary = 0; vary < 4; vary++) {
		
		for(varx = 0; varx < 4; varx++) {

			if(modelos_piezas[tipo_pieza][rotacion][3 - vary][varx] != 0) { DRAW_BLOQUE_CAE(posx + varx, posy + vary, colores_piezas[tipo_pieza][0], colores_piezas[tipo_pieza][1], colores_piezas[tipo_pieza][2]) ; }
			//else                                      { DRAW_BLOQUE_CAE(posx + varx, posy + vary, 1, 0, 0) ; }
		}
	}
	
}




// -------------------------------------------------------------------------------------------
//
//
void borrar_pieza_cae()
{
	int varx, vary ;
	
	for(vary = 0; vary < 4; vary++) {
		
		for(varx = 0; varx < 4; varx++) {

			if(modelos_piezas[tipo_pieza][rotacion][3 - vary][varx] != 0) { DRAW_BLOQUE_CAE(posx + varx, old_posy + vary, 0, 0, 0) ; }
			//else                                      { DRAW_BLOQUE_CAE(posx + varx, posy + vary, 1, 0, 0) ; }
		}
	}
}




// -------------------------------------------------------------------------------------------
//
//
void dibujar_marcos()
{
	int varx, vary ;
	
	for(varx = 0; varx < 64; varx++) {
	
  	  PUTPIXEL(varx, 0, 1, 1, 1) ;
	  PUTPIXEL(varx, 31, 1, 1, 1) ;
	}
	
	
	for(vary = 0; vary < 32; vary++) {
	
  	  PUTPIXEL(63, vary, 1, 1, 1) ;
	}
}




// -------------------------------------------------------------------------------------------
//
//
void dibujar_tablero()
{
	int varx, vary ;
	
	for(vary = 0; vary < TAMY_TABLERO; vary++) {
		
		for(varx = 0; varx < TAMX_TABLERO; varx++) {
			
			int tipo_bloque = tablero[vary][varx] ;
	
			if(tipo_bloque > 0) { DRAW_BLOQUE(varx, vary, colores_piezas[tipo_bloque][0], colores_piezas[tipo_bloque][1], colores_piezas[tipo_bloque][2]) ; }
			else                { DRAW_BLOQUE(varx, vary, 0, 0, 0) ; }
		}
	}	
	
	
	
	
	
	
}





// -------------------------------------------------------------------------------------------
//
//
void tetris_tick()
{
	if(game_over) return ;
	
	int redibujar = 0 ;
	

	if(input_cnt.down) velocidad = 0.04f ;
	else               velocidad = 0.003f ;
	
	
	if(input_trg.left) {
		
		input_trg.left = 0 ;
		
		if(posicion_valida(posx - 1, (int)(fposy - velocidad), rotacion)) posx-- ;
	}
	
	if(input_trg.right) {

		input_trg.right = 0 ;
		
		if(posicion_valida(posx + 1, (int)(fposy - velocidad), rotacion)) posx++ ;
	}
	
	
	if(input_trg.button1) {
		
		input_trg.button1 = 0 ;
		
		rotar_left() ;
	}
	
	if(input_trg.button2) {

		input_trg.button2 = 0 ;
		
		rotar_right() ;
	}
	
	

	
	if(posicion_valida(posx, (int)(fposy - velocidad), rotacion)) fposy -= velocidad ;
	else {
		
		planchar_pieza() ;
		proxima_pieza() ;
    }
	
	posy = (int)fposy ;
	
	
	if(old_posy != posy) {
		
		borrar_pieza_cae() ;
		old_posy = posy ; 
		redibujar = 1 ;
	}
	
	
	if(redibujar) {

		int vary ;
		for(vary = 0; vary < 32; vary++) {
		
	  	  PUTPIXEL(63, vary, 1, 1, 1) ;
		}
		

		//dibujar_marcos() ;
		dibujar_tablero() ;
		dibujar_pieza_cae() ;
	}
  }










// -------------------------------------------------------------------------------------------
//
//
void lcd_update()
{
	int num_linea = 0 ;
	int varx ;
	
	
			// ----------------------------------------------------------------------------------------------------------------------------------------------------------
			// Dibujado del LCD
			// ----------------------------------------------------------------------------------------------------------------------------------------------------------
			
			for(num_linea = 0; num_linea < 16; num_linea++) {
			
				
				int vary = (num_linea - 1) & 0xF ;
				//int vary = num_linea ;
			
	
		
				for(varx = 0; varx < 64; varx++) {
					
					CLK_CLEAR ;
					
					{
						int pos_pixel_h = (((vary + 1) & 0xF) * (64 * 3)) + (varx * 3) ;
						int pos_pixel_l = (pos_pixel_h ) + (64 * 16 * 3) ; 
					
		
						if(buffer_imagen[pos_pixel_h + 0]) { R1_SET ; }
						else                               { R1_CLEAR ; }
						
						if(buffer_imagen[pos_pixel_h + 1]) { G1_SET ; }
						else                               { G1_CLEAR ; }
						
						if(buffer_imagen[pos_pixel_h + 2]) { B1_SET ; }
						else                               { B1_CLEAR ; }
						
						// Abajo
					
						if(buffer_imagen[pos_pixel_l + 0]) { R2_SET ; }
						else                               { R2_CLEAR ; }
						
						if(buffer_imagen[pos_pixel_l + 1]) { G2_SET ; }
						else                               { G2_CLEAR ; }
						
						if(buffer_imagen[pos_pixel_l + 2]) { B2_SET ; }
						else                               { B2_CLEAR ; }
					}			
					
		
					// -------------------------------------------------------------------------------------------------
					// -------------------------------------------------------------------------------------------------
						
					CLK_SET ;
				}
				
				
				// Datos de linea
				
				OE_SET ;
				
				// Direccionamiento de la lnea
					 
				
				if(num_linea & 1)        A_SET ;
				else                A_CLEAR ;
		
				if((num_linea >> 1) & 1) B_SET ;
				else                B_CLEAR ;
		
				if((num_linea >> 2) & 1) C_SET ;
				else                C_CLEAR ;
		
				if((num_linea >> 3) & 1) D_SET ;
				else                D_CLEAR ;
		
				LAT_SET ;
				
				
				
				LAT_CLEAR ;
				OE_CLEAR ;
		
				//num_linea = (num_linea + 1) & 0xF ; 
			}



			// ----------------------------------------------------------------------------------------------------------------------------------------------------------
			// Dibujado del LCD
			// ----------------------------------------------------------------------------------------------------------------------------------------------------------
	
	
	
}





// -------------------------------------------------------------------------------------------
//
//
void configCPU()
{
	//return ;
	
	 SIM_COPC = 0x00U;                                                   
	  SIM_SCGC5 |= SIM_SCGC5_PORTA_MASK;   /* Enable clock gate for ports to enable pin routing */
	  /* SIM_CLKDIV1: OUTDIV1=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,OUTDIV4=1,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
	  SIM_CLKDIV1 = SIM_CLKDIV1_OUTDIV4(0x01); /* Update system prescalers */
	  /* SIM_SOPT2: PLLFLLSEL=0 */
	  SIM_SOPT2 &= (uint32_t)~(uint32_t)(SIM_SOPT2_PLLFLLSEL_MASK); /* Select FLL as a clock source for various peripherals */
	  /* SIM_SOPT1: OSC32KSEL=3 */
	  SIM_SOPT1 |= SIM_SOPT1_OSC32KSEL(0x03); /* LPO 1kHz oscillator drives 32 kHz clock for various peripherals */
	  /* SIM_SOPT2: TPMSRC=1 */
	  SIM_SOPT2 = (uint32_t)((SIM_SOPT2 & (uint32_t)~(uint32_t)(
	               SIM_SOPT2_TPMSRC(0x02)
	              )) | (uint32_t)(
	               SIM_SOPT2_TPMSRC(0x01)
	              ));                      /* Set the TPM clock */
	  /* Switch to FEI Mode */
	  /* MCG_C1: CLKS=0,FRDIV=0,IREFS=1,IRCLKEN=1,IREFSTEN=0 */
	  MCG_C1 = (MCG_C1_IREFS_MASK | MCG_C1_IRCLKEN_MASK);                                                   
	  /* MCG_C2: LOCRE0=0,??=0,RANGE0=0,HGO0=0,EREFS0=0,LP=0,IRCS=0 */
	  MCG_C2 = 0x00U;                                                   
	  /* MCG_C4: DMX32=1,DRST_DRS=1 */
	  MCG_C4 = (uint8_t)((MCG_C4 & (uint8_t)~(uint8_t)(
	            MCG_C4_DRST_DRS(0x02)
	           )) | (uint8_t)(
	            MCG_C4_DMX32_MASK |
	            MCG_C4_DRST_DRS(0x01)
	           ));                                                  
	  /* OSC0_CR: ERCLKEN=1,??=0,EREFSTEN=0,??=0,SC2P=0,SC4P=0,SC8P=0,SC16P=0 */
	  OSC0_CR = OSC_CR_ERCLKEN_MASK;                                                   
	  /* MCG_C5: ??=0,PLLCLKEN0=0,PLLSTEN0=0,PRDIV0=0 */
	  MCG_C5 = 0x00U;                                                   
	  /* MCG_C6: LOLIE0=0,PLLS=0,CME0=0,VDIV0=0 */
	  MCG_C6 = 0x00U;                                                   
	  while((MCG_S & MCG_S_IREFST_MASK) == 0x00U) { /* Check that the source of the FLL reference clock is the internal reference clock. */
	  }
	  while((MCG_S & 0x0CU) != 0x00U) {    /* Wait until output of the FLL is selected */
	  }	
}



// -------------------------------------------------------------------------------------------
//
//
void configGpios()
{
	// Initialize the Red LED (PTB18)
	
	// Turn on clock to PortB module
	SIM_SCGC5 |= SIM_SCGC5_PORTA_MASK | SIM_SCGC5_PORTB_MASK | SIM_SCGC5_PORTC_MASK | SIM_SCGC5_PORTD_MASK | SIM_SCGC5_PORTE_MASK ;

	// ----------------------
	
	// Set the PTB18 pin multiplexer to GPIO mode
	PORTB_PCR18 = PORT_PCR_MUX(1) ;  // Pin Mux Control - Alternative 1 (GPIO)
	
	PORTE_PCR4  = PORT_PCR_MUX(1) ;  // Pin Mux Control - Alternative 1 (GPIO)
	PORTE_PCR5  = PORT_PCR_MUX(1) ;  // Pin Mux Control - Alternative 1 (GPIO)
	PORTE_PCR20 = PORT_PCR_MUX(1) ;  // Pin Mux Control - Alternative 1 (GPIO)
	PORTE_PCR21 = PORT_PCR_MUX(1) ;  // Pin Mux Control - Alternative 1 (GPIO)
	PORTE_PCR22 = PORT_PCR_MUX(1) ;  // Pin Mux Control - Alternative 1 (GPIO)
	PORTE_PCR23 = PORT_PCR_MUX(1) ;  // Pin Mux Control - Alternative 1 (GPIO)
	PORTE_PCR29 = PORT_PCR_MUX(1) ;  // Pin Mux Control - Alternative 1 (GPIO)
	PORTE_PCR30 = PORT_PCR_MUX(1) ;  // Pin Mux Control - Alternative 1 (GPIO)
	
	
	
	PORTC_PCR1 = PORT_PCR_MUX(1) ;  // TO-DO // <Manu> Bit a 1 para escribir
	PORTC_PCR2 = PORT_PCR_MUX(1) ;  // TO-DO // <Manu> Bit a 1 para escribir
	
	
	PORTB_PCR1 = PORT_PCR_MUX(1) ;  // TO-DO // <Manu> Bit a 1 para escribir
	PORTB_PCR2 = PORT_PCR_MUX(1) ;  // TO-DO // <Manu> Bit a 1 para escribir
	PORTB_PCR3 = PORT_PCR_MUX(1) ;  // TO-DO // <Manu> Bit a 1 para escribir
	
	
	
	
	// MANDO ----------
	//Port Control Register
	PORTA_PCR17 = PORT_PCR_MUX(1) | 3 ;
	PORTD_PCR1 = PORT_PCR_MUX(1) | 3 ;
	PORTD_PCR6 = PORT_PCR_MUX(1) | 3 ;
	PORTD_PCR7 = PORT_PCR_MUX(1) | 3 ;
	PORTE_PCR0 = PORT_PCR_MUX(1) | 3 ;
	PORTE_PCR1 = PORT_PCR_MUX(1) | 3 ;
	PORTE_PCR31 = PORT_PCR_MUX(1) | 3 ;

	// ---------------------
	

	
	
	
	GPIOE_PDDR |= (1 << BIT_R1) ;
	GPIOE_PDDR |= (1 << BIT_B1) ;
	GPIOE_PDDR |= (1 << BIT_R2) ;
	GPIOE_PDDR |= (1 << BIT_B2) ;
	GPIOE_PDDR |= (1 << BIT_A) ;
	GPIOE_PDDR |= (1 << BIT_C) ;
	
	GPIOE_PDDR |= (1 << BIT_CLK) ;
	GPIOE_PDDR |= (1 << BIT_OE) ;
	
	
	GPIOC_PDDR |= (1 << BIT_G1) ;
	GPIOC_PDDR |= (1 << BIT_G2) ;
	
	GPIOB_PDDR |= (1 << BIT_B) ;
	GPIOB_PDDR |= (1 << BIT_D) ;
	GPIOB_PDDR |= (1 << BIT_LAT) ;

	
/*	
	
	// MANDO ----------
	// Port Data Direction Register
	GPIOA_PDDR &= ~(1 << BIT_UP) ;
	GPIOD_PDDR &= ~(1 << BIT_DOWN) ;
	GPIOD_PDDR &= ~(1 << BIT_LEFT) ; 
	GPIOD_PDDR &= ~(1 << BIT_RIGHT) ; 
	GPIOE_PDDR &= ~(1 << BIT_BUTTON1) ; 
	GPIOE_PDDR &= ~(1 << BIT_BUTTON2) ;
	 
	GPIOD_PDDR &= ~(1 << BIT_BUTTON_START) ; 

	// ---------------------
	 
*/
	
	
/*
 // MANDO ----------
	//Port Control Register
	PORTA_PCR17 = PORT_PCR_MUX(1) | 3 ;
	PORTD_PCR1 = PORT_PCR_MUX(1) | 3 ;
	PORTD_PCR6 = PORT_PCR_MUX(1) | 3 ;
	PORTD_PCR7 = PORT_PCR_MUX(1) | 3 ;
	PORTE_PCR0 = PORT_PCR_MUX(1) | 3 ;
	PORTE_PCR1 = PORT_PCR_MUX(1) | 3 ;
	PORTE_PCR31 = PORT_PCR_MUX(1) | 3 ;
 */
	
	// IRQ para el botn START
	PORTD_PCR1 |= (PORT_PCR_ISF_MASK |	PORT_PCR_IRQC(0xA)) ;
	//PORTD_PCR1 |= (PORT_PCR_ISF_MASK |	PORT_PCR_IRQC(0xB)) ;
	
	//Enable PORTD interrupt on NVIC
	NVIC_ICPR |= 1 << ((INT_PORTD - 16)%32); 
	NVIC_ISER |= 1 << ((INT_PORTD - 16)%32); 
}



// -------------------------------------------------------------------------------------------
//
//
//void PORTA_IRQHandler()
//{
//	// Flag de interrupcio
//	//PORTA_PCR17 |= PORT_PCR_ISF_MASK ;
//}


// -------------------------------------------------------------------------------------------
//
//
void PORTD_IRQHandler()
{
	// Flag de interrupcio
	PORTD_PCR1 |= PORT_PCR_ISF_MASK ;
	
	if(game_over) init_tetris() ;
}




// -------------------------------------------------------------------------------------------
//
//
int main(void)
{
	configCPU() ;
	configGpios() ;
	

	init_input() ;
	init_tetris() ;
	
	while(1) {
		
		tick_input() ;
		tetris_tick() ;
		lcd_update() ;
	}	
	
	
	return 0 ;
}
