

function soundRing(timer) {

  let spectrum2 = fft2.analyze();
  beginShape();
  for (i = 0; i < spectrum2.length; i++) {

    let angle = map(i, 1, spectrum2.length, 0, 360 * c)
    let amp = spectrum2[i];
    soundr = amp * (height * 0.0025)
    let x = soundr * cos(angle) + width / 2
    let y = soundr * sin(angle) + height / 2 + movend
    fill((soundr / 10), 255, 255, 0.15)
    stroke(i * 3, 255, 255, 0.5)
    strokeWeight(amp / 10)
    line(width / 2, (-sin(timer * 0.001) * soundr + height / 2)+movend, x, y)

    stroke(i, 10, 10, 0.7)
    vertex(x, y)
    let vect = createVector(x, y)
    ringhistory.push(vect)
    if (ringhistory.length > spectrum2.length * 5) {
      ringhistory.splice(0, 1)
    }


  }


  endShape(CLOSE);


  for (let i = 0; i < ringhistory.length; i++) {
    push();
    stroke(c * 4, 0, 255, i * 0.0008)
    strokeWeight(4)
    let pos = ringhistory[i];
    point(pos.x, pos.y);
    pop();
  }
  frames += timer * 0.0000005
  c = sin(frames) * 100
  
  if (timer >= beat*31 && timer <= beat*32){
    movend+=map(timer-(beat*31),0,beat,0,height/2)
  }




}