class Snow {
    constructor(numFlakes, container) {
        this.shouldResetPositions = false;
        this.snowflakes = [];
        
        this.browserWidth = document.documentElement.clientWidth;
        this.browserHeight = document.documentElement.clientHeight;

        this.initializeSnowflakes(numFlakes, container);
        window.addEventListener("resize", this.onResize.bind(this), false);
    }

    initializeSnowflakes(numFlakes, container) {
        
        for (var i = 0; i < numFlakes; i++) {
    
            var snowflakeEl = document.createElement("span");
            snowflakeEl.className = "snowflake";
            container.appendChild(snowflakeEl);
    
            var initialXPos = this.createRandomPosition(50, this.browserWidth);
            var initialYPos = this.createRandomPosition(50, this.browserHeight);
            var speed = 4 + Math.random() * 50;
    
            var snowflake = new Snowflake(snowflakeEl, speed, initialXPos, initialYPos, this);
            this.snowflakes.push(snowflake);
        }
    }

     createRandomPosition(offset, size) {
        return Math.round(-1 * offset + Math.random() * (size + 2 * offset));
      }    

    animate() {

        if (this.shouldResetPositions) {
            this.browserWidth = document.documentElement.clientWidth;
            this.browserHeight = document.documentElement.clientHeight;
    
            for (var i = 0; i < this.snowflakes.length; i++) {
              var snowflake = this.snowflakes[i];
    
              snowflake.xPos = this.createRandomPosition(50, this.browserWidth);
              snowflake.yPos = this.createRandomPosition(50, this.browserHeight);
            }
    
            this.shouldResetPositions = false;
        }

        for (var i = 0; i < this.snowflakes.length; i++) {
            var snowflake = this.snowflakes[i];
            snowflake.update();
        }      
  
        requestAnimationFrame(this.animate.bind(this));
      }

      onResize() {
          this.shouldResetPositions = true;
      }
}

// ----------------------------------------------------------------------------------------------------

class Snowflake{
    constructor (element, speed, xPos, yPos, snow) {
        this.element = element;
        this.speed = speed;
        this.xPos = xPos;
        this.yPos = yPos;
        this.scale = 1;
        this.rotation = 0;
        this.snow = snow;
        this.rotation += 368 * Math.random();
  
        this.counter = 0;
        this.sign = Math.random() < 0.5 ? 1 : -1;
  
        this.element.style.opacity = (.05 + Math.random()) / 6;
      }
  
      update() {
        this.counter += this.speed / 5000;
        this.xPos += this.sign * this.speed * Math.cos(this.counter) / 40;
        this.yPos += Math.sin(this.counter) / 40 + this.speed / 30;
        this.scale = .5 + Math.abs(10 * Math.cos(this.counter) / 20);
  
        this.setTransform(Math.round(this.xPos), Math.round(this.yPos), this.scale, this.rotation);
  
        if (this.yPos > this.snow.browserHeight) {
          this.yPos = -50;
        }
      }
  
      setTransform(xPos, yPos, scale, rotation) {
        this.element.style.transform = `translate3d(${xPos}px, ${yPos}px, 0) scale(${scale}, ${scale}) rotate(${rotation}deg)`;
      }    
}