/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Box;
import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Matrix3;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;

public class Line2
implements Curve2 {
    private final double ax;
    private final double ay;
    private final double bx;
    private final double by;

    private Line2(double ax, double ay, double bx, double by) {
        this.ax = ax;
        this.ay = ay;
        this.bx = bx;
        this.by = by;
    }

    public static Line2 line(Vec2 a2, Vec2 b) {
        if (a2.equals(b)) {
            throw new IllegalArgumentException("segments must have non-zero length " + a2 + " " + b);
        }
        return new Line2(a2.x, a2.y, b.x, b.y);
    }

    public static Line2 line(Box2 b) {
        return new Line2(b.lx, b.ly, b.ux, b.uy);
    }

    @Override
    public Line2 transform(Matrix3 m) {
        return Line2.line(this.start().transform(m), this.end().transform(m));
    }

    @Override
    public boolean isFlat(double epsilon) {
        return true;
    }

    @Override
    public double signedArea() {
        return (this.ax * this.by - this.bx * this.ay) / 2.0;
    }

    @Override
    public double length() {
        return this.end().sub(this.start()).length();
    }

    @Override
    public Line2 reverse() {
        return new Line2(this.bx, this.by, this.ax, this.ay);
    }

    @Override
    public double[] inflections() {
        return new double[0];
    }

    @Override
    public Vec2 position(double t2) {
        if (t2 == 0.0) {
            return this.start();
        }
        if (t2 == 1.0) {
            return this.end();
        }
        return new Vec2(this.ax + (this.bx - this.ax) * t2, this.ay + (this.by - this.ay) * t2);
    }

    @Override
    public Vec2 direction(double t2) {
        return new Vec2(this.bx - this.ax, this.by - this.ay);
    }

    @Override
    public Curve2 range(double tMin, double tMax) {
        return Line2.line(this.position(tMin), this.position(tMax));
    }

    public Line2[] split(double t2) {
        if (t2 <= 0.0 || t2 >= 1.0) {
            throw new IllegalArgumentException("t must be within (0,1)");
        }
        Vec2 v = this.position(t2);
        return new Line2[]{Line2.line(this.start(), v), Line2.line(v, this.end())};
    }

    @Override
    public double nearestPoint(Vec2 p) {
        Vec2 bSa = this.end().sub(this.start());
        Vec2 pSa = p.sub(this.start());
        return Vec.dot(bSa, pSa) / bSa.lengthSquared();
    }

    @Override
    public Line2 endpoints(Vec2 start2, Vec2 end2) {
        return Line2.line(start2, end2);
    }

    @Override
    public Vec2 start() {
        return Vec.vec(this.ax, this.ay);
    }

    @Override
    public Vec2 end() {
        return Vec.vec(this.bx, this.by);
    }

    @Override
    public Vec2[] subdivide(double error) {
        return new Vec2[]{this.start(), this.end()};
    }

    @Override
    public Box2 bounds() {
        return Box.box(this.start(), this.end());
    }

    public double distance(Vec2 p) {
        double t2 = this.nearestPoint(p);
        if (t2 <= 0.0) {
            return p.sub(this.start()).length();
        }
        if (t2 >= 1.0) {
            return p.sub(this.end()).length();
        }
        return p.sub(this.end().sub(this.start()).mul(t2)).length();
    }

    public String toString() {
        return "a=" + this.start() + ", b=" + this.end();
    }
}

