/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Matrix3;
import io.lacuna.artifex.Polar2;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec3;
import io.lacuna.artifex.Vec4;
import io.lacuna.artifex.utils.Hashes;
import java.util.Comparator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;

public class Vec2
implements Vec<Vec2> {
    public static final Vec2 ORIGIN = new Vec2(0.0, 0.0);
    public static final Vec2 X_AXIS = new Vec2(1.0, 0.0);
    public static final Vec2 Y_AXIS = new Vec2(0.0, 1.0);
    public static final Comparator<Vec2> COMPARATOR = Comparator.comparingDouble(v -> v.x).thenComparingDouble(v -> v.y);
    public final double x;
    public final double y;

    public Vec2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public final Vec2 map(DoubleUnaryOperator f) {
        return new Vec2(f.applyAsDouble(this.x), f.applyAsDouble(this.y));
    }

    @Override
    public final double reduce(DoubleBinaryOperator f, double init) {
        return f.applyAsDouble(f.applyAsDouble(this.x, this.y), init);
    }

    @Override
    public double reduce(DoubleBinaryOperator f) {
        return f.applyAsDouble(this.x, this.y);
    }

    @Override
    public final Vec2 zip(Vec2 v, DoubleBinaryOperator f) {
        return new Vec2(f.applyAsDouble(this.x, v.x), f.applyAsDouble(this.y, v.y));
    }

    @Override
    public boolean every(DoublePredicate f) {
        return f.test(this.x) && f.test(this.y);
    }

    @Override
    public boolean any(DoublePredicate f) {
        return f.test(this.x) || f.test(this.y);
    }

    @Override
    public double nth(int idx) {
        switch (idx) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int dim() {
        return 2;
    }

    @Override
    public double[] array() {
        return new double[]{this.x, this.y};
    }

    public Vec2 add(double x, double y) {
        return new Vec2(this.x + x, this.y + y);
    }

    public Vec2 sub(double x, double y) {
        return new Vec2(this.x - x, this.y - y);
    }

    public Vec2 swap() {
        return new Vec2(this.y, this.x);
    }

    public Vec3 vec3(double z) {
        return new Vec3(this.x, this.y, z);
    }

    public Vec4 vec4(double z, double w) {
        return new Vec4(this.x, this.y, z, w);
    }

    public Vec4 vec4(Vec2 v) {
        return new Vec4(this.x, this.y, v.x, v.y);
    }

    public Vec2 transform(Matrix3 m) {
        return m.transform(this);
    }

    public Vec2 rotate(double radians) {
        double s2 = Math.sin(radians);
        double c = Math.cos(radians);
        return new Vec2(c * this.x + -s2 * this.y, s2 * this.x + c * this.y);
    }

    public static double cross(Vec2 a2, Vec2 b) {
        return a2.x * b.y - a2.y * b.x;
    }

    public static double angleBetween(Vec2 a2, Vec2 b) {
        double theta = StrictMath.atan2(Vec2.cross(a2 = (Vec2)a2.pseudoNorm(), b = (Vec2)b.pseudoNorm()), Vec.dot(a2, b));
        if (theta > 0.0) {
            theta -= Math.PI * 2;
        }
        return theta;
    }

    public static boolean between(Vec2 a2, Vec2 b, Vec2 c) {
        return Vec2.cross(a2, b) * Vec2.cross(c, b) < 0.0;
    }

    public Polar2 polar2() {
        return new Polar2(Math.atan2(this.y, this.x), this.length());
    }

    public int hashCode() {
        return Hashes.hash(this.x, this.y);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec2) {
            Vec2 v = (Vec2)obj;
            return v.x == this.x && v.y == this.y;
        }
        return false;
    }

    public String toString() {
        return "[x=" + this.x + ", y=" + this.y + "]";
    }

    @Override
    public int compareTo(Vec2 o) {
        return COMPARATOR.compare(this, o);
    }

    @Override
    public Vec2 add(Vec2 v) {
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    @Override
    public Vec2 add(double n) {
        return new Vec2(this.x + n, this.y + n);
    }

    @Override
    public Vec2 negate() {
        return new Vec2(-this.x, -this.y);
    }

    @Override
    public Vec2 sub(Vec2 v) {
        return new Vec2(this.x - v.x, this.y - v.y);
    }

    @Override
    public Vec2 sub(double n) {
        return new Vec2(this.x - n, this.y - n);
    }

    @Override
    public Vec2 mul(Vec2 v) {
        return new Vec2(this.x * v.x, this.y * v.y);
    }

    @Override
    public Vec2 mul(double k) {
        return new Vec2(this.x * k, this.y * k);
    }

    @Override
    public Vec2 div(Vec2 v) {
        return new Vec2(this.x / v.x, this.y / v.y);
    }
}

