/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IForkable;
import io.lacuna.bifurcan.ILinearizable;
import io.lacuna.bifurcan.ISplittable;
import io.lacuna.bifurcan.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface IList<V>
extends ISplittable<IList<V>>,
Iterable<V>,
IForkable<IList<V>>,
ILinearizable<IList<V>> {
    public V nth(long var1);

    default public V nth(long idx, V defaultValue) {
        if (idx < 0L || idx >= this.size()) {
            return defaultValue;
        }
        return this.nth(idx);
    }

    public long size();

    default public IList<V> update(long idx, Function<V, V> updateFn) {
        return this.set(idx, updateFn.apply(this.nth(idx)));
    }

    @Override
    default public boolean isLinear() {
        return false;
    }

    default public IList<V> addLast(V value) {
        return new Lists.VirtualList<V>(this).addLast(value);
    }

    default public IList<V> addFirst(V value) {
        return new Lists.VirtualList<V>(this).addFirst(value);
    }

    default public IList<V> removeLast() {
        return new Lists.VirtualList(this).removeLast();
    }

    default public IList<V> removeFirst() {
        return new Lists.VirtualList(this).removeFirst();
    }

    default public IList<V> set(long idx, V value) {
        return new Lists.VirtualList<V>(this).set(idx, value);
    }

    default public Stream<V> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    default public Spliterator<V> spliterator() {
        return Spliterators.spliterator(this.iterator(), this.size(), 16);
    }

    @Override
    default public Iterator<V> iterator() {
        return Lists.iterator(this);
    }

    default public Object[] toArray() {
        Object[] ary = new Object[(int)this.size()];
        IntStream.range(0, ary.length).forEach((int i) -> {
            ary[i] = this.nth(i);
        });
        return ary;
    }

    default public V[] toArray(IntFunction<V[]> allocator) {
        V[] ary = allocator.apply((int)this.size());
        for (int i = 0; i < ary.length; ++i) {
            ary[i] = this.nth(i);
        }
        return ary;
    }

    default public List<V> toList() {
        return Lists.toList(this);
    }

    @Override
    default public IList<IList<V>> split(int parts) {
        parts = Math.max(1, Math.min((int)this.size(), parts));
        IList[] ary = new IList[parts];
        long subSize = this.size() / (long)parts;
        long offset2 = 0L;
        for (int i = 0; i < parts; ++i) {
            ary[i] = Lists.slice(this, offset2, i == parts - 1 ? this.size() : offset2 + subSize);
            offset2 += subSize;
        }
        return Lists.from(ary);
    }

    default public IList<V> slice(long start2, long end2) {
        return Lists.slice(this, start2, end2);
    }

    default public IList<V> concat(IList<V> l) {
        return Lists.concat(this, l);
    }

    default public V first() {
        if (this.size() == 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this.nth(0L);
    }

    default public V last() {
        if (this.size() == 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this.nth(this.size() - 1L);
    }

    @Override
    default public IList<V> forked() {
        return this;
    }

    @Override
    default public IList<V> linear() {
        return new Lists.VirtualList(this).linear();
    }

    public IList<V> clone();

    default public boolean equals(Object o, BiPredicate<V, V> equals) {
        if (o instanceof IList) {
            return Lists.equals(this, (IList)o, equals);
        }
        return false;
    }
}

