/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.LinearSet;
import io.lacuna.bifurcan.List;
import io.lacuna.bifurcan.Maps;
import io.lacuna.bifurcan.utils.Bits;
import io.lacuna.bifurcan.utils.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.IntPredicate;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;

public class LinearMap<K, V>
implements IMap<K, V>,
Cloneable {
    public static final int MAX_CAPACITY = 0x20000000;
    private static final float LOAD_FACTOR = 0.95f;
    private static final int NONE = 0;
    private static final int FALLBACK = 1;
    private final ToIntFunction<K> hashFn;
    private final BiPredicate<K, K> equalsFn;
    private int indexMask;
    long[] table;
    Object[] entries;
    private int size;
    private int hash = -1;

    public static <K, V> LinearMap<K, V> from(Map<K, V> map2) {
        return LinearMap.from(map2.entrySet());
    }

    public static <K, V> LinearMap<K, V> from(IMap<K, V> map2) {
        if (map2 instanceof LinearMap) {
            return ((LinearMap)map2).clone();
        }
        LinearMap result2 = new LinearMap((int)map2.size(), map2.keyHash(), map2.keyEquality());
        map2.forEach(e -> result2.put(e.key(), e.value()));
        return result2;
    }

    public static <K, V> LinearMap<K, V> from(Iterable<IEntry<K, V>> entries2) {
        return LinearMap.from(entries2.iterator());
    }

    public static <K, V> LinearMap<K, V> from(Iterator<IEntry<K, V>> entries2) {
        LinearMap m = new LinearMap();
        entries2.forEachRemaining(e -> m.put(e.key(), e.value()));
        return m;
    }

    public static <K, V> LinearMap<K, V> from(Collection<Map.Entry<K, V>> entries2) {
        return entries2.stream().collect(Maps.linearCollector(Map.Entry::getKey, Map.Entry::getValue, entries2.size()));
    }

    public LinearMap() {
        this(16);
    }

    public LinearMap(int initialCapacity) {
        this(initialCapacity, Objects::hashCode, Objects::equals);
    }

    public LinearMap(ToIntFunction<K> hashFn, BiPredicate<K, K> equalsFn) {
        this(16, hashFn, equalsFn);
    }

    public LinearMap(int initialCapacity, ToIntFunction<K> hashFn, BiPredicate<K, K> equalsFn) {
        if (initialCapacity > 0x20000000) {
            throw new IllegalArgumentException("initialCapacity cannot be larger than 536870912");
        }
        this.hashFn = hashFn;
        this.equalsFn = equalsFn;
        this.size = 0;
        this.resize(initialCapacity);
    }

    private LinearMap(int tableLength, int entriesLength, ToIntFunction<K> hashFn, BiPredicate<K, K> equalsFn) {
        this.hashFn = hashFn;
        this.equalsFn = equalsFn;
        this.size = 0;
        this.resize(tableLength, entriesLength);
    }

    @Override
    public ToIntFunction<K> keyHash() {
        return this.hashFn;
    }

    @Override
    public BiPredicate<K, K> keyEquality() {
        return this.equalsFn;
    }

    @Override
    public LinearMap<K, V> put(K key, V value) {
        return this.put((Object)key, (Object)value, Maps.MERGE_LAST_WRITE_WINS);
    }

    @Override
    public LinearMap<K, V> put(K key, V value, BinaryOperator<V> merge) {
        if (this.size << 1 == this.entries.length) {
            this.resize(this.size << 1);
        }
        this.put(this.keyHash(key), key, value, merge);
        this.hash = -1;
        return this;
    }

    @Override
    public LinearMap<K, V> remove(K key) {
        int idx = this.tableIndex(this.keyHash(key), key);
        if (idx >= 0) {
            int lastKeyIndex;
            long row = this.table[idx];
            --this.size;
            int keyIndex = Row.keyIndex(row);
            if (keyIndex != (lastKeyIndex = this.size << 1)) {
                Object lastKey = this.entries[lastKeyIndex];
                Object lastValue = this.entries[lastKeyIndex + 1];
                int lastIdx = this.tableIndex(this.keyHash(lastKey), lastKey);
                this.table[lastIdx] = Row.construct(Row.hash(this.table[lastIdx]), keyIndex);
                this.putEntry(keyIndex, lastKey, lastValue);
            }
            this.table[idx] = Row.addTombstone(row);
            this.putEntry(lastKeyIndex, null, null);
            this.hash = -1;
        }
        return this;
    }

    public LinearMap<K, V> clear() {
        Arrays.fill(this.entries, null);
        Arrays.fill(this.table, 0L);
        this.size = 0;
        this.hash = -1;
        return this;
    }

    @Override
    public <U> LinearMap<K, U> mapValues(BiFunction<K, V, U> f) {
        Object m = this.clone();
        int i = 0;
        while ((long)i < ((LinearMap)m).size()) {
            int idx = i << 1;
            ((LinearMap)m).entries[idx + 1] = f.apply(((LinearMap)m).entries[idx], ((LinearMap)m).entries[idx + 1]);
            ++i;
        }
        return m;
    }

    @Override
    public boolean contains(K key) {
        return this.tableIndex(this.keyHash(key), key) >= 0;
    }

    @Override
    public V get(K key, V defaultValue) {
        int idx = this.tableIndex(this.keyHash(key), key);
        if (idx >= 0) {
            long row = this.table[idx];
            return (V)this.entries[Row.keyIndex(row) + 1];
        }
        return defaultValue;
    }

    @Override
    public LinearMap<K, V> update(K key, UnaryOperator<V> update) {
        int idx = this.tableIndex(this.keyHash(key), key);
        if (idx >= 0) {
            long row = this.table[idx];
            int valIdx = Row.keyIndex(row) + 1;
            this.entries[valIdx] = update.apply(this.entries[valIdx]);
            this.hash = -1;
        } else {
            this.put((Object)key, update.apply(null));
        }
        return this;
    }

    @Override
    public ISet<K> keys() {
        return new LinearSet(this);
    }

    @Override
    public long indexOf(K key) {
        int idx = this.tableIndex(this.keyHash(key), key);
        return idx >= 0 ? (long)(Row.keyIndex(this.table[idx]) >> 1) : -1L;
    }

    @Override
    public IEntry<K, V> nth(long index) {
        int idx = (int)index << 1;
        return new Maps.Entry<Object, Object>(this.entries[idx], this.entries[idx + 1]);
    }

    @Override
    public Iterator<IEntry<K, V>> iterator() {
        return Iterators.range(this.size, i -> {
            int idx = (int)(i << 1);
            return new Maps.Entry<Object, Object>(this.entries[idx], this.entries[idx + 1]);
        });
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public IMap<K, V> forked() {
        return new Maps.VirtualMap(this);
    }

    @Override
    public IMap<K, V> linear() {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMap) {
            return Maps.equals(this, (IMap)obj);
        }
        return false;
    }

    @Override
    public LinearMap<K, V> clone() {
        LinearMap<K, V> m = new LinearMap<K, V>(this.table.length, this.entries.length, this.hashFn, this.equalsFn);
        m.size = this.size;
        m.indexMask = this.indexMask;
        System.arraycopy(this.table, 0, m.table, 0, this.table.length);
        System.arraycopy(this.entries, 0, m.entries, 0, this.size << 1);
        return m;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = 0;
            for (long row : this.table) {
                if (!Row.populated(row)) continue;
                Object value = this.entries[Row.keyIndex(row) + 1];
                this.hash += Row.hash(row) * 31 + Objects.hashCode(value);
            }
        }
        return this.hash;
    }

    public String toString() {
        return Maps.toString(this);
    }

    @Override
    public List<LinearMap<K, V>> split(int parts) {
        parts = Math.min(parts, this.size);
        IList list = new List().linear();
        if (parts <= 1) {
            return ((List)((List)list).addLast(this)).forked();
        }
        int partSize = this.table.length / parts;
        for (int p = 0; p < parts; ++p) {
            int start2 = p * partSize;
            int finish = p == parts - 1 ? this.table.length : start2 + partSize;
            LinearMap<K, V> m = new LinearMap<K, V>(finish - start2);
            for (int i = start2; i < finish; ++i) {
                long row = this.table[i];
                if (!Row.populated(row)) continue;
                int keyIndex = Row.keyIndex(row);
                int resultKeyIndex = m.size << 1;
                super.putEntry(resultKeyIndex, this.entries[keyIndex], this.entries[keyIndex + 1]);
                super.putTable(Row.hash(row), resultKeyIndex);
                ++m.size;
            }
            if (m.size <= 0) continue;
            ((List)list).addLast(m);
        }
        return ((List)list).forked();
    }

    @Override
    public LinearMap<K, V> union(IMap<K, V> m) {
        return this.merge((IMap)m, Maps.MERGE_LAST_WRITE_WINS);
    }

    @Override
    public LinearMap<K, V> merge(IMap<K, V> o, BinaryOperator<V> mergeFn) {
        if (o.size() == 0L) {
            return this.clone();
        }
        if (o instanceof LinearMap) {
            return this.merge((LinearMap)o, mergeFn);
        }
        Object result2 = this.clone();
        for (IEntry<K, V> e : o.entries()) {
            ((LinearMap)result2).put((Object)e.key(), (Object)e.value(), (BinaryOperator)mergeFn);
        }
        return result2;
    }

    @Override
    public LinearMap<K, V> difference(IMap<K, ?> m) {
        if (m instanceof LinearMap) {
            return this.difference((LinearMap)m);
        }
        return (LinearMap)Maps.difference(this.clone(), m.keys());
    }

    @Override
    public LinearMap<K, V> intersection(IMap<K, ?> m) {
        if (m instanceof LinearMap) {
            return this.intersection((LinearMap)m);
        }
        return (LinearMap)Maps.intersection(new LinearMap<K, V>(), this, m.keys());
    }

    @Override
    public LinearMap<K, V> intersection(ISet<K> keys2) {
        if (keys2 instanceof LinearSet) {
            return this.intersection(((LinearSet)keys2).map);
        }
        return (LinearMap)Maps.intersection(new LinearMap<K, V>(), this, keys2);
    }

    @Override
    public boolean containsAll(ISet<K> set) {
        if (set instanceof LinearSet) {
            return this.isSubset(((LinearSet)set).map);
        }
        return set.elements().stream().allMatch(this::contains);
    }

    @Override
    public boolean containsAll(IMap<K, ?> map2) {
        if (map2 instanceof LinearMap) {
            return this.isSubset((LinearMap)map2);
        }
        return map2.keys().stream().allMatch(this::contains);
    }

    @Override
    public boolean containsAny(ISet<K> set) {
        if (this.size() < set.size()) {
            return set.containsAny(this);
        }
        if (set instanceof LinearSet) {
            return this.intersects(((LinearSet)set).map);
        }
        return set.elements().stream().anyMatch(this::contains);
    }

    @Override
    public boolean containsAny(IMap<K, ?> map2) {
        if (this.size() < map2.size()) {
            return map2.containsAny(this);
        }
        if (map2 instanceof LinearMap) {
            return this.intersects((LinearMap)map2);
        }
        return map2.keys().stream().anyMatch(this::contains);
    }

    @Override
    LinearMap<K, V> merge(LinearMap<K, V> m, BinaryOperator<V> mergeFn) {
        if (m.size > this.size) {
            return m.merge(this, (x, y) -> mergeFn.apply(y, x));
        }
        Object result2 = this.clone();
        super.resize(((LinearMap)result2).size + m.size);
        for (long row : m.table) {
            if (!Row.populated(row)) continue;
            int keyIndex = Row.keyIndex(row);
            super.put(Row.hash(row), m.entries[keyIndex], m.entries[keyIndex + 1], mergeFn);
        }
        return result2;
    }

    @Override
    LinearMap<K, V> difference(LinearMap<K, ?> m) {
        LinearMap<K, V> result2 = new LinearMap<K, V>(this.size);
        this.combine(m, result2, i -> i == -1);
        return result2;
    }

    @Override
    LinearMap<K, V> intersection(LinearMap<K, ?> m) {
        LinearMap<K, V> result2 = new LinearMap<K, V>(Math.min(this.size, (int)m.size()));
        this.combine(m, result2, i -> i != -1);
        return result2;
    }

    private boolean isSubset(LinearMap<K, ?> m) {
        for (long row : m.table) {
            if (!Row.populated(row)) continue;
            int currKeyIndex = Row.keyIndex(row);
            Object currKey = m.entries[currKeyIndex];
            if (super.tableIndex(Row.hash(row), currKey) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean intersects(LinearMap<K, ?> m) {
        for (long row : m.table) {
            if (!Row.populated(row)) continue;
            int currKeyIndex = Row.keyIndex(row);
            Object currKey = m.entries[currKeyIndex];
            if (super.tableIndex(Row.hash(row), currKey) == -1) continue;
            return true;
        }
        return true;
    }

    private void combine(LinearMap<K, ?> m, LinearMap<K, V> result2, IntPredicate indexPredicate) {
        for (long row : this.table) {
            if (!Row.populated(row)) continue;
            int currKeyIndex = Row.keyIndex(row);
            Object currKey = this.entries[currKeyIndex];
            int entryIndex = super.tableIndex(Row.hash(row), currKey);
            if (!indexPredicate.test(entryIndex)) continue;
            int resultKeyIndex = result2.size << 1;
            super.putEntry(resultKeyIndex, currKey, this.entries[currKeyIndex + 1]);
            super.putTable(Row.hash(row), resultKeyIndex);
            ++result2.size;
        }
    }

    private void resize(int tableLength, int entriesLength) {
        this.indexMask = tableLength - 1;
        if (this.table == null) {
            this.table = new long[tableLength];
        } else if (this.table.length != tableLength) {
            long[] oldTable = this.table;
            this.table = new long[tableLength];
            for (long row : oldTable) {
                if (!Row.populated(row)) continue;
                int hash = Row.hash(row);
                this.putTable(hash, Row.keyIndex(row), this.estimatedIndex(hash));
            }
        }
        if (this.entries == null) {
            this.entries = new Object[entriesLength];
        } else {
            Object[] nEntries = new Object[entriesLength];
            System.arraycopy(this.entries, 0, nEntries, 0, this.size << 1);
            this.entries = nEntries;
        }
    }

    private void resize(int capacity) {
        if (capacity > 0x20000000) {
            throw new IllegalStateException("the map cannot be larger than 536870912");
        }
        capacity = Math.max(4, capacity);
        int tableLength = 1 << Bits.log2Ceil((long)Math.ceil((float)capacity / 0.95f));
        this.resize(tableLength, capacity << 1);
    }

    private int tableIndex(int hash, K key) {
        int idx = this.estimatedIndex(hash);
        int dist = 0;
        long row;
        int currHash;
        while ((currHash = Row.hash(row = this.table[idx])) != hash || Row.tombstone(row) || !this.equalsFn.test(key, this.entries[Row.keyIndex(row)])) {
            if (currHash == 0 || dist > this.probeDistance(currHash, idx)) {
                return -1;
            }
            idx = this.nextIndex(idx);
            ++dist;
        }
        return idx;
    }

    private void putTable(int hash, int keyIndex, int tableIndex) {
        int tombstoneIdx = -1;
        int idx = tableIndex;
        int dist = this.probeDistance(hash, tableIndex);
        int abs = 0;
        while (true) {
            long row = this.table[idx];
            int currHash = Row.hash(row);
            boolean isTombstone = Row.tombstone(row);
            if (abs > this.table.length) {
                throw new IllegalStateException();
            }
            if (currHash == 0) {
                this.table[idx] = Row.construct(hash, keyIndex);
                break;
            }
            int currDist = this.probeDistance(currHash, idx);
            if (!isTombstone && currDist > dist) {
                tombstoneIdx = -1;
            } else if (isTombstone && tombstoneIdx == -1) {
                tombstoneIdx = idx;
            }
            if (dist > currDist) {
                long nRow = Row.construct(hash, keyIndex);
                if (tombstoneIdx >= 0) {
                    this.table[tombstoneIdx] = nRow;
                    break;
                }
                this.table[idx] = nRow;
                if (isTombstone) break;
                dist = currDist;
                keyIndex = Row.keyIndex(row);
                hash = currHash;
            }
            idx = this.nextIndex(idx);
            ++dist;
            ++abs;
        }
    }

    private void putEntry(int keyIndex, K key, V value) {
        this.entries[keyIndex] = key;
        this.entries[keyIndex + 1] = value;
    }

    private void putTable(int hash, int keyIndex) {
        this.putTable(hash, keyIndex, this.estimatedIndex(hash));
    }

    private boolean putCheckEquality(int idx, K key, V value, BinaryOperator<V> mergeFn) {
        long row = this.table[idx];
        int keyIndex = Row.keyIndex(row);
        Object currKey = this.entries[keyIndex];
        if (this.equalsFn.test(key, currKey)) {
            this.entries[keyIndex + 1] = mergeFn.apply(this.entries[keyIndex + 1], value);
            return true;
        }
        return false;
    }

    private void put(int hash, K key, V value, BinaryOperator<V> mergeFn) {
        int tombstoneIdx = -1;
        int idx = this.estimatedIndex(hash);
        int dist = 0;
        while (true) {
            long row;
            int currHash;
            boolean isNone = (currHash = Row.hash(row = this.table[idx])) == 0;
            boolean isTombstone = Row.tombstone(row);
            if (currHash == hash && !isTombstone && this.putCheckEquality(idx, key, value, mergeFn)) break;
            int currDist = this.probeDistance(currHash, idx);
            if (!isTombstone && currDist > dist) {
                tombstoneIdx = -1;
            } else if (isTombstone && tombstoneIdx == -1) {
                tombstoneIdx = idx;
            }
            if (isNone || dist > currDist) {
                int keyIndex = this.size << 1;
                this.putEntry(keyIndex, key, value);
                ++this.size;
                long nRow = Row.construct(hash, keyIndex);
                if (tombstoneIdx >= 0) {
                    this.table[tombstoneIdx] = nRow;
                    break;
                }
                if (isNone || isTombstone) {
                    this.table[idx] = nRow;
                    break;
                }
                this.putTable(hash, keyIndex, idx);
                break;
            }
            idx = this.nextIndex(idx);
            ++dist;
        }
    }

    private int estimatedIndex(int hash) {
        return hash & this.indexMask;
    }

    private int nextIndex(int idx) {
        return idx + 1 & this.indexMask;
    }

    private int probeDistance(int hash, int index) {
        return index + this.table.length - (hash & this.indexMask) & this.indexMask;
    }

    private int keyHash(K key) {
        int hash = this.hashFn.applyAsInt(key);
        hash ^= hash >>> 20 ^ hash >>> 12;
        return (hash ^= hash >>> 7 ^ hash >>> 4) == 0 ? 1 : hash;
    }

    static class Row {
        static final long HASH_MASK = 0xFFFFFFFFL;
        static final long KEY_INDEX_MASK = Integer.MAX_VALUE;
        static final long TOMBSTONE_MASK = Long.MIN_VALUE;

        Row() {
        }

        static long construct(int hash, int keyIndex) {
            return (long)hash & 0xFFFFFFFFL | ((long)keyIndex & Integer.MAX_VALUE) << 32;
        }

        static int hash(long row) {
            return (int)(row & 0xFFFFFFFFL);
        }

        static boolean populated(long row) {
            return (row & 0xFFFFFFFFL) != 0L && (row & Long.MIN_VALUE) == 0L;
        }

        static int keyIndex(long row) {
            return (int)(row >> 32 & Integer.MAX_VALUE);
        }

        static boolean tombstone(long row) {
            return (row & Long.MIN_VALUE) != 0L;
        }

        static long addTombstone(long row) {
            return row | Long.MIN_VALUE;
        }

        static long removeTombstone(long row) {
            return row & Long.MAX_VALUE;
        }
    }
}

