/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.nodes.ListNodes;
import io.lacuna.bifurcan.utils.Bits;
import java.util.Iterator;

public class List<V>
implements IList<V>,
Cloneable {
    private ListNodes.Node root;
    private byte prefixLen;
    private byte suffixLen;
    public Object[] prefix;
    public Object[] suffix;
    private final Object editor;

    public static <V> List<V> of(V ... elements) {
        IList list = new List<V>().linear();
        for (V e : elements) {
            ((List)list).addLast((Object)e);
        }
        return ((List)list).forked();
    }

    public static <V> List<V> from(IList<V> list) {
        if (list instanceof List) {
            return ((List)list).forked();
        }
        return List.from(list.iterator());
    }

    public static <V> List<V> from(Iterable<V> iterable) {
        return List.from(iterable.iterator());
    }

    public static <V> List<V> from(Iterator<V> iterator2) {
        IList list = new List<V>().linear();
        iterator2.forEachRemaining(object -> this.addLast(object));
        return ((List)list).forked();
    }

    public List() {
        this.editor = null;
        this.root = ListNodes.Node.EMPTY;
        this.prefixLen = 0;
        this.prefix = null;
        this.suffixLen = 0;
        this.suffix = null;
    }

    List(boolean linear, ListNodes.Node root, int prefixLen, Object[] prefix, int suffixLen, Object[] suffix) {
        this.editor = linear ? new Object() : null;
        this.root = root;
        this.prefixLen = (byte)prefixLen;
        this.suffixLen = (byte)suffixLen;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public V nth(long idx) {
        int rootSize = this.root.size();
        if (idx < 0L || idx >= (long)(rootSize + this.prefixLen + this.suffixLen)) {
            throw new IndexOutOfBoundsException(idx + " must be within [0," + this.size() + ")");
        }
        int i = (int)idx;
        if (i < this.prefixLen) {
            return (V)this.prefix[this.prefix.length + i - this.prefixLen];
        }
        if (i - this.prefixLen < rootSize) {
            return (V)this.root.nth(i - this.prefixLen, false);
        }
        return (V)this.suffix[i - (rootSize + this.prefixLen)];
    }

    @Override
    public long size() {
        return this.root.size() + this.prefixLen + this.suffixLen;
    }

    @Override
    public boolean isLinear() {
        return this.editor != null;
    }

    @Override
    public List<V> addLast(V value) {
        return ((List)(this.isLinear() ? this : this.clone())).pushLast(value);
    }

    @Override
    public List<V> addFirst(V value) {
        return ((List)(this.isLinear() ? this : this.clone())).pushFirst(value);
    }

    @Override
    public List<V> removeLast() {
        return ((List)(this.isLinear() ? this : this.clone())).popLast();
    }

    @Override
    public List<V> removeFirst() {
        return ((List)(this.isLinear() ? this : this.clone())).popFirst();
    }

    @Override
    public List<V> set(long idx, V value) {
        int size = (int)this.size();
        if (idx < 0L || idx > (long)size) {
            throw new IndexOutOfBoundsException();
        }
        if (idx == (long)size) {
            return this.addLast((Object)value);
        }
        return ((List)(this.isLinear() ? this : this.clone())).overwrite((int)idx, value);
    }

    @Override
    public Iterator<V> iterator() {
        int initLimit;
        int initOffset;
        Object[] initChunk;
        final int size = (int)this.size();
        final int rootSize = this.root.size();
        if (this.prefixLen > 0) {
            initChunk = this.prefix;
            initOffset = this.pIdx(0);
            initLimit = this.prefix.length;
        } else if (rootSize > 0) {
            initChunk = (Object[])this.root.nth(0, true);
            initOffset = 0;
            initLimit = initChunk.length;
        } else {
            initChunk = this.suffix;
            initOffset = 0;
            initLimit = this.suffixLen;
        }
        return new Iterator<V>(){
            int idx = 0;
            Object[] chunk = initChunk;
            int offset = initOffset;
            int limit = initLimit;
            int chunkSize = this.limit - this.offset;

            @Override
            public boolean hasNext() {
                return this.idx < size;
            }

            @Override
            public V next() {
                Object val = this.chunk[this.offset++];
                if (this.offset == this.limit) {
                    this.idx += this.chunkSize;
                    if (this.idx < size) {
                        if (this.idx == List.this.prefixLen + rootSize) {
                            this.chunk = List.this.suffix;
                            this.limit = List.this.suffixLen;
                        } else {
                            this.chunk = (Object[])List.this.root.nth(this.idx - List.this.prefixLen, true);
                            this.limit = this.chunk.length;
                        }
                        this.offset = 0;
                        this.chunkSize = this.limit;
                    }
                }
                return val;
            }
        };
    }

    @Override
    public List<V> slice(long start2, long end2) {
        if (start2 < 0L || end2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int s2 = (int)start2;
        int e = (int)end2;
        int pStart = Math.min(this.prefixLen, s2);
        int pEnd = Math.min(this.prefixLen, e);
        int pLen = pEnd - pStart;
        Object[] pre = null;
        if (pLen > 0) {
            pre = new Object[1 << Bits.log2Ceil(pLen)];
            System.arraycopy(this.prefix, this.pIdx(pStart), pre, pre.length - pLen, pLen);
        }
        int sStart = Math.max(0, s2 - (this.prefixLen + this.root.size()));
        int sEnd = Math.max(0, e - (this.prefixLen + this.root.size()));
        int sLen = sEnd - sStart;
        Object[] suf = null;
        if (sLen > 0) {
            suf = new Object[1 << Bits.log2Ceil(sLen)];
            System.arraycopy(this.suffix, sStart, suf, 0, sLen);
        }
        return new List<V>(this.isLinear(), this.root.slice(Math.max(0, Math.min(this.root.size(), s2 - this.prefixLen)), Math.max(0, Math.min(this.root.size(), e - this.prefixLen)), new Object()), pLen, pre, sLen, suf);
    }

    @Override
    public IList<V> concat(IList<V> l) {
        if (l instanceof List) {
            List b = (List)l;
            ListNodes.Node r = this.root;
            Object editor = new Object();
            if (this.suffixLen > 0) {
                r = r.pushLast(this.suffixArray(), editor);
            }
            if (b.prefixLen > 0) {
                r = r.pushLast(b.prefixArray(), editor);
            }
            if (b.root.size() > 0) {
                r = r.concat(b.root, editor);
            }
            return new List<V>(this.isLinear(), r, this.prefixLen, this.prefixLen > 0 ? (Object[])this.prefix.clone() : null, b.suffixLen, b.suffixLen > 0 ? (Object[])b.suffix.clone() : null);
        }
        return Lists.concat(this, l);
    }

    @Override
    public List<V> forked() {
        return this.isLinear() ? new List<V>(false, this.root, this.prefixLen, this.prefix, this.suffixLen, this.suffix).clone() : this;
    }

    @Override
    public List<V> linear() {
        return this.isLinear() ? this : new List<V>(true, this.root, this.prefixLen, this.prefix, this.suffixLen, this.suffix).clone();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IList) {
            return Lists.equals(this, (IList)obj);
        }
        return false;
    }

    public String toString() {
        return Lists.toString(this);
    }

    @Override
    public List<V> clone() {
        return new List<V>(this.isLinear(), this.root, this.prefixLen, this.prefix == null ? null : (Object[])this.prefix.clone(), this.suffixLen, this.suffix == null ? null : (Object[])this.suffix.clone());
    }

    private Object[] suffixArray() {
        Object[] suf = new Object[this.suffixLen];
        System.arraycopy(this.suffix, 0, suf, 0, suf.length);
        return suf;
    }

    private Object[] prefixArray() {
        Object[] pre = new Object[this.prefixLen];
        System.arraycopy(this.prefix, this.pIdx(0), pre, 0, pre.length);
        return pre;
    }

    private int pIdx(int idx) {
        return this.prefix.length - this.prefixLen + idx;
    }

    List<V> overwrite(int idx, V value) {
        int rootSize = this.root.size();
        if (idx < this.prefixLen) {
            this.prefix[this.prefix.length - this.prefixLen + idx] = value;
        } else if (idx < this.prefixLen + rootSize) {
            this.root = this.root.set(this.editor, idx - this.prefixLen, value);
        } else {
            this.suffix[idx - (this.prefixLen + rootSize)] = value;
        }
        return this;
    }

    List<V> pushFirst(V value) {
        if (this.prefix == null) {
            this.prefix = new Object[2];
        } else if (this.prefixLen == this.prefix.length) {
            Object[] newPrefix = new Object[Math.min(32, this.prefix.length << 1)];
            System.arraycopy(this.prefix, 0, newPrefix, newPrefix.length - this.prefixLen, this.prefixLen);
            this.prefix = newPrefix;
        }
        this.prefix[this.pIdx((int)-1)] = value;
        this.prefixLen = (byte)(this.prefixLen + 1);
        if (this.prefixLen == 32) {
            Object editor = this.isLinear() ? this.editor : new Object();
            this.root = this.root.pushFirst(this.prefix, editor);
            this.prefix = null;
            this.prefixLen = 0;
        }
        return this;
    }

    List<V> pushLast(V value) {
        if (this.suffix == null) {
            this.suffix = new Object[2];
        } else if (this.suffixLen == this.suffix.length) {
            Object[] newSuffix = new Object[Math.min(32, this.suffix.length << 1)];
            System.arraycopy(this.suffix, 0, newSuffix, 0, this.suffix.length);
            this.suffix = newSuffix;
        }
        byte by = this.suffixLen;
        this.suffixLen = (byte)(by + 1);
        this.suffix[by] = value;
        if (this.suffixLen == 32) {
            Object editor = this.isLinear() ? this.editor : new Object();
            this.root = this.root.pushLast(this.suffix, editor);
            this.suffix = null;
            this.suffixLen = 0;
        }
        return this;
    }

    List<V> popFirst() {
        if (this.prefixLen == 0) {
            if (this.root.size() > 0) {
                Object[] chunk = this.root.first();
                if (chunk != null) {
                    Object editor = this.isLinear() ? this.editor : new Object();
                    this.prefix = (Object[])chunk.clone();
                    this.prefixLen = (byte)this.prefix.length;
                    this.root = this.root.popFirst(editor);
                }
            } else if (this.suffixLen > 0) {
                this.suffixLen = (byte)(this.suffixLen - 1);
                System.arraycopy(this.suffix, 1, this.suffix, 0, this.suffixLen);
                this.suffix[this.suffixLen] = null;
            }
        }
        if (this.prefixLen > 0) {
            this.prefixLen = (byte)(this.prefixLen - 1);
            this.prefix[this.pIdx((int)-1)] = null;
        }
        return this;
    }

    List<V> popLast() {
        if (this.suffixLen == 0) {
            if (this.root.size() > 0) {
                Object[] chunk = this.root.last();
                if (chunk != null) {
                    Object editor = this.isLinear() ? this.editor : new Object();
                    this.suffix = (Object[])chunk.clone();
                    this.suffixLen = (byte)this.suffix.length;
                    this.root = this.root.popLast(editor);
                }
            } else if (this.prefixLen > 0) {
                this.prefixLen = (byte)(this.prefixLen - 1);
                System.arraycopy(this.prefix, this.pIdx(-1), this.prefix, this.pIdx(0), this.prefixLen);
                this.prefix[this.pIdx((int)-1)] = null;
            }
        }
        if (this.suffixLen > 0) {
            this.suffixLen = (byte)(this.suffixLen - 1);
            this.suffix[this.suffixLen] = null;
        }
        return this;
    }
}

