/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.nodes;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.Maps;
import io.lacuna.bifurcan.nodes.Util;
import io.lacuna.bifurcan.utils.Bits;
import io.lacuna.bifurcan.utils.Iterators;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;

public class IntMapNodes {
    public static int offset(long a2, long b) {
        return Bits.bitOffset(Bits.highestBit(a2 ^ b)) & 0xFFFFFFFC;
    }

    private static boolean overlap(long min0, long max0, long min1, long max1) {
        return max1 - min0 >= 0L && max0 - min1 >= 0L;
    }

    public static <V> IList<Node<V>> split(Object editor, Node<V> node, int targetSize) {
        LinearList result2 = new LinearList();
        if (node.size() >> 1 < targetSize) {
            result2.addLast(node);
        } else {
            Node acc = new Node(editor, node.prefix, node.offset);
            PrimitiveIterator.OfInt masks = Util.masks(node.datamap | node.nodemap);
            while (masks.hasNext()) {
                int mask = masks.nextInt();
                if (acc.size() >= targetSize) {
                    result2.addLast(acc);
                    acc = new Node(editor, node.prefix, node.offset);
                }
                if (((Node)node).isEntry(mask)) {
                    acc = IntMapNodes.transferEntry(mask, node, acc);
                    continue;
                }
                if (!node.isNode(mask)) continue;
                Node child = ((Node)node).node(mask);
                if (child.size() >= targetSize << 1) {
                    IntMapNodes.split(editor, child, targetSize).forEach(result2::addLast);
                    continue;
                }
                acc = acc.putNode(mask, child);
            }
            if (acc.size() > 0) {
                result2.addLast(acc);
            }
        }
        return result2;
    }

    public static <V> Node<V> merge(Object editor, Node<V> a2, Node<V> b, BinaryOperator<V> mergeFn) {
        if (a2.size() == 0) {
            return b;
        }
        if (b.size() == 0) {
            return a2;
        }
        int offsetPrime = IntMapNodes.offset(a2.prefix, b.prefix);
        if (offsetPrime > a2.offset && offsetPrime > b.offset) {
            Node<V> n = new Node<V>(editor, a2.prefix, offsetPrime);
            return IntMapNodes.merge(editor, n.putNode(((Node)n).mask(a2.prefix), a2), b, mergeFn);
        }
        if (a2.offset > b.offset) {
            int mask = ((Node)a2).mask(b.prefix);
            if (((Node)a2).isEntry(mask)) {
                int idx = ((Node)a2).entryIndex(mask);
                long key = a2.keys[idx];
                Object val = a2.content[idx];
                return ((Node)a2).clone(editor).removeEntry(mask).putNode(mask, b).put(editor, key, val, (x, y) -> mergeFn.apply(y, x));
            }
            if (a2.isNode(mask)) {
                return ((Node)a2).clone(editor).setNode(mask, IntMapNodes.merge(editor, ((Node)a2).node(mask), b, mergeFn));
            }
            return ((Node)a2).clone(editor).putNode(mask, b);
        }
        if (a2.offset < b.offset) {
            return IntMapNodes.merge(editor, b, a2, (x, y) -> mergeFn.apply(y, x));
        }
        Node<Object> result2 = new Node<Object>(editor, a2.prefix, a2.offset);
        PrimitiveIterator.OfInt masks = Util.masks(a2.datamap | a2.nodemap | b.datamap | b.nodemap);
        while (masks.hasNext()) {
            int mask = masks.nextInt();
            int state = Util.mergeState(mask, a2.nodemap, a2.datamap, b.nodemap, b.datamap);
            switch (state) {
                case 1: 
                case 4: {
                    result2 = IntMapNodes.transferNode(mask, state == 1 ? a2 : b, result2);
                    break;
                }
                case 2: 
                case 8: {
                    result2 = IntMapNodes.transferEntry(mask, state == 2 ? a2 : b, result2);
                    break;
                }
                case 10: {
                    result2 = IntMapNodes.transferEntry(mask, a2, result2);
                    int idx = ((Node)b).entryIndex(mask);
                    result2 = result2.put(editor, b.keys[idx], b.content[idx], mergeFn);
                    break;
                }
                case 5: {
                    result2 = result2.putNode(mask, IntMapNodes.merge(editor, ((Node)a2).node(mask), ((Node)b).node(mask), mergeFn));
                    break;
                }
                case 9: {
                    int idx = ((Node)b).entryIndex(mask);
                    result2 = result2.putNode(mask, ((Node)a2).node(mask)).put(editor, b.keys[idx], b.content[idx], mergeFn);
                    break;
                }
                case 6: {
                    int idx = ((Node)a2).entryIndex(mask);
                    result2 = result2.putNode(mask, ((Node)b).node(mask)).put(editor, a2.keys[idx], a2.content[idx], (x, y) -> mergeFn.apply(y, x));
                    break;
                }
            }
        }
        return result2;
    }

    public static <V> Node<V> difference(Object editor, Node<V> a2, Node<V> b) {
        int offsetPrime = IntMapNodes.offset(a2.prefix, b.prefix);
        if (offsetPrime > a2.offset && offsetPrime > b.offset) {
            return a2;
        }
        Node result2 = null;
        if (a2.offset > b.offset) {
            int mask = ((Node)a2).mask(b.prefix);
            if (((Node)a2).isEntry(mask)) {
                long key = ((Node)a2).key(mask);
                Node<V> nPrime = b.get(key, Util.DEFAULT_VALUE) == Util.DEFAULT_VALUE ? a2 : ((Node)a2).clone(editor).remove(editor, key);
                result2 = nPrime.size() == 0 ? null : nPrime;
            } else {
                Node<V> nPrime;
                result2 = a2.isNode(mask) ? ((nPrime = IntMapNodes.difference(editor, ((Node)a2).node(mask), b)) == null ? ((Node)a2).clone(editor).removeNode(mask).collapse() : ((Node)a2).clone(editor).setNode(mask, nPrime)) : a2;
            }
        } else if (a2.offset < b.offset) {
            Node<V> nPrime;
            int mask = ((Node)b).mask(a2.prefix);
            result2 = ((Node)b).isEntry(mask) ? ((nPrime = a2.remove(editor, ((Node)b).key(mask))).size() == 0 ? null : nPrime) : (b.isNode(mask) ? IntMapNodes.difference(editor, a2, ((Node)b).node(mask)) : a2);
        } else {
            result2 = new Node(editor, a2.prefix, a2.offset);
            PrimitiveIterator.OfInt masks = Util.masks(a2.datamap | a2.nodemap | b.datamap | b.nodemap);
            while (masks.hasNext()) {
                int mask = masks.nextInt();
                int state = Util.mergeState(mask, a2.nodemap, a2.datamap, b.nodemap, b.datamap);
                switch (state) {
                    case 1: {
                        result2 = IntMapNodes.transferNode(mask, a2, result2);
                        break;
                    }
                    case 2: {
                        result2 = IntMapNodes.transferEntry(mask, a2, result2);
                        break;
                    }
                    case 10: {
                        if (((Node)a2).key(mask) == ((Node)b).key(mask)) break;
                        result2 = IntMapNodes.transferEntry(mask, a2, result2);
                        break;
                    }
                    case 5: {
                        Node<V> nPrime = IntMapNodes.difference(editor, ((Node)a2).node(mask), ((Node)b).node(mask));
                        if (nPrime == null) break;
                        result2 = result2.putNode(mask, nPrime);
                        break;
                    }
                    case 9: {
                        result2 = result2.putNode(mask, ((Node)a2).node(mask).remove(editor, ((Node)b).key(mask)));
                        break;
                    }
                    case 6: {
                        if (b.get(((Node)a2).key(mask), Util.DEFAULT_VALUE) != Util.DEFAULT_VALUE) break;
                        result2 = IntMapNodes.transferEntry(mask, a2, result2);
                        break;
                    }
                }
            }
        }
        return result2 == null || result2.size() == 0 ? null : result2.collapse();
    }

    public static <V> Node<V> intersection(Object editor, Node<V> a2, Node<V> b) {
        int offsetPrime = IntMapNodes.offset(a2.prefix, b.prefix);
        if (offsetPrime > a2.offset && offsetPrime > b.offset) {
            return null;
        }
        Node<Object> result2 = null;
        if (a2.offset > b.offset) {
            int mask = ((Node)a2).mask(b.prefix);
            result2 = ((Node)a2).isEntry(mask) ? (b.get(((Node)a2).key(mask), Util.DEFAULT_VALUE) == Util.DEFAULT_VALUE ? null : IntMapNodes.transferEntry(mask, a2, new Node(editor, a2.prefix, a2.offset))) : (a2.isNode(mask) ? IntMapNodes.intersection(editor, ((Node)a2).node(mask), b) : null);
        } else if (a2.offset < b.offset) {
            long key;
            Object value;
            int mask = ((Node)b).mask(a2.prefix);
            result2 = ((Node)b).isEntry(mask) ? ((value = a2.get(key = ((Node)b).key(mask), Util.DEFAULT_VALUE)) == Util.DEFAULT_VALUE ? null : new Node<Object>(editor, a2.prefix, a2.offset).putEntry(((Node)a2).mask(key), key, value)) : (b.isNode(mask) ? IntMapNodes.intersection(editor, a2, ((Node)b).node(mask)) : null);
        } else {
            result2 = new Node<Object>(editor, a2.prefix, a2.offset);
            PrimitiveIterator.OfInt masks = Util.masks(a2.datamap | a2.nodemap | b.datamap | b.nodemap);
            while (masks.hasNext()) {
                int mask = masks.nextInt();
                int state = Util.mergeState(mask, a2.nodemap, a2.datamap, b.nodemap, b.datamap);
                switch (state) {
                    case 10: {
                        if (((Node)a2).key(mask) != ((Node)b).key(mask)) break;
                        result2 = IntMapNodes.transferEntry(mask, a2, result2);
                        break;
                    }
                    case 5: {
                        Node<V> n = IntMapNodes.intersection(editor, ((Node)a2).node(mask), ((Node)b).node(mask));
                        if (n == null) break;
                        result2 = result2.putNode(mask, n);
                        break;
                    }
                    case 9: {
                        long key = ((Node)b).key(mask);
                        Object val = a2.get(key, Util.DEFAULT_VALUE);
                        if (val == Util.DEFAULT_VALUE) break;
                        result2 = result2.putEntry(mask, key, val);
                        break;
                    }
                    case 6: {
                        if (b.get(((Node)a2).key(mask), Util.DEFAULT_VALUE) == Util.DEFAULT_VALUE) break;
                        result2 = IntMapNodes.transferEntry(mask, a2, result2);
                        break;
                    }
                }
            }
        }
        return result2 == null || result2.size() == 0 ? null : ((Node)result2).collapse();
    }

    private static <V> Node<V> transferNode(int mask, Node<V> src, Node<V> dst) {
        return dst.putNode(mask, ((Node)src).node(mask));
    }

    private static <V> Node<V> transferEntry(int mask, Node<V> src, Node<V> dst) {
        int idx = ((Node)src).entryIndex(mask);
        return dst.putEntry(mask, src.keys[idx], src.content[idx]);
    }

    public static class Node<V> {
        public static final Node POS_EMPTY = new Node(new Object(), 0L, 0);
        public static final Node NEG_EMPTY = new Node(new Object(), -1L, 0);
        public final Object editor;
        public final long prefix;
        public final int offset;
        public int datamap;
        public int nodemap;
        public int size;
        public long[] keys;
        public Object[] content;

        private Node(Object editor, long prefix, int offset2, boolean empty) {
            this.editor = editor;
            this.prefix = prefix;
            this.offset = offset2;
        }

        public Node(Object editor, long prefix, int offset2) {
            this.editor = editor;
            this.prefix = prefix;
            this.offset = offset2;
            this.keys = new long[2];
            this.content = new Object[2];
        }

        public Object get(long k, Object defaultVal) {
            Node<V> n = this;
            while (true) {
                int mask;
                if (n.isEntry(mask = n.mask(k))) {
                    int idx = n.entryIndex(mask);
                    return n.keys[idx] == k ? n.content[idx] : defaultVal;
                }
                if (!n.isNode(mask)) break;
                n = n.node(mask);
            }
            return defaultVal;
        }

        public IEntry<Long, V> nth(long idx) {
            PrimitiveIterator.OfInt masks = this.masks();
            while (masks.hasNext()) {
                int mask = masks.nextInt();
                if (this.isEntry(mask)) {
                    if (idx-- != 0L) continue;
                    int entryIdx = this.entryIndex(mask);
                    return new Maps.Entry<Long, Object>(this.keys[entryIdx], this.content[entryIdx]);
                }
                if (!this.isNode(mask)) continue;
                Node<V> node = this.node(mask);
                if (idx < (long)node.size()) {
                    return node.nth(idx);
                }
                idx -= (long)node.size();
            }
            throw new IndexOutOfBoundsException();
        }

        public long indexOf(long key) {
            int mask;
            Node<V> n = this;
            long idx = 0L;
            block0: while (n.isEntry(mask = n.mask(key)) || n.isNode(mask)) {
                PrimitiveIterator.OfInt masks = n.masks();
                while (masks.hasNext()) {
                    int m = masks.next();
                    if (mask == m) {
                        if (n.isEntry(mask)) {
                            return idx;
                        }
                        n = n.node(mask);
                        continue block0;
                    }
                    idx += n.isEntry(m) ? 1L : (long)super.node(m).size();
                }
            }
            return -1L;
        }

        public IEntry<Long, V> floor(long key) {
            if (this.min() > key) {
                return null;
            }
            PrimitiveIterator.OfInt masks = this.reverseMasks();
            while (masks.hasNext()) {
                IEntry<Long, V> entry;
                int mask = masks.next();
                if (this.isEntry(mask)) {
                    int idx = this.entryIndex(mask);
                    if (this.keys[idx] > key) continue;
                    return new Maps.Entry<Long, Object>(this.keys[idx], this.content[idx]);
                }
                if (!this.isNode(mask) || (entry = this.node(mask).floor(key)) == null) continue;
                return entry;
            }
            return null;
        }

        public IEntry<Long, V> ceil(long key) {
            if (this.max() < key) {
                return null;
            }
            PrimitiveIterator.OfInt masks = this.masks();
            while (masks.hasNext()) {
                IEntry<Long, V> entry;
                int mask = masks.next();
                if (this.isEntry(mask)) {
                    int idx = this.entryIndex(mask);
                    if (this.keys[idx] < key) continue;
                    return new Maps.Entry<Long, Object>(this.keys[idx], this.content[idx]);
                }
                if (!this.isNode(mask) || (entry = this.node(mask).ceil(key)) == null) continue;
                return entry;
            }
            return null;
        }

        public <U> Node<U> mapVals(Object editor, BiFunction<Long, V, U> f) {
            int i;
            Node<V> n = this.clone(editor);
            for (i = Integer.bitCount(n.datamap); i >= 0; --i) {
                n.content[i] = f.apply(n.keys[i], n.content[i]);
            }
            for (i = this.content.length - 1 - Integer.bitCount(n.nodemap); i < this.content.length; ++i) {
                n.content[i] = ((Node)n.content[i]).mapVals(editor, f);
            }
            return n;
        }

        public Node<V> put(Object editor, long k, V v, BinaryOperator<V> mergeFn) {
            if (editor != this.editor) {
                return this.clone(editor).put(editor, k, v, mergeFn);
            }
            int offsetPrime = IntMapNodes.offset(k, this.prefix);
            if (offsetPrime > this.offset) {
                Node<Object> n = new Node<Object>(editor, k, offsetPrime);
                switch (this.size) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        n = n.putEntry(super.mask(this.prefix), this.keys[0], this.content[0]);
                        break;
                    }
                    default: {
                        n = n.putNode(super.mask(this.prefix), this);
                    }
                }
                return n.putEntry(super.mask(k), k, v);
            }
            int mask = this.mask(k);
            if (this.isEntry(mask)) {
                int idx = this.entryIndex(mask);
                if (k == this.keys[idx]) {
                    this.content[idx] = mergeFn.apply(this.content[idx], v);
                    return this;
                }
                Node<Object> n = new Node<Object>(editor, k, IntMapNodes.offset(k, this.keys[idx]));
                n = n.putEntry(super.mask(this.keys[idx]), this.keys[idx], this.content[idx]).putEntry(super.mask(k), k, v);
                return this.removeEntry(mask).putNode(mask, n);
            }
            if (this.isNode(mask)) {
                Node<V> n = this.node(mask);
                int prevSize = n.size();
                Node<V> nPrime = n.put(editor, k, v, mergeFn);
                this.setNode(mask, nPrime);
                if (n == nPrime) {
                    this.size += nPrime.size() - prevSize;
                }
                return this;
            }
            return this.putEntry(mask, k, v);
        }

        public Node<V> remove(Object editor, long k) {
            int mask = this.mask(k);
            if ((mask & (this.nodemap | this.datamap)) == 0) {
                return this;
            }
            if (editor != this.editor) {
                return this.clone(editor).remove(editor, k);
            }
            Node<Object> result2 = null;
            if (this.isEntry(mask)) {
                int idx = this.entryIndex(mask);
                result2 = this.keys[idx] == k ? this.removeEntry(mask) : this;
            } else if (this.isNode(mask)) {
                Node<V> n = this.node(mask);
                int prevSize = n.size();
                boolean isLinear = n.editor == editor;
                Node<V> nPrime = n.remove(editor, k);
                if (isLinear) {
                    this.size -= prevSize - nPrime.size();
                }
                switch (nPrime.size()) {
                    case 0: {
                        result2 = this.removeNode(mask);
                        break;
                    }
                    case 1: {
                        result2 = this.removeNode(mask).putEntry(mask, nPrime.keys[0], nPrime.content[0]);
                        break;
                    }
                    default: {
                        result2 = this.setNode(mask, nPrime);
                    }
                }
            }
            return super.collapse();
        }

        private PrimitiveIterator.OfInt masks() {
            return Util.masks(this.nodemap | this.datamap);
        }

        private PrimitiveIterator.OfInt reverseMasks() {
            return Util.reverseMasks(this.nodemap | this.datamap);
        }

        public Iterator<IEntry<Long, V>> iterator() {
            if (this.size() == 0) {
                return Iterators.EMPTY;
            }
            return new Iterator<IEntry<Long, V>>(){
                Node<V>[] stack = new Node[16];
                byte[] cursors = new byte[32];
                int depth = 0;
                {
                    this.stack[0] = this;
                    int bits = nodemap | datamap;
                    this.cursors[0] = (byte)Util.startIndex(bits);
                    this.cursors[1] = (byte)Util.endIndex(bits);
                    this.nextValue();
                }

                private void nextValue() {
                    while (this.depth >= 0) {
                        int pos = this.depth << 1;
                        byte idx = this.cursors[pos];
                        byte limit = this.cursors[pos + 1];
                        if (idx <= limit) {
                            Node curr = this.stack[this.depth];
                            int mask = 1 << idx;
                            if (curr.isEntry(mask)) {
                                return;
                            }
                            if (curr.isNode(mask)) {
                                Node next = curr.node(mask);
                                this.stack[++this.depth] = next;
                                int bits = next.nodemap | next.datamap;
                                this.cursors[pos + 2] = (byte)Util.startIndex(bits);
                                this.cursors[pos + 3] = (byte)Util.endIndex(bits);
                                int n = pos;
                                this.cursors[n] = (byte)(this.cursors[n] + 1);
                                continue;
                            }
                            int n = pos;
                            this.cursors[n] = (byte)(this.cursors[n] + 1);
                            continue;
                        }
                        --this.depth;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.depth >= 0;
                }

                @Override
                public IEntry<Long, V> next() {
                    Node n = this.stack[this.depth];
                    int mask = 1 << this.cursors[this.depth << 1];
                    int idx = n.entryIndex(mask);
                    Maps.Entry<Long, Object> e = new Maps.Entry<Long, Object>(n.keys[idx], n.content[idx]);
                    int n2 = this.depth << 1;
                    this.cursors[n2] = (byte)(this.cursors[n2] + 1);
                    this.nextValue();
                    return e;
                }
            };
        }

        public Node<V> slice(Object editor, long min, long max) {
            if (!this.overlap(min, max)) {
                return null;
            }
            if (min <= this.min() && this.max() <= max) {
                return this;
            }
            Node<Object> n = new Node<Object>(editor, this.prefix, this.offset);
            PrimitiveIterator.OfInt masks = this.masks();
            while (masks.hasNext()) {
                Node<V> child;
                int mask = masks.nextInt();
                if (this.isEntry(mask)) {
                    int idx = this.entryIndex(mask);
                    long key = this.keys[idx];
                    if (min > key || key > max) continue;
                    n = n.put(editor, key, this.content[idx], null);
                    continue;
                }
                if (!this.isNode(mask) || (child = this.node(mask).slice(editor, min, max)) == null) continue;
                n = n.putNode(mask, child);
            }
            return n;
        }

        public int size() {
            return this.size;
        }

        public boolean equals(Node<V> n, BiPredicate<V, V> equalsFn) {
            if (n == this) {
                return true;
            }
            if (this.size == n.size && this.datamap == n.datamap && this.nodemap == n.nodemap) {
                int numEntries = Integer.bitCount(this.datamap);
                for (int i = 0; i < numEntries; ++i) {
                    if (this.keys[i] == n.keys[i] && equalsFn.test(this.content[i], n.content[i])) continue;
                    return false;
                }
                int numNodes = Integer.bitCount(this.nodemap);
                for (int i = 0; i < numNodes; ++i) {
                    Node child = (Node)this.content[this.content.length - 1 - i];
                    if (child.equals((Node)n.content[n.content.length - 1 - i], equalsFn)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private int mask(long key) {
            return 1 << (int)((key & 15L << this.offset) >>> this.offset);
        }

        private long key(int mask) {
            return this.keys[this.entryIndex(mask)];
        }

        private boolean isEntry(int mask) {
            return (this.datamap & mask) != 0;
        }

        public boolean isNode(int mask) {
            return (this.nodemap & mask) != 0;
        }

        private int entryIndex(int mask) {
            return Util.compressedIndex(this.datamap, mask);
        }

        private int nodeIndex(int mask) {
            return Util.compressedIndex(this.nodemap, mask);
        }

        private long min() {
            long mask = this.prefix;
            mask &= (this.offset == 60 ? -1L : (1L << this.offset + 4) - 1L) ^ 0xFFFFFFFFFFFFFFFFL;
            return mask |= this.prefix & Long.MIN_VALUE;
        }

        private long max() {
            long mask = this.prefix;
            mask |= this.offset == 60 ? (this.prefix < 0L ? -1L : Long.MAX_VALUE) : (1L << this.offset + 4) - 1L;
            return mask |= this.prefix & Long.MIN_VALUE;
        }

        private boolean overlap(long min, long max) {
            return IntMapNodes.overlap(min, max, this.min(), this.max());
        }

        private Node<V> node(int mask) {
            return (Node)this.content[this.content.length - 1 - this.nodeIndex(mask)];
        }

        private Node<V> clone(Object editor) {
            Node<V> n = new Node<V>(editor, this.prefix, this.offset, false);
            n.datamap = this.datamap;
            n.nodemap = this.nodemap;
            n.size = this.size;
            n.content = (Object[])this.content.clone();
            n.keys = (long[])this.keys.clone();
            return n;
        }

        private void grow() {
            if (this.content.length == 32) {
                return;
            }
            Object[] c = new Object[this.content.length << 1];
            long[] k = new long[this.keys.length << 1];
            int numNodes = Integer.bitCount(this.nodemap);
            int numEntries = Integer.bitCount(this.datamap);
            System.arraycopy(this.content, 0, c, 0, numEntries);
            System.arraycopy(this.content, this.content.length - numNodes, c, c.length - numNodes, numNodes);
            System.arraycopy(this.keys, 0, k, 0, numEntries);
            this.keys = k;
            this.content = c;
        }

        private Node<V> collapse() {
            if (this.datamap == 0 && this.nodemap > 0 && Bits.isPowerOfTwo(this.nodemap)) {
                return this.node(this.nodemap);
            }
            if (this.size() == 1) {
                long key = this.keys[0];
                Node<Object> n = new Node<Object>(this.editor, key, 0);
                return n.putEntry(super.mask(key), key, this.content[0]);
            }
            return this;
        }

        Node<V> putEntry(int mask, long key, V value) {
            int idx;
            assert (((this.datamap | this.nodemap) & mask) == 0);
            int numEntries = Integer.bitCount(this.datamap);
            int count2 = numEntries + Integer.bitCount(this.nodemap);
            if (count2 + 1 > this.content.length) {
                this.grow();
            }
            if ((idx = this.entryIndex(mask)) != numEntries) {
                System.arraycopy(this.content, idx, this.content, idx + 1, numEntries - idx);
                System.arraycopy(this.keys, idx, this.keys, idx + 1, numEntries - idx);
            }
            this.datamap |= mask;
            ++this.size;
            this.keys[idx] = key;
            this.content[idx] = value;
            return this;
        }

        Node<V> removeEntry(int mask) {
            int numEntries;
            assert ((mask & this.datamap) > 0);
            int idx = this.entryIndex(mask);
            if (idx != (numEntries = Integer.bitCount(this.datamap)) - 1) {
                System.arraycopy(this.content, idx + 1, this.content, idx, numEntries - 1 - idx);
                System.arraycopy(this.keys, idx + 1, this.keys, idx, numEntries - 1 - idx);
            }
            this.datamap &= ~mask;
            --this.size;
            this.content[numEntries - 1] = null;
            this.keys[numEntries - 1] = 0L;
            return this;
        }

        Node<V> setNode(int mask, Node<V> node) {
            assert ((this.nodemap & mask) > 0);
            int idx = this.content.length - 1 - this.nodeIndex(mask);
            this.size += node.size() - ((Node)this.content[idx]).size();
            this.content[idx] = node;
            return this;
        }

        Node<V> putNode(int mask, Node<V> node) {
            assert (((this.nodemap | this.datamap) & mask) == 0);
            assert (node.offset < this.offset);
            if (node.size() == 1) {
                return this.putEntry(mask, node.keys[0], node.content[0]);
            }
            int numNodes = Integer.bitCount(this.nodemap);
            int count2 = Integer.bitCount(this.datamap) + numNodes;
            if (count2 + 1 > this.content.length) {
                this.grow();
            }
            int idx = this.nodeIndex(mask);
            if (numNodes > 0) {
                System.arraycopy(this.content, this.content.length - numNodes, this.content, this.content.length - 1 - numNodes, numNodes - idx);
            }
            this.nodemap |= mask;
            this.size += node.size();
            this.content[this.content.length - 1 - idx] = node;
            return this;
        }

        Node<V> removeNode(int mask) {
            int idx = this.nodeIndex(mask);
            int numNodes = Integer.bitCount(this.nodemap);
            this.size -= this.node(mask).size();
            System.arraycopy(this.content, this.content.length - numNodes, this.content, this.content.length + 1 - numNodes, numNodes - 1 - idx);
            this.nodemap &= ~mask;
            this.content[this.content.length - numNodes] = null;
            return this;
        }
    }
}

