/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.LongToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class IntIterators {
    public static final PrimitiveIterator.OfInt EMPTY = new PrimitiveIterator.OfInt(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }
    };

    public static boolean equals(PrimitiveIterator.OfInt a2, PrimitiveIterator.OfInt b) {
        while (a2.hasNext()) {
            if (a2.nextInt() == b.nextInt()) continue;
            return false;
        }
        return true;
    }

    public static PrimitiveIterator.OfInt filter(final PrimitiveIterator.OfInt it, final IntPredicate f) {
        return new PrimitiveIterator.OfInt(){
            private int next = 0;
            private boolean primed = false;
            private boolean done = false;

            private void prime() {
                if (!this.primed && !this.done) {
                    while (it.hasNext()) {
                        this.next = it.nextInt();
                        if (!f.test(this.next)) continue;
                        this.primed = true;
                        return;
                    }
                    this.done = true;
                }
            }

            @Override
            public boolean hasNext() {
                this.prime();
                return !this.done;
            }

            @Override
            public int nextInt() {
                this.prime();
                if (!this.primed) {
                    throw new NoSuchElementException();
                }
                this.primed = false;
                return this.next;
            }
        };
    }

    public static PrimitiveIterator.OfInt map(final PrimitiveIterator.OfInt it, final IntUnaryOperator f) {
        return new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public int nextInt() {
                return f.applyAsInt(it.nextInt());
            }
        };
    }

    public static <U> PrimitiveIterator.OfInt flatMap(final Iterator<U> it, final Function<U, PrimitiveIterator.OfInt> f) {
        return new PrimitiveIterator.OfInt(){
            PrimitiveIterator.OfInt curr = EMPTY;

            private void prime() {
                while (!this.curr.hasNext() && it.hasNext()) {
                    this.curr = (PrimitiveIterator.OfInt)f.apply(it.next());
                }
            }

            @Override
            public boolean hasNext() {
                this.prime();
                return this.curr.hasNext();
            }

            @Override
            public int nextInt() {
                this.prime();
                return this.curr.nextInt();
            }
        };
    }

    public static PrimitiveIterator.OfInt range(final long min, final long max, final LongToIntFunction f) {
        return new PrimitiveIterator.OfInt(){
            long i;
            {
                this.i = min;
            }

            @Override
            public boolean hasNext() {
                return this.i < max;
            }

            @Override
            public int nextInt() {
                if (this.hasNext()) {
                    return f.applyAsInt(this.i++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static PrimitiveIterator.OfInt range(long max, LongToIntFunction f) {
        return IntIterators.range(0L, max, f);
    }

    public static IntStream toStream(PrimitiveIterator.OfInt it, long estimatedSize) {
        return StreamSupport.intStream(Spliterators.spliterator(it, estimatedSize, 16), false);
    }
}

