/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EGL10 {
    public static final int EGL_ALPHA_SIZE = 12321;
    public static final int EGL_BAD_ACCESS = 12290;
    public static final int EGL_BAD_ALLOC = 12291;
    public static final int EGL_BAD_ATTRIBUTE = 12292;
    public static final int EGL_BAD_CONFIG = 12293;
    public static final int EGL_BAD_CONTEXT = 12294;
    public static final int EGL_BAD_CURRENT_SURFACE = 12295;
    public static final int EGL_BAD_DISPLAY = 12296;
    public static final int EGL_BAD_MATCH = 12297;
    public static final int EGL_BAD_NATIVE_PIXMAP = 12298;
    public static final int EGL_BAD_NATIVE_WINDOW = 12299;
    public static final int EGL_BAD_PARAMETER = 12300;
    public static final int EGL_BAD_SURFACE = 12301;
    public static final int EGL_BLUE_SIZE = 12322;
    public static final int EGL_BUFFER_SIZE = 12320;
    public static final int EGL_CONFIG_CAVEAT = 12327;
    public static final int EGL_CONFIG_ID = 12328;
    public static final int EGL_CORE_NATIVE_ENGINE = 12379;
    public static final int EGL_DEPTH_SIZE = 12325;
    public static final int EGL_DONT_CARE = -1;
    public static final int EGL_DRAW = 12377;
    public static final int EGL_EXTENSIONS = 12373;
    public static final int EGL_FALSE = 0;
    public static final int EGL_GREEN_SIZE = 12323;
    public static final int EGL_HEIGHT = 12374;
    public static final int EGL_LARGEST_PBUFFER = 12376;
    public static final int EGL_LEVEL = 12329;
    public static final int EGL_MAX_PBUFFER_HEIGHT = 12330;
    public static final int EGL_MAX_PBUFFER_PIXELS = 12331;
    public static final int EGL_MAX_PBUFFER_WIDTH = 12332;
    public static final int EGL_NATIVE_RENDERABLE = 12333;
    public static final int EGL_NATIVE_VISUAL_ID = 12334;
    public static final int EGL_NATIVE_VISUAL_TYPE = 12335;
    public static final int EGL_NONE = 12344;
    public static final int EGL_NON_CONFORMANT_CONFIG = 12369;
    public static final int EGL_NOT_INITIALIZED = 12289;
    public static final int EGL_PBUFFER_BIT = 1;
    public static final int EGL_PIXMAP_BIT = 2;
    public static final int EGL_READ = 12378;
    public static final int EGL_RED_SIZE = 12324;
    public static final int EGL_SAMPLES = 12337;
    public static final int EGL_SAMPLE_BUFFERS = 12338;
    public static final int EGL_SLOW_CONFIG = 12368;
    public static final int EGL_STENCIL_SIZE = 12326;
    public static final int EGL_SUCCESS = 12288;
    public static final int EGL_SURFACE_TYPE = 12339;
    public static final int EGL_TRANSPARENT_BLUE_VALUE = 12341;
    public static final int EGL_TRANSPARENT_GREEN_VALUE = 12342;
    public static final int EGL_TRANSPARENT_RED_VALUE = 12343;
    public static final int EGL_TRANSPARENT_RGB = 12370;
    public static final int EGL_TRANSPARENT_TYPE = 12340;
    public static final int EGL_TRUE = 1;
    public static final int EGL_VENDOR = 12371;
    public static final int EGL_VERSION = 12372;
    public static final int EGL_WIDTH = 12375;
    public static final int EGL_WINDOW_BIT = 4;
    public static final long EGL_NO_CONTEXT = 0L;
    public static final long EGL_NO_DISPLAY = 0L;
    public static final long EGL_NO_SURFACE = 0L;

    protected EGL10() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglChooseConfig, caps.eglCopyBuffers, caps.eglCreateContext, caps.eglCreatePbufferSurface, caps.eglCreatePixmapSurface, caps.eglCreateWindowSurface, caps.eglDestroyContext, caps.eglDestroySurface, caps.eglGetConfigAttrib, caps.eglGetConfigs, caps.eglGetCurrentDisplay, caps.eglGetCurrentSurface, caps.eglGetDisplay, caps.eglGetError, caps.eglGetProcAddress, caps.eglInitialize, caps.eglMakeCurrent, caps.eglQueryContext, caps.eglQueryString, caps.eglQuerySurface, caps.eglSwapBuffers, caps.eglTerminate, caps.eglWaitGL, caps.eglWaitNative);
    }

    public static int neglChooseConfig(long dpy, long attrib_list, long configs, int config_size, long num_config) {
        long __functionAddress = EGL.getCapabilities().eglChooseConfig;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPPPI(dpy, attrib_list, configs, config_size, num_config, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglChooseConfig(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list, @Nullable @NativeType(value="EGLConfig *") PointerBuffer configs, @NativeType(value="EGLint *") IntBuffer num_config) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
            Checks.check((Buffer)num_config, 1);
        }
        return EGL10.neglChooseConfig(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(configs), Checks.remainingSafe(configs), MemoryUtil.memAddress(num_config)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglCopyBuffers(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surface, @NativeType(value="EGLNativePixmapType") long target2) {
        long __functionAddress = EGL.getCapabilities().eglCopyBuffers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surface);
            Checks.check(target2);
        }
        return JNI.callPPPI(dpy, surface, target2, __functionAddress) != 0;
    }

    public static long neglCreateContext(long dpy, long config, long share_context, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
        }
        return JNI.callPPPPP(dpy, config, share_context, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLContext")
    public static long eglCreateContext(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLContext") long share_context, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return EGL10.neglCreateContext(dpy, config, share_context, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePbufferSurface(long dpy, long config, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePbufferSurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
        }
        return JNI.callPPPP(dpy, config, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePbufferSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return EGL10.neglCreatePbufferSurface(dpy, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePixmapSurface(long dpy, long config, long pixmap, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePixmapSurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(pixmap);
        }
        return JNI.callPPPPP(dpy, config, pixmap, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePixmapSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLNativePixmapType") long pixmap, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return EGL10.neglCreatePixmapSurface(dpy, config, pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreateWindowSurface(long dpy, long config, long win, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(win);
        }
        return JNI.callPPPPP(dpy, config, win, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreateWindowSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLNativeWindowType") long win, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return EGL10.neglCreateWindowSurface(dpy, config, win, MemoryUtil.memAddressSafe(attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroyContext(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLContext") long ctx) {
        long __functionAddress = EGL.getCapabilities().eglDestroyContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(ctx);
        }
        return JNI.callPPI(dpy, ctx, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroySurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surface) {
        long __functionAddress = EGL.getCapabilities().eglDestroySurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surface);
        }
        return JNI.callPPI(dpy, surface, __functionAddress) != 0;
    }

    public static int neglGetConfigAttrib(long dpy, long config, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglGetConfigAttrib;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
        }
        return JNI.callPPPI(dpy, config, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetConfigAttrib(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return EGL10.neglGetConfigAttrib(dpy, config, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static int neglGetConfigs(long dpy, long configs, int config_size, long num_config) {
        long __functionAddress = EGL.getCapabilities().eglGetConfigs;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPPI(dpy, configs, config_size, num_config, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetConfigs(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLConfig *") PointerBuffer configs, @NativeType(value="EGLint *") IntBuffer num_config) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)num_config, 1);
        }
        return EGL10.neglGetConfigs(dpy, MemoryUtil.memAddressSafe(configs), Checks.remainingSafe(configs), MemoryUtil.memAddress(num_config)) != 0;
    }

    @NativeType(value="EGLDisplay")
    public static long eglGetCurrentDisplay() {
        long __functionAddress = EGL.getCapabilities().eglGetCurrentDisplay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglGetCurrentSurface(@NativeType(value="EGLint") int readdraw) {
        long __functionAddress = EGL.getCapabilities().eglGetCurrentSurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(readdraw, __functionAddress);
    }

    @NativeType(value="EGLDisplay")
    public static long eglGetDisplay(@NativeType(value="EGLNativeDisplayType") long display_id) {
        long __functionAddress = EGL.getCapabilities().eglGetDisplay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPP(display_id, __functionAddress);
    }

    @NativeType(value="EGLint")
    public static int eglGetError() {
        long __functionAddress = EGL.getCapabilities().eglGetError;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static long neglGetProcAddress(long procname) {
        long __functionAddress = EGL.getCapabilities().eglGetProcAddress;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPP(procname, __functionAddress);
    }

    @NativeType(value="__eglMustCastToProperFunctionPointerType")
    public static long eglGetProcAddress(@NativeType(value="char const *") ByteBuffer procname) {
        if (Checks.CHECKS) {
            Checks.checkNT1(procname);
        }
        return EGL10.neglGetProcAddress(MemoryUtil.memAddress(procname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="__eglMustCastToProperFunctionPointerType")
    public static long eglGetProcAddress(@NativeType(value="char const *") CharSequence procname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(procname, true);
            long procnameEncoded = stack.getPointerAddress();
            long l = EGL10.neglGetProcAddress(procnameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int neglInitialize(long dpy, long major, long minor) {
        long __functionAddress = EGL.getCapabilities().eglInitialize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPPI(dpy, major, minor, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglInitialize(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLint *") IntBuffer major, @NativeType(value="EGLint *") IntBuffer minor) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)major, 1);
            Checks.check((Buffer)minor, 1);
        }
        return EGL10.neglInitialize(dpy, MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglMakeCurrent(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long draw, @NativeType(value="EGLSurface") long read2, @NativeType(value="EGLContext") long ctx) {
        long __functionAddress = EGL.getCapabilities().eglMakeCurrent;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPPPI(dpy, draw, read2, ctx, __functionAddress) != 0;
    }

    public static int neglQueryContext(long dpy, long ctx, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(ctx);
        }
        return JNI.callPPPI(dpy, ctx, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryContext(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLContext") long ctx, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return EGL10.neglQueryContext(dpy, ctx, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static long neglQueryString(long dpy, int name) {
        long __functionAddress = EGL.getCapabilities().eglQueryString;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPP(dpy, name, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String eglQueryString(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLint") int name) {
        long __result = EGL10.neglQueryString(dpy, name);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static int neglQuerySurface(long dpy, long surface, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQuerySurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surface);
        }
        return JNI.callPPPI(dpy, surface, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQuerySurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surface, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return EGL10.neglQuerySurface(dpy, surface, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglSwapBuffers(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surface) {
        long __functionAddress = EGL.getCapabilities().eglSwapBuffers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surface);
        }
        return JNI.callPPI(dpy, surface, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglTerminate(@NativeType(value="EGLDisplay") long dpy) {
        long __functionAddress = EGL.getCapabilities().eglTerminate;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPI(dpy, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglWaitGL() {
        long __functionAddress = EGL.getCapabilities().eglWaitGL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglWaitNative(@NativeType(value="EGLint") int engine) {
        long __functionAddress = EGL.getCapabilities().eglWaitNative;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(engine, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglChooseConfig(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLint const *") int[] attrib_list, @Nullable @NativeType(value="EGLConfig *") PointerBuffer configs, @NativeType(value="EGLint *") int[] num_config) {
        long __functionAddress = EGL.getCapabilities().eglChooseConfig;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.checkNTSafe(attrib_list, 12344);
            Checks.check(num_config, 1);
        }
        return JNI.callPPPPI(dpy, attrib_list, MemoryUtil.memAddressSafe(configs), Checks.remainingSafe(configs), num_config, __functionAddress) != 0;
    }

    @NativeType(value="EGLContext")
    public static long eglCreateContext(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLContext") long share_context, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPPPP(dpy, config, share_context, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePbufferSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePbufferSurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPPP(dpy, config, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePixmapSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLNativePixmapType") long pixmap, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePixmapSurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(pixmap);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPPPP(dpy, config, pixmap, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreateWindowSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLNativeWindowType") long win, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(win);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPPPP(dpy, config, win, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetConfigAttrib(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") int[] value) {
        long __functionAddress = EGL.getCapabilities().eglGetConfigAttrib;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(value, 1);
        }
        return JNI.callPPPI(dpy, config, attribute, value, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetConfigs(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLConfig *") PointerBuffer configs, @NativeType(value="EGLint *") int[] num_config) {
        long __functionAddress = EGL.getCapabilities().eglGetConfigs;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(num_config, 1);
        }
        return JNI.callPPPI(dpy, MemoryUtil.memAddressSafe(configs), Checks.remainingSafe(configs), num_config, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglInitialize(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLint *") int[] major, @NativeType(value="EGLint *") int[] minor) {
        long __functionAddress = EGL.getCapabilities().eglInitialize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(major, 1);
            Checks.check(minor, 1);
        }
        return JNI.callPPPI(dpy, major, minor, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryContext(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLContext") long ctx, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") int[] value) {
        long __functionAddress = EGL.getCapabilities().eglQueryContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(ctx);
            Checks.check(value, 1);
        }
        return JNI.callPPPI(dpy, ctx, attribute, value, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQuerySurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surface, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") int[] value) {
        long __functionAddress = EGL.getCapabilities().eglQuerySurface;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surface);
            Checks.check(value, 1);
        }
        return JNI.callPPPI(dpy, surface, attribute, value, __functionAddress) != 0;
    }
}

