/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRStream {
    public static final long EGL_NO_STREAM_KHR = 0L;
    public static final int EGL_CONSUMER_LATENCY_USEC_KHR = 12816;
    public static final int EGL_PRODUCER_FRAME_KHR = 12818;
    public static final int EGL_CONSUMER_FRAME_KHR = 12819;
    public static final int EGL_STREAM_STATE_KHR = 12820;
    public static final int EGL_STREAM_STATE_CREATED_KHR = 12821;
    public static final int EGL_STREAM_STATE_CONNECTING_KHR = 12822;
    public static final int EGL_STREAM_STATE_EMPTY_KHR = 12823;
    public static final int EGL_STREAM_STATE_NEW_FRAME_AVAILABLE_KHR = 12824;
    public static final int EGL_STREAM_STATE_OLD_FRAME_AVAILABLE_KHR = 12825;
    public static final int EGL_STREAM_STATE_DISCONNECTED_KHR = 12826;
    public static final int EGL_BAD_STREAM_KHR = 12827;
    public static final int EGL_BAD_STATE_KHR = 12828;

    protected KHRStream() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateStreamKHR, caps.eglDestroyStreamKHR, caps.eglStreamAttribKHR, caps.eglQueryStreamKHR, caps.eglQueryStreamu64KHR);
    }

    public static long neglCreateStreamKHR(long dpy, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPP(dpy, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLStreamKHR")
    public static long eglCreateStreamKHR(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return KHRStream.neglCreateStreamKHR(dpy, MemoryUtil.memAddressSafe(attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroyStreamKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream) {
        long __functionAddress = EGL.getCapabilities().eglDestroyStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPI(dpy, stream, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamAttribKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int attribute, @NativeType(value="EGLint") int value) {
        long __functionAddress = EGL.getCapabilities().eglStreamAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPI(dpy, stream, attribute, value, __functionAddress) != 0;
    }

    public static int neglQueryStreamKHR(long dpy, long stream, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(dpy, stream, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryStreamKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int attribute, @NativeType(value="EGLint *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return KHRStream.neglQueryStreamKHR(dpy, stream, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static int neglQueryStreamu64KHR(long dpy, long stream, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamu64KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(dpy, stream, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryStreamu64KHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int attribute, @NativeType(value="EGLuint64KHR *") LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return KHRStream.neglQueryStreamu64KHR(dpy, stream, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    @NativeType(value="EGLStreamKHR")
    public static long eglCreateStreamKHR(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPP(dpy, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryStreamKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int attribute, @NativeType(value="EGLint *") int[] value) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
            Checks.check(value, 1);
        }
        return JNI.callPPPI(dpy, stream, attribute, value, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryStreamu64KHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int attribute, @NativeType(value="EGLuint64KHR *") long[] value) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamu64KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
            Checks.check(value, 1);
        }
        return JNI.callPPPI(dpy, stream, attribute, value, __functionAddress) != 0;
    }
}

