/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a/\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u000e\b\u0004\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u001a\u0006\u0010!\u001a\u00020\"\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"$\u0010\u0004\u001a\u00020\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\"(\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\r8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0007\u001a\u0004\b\u0010\u0010\u0011\"(\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\r8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0007\u001a\u0004\b\u0014\u0010\u0011\"$\u0010\u0015\u001a\u00020\u000e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0007\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"enableProfiling", "", "getEnableProfiling", "()Z", "measureName", "", "getMeasureName$annotations", "()V", "getMeasureName", "()Ljava/lang/String;", "setMeasureName", "(Ljava/lang/String;)V", "measuredHits", "", "", "getMeasuredHits$annotations", "getMeasuredHits", "()Ljava/util/Map;", "measuredTime", "getMeasuredTime$annotations", "getMeasuredTime", "profilingStart", "getProfilingStart$annotations", "getProfilingStart", "()J", "setProfilingStart", "(J)V", "measure", "T", "name", "f", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "report", "", "openrndr-core"})
public final class ProfilerToolsKt {
    private static final boolean enableProfiling;
    @NotNull
    private static final Map<String, Long> measuredTime;
    @NotNull
    private static final Map<String, Long> measuredHits;
    private static long profilingStart;
    @NotNull
    private static String measureName;

    public static final boolean getEnableProfiling() {
        return enableProfiling;
    }

    @PublishedApi
    public static /* synthetic */ void getMeasuredTime$annotations() {
    }

    @NotNull
    public static final Map<String, Long> getMeasuredTime() {
        return measuredTime;
    }

    @PublishedApi
    public static /* synthetic */ void getMeasuredHits$annotations() {
    }

    @NotNull
    public static final Map<String, Long> getMeasuredHits() {
        return measuredHits;
    }

    @PublishedApi
    public static /* synthetic */ void getProfilingStart$annotations() {
    }

    public static final long getProfilingStart() {
        return profilingStart;
    }

    public static final void setProfilingStart(long l) {
        profilingStart = l;
    }

    @PublishedApi
    public static /* synthetic */ void getMeasureName$annotations() {
    }

    @NotNull
    public static final String getMeasureName() {
        return measureName;
    }

    public static final void setMeasureName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        measureName = string;
    }

    public static final <T> T measure(@NotNull String name, @NotNull Function0<? extends T> f) {
        int $i$f$measure = 0;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(f, "f");
        return f.invoke();
    }

    public static final void report() {
        long profilingEnd = System.nanoTime();
        double profilingRuntime = (double)(profilingEnd - profilingStart) / 1000000.0;
        String string = "total runtime: " + profilingRuntime;
        boolean bl = false;
        System.out.println((Object)string);
        string = "--------------------------------------";
        bl = false;
        System.out.println((Object)string);
        for (String name : measuredTime.keySet()) {
            String spacedName;
            Long l = measuredTime.get(name);
            Intrinsics.checkNotNull(l);
            double timeMS = ((Number)l).doubleValue() / 1000000.0;
            double timePercentage = 100.0 * (timeMS / profilingRuntime);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%.2f";
            Object[] objectArray = new Object[]{timePercentage};
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), "java.lang.String.format(format, *args)");
            Long l2 = measuredTime.get(name);
            Intrinsics.checkNotNull(l2);
            double d = ((Number)l2).longValue();
            Long l3 = measuredHits.get(name);
            Intrinsics.checkNotNull(l3);
            double average = d / (double)((Number)l3).longValue() / 1000000.0;
            Object object = StringCompanionObject.INSTANCE;
            String string3 = "%-100s";
            Object[] objectArray2 = new Object[]{name};
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length)), "java.lang.String.format(format, *args)");
            StringBuilder stringBuilder = new StringBuilder().append(spacedName).append(' ');
            Long l4 = measuredTime.get(name);
            Intrinsics.checkNotNull(l4);
            object = stringBuilder.append(((Number)l4).doubleValue() / 1000000.0).append('\t').append(measuredHits.get(name)).append('\t').append(average).append("ms").toString();
            boolean bl4 = false;
            System.out.println(object);
        }
    }

    static {
        CharSequence charSequence = System.getProperty("org.openrndr.profiling");
        boolean bl = false;
        boolean bl2 = false;
        enableProfiling = !(charSequence == null || StringsKt.isBlank(charSequence));
        boolean bl3 = false;
        measuredTime = new LinkedHashMap();
        bl3 = false;
        measuredHits = new LinkedHashMap();
        profilingStart = -1L;
        measureName = "";
    }
}

