/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorHSLa;
import org.openrndr.math.MappingKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a&\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"hsl", "Lorg/openrndr/color/ColorHSLa;", "h", "", "s", "l", "hsla", "a", "hue2rgb", "p", "q", "ut", "mix", "left", "right", "x", "openrndr-color"})
public final class ColorHSLaKt {
    public static final double hue2rgb(double p, double q, double ut) {
        double t2;
        for (t2 = ut; t2 < 0.0; t2 += 1.0) {
        }
        while (t2 > 1.0) {
            t2 -= 1.0;
        }
        if (t2 < 0.16666666666666666) {
            return p + (q - p) * 6.0 * t2;
        }
        if (t2 < 0.5) {
            return q;
        }
        return t2 < 0.6666666666666666 ? p + (q - p) * (0.6666666666666666 - t2) * 6.0 : p;
    }

    @NotNull
    public static final ColorHSLa hsl(double h, double s2, double l) {
        return new ColorHSLa(h, s2, l, 0.0, 8, null);
    }

    @NotNull
    public static final ColorHSLa hsla(double h, double s2, double l, double a2) {
        return new ColorHSLa(h, s2, l, a2);
    }

    @NotNull
    public static final ColorHSLa mix(@NotNull ColorHSLa left, @NotNull ColorHSLa right, double x) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        double sx = RangesKt.coerceIn(x, 0.0, 1.0);
        return new ColorHSLa(MappingKt.mixAngle(left.getH(), right.getH(), sx), (1.0 - sx) * left.getS() + sx * right.getS(), (1.0 - sx) * left.getL() + sx * right.getL(), (1.0 - sx) * left.getA() + sx * right.getA());
    }
}

