/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXSLaKt;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.OpacifiableColor;
import org.openrndr.color.SaturatableColor;
import org.openrndr.color.ShadableColor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 -2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\b\u0012\u0004\u0012\u00020\u00000\u0006:\u0001-B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\bH\u0016J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\bH\u0096\u0002J\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020*H\u0016J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006."}, d2={"Lorg/openrndr/color/ColorXSLa;", "Lorg/openrndr/color/ConvertibleToColorRGBa;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/SaturatableColor;", "Lorg/openrndr/color/OpacifiableColor;", "Lorg/openrndr/color/AlgebraicColor;", "x", "", "s", "l", "a", "(DDDD)V", "getA", "()D", "getL", "getS", "getX", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "minus", "mix", "factor", "opacify", "plus", "saturate", "shade", "shiftHue", "shiftInDegrees", "times", "toHSLa", "Lorg/openrndr/color/ColorHSLa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "Companion", "openrndr-color"})
public final class ColorXSLa
implements ConvertibleToColorRGBa,
ShadableColor<ColorXSLa>,
HueShiftableColor<ColorXSLa>,
SaturatableColor<ColorXSLa>,
OpacifiableColor<ColorXSLa>,
AlgebraicColor<ColorXSLa> {
    private final double x;
    private final double s;
    private final double l;
    private final double a;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ColorHSLa toHSLa() {
        double x = this.x % 360.0;
        double h = 0.0 <= x && x < 60.0 ? ColorXSLaKt.access$map(x, 0.0, 60.0, 0.0, 35.0) : (60.0 <= x && x < 120.0 ? ColorXSLaKt.access$map(x, 60.0, 120.0, 35.0, 60.0) : (120.0 <= x && x < 180.0 ? ColorXSLaKt.access$map(x, 120.0, 180.0, 60.0, 135.0) : (180.0 <= x && x < 240.0 ? ColorXSLaKt.access$map(x, 180.0, 240.0, 135.0, 225.0) : (240.0 <= x && x < 300.0 ? ColorXSLaKt.access$map(x, 240.0, 300.0, 225.0, 275.0) : ColorXSLaKt.access$map(x, 300.0, 360.0, 276.0, 360.0)))));
        return new ColorHSLa(h, this.s, this.l, this.a);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toHSLa().toRGBa();
    }

    @Override
    @NotNull
    public ColorXSLa shiftHue(double shiftInDegrees) {
        return ColorXSLa.copy$default(this, this.x + shiftInDegrees, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorXSLa saturate(double factor) {
        return ColorXSLa.copy$default(this, 0.0, this.s * factor, 0.0, 0.0, 13, null);
    }

    @Override
    @NotNull
    public ColorXSLa shade(double factor) {
        return ColorXSLa.copy$default(this, 0.0, 0.0, this.l * factor, 0.0, 11, null);
    }

    @Override
    @NotNull
    public ColorXSLa opacify(double factor) {
        return ColorXSLa.copy$default(this, 0.0, 0.0, 0.0, this.a * factor, 7, null);
    }

    @Override
    @NotNull
    public ColorXSLa plus(@NotNull ColorXSLa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.copy(this.x + other.x, this.s + other.s, this.l + other.l, this.a + other.a);
    }

    @Override
    @NotNull
    public ColorXSLa minus(@NotNull ColorXSLa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.copy(this.x - other.x, this.s - other.s, this.l - other.l, this.a - other.a);
    }

    @Override
    @NotNull
    public ColorXSLa times(double factor) {
        return this.copy(this.x * factor, this.s * factor, this.l * factor, this.a * factor);
    }

    @Override
    @NotNull
    public ColorXSLa mix(@NotNull ColorXSLa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorXSLaKt.mix(this, other, factor);
    }

    public final double getX() {
        return this.x;
    }

    public final double getS() {
        return this.s;
    }

    public final double getL() {
        return this.l;
    }

    public final double getA() {
        return this.a;
    }

    public ColorXSLa(double x, double s2, double l, double a2) {
        this.x = x;
        this.s = s2;
        this.l = l;
        this.a = a2;
    }

    @Override
    @NotNull
    public ColorXSLa div(double factor) {
        return AlgebraicColor.DefaultImpls.div(this, factor);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.l;
    }

    public final double component4() {
        return this.a;
    }

    @NotNull
    public final ColorXSLa copy(double x, double s2, double l, double a2) {
        return new ColorXSLa(x, s2, l, a2);
    }

    public static /* synthetic */ ColorXSLa copy$default(ColorXSLa colorXSLa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorXSLa.x;
        }
        if ((n & 2) != 0) {
            d2 = colorXSLa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorXSLa.l;
        }
        if ((n & 8) != 0) {
            d4 = colorXSLa.a;
        }
        return colorXSLa.copy(d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "ColorXSLa(x=" + this.x + ", s=" + this.s + ", l=" + this.l + ", a=" + this.a + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.s);
        long l3 = Double.doubleToLongBits(this.l);
        long l4 = Double.doubleToLongBits(this.a);
        return (((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorXSLa)) break block3;
                ColorXSLa colorXSLa = (ColorXSLa)object;
                if (Double.compare(this.x, colorXSLa.x) != 0 || Double.compare(this.s, colorXSLa.s) != 0 || Double.compare(this.l, colorXSLa.l) != 0 || Double.compare(this.a, colorXSLa.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/color/ColorXSLa$Companion;", "", "()V", "fromHSLa", "Lorg/openrndr/color/ColorXSLa;", "hsla", "Lorg/openrndr/color/ColorHSLa;", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorXSLa fromHSLa(@NotNull ColorHSLa hsla) {
            Intrinsics.checkNotNullParameter(hsla, "hsla");
            double h = (hsla.getH() % 360.0 + 360.0) % 360.0;
            double x = 0.0 <= h && h < (double)35 ? ColorXSLaKt.access$map(h, 0.0, 35.0, 0.0, 60.0) : ((double)35 <= h && h < (double)60 ? ColorXSLaKt.access$map(h, 35.0, 60.0, 60.0, 120.0) : ((double)60 <= h && h < 135.0 ? ColorXSLaKt.access$map(h, 60.0, 135.0, 120.0, 180.0) : (135.0 <= h && h < 225.0 ? ColorXSLaKt.access$map(h, 135.0, 225.0, 180.0, 240.0) : (225.0 <= h && h < 275.0 ? ColorXSLaKt.access$map(h, 225.0, 275.0, 240.0, 300.0) : ColorXSLaKt.access$map(h, 276.0, 360.0, 300.0, 360.0)))));
            return new ColorXSLa(x, hsla.getS(), hsla.getL(), hsla.getA());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

