/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.draw.Session;
import org.openrndr.internal.Driver;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001aT\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00032\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a&\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a$\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a&\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0019"}, d2={"colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "width", "", "height", "contentScale", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "levels", "session", "Lorg/openrndr/draw/Session;", "loadImage", "file", "Ljava/io/File;", "formatHint", "Lorg/openrndr/draw/ImageFileFormat;", "url", "Ljava/net/URL;", "fileOrUrl", "", "openrndr-core"})
public final class ColorBufferKt {
    @NotNull
    public static final ColorBuffer colorBuffer(int width, int height, double contentScale, @NotNull ColorFormat format, @NotNull ColorType type2, @NotNull BufferMultisample multisample, int levels2, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(multisample, "multisample");
        return Driver.Companion.getInstance().createColorBuffer(width, height, contentScale, format, type2, multisample, levels2, session);
    }

    public static /* synthetic */ ColorBuffer colorBuffer$default(int n, int n2, double d, ColorFormat colorFormat, ColorType colorType, BufferMultisample bufferMultisample, int n3, Session session, int n4, Object object) {
        if ((n4 & 4) != 0) {
            d = 1.0;
        }
        if ((n4 & 8) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n4 & 0x10) != 0) {
            colorType = ColorType.UINT8;
        }
        if ((n4 & 0x20) != 0) {
            bufferMultisample = BufferMultisample.Disabled.INSTANCE;
        }
        if ((n4 & 0x40) != 0) {
            n3 = 1;
        }
        if ((n4 & 0x80) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferKt.colorBuffer(n, n2, d, colorFormat, colorType, bufferMultisample, n3, session);
    }

    @NotNull
    public static final ColorBuffer loadImage(@NotNull String fileOrUrl, @Nullable ImageFileFormat formatHint, @Nullable Session session) {
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        try {
            if (!StringsKt.startsWith$default(fileOrUrl, "data:", false, 2, null)) {
                new URL(fileOrUrl);
            }
            colorBuffer = ColorBuffer.Companion.fromUrl(fileOrUrl, formatHint, session);
        }
        catch (MalformedURLException e) {
            colorBuffer = ColorBufferKt.loadImage(new File(fileOrUrl), formatHint, session);
        }
        return colorBuffer;
    }

    public static /* synthetic */ ColorBuffer loadImage$default(String string, ImageFileFormat imageFileFormat, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            imageFileFormat = null;
        }
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferKt.loadImage(string, imageFileFormat, session);
    }

    @NotNull
    public static final ColorBuffer loadImage(@NotNull File file, @Nullable ImageFileFormat formatHint, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(file, "file");
        boolean bl = file.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "failed to load image: file '" + file.getAbsolutePath() + "' does not exist.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return ColorBuffer.Companion.fromFile(file, formatHint, session);
    }

    public static /* synthetic */ ColorBuffer loadImage$default(File file, ImageFileFormat imageFileFormat, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            imageFileFormat = null;
        }
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferKt.loadImage(file, imageFileFormat, session);
    }

    @NotNull
    public static final ColorBuffer loadImage(@NotNull URL url, @Nullable ImageFileFormat formatHint, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(url, "url");
        String string = url.toExternalForm();
        Intrinsics.checkNotNullExpressionValue(string, "url.toExternalForm()");
        return ColorBuffer.Companion.fromUrl(string, formatHint, session);
    }

    public static /* synthetic */ ColorBuffer loadImage$default(URL uRL, ImageFileFormat imageFileFormat, Session session, int n, Object object) {
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferKt.loadImage(uRL, imageFileFormat, session);
    }
}

