/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.exceptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.openrndr.exceptions.ExceptionSanitizerKt;
import org.openrndr.exceptions.SanitizingUncaughtExceptionHandler;
import org.openrndr.platform.Platform;
import org.openrndr.platform.PlatformType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u001a\b\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0006\u0010\u0010\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"logger", "Lmu/KLogger;", "cleanClassName", "", "name", "cleanMethodName", "color", "r", "", "g", "b", "colorReset", "findUserCause", "", "throwable", "", "installUncaughtExceptionHandler", "openrndr-core"})
public final class ExceptionSanitizerKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger("");

    public static final void installUncaughtExceptionHandler() {
        if (Platform.INSTANCE.getType() != PlatformType.WINDOWS) {
            System.err.print(ExceptionSanitizerKt.color(127, 127, 127));
            if (Intrinsics.areEqual(System.getProperty("org.openrndr.exceptions"), "JVM") ^ true) {
                Thread.setDefaultUncaughtExceptionHandler(new SanitizingUncaughtExceptionHandler());
            }
        }
    }

    private static final String color(int r, int g, int b) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "\u001b[38;2;%d;%d;%dm";
        Object[] objectArray = new Object[]{r, g, b};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(format, *args)");
        return string2;
    }

    private static final String colorReset() {
        return "\u001b[0m";
    }

    private static final String cleanClassName(String name) {
        CharSequence charSequence = StringsKt.replace$default(name, "Kt$", ".", false, 4, null);
        Regex regex = new Regex("\\$[0-9]+");
        String string = ".{ }";
        boolean bl = false;
        return StringsKt.replace$default(regex.replace(charSequence, string), "$", ".", false, 4, null);
    }

    private static final String cleanMethodName(String name) {
        return Intrinsics.areEqual(name, "invoke") ? ".{ }" : '.' + name;
    }

    /*
     * WARNING - void declaration
     */
    public static final void findUserCause(@NotNull Throwable throwable) {
        int n;
        block15: {
            Intrinsics.checkNotNullParameter(throwable, "throwable");
            logger.info("Set -Dorg.openrndr.exceptions=JVM for conventional exception-handling");
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "throwable.stackTrace");
            List<StackTraceElement> $this$indexOfLast$iv = ArraysKt.reversed(stackTraceElementArray);
            boolean $i$f$indexOfLast = false;
            ListIterator<StackTraceElement> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                StackTraceElement it = iterator$iv.previous();
                boolean bl = false;
                StackTraceElement stackTraceElement = it;
                Intrinsics.checkNotNullExpressionValue(stackTraceElement, "it");
                String string = stackTraceElement.getClassName();
                Intrinsics.checkNotNullExpressionValue(string, "it.className");
                if (!(!StringsKt.contains$default((CharSequence)string, "org.openrndr", false, 2, null))) continue;
                n = iterator$iv.nextIndex();
                break block15;
            }
            n = -1;
        }
        int bestSolution = n;
        System.err.println();
        System.err.println();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "throwable.stackTrace");
        Iterable $this$forEachIndexed$iv = ArraysKt.reversed(stackTraceElementArray);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n2 = index$iv++;
            boolean bl = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            StackTraceElement stackTraceElement = (StackTraceElement)item$iv;
            int index = n2;
            boolean bl2 = false;
            throwable.getStackTrace();
            void v5 = it;
            Intrinsics.checkNotNullExpressionValue(v5, "it");
            String string = v5.getClassName();
            Intrinsics.checkNotNullExpressionValue(string, "it.className");
            List parts = StringsKt.split$default((CharSequence)string, new String[]{"$"}, false, 0, 6, null);
            String query = (String)parts.get(0);
            boolean bl3 = false;
            List lambdaReceiverTypes = new ArrayList();
            for (String part : CollectionsKt.drop(parts, 1)) {
                query = query + '$' + part;
                try {
                    void $this$mapTo$iv$iv;
                    String it2;
                    Iterable $this$filterTo$iv$iv;
                    Metadata annotation;
                    Class<?> cl = Class.forName(query);
                    if (cl == null) continue;
                    Class<?> clazz = cl.getSuperclass();
                    Intrinsics.checkNotNullExpressionValue(clazz, "cl.superclass");
                    if (!Intrinsics.areEqual(clazz.getTypeName(), "kotlin.jvm.internal.Lambda") || (annotation = cl.getAnnotation(Metadata.class)) == null) continue;
                    Iterable $this$filter$iv = StringsKt.split$default((CharSequence)annotation.d2()[2], new String[]{";"}, false, 0, 6, null);
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it2 = (String)element$iv$iv;
                        boolean bl4 = false;
                        CharSequence charSequence = it2;
                        boolean bl5 = false;
                        if (!(!StringsKt.isBlank(charSequence))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        it2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl6 = false;
                        String string2 = (String)CollectionsKt.last(StringsKt.split$default((CharSequence)it3, new String[]{"/"}, false, 0, 6, null));
                        collection.add(string2);
                    }
                    String types = CollectionsKt.joinToString$default((List)destination$iv$iv, ", ", null, null, 0, null, null, 62, null);
                    lambdaReceiverTypes.add(types);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            String string2 = it.getClassName();
            Intrinsics.checkNotNullExpressionValue(string2, "it.className");
            String filledName = ExceptionSanitizerKt.cleanClassName(string2);
            for (String receiver : lambdaReceiverTypes) {
                filledName = StringsKt.replaceFirst$default(filledName, "{ }", "{ :" + receiver + " }", false, 4, null);
            }
            StringBuilder stringBuilder = new StringBuilder().append(filledName);
            String string3 = it.getMethodName();
            Intrinsics.checkNotNullExpressionValue(string3, "it.methodName");
            String cleanName = stringBuilder.append(ExceptionSanitizerKt.cleanMethodName(string3)).toString();
            String string4 = it.getClassName();
            Intrinsics.checkNotNullExpressionValue(string4, "it.className");
            if (!StringsKt.contains$default((CharSequence)string4, "org.openrndr", false, 2, null) && it.getLineNumber() >= 0) {
                if (index == bestSolution) {
                    System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u251c\u2500 " + ExceptionSanitizerKt.color(255, 192, 203) + cleanName + '(' + it.getFileName() + ':' + it.getLineNumber() + ')' + ExceptionSanitizerKt.colorReset());
                    continue;
                }
                System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u251c\u2500 " + ExceptionSanitizerKt.color(127, 127, 127) + cleanName + '(' + it.getFileName() + ':' + it.getLineNumber() + ')' + ExceptionSanitizerKt.colorReset());
                continue;
            }
            System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u2502  " + ExceptionSanitizerKt.color(79, 79, 79) + cleanName + '(' + it.getFileName() + ':' + it.getLineNumber() + ')' + ExceptionSanitizerKt.colorReset());
        }
        System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + '\u2502' + ExceptionSanitizerKt.colorReset());
        System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u2191 " + ExceptionSanitizerKt.color(255, 192, 203) + throwable.getMessage() + " (" + Reflection.getOrCreateKotlinClass(throwable.getClass()).getSimpleName() + ')' + ExceptionSanitizerKt.colorReset() + ' ');
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            StackTraceElement line;
            StackTraceElement[] stackTraceElementArray2 = cause.getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray2, "cause.stackTrace");
            StackTraceElement stackTraceElement = line = ArraysKt.first(stackTraceElementArray2);
            Intrinsics.checkNotNullExpressionValue(stackTraceElement, "line");
            String string = stackTraceElement.getClassName();
            Intrinsics.checkNotNullExpressionValue(string, "line.className");
            String filledName = ExceptionSanitizerKt.cleanClassName(string);
            StringBuilder stringBuilder = new StringBuilder().append(filledName);
            String string5 = line.getMethodName();
            Intrinsics.checkNotNullExpressionValue(string5, "line.methodName");
            String cleanName = stringBuilder.append(ExceptionSanitizerKt.cleanMethodName(string5)).toString();
            System.err.println(ExceptionSanitizerKt.color(127, 127, 127) + "\u251c\u2500 " + ExceptionSanitizerKt.color(127, 127, 127) + cleanName + '(' + line.getFileName() + ':' + line.getLineNumber() + ')' + ExceptionSanitizerKt.colorReset());
        }
        if (throwable instanceof NoSuchMethodError || throwable instanceof ClassNotFoundException) {
            String string = throwable.getMessage();
            if (string != null) {
                if (StringsKt.contains$default((CharSequence)string, "org.openrndr", false, 2, null)) {
                    System.err.println();
                    logger.error(findUserCause.2.INSTANCE);
                }
            }
        }
    }
}

