/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.ffmpeg;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.ffmpeg.VideoWriterProfile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0016\u00a2\u0006\u0002\u0010#J\u0015\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010+J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\u0017R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\u0017R\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010'\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0006\"\u0004\b)\u0010\u0017\u00a8\u0006-"}, d2={"Lorg/openrndr/ffmpeg/MP4Profile;", "Lorg/openrndr/ffmpeg/VideoWriterProfile;", "()V", "CODEC_H264_NVENC", "", "getCODEC_H264_NVENC", "()Ljava/lang/String;", "CODEC_LIBX264", "getCODEC_LIBX264", "constantRateFactor", "", "Ljava/lang/Integer;", "fileExtension", "getFileExtension", "highPrecisionChroma", "", "getHighPrecisionChroma", "()Z", "setHighPrecisionChroma", "(Z)V", "hwaccel", "getHwaccel", "setHwaccel", "(Ljava/lang/String;)V", "mode", "Lorg/openrndr/ffmpeg/MP4Profile$WriterMode;", "pixelFormat", "getPixelFormat", "setPixelFormat", "preset", "getPreset", "setPreset", "userArguments", "", "getUserArguments", "()[Ljava/lang/String;", "setUserArguments", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "videoCodec", "getVideoCodec", "setVideoCodec", "arguments", "(Ljava/lang/Integer;)Lorg/openrndr/ffmpeg/MP4Profile;", "WriterMode", "openrndr-ffmpeg"})
public final class MP4Profile
extends VideoWriterProfile {
    private WriterMode mode = WriterMode.Normal;
    private Integer constantRateFactor = null;
    @NotNull
    private final String fileExtension;
    private boolean highPrecisionChroma = true;
    @NotNull
    private final String CODEC_LIBX264;
    @NotNull
    private final String CODEC_H264_NVENC;
    @Nullable
    private String videoCodec = this.CODEC_LIBX264;
    @Nullable
    private String hwaccel = null;
    @Nullable
    private String preset = null;
    @Nullable
    private String pixelFormat = "yuv420p";
    @NotNull
    private String[] userArguments = new String[0];

    @Override
    @NotNull
    public String getFileExtension() {
        return this.fileExtension;
    }

    @NotNull
    public final MP4Profile mode(@NotNull WriterMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        this.mode = mode;
        return this;
    }

    @NotNull
    public final MP4Profile constantRateFactor(@Nullable Integer constantRateFactor) {
        this.constantRateFactor = constantRateFactor;
        return this;
    }

    public final boolean getHighPrecisionChroma() {
        return this.highPrecisionChroma;
    }

    public final void setHighPrecisionChroma(boolean bl) {
        this.highPrecisionChroma = bl;
    }

    @NotNull
    public final String getCODEC_LIBX264() {
        return this.CODEC_LIBX264;
    }

    @NotNull
    public final String getCODEC_H264_NVENC() {
        return this.CODEC_H264_NVENC;
    }

    @Nullable
    public final String getVideoCodec() {
        return this.videoCodec;
    }

    public final void setVideoCodec(@Nullable String string) {
        this.videoCodec = string;
    }

    @Nullable
    public final String getHwaccel() {
        return this.hwaccel;
    }

    public final void setHwaccel(@Nullable String string) {
        this.hwaccel = string;
    }

    @Nullable
    public final String getPreset() {
        return this.preset;
    }

    public final void setPreset(@Nullable String string) {
        this.preset = string;
    }

    @Nullable
    public final String getPixelFormat() {
        return this.pixelFormat;
    }

    public final void setPixelFormat(@Nullable String string) {
        this.pixelFormat = string;
    }

    @NotNull
    public final String[] getUserArguments() {
        return this.userArguments;
    }

    public final void setUserArguments(@NotNull String[] stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "<set-?>");
        this.userArguments = stringArray;
    }

    @Override
    @NotNull
    public String[] arguments() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        int it;
        String[] stringArray4;
        String[] stringArray5;
        boolean bl;
        String[] chromaArguments;
        String[] stringArray6;
        boolean bl2 = false;
        List filters = new ArrayList();
        filters.add("vflip");
        if (this.highPrecisionChroma) {
            String[] stringArray7 = new String[10];
            stringArray7[0] = "-sws_flags";
            stringArray7[1] = "spline+accurate_rnd+full_chroma_int";
            stringArray7[2] = "-color_range";
            stringArray7[3] = "1";
            stringArray7[4] = "-colorspace";
            stringArray7[5] = "1";
            stringArray7[6] = "-color_primaries";
            stringArray7[7] = "1";
            stringArray7[8] = "-color_trc";
            stringArray6 = stringArray7;
            stringArray7[9] = "1";
        } else {
            stringArray6 = chromaArguments = new String[]{};
        }
        if (this.highPrecisionChroma) {
            filters.add("colorspace=bt709:iall=bt601-6-625:fast=1");
        }
        String string = this.hwaccel;
        if (string != null) {
            String string2 = string;
            boolean bl3 = false;
            bl = false;
            String it2 = string2;
            boolean bl4 = false;
            String[] stringArray8 = new String[2];
            stringArray8[0] = "-hwaccel";
            stringArray5 = stringArray8;
            stringArray8[1] = it2;
        } else {
            stringArray5 = new String[]{};
        }
        String[] hwaccelArguments = stringArray5;
        String string3 = this.pixelFormat;
        if (string3 != null) {
            String string4 = string3;
            bl = false;
            boolean it2 = false;
            String it3 = string4;
            boolean bl5 = false;
            String[] stringArray9 = new String[2];
            stringArray9[0] = "-pix_fmt";
            stringArray4 = stringArray9;
            stringArray9[1] = it3;
        } else {
            stringArray4 = new String[]{};
        }
        String[] pixelFormatArguments = stringArray4;
        Integer n = this.constantRateFactor;
        if (n != null) {
            Integer n2 = n;
            boolean it2 = false;
            boolean it3 = false;
            it = ((Number)n2).intValue();
            boolean bl6 = false;
            String[] stringArray10 = new String[2];
            stringArray10[0] = "-crf";
            stringArray3 = stringArray10;
            stringArray10[1] = String.valueOf(it);
        } else {
            stringArray3 = new String[]{};
        }
        String[] constantRateArguments = stringArray3;
        String string5 = this.preset;
        if (string5 != null) {
            String it2 = string5;
            boolean it3 = false;
            it = 0;
            String it4 = it2;
            boolean bl7 = false;
            String[] stringArray11 = new String[2];
            stringArray11[0] = "-preset";
            stringArray2 = stringArray11;
            stringArray11[1] = it4;
        } else {
            stringArray2 = new String[]{};
        }
        String[] presetArguments = stringArray2;
        String string6 = this.videoCodec;
        if (string6 != null) {
            String it3 = string6;
            it = 0;
            boolean bl8 = false;
            String it5 = it3;
            boolean bl9 = false;
            String[] stringArray12 = new String[2];
            stringArray12[0] = "-vcodec";
            stringArray = stringArray12;
            stringArray12[1] = it5;
        } else {
            stringArray = new String[]{};
        }
        String[] videoCodecArguments = stringArray;
        String[] filterArguments = new String[]{"-vf", CollectionsKt.joinToString$default(filters, ",", null, null, 0, null, null, 62, null)};
        String[] arguments2 = ArraysKt.plus(ArraysKt.plus(ArraysKt.plus(ArraysKt.plus(ArraysKt.plus(ArraysKt.plus(ArraysKt.plus(hwaccelArguments, pixelFormatArguments), chromaArguments), filterArguments), videoCodecArguments), constantRateArguments), presetArguments), this.userArguments);
        return arguments2;
    }

    public MP4Profile() {
        this.fileExtension = "mp4";
        this.CODEC_LIBX264 = "libx264";
        this.CODEC_H264_NVENC = "h264_nvenc";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/openrndr/ffmpeg/MP4Profile$WriterMode;", "", "(Ljava/lang/String;I)V", "Normal", "Lossless", "openrndr-ffmpeg"})
    public static final class WriterMode
    extends Enum<WriterMode> {
        public static final /* enum */ WriterMode Normal;
        public static final /* enum */ WriterMode Lossless;
        private static final /* synthetic */ WriterMode[] $VALUES;

        static {
            WriterMode[] writerModeArray = new WriterMode[2];
            WriterMode[] writerModeArray2 = writerModeArray;
            writerModeArray[0] = Normal = new WriterMode();
            writerModeArray[1] = Lossless = new WriterMode();
            $VALUES = writerModeArray;
        }

        public static WriterMode[] values() {
            return (WriterMode[])$VALUES.clone();
        }

        public static WriterMode valueOf(String string) {
            return Enum.valueOf(WriterMode.class, string);
        }
    }
}

