/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.ffmpeg;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.ffmpeg.MP4Profile;
import org.openrndr.ffmpeg.VideoWriter;
import org.openrndr.ffmpeg.VideoWriterKt;
import org.openrndr.ffmpeg.VideoWriterProfile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/openrndr/ffmpeg/VideoWriter;", "", "()V", "channel", "Ljava/nio/channels/WritableByteChannel;", "ffmpeg", "Ljava/lang/Process;", "ffmpegOutput", "Ljava/io/File;", "getFfmpegOutput$openrndr_ffmpeg", "()Ljava/io/File;", "setFfmpegOutput$openrndr_ffmpeg", "(Ljava/io/File;)V", "filename", "", "frameBuffer", "Ljava/nio/ByteBuffer;", "frameRate", "", "height", "inputFormat", "getInputFormat", "()Ljava/lang/String;", "setInputFormat", "(Ljava/lang/String;)V", "movieStream", "Ljava/io/OutputStream;", "profile", "Lorg/openrndr/ffmpeg/VideoWriterProfile;", "stopped", "", "width", "frame", "Lorg/openrndr/draw/ColorBuffer;", "output", "size", "start", "stop", "Companion", "openrndr-ffmpeg"})
public final class VideoWriter {
    @NotNull
    private File ffmpegOutput = new File("ffmpegOutput.txt");
    private boolean stopped;
    private int frameRate = 25;
    private int width = -1;
    private int height = -1;
    private String filename = "openrndr.mp4";
    private ByteBuffer frameBuffer;
    private WritableByteChannel channel;
    private Process ffmpeg;
    private OutputStream movieStream;
    private VideoWriterProfile profile = new MP4Profile();
    @NotNull
    private String inputFormat = "rgba";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final File getFfmpegOutput$openrndr_ffmpeg() {
        return this.ffmpegOutput;
    }

    public final void setFfmpegOutput$openrndr_ffmpeg(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "<set-?>");
        this.ffmpegOutput = file;
    }

    @NotNull
    public final String getInputFormat() {
        return this.inputFormat;
    }

    public final void setInputFormat(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.inputFormat = string;
    }

    @NotNull
    public final VideoWriter profile(@NotNull VideoWriterProfile profile) {
        Intrinsics.checkNotNullParameter(profile, "profile");
        this.profile = profile;
        return this;
    }

    public final int width() {
        return this.width;
    }

    public final int height() {
        return this.height;
    }

    @NotNull
    public final VideoWriter size(int width, int height) {
        if (width % 2 != 0 || height % 2 != 0) {
            throw (Throwable)new IllegalArgumentException("width (" + width + ") and height (" + height + ") should be divisible by 2");
        }
        this.width = width;
        this.height = height;
        return this;
    }

    @NotNull
    public final VideoWriter output(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        this.filename = filename;
        return this;
    }

    @NotNull
    public final VideoWriter frameRate(int frameRate) {
        this.frameRate = frameRate;
        return this;
    }

    @NotNull
    public final VideoWriter start() {
        ByteBuffer byteBuffer;
        String finalFilename;
        VideoWriterKt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(this){
            final /* synthetic */ VideoWriter this$0;

            @Nullable
            public final Object invoke() {
                return "starting video writer with " + VideoWriter.access$getWidth$p(this.this$0) + " x " + VideoWriter.access$getHeight$p(this.this$0) + " output using " + this.this$0.getInputFormat() + " writing to " + VideoWriter.access$getFilename$p(this.this$0);
            }
            {
                this.this$0 = videoWriter;
                super(0);
            }
        });
        File file = new File(this.filename);
        String string = finalFilename = Intrinsics.areEqual(FilesKt.getExtension(file), this.profile.getFileExtension()) ^ true ? VideoWriterKt.getFileWithoutExtension(file) + '.' + this.profile.getFileExtension() : this.filename;
        if (this.width <= 0) {
            throw (Throwable)new RuntimeException("invalid width or width not set " + this.width);
        }
        if (this.height <= 0) {
            throw (Throwable)new RuntimeException("invalid height or height not set " + this.height);
        }
        switch (this.inputFormat) {
            case "rgba": {
                ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(this.width * this.height * 4);
                byteBuffer = byteBuffer2;
                Intrinsics.checkNotNullExpressionValue(byteBuffer2, "BufferUtils.createByteBuffer(width * height * 4)");
                break;
            }
            case "rgba64le": {
                ByteBuffer byteBuffer3 = BufferUtils.createByteBuffer(this.width * this.height * 8);
                byteBuffer = byteBuffer3;
                Intrinsics.checkNotNullExpressionValue(byteBuffer3, "BufferUtils.createByteBuffer(width * height * 8)");
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported format " + this.inputFormat);
            }
        }
        this.frameBuffer = byteBuffer;
        String[] stringArray = new String[13];
        stringArray[0] = "-y";
        stringArray[1] = "-f";
        stringArray[2] = "rawvideo";
        stringArray[3] = "-vcodec";
        stringArray[4] = "rawvideo";
        stringArray[5] = "-s";
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%dx%d";
        Object[] objectArray = new Object[]{this.width, this.height};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
        stringArray[6] = string3;
        stringArray[7] = "-pix_fmt";
        stringArray[8] = this.inputFormat;
        stringArray[9] = "-r";
        stringArray[10] = "" + this.frameRate;
        stringArray[11] = "-i";
        stringArray[12] = "-";
        String[] preamble = stringArray;
        String[] codec = this.profile.arguments();
        ArrayList<String> arguments2 = new ArrayList<String>();
        String string4 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string4, "System.getProperty(\"os.name\")");
        if (StringsKt.contains$default((CharSequence)string4, "Windows", false, 2, null)) {
            arguments2.add("ffmpeg.exe");
        } else {
            arguments2.add("ffmpeg");
        }
        arguments2.addAll((Collection)CollectionsKt.listOf(Arrays.copyOf(preamble, preamble.length)));
        arguments2.addAll((Collection)CollectionsKt.listOf(Arrays.copyOf(codec, codec.length)));
        arguments2.add(finalFilename);
        VideoWriterKt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(arguments2){
            final /* synthetic */ ArrayList $arguments;

            @Nullable
            public final Object invoke() {
                return "using arguments: " + CollectionsKt.joinToString$default(this.$arguments, null, null, null, 0, null, null, 63, null);
            }
            {
                this.$arguments = arrayList;
                super(0);
            }
        });
        Collection $this$toTypedArray$iv = arguments2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(Arrays.copyOf(stringArray2, stringArray2.length));
        pb.redirectErrorStream(true);
        pb.redirectOutput(this.ffmpegOutput);
        try {
            Process process = this.ffmpeg = pb.start();
            Intrinsics.checkNotNull(process);
            this.movieStream = process.getOutputStream();
            WritableByteChannel writableByteChannel = Channels.newChannel(this.movieStream);
            Intrinsics.checkNotNullExpressionValue(writableByteChannel, "Channels.newChannel(movieStream)");
            this.channel = writableByteChannel;
            return this;
        }
        catch (IOException e) {
            System.err.println("system path: " + System.getenv("path"));
            System.err.println("command: " + CollectionsKt.joinToString$default(arguments2, " ", null, null, 0, null, null, 62, null));
            throw (Throwable)new RuntimeException("failed to launch ffmpeg", e);
        }
    }

    @NotNull
    public final VideoWriter frame(@NotNull ColorBuffer frame2) {
        Intrinsics.checkNotNullParameter(frame2, "frame");
        if (!this.stopped) {
            int frameBytes = frame2.getWidth() * frame2.getHeight() * frame2.getFormat().getComponentCount() * frame2.getType().getComponentSize();
            ByteBuffer byteBuffer = this.frameBuffer;
            if (byteBuffer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
            }
            boolean bl = frameBytes == byteBuffer.capacity();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "frame size/format/type mismatch";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ByteBuffer byteBuffer2 = this.frameBuffer;
            if (byteBuffer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
            }
            if (byteBuffer2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)byteBuffer2).rewind();
            ByteBuffer byteBuffer3 = this.frameBuffer;
            if (byteBuffer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
            }
            ColorBuffer.DefaultImpls.read$default(frame2, byteBuffer3, null, null, 0, 14, null);
            ByteBuffer byteBuffer4 = this.frameBuffer;
            if (byteBuffer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
            }
            if (byteBuffer4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)byteBuffer4).rewind();
            try {
                WritableByteChannel writableByteChannel = this.channel;
                if (writableByteChannel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("channel");
                }
                ByteBuffer byteBuffer5 = this.frameBuffer;
                if (byteBuffer5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
                }
                writableByteChannel.write(byteBuffer5);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw (Throwable)new RuntimeException("failed to write frame", e);
            }
        } else {
            VideoWriterKt.access$getLogger$p().warn(frame.2.INSTANCE);
        }
        return this;
    }

    @NotNull
    public final VideoWriter stop() {
        this.stopped = true;
        try {
            OutputStream outputStream = this.movieStream;
            Intrinsics.checkNotNull(outputStream);
            outputStream.close();
            try {
                VideoWriterKt.access$getLogger$p().info("waiting for ffmpeg to finish");
                Process process = this.ffmpeg;
                Intrinsics.checkNotNull(process);
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("failed to close the movie stream");
        }
        return this;
    }

    public static final /* synthetic */ int access$getWidth$p(VideoWriter $this) {
        return $this.width;
    }

    public static final /* synthetic */ void access$setWidth$p(VideoWriter $this, int n) {
        $this.width = n;
    }

    public static final /* synthetic */ int access$getHeight$p(VideoWriter $this) {
        return $this.height;
    }

    public static final /* synthetic */ void access$setHeight$p(VideoWriter $this, int n) {
        $this.height = n;
    }

    public static final /* synthetic */ String access$getFilename$p(VideoWriter $this) {
        return $this.filename;
    }

    public static final /* synthetic */ void access$setFilename$p(VideoWriter $this, String string) {
        $this.filename = string;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/openrndr/ffmpeg/VideoWriter$Companion;", "", "()V", "create", "Lorg/openrndr/ffmpeg/VideoWriter;", "openrndr-ffmpeg"})
    public static final class Companion {
        @NotNull
        public final VideoWriter create() {
            return new VideoWriter();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

