/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.CircleBatch;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.CircleDrawerKt;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Circle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J,\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0016\u001a\u00020\u0014J2\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bJ$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001bJ&\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0015\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b#R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/openrndr/internal/CircleDrawer;", "", "()V", "batch", "Lorg/openrndr/draw/CircleBatch;", "getBatch$openrndr_core", "()Lorg/openrndr/draw/CircleBatch;", "setBatch$openrndr_core", "(Lorg/openrndr/draw/CircleBatch;)V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "drawCircle", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "x", "", "y", "radius", "drawCircles", "count", "", "positions", "", "Lorg/openrndr/math/Vector2;", "radii", "circles", "Lorg/openrndr/shape/Circle;", "circleBatch", "ensureBatchSize", "size", "ensureBatchSize$openrndr_core", "openrndr-core"})
public final class CircleDrawer {
    private final VertexBuffer vertices;
    @NotNull
    private CircleBatch batch;
    private final ShadeStyleManager shaderManager;

    @NotNull
    public final CircleBatch getBatch$openrndr_core() {
        return this.batch;
    }

    public final void setBatch$openrndr_core(@NotNull CircleBatch circleBatch) {
        Intrinsics.checkNotNullParameter(circleBatch, "<set-?>");
        this.batch = circleBatch;
    }

    public final void ensureBatchSize$openrndr_core(int size) {
        if (this.batch.getSize() < size) {
            CircleDrawerKt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(this, size){
                final /* synthetic */ CircleDrawer this$0;
                final /* synthetic */ int $size;

                @Nullable
                public final Object invoke() {
                    return "resizing buffer from " + this.this$0.getBatch$openrndr_core().getSize() + " to " + this.$size;
                }
                {
                    this.this$0 = circleDrawer;
                    this.$size = n;
                    super(0);
                }
            });
            this.batch.destroy();
            this.batch = CircleBatch.Companion.create(size, Session.Companion.getRoot());
        }
    }

    public final void drawCircles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, @NotNull List<Double> radii) {
        int i;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        Intrinsics.checkNotNullParameter(radii, "radii");
        this.ensureBatchSize$openrndr_core(positions.size());
        BufferWriter bufferWriter = this.batch.getGeometry().getShadow().writer();
        boolean bl = false;
        boolean bl2 = false;
        BufferWriter $this$apply = bufferWriter;
        boolean bl3 = false;
        $this$apply.rewind();
        int n = 0;
        int n2 = ((Collection)positions).size();
        while (n < n2) {
            $this$apply.write(new Vector3(positions.get(i).getX(), positions.get(i).getY(), 0.0));
            double d = ((Number)radii.get(i)).doubleValue();
            boolean bl4 = false;
            $this$apply.write(new Vector2(Math.abs(d)));
            ++i;
        }
        this.batch.getGeometry().getShadow().uploadElements(0, positions.size());
        bufferWriter = this.batch.getDrawStyle().getShadow().writer();
        bl = false;
        bl2 = false;
        $this$apply = bufferWriter;
        boolean bl5 = false;
        $this$apply.rewind();
        n2 = ((Collection)positions).size();
        for (i = 0; i < n2; ++i) {
            BatchesKt.write($this$apply, drawStyle);
        }
        this.batch.getDrawStyle().getShadow().uploadElements(0, positions.size());
        this.drawCircles(drawContext, drawStyle, positions.size());
    }

    public final void drawCircles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, double radius) {
        int i;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        this.ensureBatchSize$openrndr_core(positions.size());
        BufferWriter bufferWriter = this.batch.getGeometry().getShadow().writer();
        boolean bl = false;
        boolean bl2 = false;
        BufferWriter $this$apply = bufferWriter;
        boolean bl3 = false;
        $this$apply.rewind();
        int n = 0;
        int n2 = ((Collection)positions).size();
        while (n < n2) {
            $this$apply.write(new Vector3(positions.get(i).getX(), positions.get(i).getY(), 0.0));
            double d = radius;
            boolean bl4 = false;
            $this$apply.write(new Vector2(Math.abs(d)));
            ++i;
        }
        this.batch.getGeometry().getShadow().uploadElements(0, positions.size());
        bufferWriter = this.batch.getDrawStyle().getShadow().writer();
        bl = false;
        bl2 = false;
        $this$apply = bufferWriter;
        boolean bl5 = false;
        $this$apply.rewind();
        n2 = ((Collection)positions).size();
        for (i = 0; i < n2; ++i) {
            BatchesKt.write($this$apply, drawStyle);
        }
        this.batch.getDrawStyle().getShadow().uploadElements(0, positions.size());
        this.drawCircles(drawContext, drawStyle, positions.size());
    }

    public final void drawCircles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Circle> circles) {
        int i;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(circles, "circles");
        this.ensureBatchSize$openrndr_core(circles.size());
        BufferWriter bufferWriter = this.batch.getGeometry().getShadow().writer();
        boolean bl = false;
        boolean bl2 = false;
        BufferWriter $this$apply = bufferWriter;
        boolean bl3 = false;
        $this$apply.rewind();
        int n = 0;
        int n2 = ((Collection)circles).size();
        while (n < n2) {
            $this$apply.write(circles.get(i).getCenter().getXy0());
            double d = circles.get(i).getRadius();
            boolean bl4 = false;
            $this$apply.write(new Vector2(Math.abs(d)));
            ++i;
        }
        this.batch.getGeometry().getShadow().uploadElements(0, circles.size());
        bufferWriter = this.batch.getDrawStyle().getShadow().writer();
        bl = false;
        bl2 = false;
        $this$apply = bufferWriter;
        boolean bl5 = false;
        $this$apply.rewind();
        n2 = ((Collection)circles).size();
        for (i = 0; i < n2; ++i) {
            BatchesKt.write($this$apply, drawStyle);
        }
        this.batch.getDrawStyle().getShadow().uploadElements(0, circles.size());
        this.drawCircles(drawContext, drawStyle, circles.size());
    }

    public final void drawCircle(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, double x, double y, double radius) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        this.ensureBatchSize$openrndr_core(1);
        BufferWriter bufferWriter = this.batch.getGeometry().getShadow().writer();
        boolean bl = false;
        boolean bl2 = false;
        BufferWriter $this$apply = bufferWriter;
        boolean bl3 = false;
        $this$apply.rewind();
        $this$apply.write(new Vector3(x, y, 0.0));
        double d = radius;
        boolean bl4 = false;
        $this$apply.write(new Vector2(Math.abs(d)));
        this.batch.getGeometry().getShadow().uploadElements(0, 1);
        bufferWriter = this.batch.getDrawStyle().getShadow().writer();
        bl = false;
        bl2 = false;
        $this$apply = bufferWriter;
        boolean bl5 = false;
        $this$apply.rewind();
        ColorRGBa colorRGBa = drawStyle.getFill();
        if (colorRGBa == null) {
            colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
        }
        $this$apply.write(colorRGBa);
        ColorRGBa colorRGBa2 = drawStyle.getStroke();
        if (colorRGBa2 == null) {
            colorRGBa2 = ColorRGBa.Companion.getTRANSPARENT();
        }
        $this$apply.write(colorRGBa2);
        $this$apply.write((float)drawStyle.getStrokeWeight());
        this.batch.getDrawStyle().getShadow().uploadElements(0, 1);
        this.drawCircles(drawContext, drawStyle, 1);
    }

    private final void drawCircles(DrawContext drawContext, DrawStyle drawStyle, int count2) {
        this.drawCircles(drawContext, drawStyle, this.batch, count2);
    }

    public final void drawCircles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull CircleBatch circleBatch, int count2) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(circleBatch, "circleBatch");
        List<VertexBuffer> instanceAttributes = CollectionsKt.listOf(circleBatch.getGeometry(), circleBatch.getDrawStyle());
        List<VertexFormat> instanceAttributeFormats = CollectionsKt.listOf(circleBatch.getGeometry().getVertexFormat(), circleBatch.getDrawStyle().getVertexFormat());
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), instanceAttributeFormats);
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver driver = Driver.Companion.getInstance();
        List<VertexBuffer> list = CollectionsKt.listOf(this.vertices);
        Collection collection = instanceAttributes;
        ShadeStyle shadeStyle = drawStyle.getShadeStyle();
        List<VertexBuffer> list2 = shadeStyle != null ? shadeStyle.getAttributes() : null;
        boolean bl = false;
        List<VertexBuffer> list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        driver.drawInstances(shader2, list, CollectionsKt.plus(collection, (Iterable)list3), DrawPrimitive.TRIANGLES, 0, 6, 0, count2);
        shader2.end();
    }

    /*
     * WARNING - void declaration
     */
    public CircleDrawer() {
        void $this$apply;
        VertexFormat vertexFormat2 = new VertexFormat();
        boolean bl = false;
        boolean bl2 = false;
        VertexFormat vertexFormat3 = vertexFormat2;
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        CircleDrawer circleDrawer = this;
        boolean bl3 = false;
        $this$apply.position(3);
        $this$apply.normal(3);
        VertexFormat.textureCoordinate$default((VertexFormat)$this$apply, 2, 0, 2, null);
        Unit unit = Unit.INSTANCE;
        circleDrawer.vertices = companion.createDynamic(vertexFormat2, 6, Session.Companion.getRoot());
        this.batch = CircleBatch.Companion.create$default(CircleBatch.Companion, 10000, null, 2, null);
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "circle", new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((ShaderGenerators)this.receiver).circleVertexShader(p1);
            }
        }, null, null, null, new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((ShaderGenerators)this.receiver).circleFragmentShader(p1);
            }
        }, 28, null);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        double x = 0.0;
        double y = 0.0;
        double radius = 1.0;
        Vector3 pa = new Vector3(x - radius, y - radius, 0.0);
        Vector3 pb = new Vector3(x + radius, y - radius, 0.0);
        Vector3 pc = new Vector3(x + radius, y + radius, 0.0);
        Vector3 pd = new Vector3(x - radius, y + radius, 0.0);
        Vector2 ta = new Vector2(0.0, 0.0);
        Vector2 tb = new Vector2(1.0, 0.0);
        Vector2 tc = new Vector2(1.0, 1.0);
        Vector2 td = new Vector2(0.0, 1.0);
        Vector3 n = new Vector3(0.0, 0.0, -1.0);
        BufferWriter bufferWriter = w;
        boolean bl4 = false;
        boolean bl5 = false;
        BufferWriter $this$apply2 = bufferWriter;
        boolean bl6 = false;
        $this$apply2.write(pa);
        $this$apply2.write(n);
        $this$apply2.write(ta);
        $this$apply2.write(pd);
        $this$apply2.write(n);
        $this$apply2.write(td);
        $this$apply2.write(pc);
        $this$apply2.write(n);
        $this$apply2.write(tc);
        $this$apply2.write(pc);
        $this$apply2.write(n);
        $this$apply2.write(tc);
        $this$apply2.write(pb);
        $this$apply2.write(n);
        $this$apply2.write(tb);
        $this$apply2.write(pa);
        $this$apply2.write(n);
        $this$apply2.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }
}

