/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ChannelMask;
import org.openrndr.draw.CullTestPass;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.StencilOperation;
import org.openrndr.draw.StencilStyle;
import org.openrndr.draw.StencilTest;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.internal.Command;
import org.openrndr.internal.Driver;
import org.openrndr.internal.Expansion;
import org.openrndr.internal.ExpansionDrawer;
import org.openrndr.internal.ExpansionType;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ4\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ&\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010'\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010(\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010)\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+J\"\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000f\u001a\u00020\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0019R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\b\u00a8\u0006-"}, d2={"Lorg/openrndr/internal/ExpansionDrawer;", "", "()V", "quad", "Lorg/openrndr/draw/VertexBuffer;", "getQuad", "()Lorg/openrndr/draw/VertexBuffer;", "setQuad", "(Lorg/openrndr/draw/VertexBuffer;)V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "getVertexFormat", "()Lorg/openrndr/draw/VertexFormat;", "vertices", "getVertices", "setVertices", "renderConvexFillCommands", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "commands", "", "Lorg/openrndr/internal/Command;", "fringeScale", "", "renderFill", "expansions", "Lorg/openrndr/internal/Expansion;", "convex", "", "renderFillCommands", "renderFills", "renderStroke", "expansion", "renderStrokeCommands", "renderStrokeCommandsInterleaved", "renderStrokes", "toCommand", "vertexOffset", "", "toCommands", "openrndr-core"})
public final class ExpansionDrawer {
    private final ShadeStyleManager shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "expansion", new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

        @NotNull
        public final String invoke(@NotNull ShadeStructure p1) {
            Intrinsics.checkNotNullParameter(p1, "p1");
            return ((ShaderGenerators)this.receiver).expansionVertexShader(p1);
        }
    }, null, null, null, new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

        @NotNull
        public final String invoke(@NotNull ShadeStructure p1) {
            Intrinsics.checkNotNullParameter(p1, "p1");
            return ((ShaderGenerators)this.receiver).expansionFragmentShader(p1);
        }
    }, 28, null);
    @NotNull
    private final VertexFormat vertexFormat = VertexFormatKt.vertexFormat(vertexFormat.1.INSTANCE);
    @NotNull
    private VertexBuffer vertices = VertexBuffer.Companion.createDynamic(this.vertexFormat, 0x400000, Session.Companion.getRoot());
    @NotNull
    private VertexBuffer quad = VertexBuffer.Companion.createDynamic(this.vertexFormat, 6, Session.Companion.getRoot());

    @NotNull
    public final VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    public final void setVertices(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkNotNullParameter(vertexBuffer, "<set-?>");
        this.vertices = vertexBuffer;
    }

    @NotNull
    public final VertexBuffer getQuad() {
        return this.quad;
    }

    public final void setQuad(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkNotNullParameter(vertexBuffer, "<set-?>");
        this.quad = vertexBuffer;
    }

    public final void renderStrokeCommands(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands, double fringeScale) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(commands, "commands");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.<VertexFormat>emptyList());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        DrawStyle localStyle = DrawStyle.copy$default(drawStyle, null, null, null, null, null, 0.0, false, null, null, false, null, null, null, false, null, null, null, null, null, null, null, 0x1FFFFF, null);
        shader2.uniform("strokeMult", (drawStyle.getStrokeWeight() + fringeScale * 2.0) / (fringeScale * 2.0));
        shader2.uniform("strokeFillFactor", 0.0);
        Iterable $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Command command = (Command)element$iv;
            boolean bl = false;
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            shader2.uniform("strokeThr", 0.9980392f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
            shader2.uniform("strokeThr", -1.0f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
            localStyle.setChannelWriteMask(new ChannelMask(false, false, false, false));
            localStyle.getStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
            localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            Driver.Companion.getInstance().setState(localStyle);
        }
        shader2.end();
    }

    public final void renderStrokeCommandsInterleaved(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands, double fringeScale) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(commands, "commands");
        Collection collection = commands;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Shader shader2 = ShadeStyleManager.shader$default(this.shaderManager, drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), null, 4, null);
            shader2.begin();
            drawContext.applyToShader(shader2);
            drawStyle.applyToShader(shader2);
            Driver.Companion.getInstance().setState(drawStyle);
            DrawStyle localStyle = drawStyle;
            Command command = CollectionsKt.last(commands);
            boolean bl2 = false;
            boolean bl3 = false;
            Command it = command;
            boolean bl4 = false;
            int vertexCount2 = it.getVertexOffset() + it.getVertexCount();
            shader2.uniform("strokeMult", (drawStyle.getStrokeWeight() + fringeScale * 2.0) / (fringeScale * 2.0));
            shader2.uniform("strokeFillFactor", 0.0);
            shader2.uniform("bounds", new Vector4(-1000.0, -1000.0, 2000.0, 2000.0));
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            shader2.uniform("strokeThr", 0.9980392f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount2);
            shader2.uniform("strokeThr", 0.0f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount2);
            localStyle.setChannelWriteMask(new ChannelMask(false, false, false, false));
            localStyle.getStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount2);
            localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            Driver.Companion.getInstance().setState(localStyle);
        }
    }

    public final void renderConvexFillCommands(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands, double fringeScale) {
        Command command;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(commands, "commands");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        shader2.uniform("strokeThr", -1.0f);
        shader2.uniform("strokeMult", 1.0);
        shader2.uniform("strokeFillFactor", 1.0);
        Iterable $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            command = (Command)element$iv;
            boolean bl = false;
            if (command.getType() != ExpansionType.FILL) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_FAN, command.getVertexOffset(), command.getVertexCount());
        }
        $this$forEach$iv = commands;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            command = (Command)element$iv;
            boolean bl = false;
            if (command.getType() != ExpansionType.FRINGE) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
        }
    }

    public final void renderFillCommands(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands, double fringeScale) {
        Object v6;
        Object v4;
        Object v2;
        Object v0;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(commands, "commands");
        if (commands.isEmpty()) {
            return;
        }
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        DrawStyle localStyle = drawStyle;
        shader2.uniform("strokeThr", -1.0f);
        shader2.uniform("strokeMult", 1.0);
        shader2.uniform("strokeFillFactor", 1.0);
        Object $this$minBy$iv = commands;
        boolean $i$f$minBy = false;
        Iterable $this$minByOrNull$iv$iv = $this$minBy$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv$iv = $this$minByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v0 = minElem$iv$iv;
            } else {
                Command it = (Command)minElem$iv$iv;
                boolean bl = false;
                double minValue$iv$iv = it.getMinX();
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    Command it2 = (Command)e$iv$iv;
                    $i$a$-minBy-ExpansionDrawer$renderFillCommands$minX$1 = false;
                    double v$iv$iv = it2.getMinX();
                    if (Double.compare(minValue$iv$iv, v$iv$iv) <= 0) continue;
                    minElem$iv$iv = e$iv$iv;
                    minValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v0 = minElem$iv$iv;
            }
        }
        Command command = v0;
        if (command == null) {
            $this$minBy$iv = "no commands";
            boolean bl = false;
            throw (Throwable)new IllegalStateException($this$minBy$iv.toString());
        }
        double minX = command.getMinX();
        Object $this$minBy$iv2 = commands;
        boolean $i$f$minBy2 = false;
        Iterable $this$minByOrNull$iv$iv2 = $this$minBy$iv2;
        boolean $i$f$minByOrNull2 = false;
        Iterator iterator$iv$iv2 = $this$minByOrNull$iv$iv2.iterator();
        if (!iterator$iv$iv2.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv$iv = iterator$iv$iv2.next();
            if (!iterator$iv$iv2.hasNext()) {
                v2 = minElem$iv$iv;
            } else {
                Command it = (Command)minElem$iv$iv;
                boolean bl = false;
                double minValue$iv$iv = it.getMinY();
                do {
                    Object e$iv$iv = iterator$iv$iv2.next();
                    Command it3 = (Command)e$iv$iv;
                    $i$a$-minBy-ExpansionDrawer$renderFillCommands$minY$1 = false;
                    double v$iv$iv = it3.getMinY();
                    if (Double.compare(minValue$iv$iv, v$iv$iv) <= 0) continue;
                    minElem$iv$iv = e$iv$iv;
                    minValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv2.hasNext());
                v2 = minElem$iv$iv;
            }
        }
        Command command2 = v2;
        if (command2 == null) {
            $this$minBy$iv2 = "no commands";
            boolean bl = false;
            throw (Throwable)new IllegalStateException($this$minBy$iv2.toString());
        }
        double minY = command2.getMinY();
        Object $this$maxBy$iv = commands;
        boolean $i$f$maxBy = false;
        Iterable $this$maxByOrNull$iv$iv = $this$maxBy$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv$iv3 = $this$maxByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv3.hasNext()) {
            v4 = null;
        } else {
            Object maxElem$iv$iv = iterator$iv$iv3.next();
            if (!iterator$iv$iv3.hasNext()) {
                v4 = maxElem$iv$iv;
            } else {
                Command it = (Command)maxElem$iv$iv;
                boolean bl = false;
                double maxValue$iv$iv = it.getMaxX();
                do {
                    Object e$iv$iv = iterator$iv$iv3.next();
                    Command it4 = (Command)e$iv$iv;
                    $i$a$-maxBy-ExpansionDrawer$renderFillCommands$maxX$1 = false;
                    double v$iv$iv = it4.getMaxX();
                    if (Double.compare(maxValue$iv$iv, v$iv$iv) >= 0) continue;
                    maxElem$iv$iv = e$iv$iv;
                    maxValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv3.hasNext());
                v4 = maxElem$iv$iv;
            }
        }
        Command command3 = v4;
        if (command3 == null) {
            $this$maxBy$iv = "no commands";
            boolean bl = false;
            throw (Throwable)new IllegalStateException($this$maxBy$iv.toString());
        }
        double maxX = command3.getMaxX();
        Object $this$maxBy$iv2 = commands;
        boolean $i$f$maxBy2 = false;
        Iterable $this$maxByOrNull$iv$iv2 = $this$maxBy$iv2;
        boolean $i$f$maxByOrNull2 = false;
        Iterator iterator$iv$iv4 = $this$maxByOrNull$iv$iv2.iterator();
        if (!iterator$iv$iv4.hasNext()) {
            v6 = null;
        } else {
            Object maxElem$iv$iv = iterator$iv$iv4.next();
            if (!iterator$iv$iv4.hasNext()) {
                v6 = maxElem$iv$iv;
            } else {
                Command it = (Command)maxElem$iv$iv;
                boolean bl = false;
                double maxValue$iv$iv = it.getMaxY();
                do {
                    Object e$iv$iv = iterator$iv$iv4.next();
                    Command it5 = (Command)e$iv$iv;
                    $i$a$-maxBy-ExpansionDrawer$renderFillCommands$maxY$1 = false;
                    double v$iv$iv = it5.getMaxY();
                    if (Double.compare(maxValue$iv$iv, v$iv$iv) >= 0) continue;
                    maxElem$iv$iv = e$iv$iv;
                    maxValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv4.hasNext());
                v6 = maxElem$iv$iv;
            }
        }
        Command command4 = v6;
        if (command4 == null) {
            $this$maxBy$iv2 = "no commands";
            $i$f$maxBy2 = false;
            throw (Throwable)new IllegalStateException($this$maxBy$iv2.toString());
        }
        double maxY = command4.getMaxY();
        Command command5 = commands.get(0);
        shader2.uniform("bounds", new Vector4(command5.getMinX(), command5.getMinY(), command5.getMaxX() - command5.getMinX(), command5.getMaxY() - command5.getMinY()));
        localStyle.setFrontStencil(new StencilStyle());
        localStyle.setBackStencil(new StencilStyle());
        localStyle.getFrontStencil().setStencilWriteMask(255);
        localStyle.getBackStencil().setStencilWriteMask(255);
        localStyle.getFrontStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE_WRAP);
        localStyle.getBackStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.DECREASE_WRAP);
        localStyle.getFrontStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
        localStyle.getBackStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
        localStyle.setChannelWriteMask(ChannelMask.Companion.getNONE());
        localStyle.setCullTestPass(CullTestPass.ALWAYS);
        Driver.Companion.getInstance().setState(localStyle);
        for (Command c : commands) {
            if (c.getType() != ExpansionType.FILL) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(c.getVertexBuffer()), DrawPrimitive.TRIANGLE_FAN, c.getVertexOffset(), c.getVertexCount());
        }
        localStyle.setFrontStencil(localStyle.getStencil());
        localStyle.setBackStencil(localStyle.getStencil());
        localStyle.setChannelWriteMask(ChannelMask.Companion.getALL());
        shader2.uniform("strokeThr", 0.0f);
        localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
        localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
        Driver.Companion.getInstance().setState(localStyle);
        for (Command c : commands) {
            if (c.getType() != ExpansionType.FRINGE) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(c.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, c.getVertexOffset(), c.getVertexCount());
        }
        shader2.uniform("strokeThr", -1.0f);
        localStyle.getStencil().stencilFunc(StencilTest.NOT_EQUAL, 0, 255);
        localStyle.getStencil().setStencilTestMask(1);
        localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
        localStyle.setChannelWriteMask(ChannelMask.Companion.getALL());
        localStyle.setCullTestPass(CullTestPass.ALWAYS);
        BufferWriter bufferWriter = this.quad.getShadow().writer();
        boolean bl = false;
        boolean bl2 = false;
        BufferWriter $this$apply = bufferWriter;
        boolean bl3 = false;
        $this$apply.rewind();
        $this$apply.write((float)minX, (float)minY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)minX, (float)maxY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)maxX, (float)maxY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)maxX, (float)maxY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)maxX, (float)minY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)minX, (float)minY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        VertexBufferShadow.DefaultImpls.upload$default(this.quad.getShadow(), 0, 0, 3, null);
        Driver.Companion.getInstance().setState(localStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.quad), DrawPrimitive.TRIANGLES, 0, 6);
        localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
        shader2.end();
    }

    @NotNull
    public final Command toCommand(@NotNull VertexBuffer vertices, @NotNull Expansion expansion, int vertexOffset) {
        Intrinsics.checkNotNullParameter(vertices, "vertices");
        Intrinsics.checkNotNullParameter(expansion, "expansion");
        if (expansion.getVertexCount() > 0) {
            Command command = new Command(vertices, expansion.getType(), vertexOffset, expansion.getVertexCount() + 2, expansion.getMinx(), expansion.getMiny(), expansion.getMaxx(), expansion.getMaxy());
            BufferWriter bufferWriter = vertices.getShadow().writer();
            boolean bl = false;
            boolean bl2 = false;
            BufferWriter $this$apply = bufferWriter;
            boolean bl3 = false;
            $this$apply.setPositionElements(vertexOffset);
            BufferWriter w = bufferWriter;
            int vertexSize = (expansion.getBufferPosition() - expansion.getBufferStart()) / expansion.getVertexCount();
            w.write(expansion.getFb(), expansion.getBufferStart(), vertexSize);
            w.write(expansion.getFb(), expansion.getBufferStart(), expansion.getBufferPosition() - expansion.getBufferStart());
            w.write(expansion.getFb(), expansion.getBufferStart() + vertexSize * (expansion.getVertexCount() - 1), vertexSize);
            return command;
        }
        return new Command(vertices, ExpansionType.SKIP, 0, 0, 0.0, 0.0, 0.0, 0.0);
    }

    @NotNull
    public final List<Command> toCommands(@NotNull VertexBuffer vertices, @NotNull List<Expansion> expansions) {
        Intrinsics.checkNotNullParameter(vertices, "vertices");
        Intrinsics.checkNotNullParameter(expansions, "expansions");
        int vertexOffset = 0;
        boolean bl = false;
        List commands = new ArrayList();
        Iterable $this$forEach$iv = expansions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expansion it = (Expansion)element$iv;
            boolean bl2 = false;
            Command command = this.toCommand(vertices, it, vertexOffset);
            if (command.getType() == ExpansionType.SKIP) continue;
            commands.add(command);
            vertexOffset += it.getVertexCount() + 2;
        }
        vertices.getShadow().uploadElements(0, vertexOffset);
        return commands;
    }

    public final void renderStroke(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Expansion expansion, double fringeScale) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(expansion, "expansion");
        this.renderStrokeCommands(drawContext, drawStyle, this.toCommands(this.vertices, CollectionsKt.listOf(expansion)), fringeScale);
    }

    public final void renderStrokes(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions, double fringeScale) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(expansions, "expansions");
        this.renderStrokeCommandsInterleaved(drawContext, drawStyle, this.toCommands(this.vertices, expansions), fringeScale);
    }

    public final void renderFill(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions, boolean convex, double fringeScale) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(expansions, "expansions");
        if (convex) {
            this.renderConvexFillCommands(drawContext, drawStyle, this.toCommands(this.vertices, expansions), fringeScale);
        } else {
            this.renderFillCommands(drawContext, drawStyle, this.toCommands(this.vertices, expansions), fringeScale);
        }
    }

    public final void renderFills(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions, double fringeScale) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(expansions, "expansions");
        this.renderFillCommands(drawContext, drawStyle, this.toCommands(this.vertices, expansions), fringeScale);
    }
}

