/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.LineCap;
import org.openrndr.draw.LineJoin;
import org.openrndr.internal.Expansion;
import org.openrndr.internal.ExpansionKt;
import org.openrndr.internal.ExpansionType;
import org.openrndr.internal.Path$WhenMappings;
import org.openrndr.internal.PathPoint;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J,\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000b2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cJ.\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cJ\u0014\u0010'\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lorg/openrndr/internal/Path;", "", "()V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "contours", "", "", "Lorg/openrndr/internal/PathPoint;", "getContours", "()Ljava/util/List;", "convex", "getConvex", "setConvex", "nbevel", "", "getNbevel", "()I", "setNbevel", "(I)V", "calculateJoins", "", "points", "w", "", "lineJoin", "Lorg/openrndr/draw/LineJoin;", "miterLimit", "expandFill", "Lorg/openrndr/internal/Expansion;", "fringeWidth", "expandStroke", "weight", "lineCap", "Lorg/openrndr/draw/LineCap;", "prepare", "Companion", "openrndr-core"})
public final class Path {
    private boolean convex;
    private boolean closed;
    private int nbevel;
    @NotNull
    private final List<List<PathPoint>> contours;
    public static final Companion Companion = new Companion(null);

    public final boolean getConvex() {
        return this.convex;
    }

    public final void setConvex(boolean bl) {
        this.convex = bl;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    public final int getNbevel() {
        return this.nbevel;
    }

    public final void setNbevel(int n) {
        this.nbevel = n;
    }

    @NotNull
    public final List<List<PathPoint>> getContours() {
        return this.contours;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateJoins(List<PathPoint> points, double w, LineJoin lineJoin, double miterLimit) {
        this.nbevel = 0;
        double iw = w > 0.0 ? 1.0 / w : 0.0;
        int nleft = 0;
        PathPoint p0 = points.get(points.size() - 1);
        PathPoint p1 = points.get(0);
        int p1ptr = 0;
        int n = 0;
        int n2 = ((Collection)points).size();
        while (n < n2) {
            void j;
            double dlx0 = p0.getDy();
            double dly0 = -p0.getDx();
            double dlx1 = p1.getDy();
            double dly1 = -p1.getDx();
            p1.setDmx((dlx0 + dlx1) * 0.5);
            p1.setDmy((dly0 + dly1) * 0.5);
            double dmr2 = p1.getDmx() * p1.getDmx() + p1.getDmy() * p1.getDmy();
            if (dmr2 > (double)1.0E-6f) {
                double scale2 = 1.0 / dmr2;
                if (scale2 > 600.0) {
                    scale2 = 600.0;
                }
                PathPoint pathPoint = p1;
                pathPoint.setDmx(pathPoint.getDmx() * scale2);
                PathPoint pathPoint2 = p1;
                pathPoint2.setDmy(pathPoint2.getDmy() * scale2);
            }
            p1.setFlags((p1.getFlags() & 1) != 0 ? 1 : 0);
            double cross = p1.getDx() * p0.getDy() - p0.getDx() * p1.getDy();
            if (cross > 0.0) {
                ++nleft;
                p1.setFlags(p1.getFlags() | 2);
            }
            double d = 1.01;
            double d2 = p0.getLength();
            double d3 = p1.getLength();
            boolean bl = false;
            d2 = Math.min(d2, d3) * iw;
            boolean bl2 = false;
            double limit = Math.max(d, d2);
            if (dmr2 * limit * limit < (double)1.0f) {
                p1.setFlags(p1.getFlags() | 8);
            }
            if ((p1.getFlags() & 1) != 0 && (dmr2 * miterLimit * miterLimit < (double)1.0f || lineJoin == LineJoin.BEVEL || lineJoin == LineJoin.ROUND)) {
                p1.setFlags(p1.getFlags() | 4);
            }
            if ((p1.getFlags() & 0xC) != 0) {
                int n3 = this.nbevel;
                this.nbevel = n3 + 1;
            }
            p0 = p1;
            if (++p1ptr < points.size()) {
                p1 = points.get(p1ptr);
            }
            ++j;
        }
        this.convex = nleft == points.size();
    }

    /*
     * WARNING - void declaration
     */
    public final void prepare(@NotNull List<PathPoint> points) {
        Intrinsics.checkNotNullParameter(points, "points");
        PathPoint p0 = points.get(points.size() - 1);
        PathPoint p1 = points.get(0);
        int p1ptr = 0;
        int n = 0;
        int n2 = ((Collection)points).size();
        while (n < n2) {
            void i;
            p0.setDx(p1.getX() - p0.getX());
            p0.setDy(p1.getY() - p0.getY());
            double distanceSquared = p0.getDx() * p0.getDx() + p0.getDy() * p0.getDy();
            boolean bl = distanceSquared > 0.0 || i == false && !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "consecutive point duplication in input geometry at (" + (int)i + " and " + (int)(i + true) + ") (" + p0.getX() + ',' + p0.getY() + ')';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = false;
            p0.setLength(Math.sqrt(distanceSquared));
            if (p0.getLength() > 0.0) {
                PathPoint pathPoint = p0;
                pathPoint.setDx(pathPoint.getDx() / p0.getLength());
                PathPoint pathPoint2 = p0;
                pathPoint2.setDy(pathPoint2.getDy() / p0.getLength());
            } else {
                p0.setDx(0.0);
                p0.setDy(0.0);
            }
            p0 = p1;
            if (++p1ptr < points.size()) {
                p1 = points.get(p1ptr);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Expansion expandStroke(double fringeWidth, double weight, @NotNull LineCap lineCap, @NotNull LineJoin lineJoin, double miterLimit) {
        Intrinsics.checkNotNullParameter((Object)lineCap, "lineCap");
        Intrinsics.checkNotNullParameter((Object)lineJoin, "lineJoin");
        Collection collection = this.contours;
        boolean bl = false;
        if (!collection.isEmpty() && ExpansionKt.access$getRenderable$p(this.contours.get(0))) {
            boolean bl2;
            double dy;
            int p1ptr;
            List<PathPoint> points = this.contours.get(0);
            double tessTol = 0.1 * fringeWidth;
            int capSteps = ExpansionKt.curveDivs(weight, Math.PI, tessTol);
            this.prepare(points);
            this.calculateJoins(points, weight, lineJoin, miterLimit);
            int cverts = 0;
            cverts += lineJoin == LineJoin.ROUND ? (points.size() + this.nbevel * (capSteps + 2) + 1) * 2 : (points.size() + this.nbevel * 5 + 1) * 2;
            if (!this.closed) {
                cverts += lineCap == LineCap.ROUND ? (capSteps * 2 + 2) * 2 : 12;
            }
            Expansion expansion = new Expansion(ExpansionType.STROKE, new float[cverts * 5], 0);
            double offset2 = 0.0;
            double aa = fringeWidth;
            PathPoint p0 = this.closed ? points.get(points.size() - 1) : points.get(0);
            PathPoint p1 = this.closed ? points.get(0) : points.get(1);
            int start2 = this.closed ? 0 : 1;
            int end2 = this.closed ? points.size() : points.size() - 1;
            int n = p1ptr = this.closed ? 0 : 1;
            if (!this.closed) {
                double dx = p1.getX() - p0.getX();
                double dy2 = p1.getY() - p0.getY();
                double d = dx * dx + dy2 * dy2;
                boolean bl3 = false;
                double length2 = Math.sqrt(d);
                if (length2 > 0.0) {
                    dx /= length2;
                    dy2 /= length2;
                }
                switch (Path$WhenMappings.$EnumSwitchMapping$0[lineCap.ordinal()]) {
                    case 1: {
                        expansion.buttCapStart(p0, dx, dy2, weight, -aa * 0.5, aa, offset2);
                        break;
                    }
                    case 2: {
                        expansion.buttCapStart(p0, dx, dy2, weight, weight - aa, aa, offset2);
                        break;
                    }
                    case 3: {
                        expansion.roundCapStart(p0, dx, dy2, weight, capSteps, aa, offset2);
                        break;
                    }
                }
            }
            double fweight = weight + fringeWidth;
            int dy2 = start2;
            int n2 = end2;
            while (dy2 < n2) {
                void j;
                offset2 += p0.getLength();
                if ((p1.getFlags() & 0xC) != 0) {
                    if (lineJoin == LineJoin.ROUND) {
                        expansion.roundJoin(p0, p1, weight, weight, 0.0, 1.0, capSteps, aa, offset2);
                    } else {
                        expansion.bevelJoin(p0, p1, weight, weight, 0.0, 1.0, aa, offset2);
                    }
                } else {
                    expansion.addVertex(p1.getX() + p1.getDmx() * fweight, p1.getY() + p1.getDmy() * fweight, 0.0, 1.0, offset2);
                    expansion.addVertex(p1.getX() - p1.getDmx() * fweight, p1.getY() - p1.getDmy() * fweight, 1.0, 1.0, offset2);
                }
                p0 = p1;
                if (++p1ptr < points.size()) {
                    p1 = points.get(p1ptr);
                }
                ++j;
            }
            if (points.size() == 2) {
                double length3;
                double dx = p1.getX() - p0.getX();
                dy = p1.getY() - p0.getY();
                double d = dx * dx + dy * dy;
                bl2 = false;
                offset2 = length3 = Math.sqrt(d);
            } else {
                offset2 += p0.getLength();
            }
            if (this.closed) {
                Vector2 v0 = expansion.vertex(0);
                Vector2 v1 = expansion.vertex(1);
                expansion.addVertex(v0.getX(), v0.getY(), 0.0, 1.0, offset2);
                expansion.addVertex(v1.getX(), v1.getY(), 1.0, 1.0, offset2);
            } else {
                double dx = p1.getX() - p0.getX();
                dy = p1.getY() - p0.getY();
                double d = dx * dx + dy * dy;
                bl2 = false;
                double l = Math.sqrt(d);
                if (l > 0.0) {
                    dx /= l;
                    dy /= l;
                }
                switch (Path$WhenMappings.$EnumSwitchMapping$1[lineCap.ordinal()]) {
                    case 1: {
                        expansion.buttCapEnd(p1, dx, dy, weight, -aa * 0.5, aa, offset2);
                        break;
                    }
                    case 2: {
                        expansion.buttCapEnd(p1, dx, dy, weight, weight - aa, aa, offset2);
                        break;
                    }
                    case 3: {
                        expansion.roundCapEnd(p1, dx, dy, weight, capSteps, aa, offset2);
                        break;
                    }
                }
            }
            return expansion;
        }
        return new Expansion(ExpansionType.SKIP, new float[0], 0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Expansion> expandFill(double fringeWidth, double w, @NotNull LineJoin lineJoin, double miterLimit) {
        Intrinsics.checkNotNullParameter((Object)lineJoin, "lineJoin");
        Collection collection = this.contours;
        boolean bl = false;
        if (!collection.isEmpty()) {
            List it;
            bl = false;
            List result2 = new ArrayList();
            Iterable $this$forEach$iv = this.contours;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (List)element$iv;
                boolean bl2 = false;
                this.prepare(it);
            }
            $this$forEach$iv = this.contours;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (List)element$iv;
                boolean bl3 = false;
                this.calculateJoins(it, w, lineJoin, miterLimit);
            }
            if (this.contours.size() > 1) {
                this.convex = false;
            }
            double aa = fringeWidth;
            double woff = 0.5 * aa;
            boolean generateFringe = w > 0.0;
            double offset2 = 0.0;
            Iterable $this$forEach$iv2 = this.contours;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                int n;
                List points = (List)element$iv;
                boolean bl4 = false;
                int size = 4;
                Iterable $this$forEach$iv3 = points;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    PathPoint point = (PathPoint)element$iv2;
                    n = 0;
                    size += (point.getFlags() & 4) != 0 ? 12 : 4;
                }
                Expansion fill2 = new Expansion(ExpansionType.FILL, new float[size * 5], 0);
                if (generateFringe) {
                    PathPoint p0 = (PathPoint)CollectionsKt.last(points);
                    PathPoint p1 = (PathPoint)points.get(0);
                    int p1ptr = 0;
                    int point = 0;
                    n = ((Collection)points).size();
                    while (point < n) {
                        void j;
                        if ((p1.getFlags() & 4) != 0) {
                            if ((p1.getFlags() & 2) != 0) {
                                fill2.addVertex(p1.getX() + p1.getDmx() * woff, p1.getY() + p1.getDmy() * woff, 0.5, 1.0, offset2);
                            } else {
                                double dlx0 = p0.getDy();
                                double dly0 = -p0.getDx();
                                double dlx1 = p1.getDy();
                                double dly1 = -p1.getDx();
                                double lx0 = p1.getX() + dlx0 * woff;
                                double ly0 = p1.getY() + dly0 * woff;
                                double lx1 = p1.getX() + dlx1 * woff;
                                double ly1 = p1.getY() + dly1 * woff;
                                fill2.addVertex(lx0, ly0, 0.5, 1.0, offset2);
                                fill2.addVertex(lx1, ly1, 0.5, 1.0, offset2);
                            }
                        } else {
                            fill2.addVertex(p1.getX() + p1.getDmx() * woff, p1.getY() + p1.getDmy() * woff, 0.5, 1.0, offset2);
                        }
                        p0 = p1;
                        if (++p1ptr < points.size()) {
                            p1 = (PathPoint)points.get(p1ptr);
                        }
                        ++j;
                    }
                } else {
                    int p0 = 0;
                    int n2 = ((Collection)points).size();
                    while (p0 < n2) {
                        void j;
                        fill2.addVertex(((PathPoint)points.get((int)j)).getX(), ((PathPoint)points.get((int)j)).getY(), 0.5, 1.0, offset2);
                        ++j;
                    }
                }
                result2.add(fill2);
            }
            if (generateFringe) {
                for (List<PathPoint> points : this.contours) {
                    int size = 2;
                    for (PathPoint point : points) {
                        size += (point.getFlags() & 0xC) != 0 ? 10 : 4;
                    }
                    Expansion fringe = new Expansion(ExpansionType.FRINGE, new float[size * 5], 0);
                    double lw = w + woff;
                    double rw = w - woff;
                    double lu = 0.0;
                    double ru = 1.0;
                    if (this.convex) {
                        lw = woff;
                        lu = 0.5;
                    }
                    PathPoint p0 = points.get(points.size() - 1);
                    PathPoint p1 = points.get(0);
                    int p1ptr = 0;
                    int dly0 = 0;
                    int n = ((Collection)points).size();
                    while (dly0 < n) {
                        void j;
                        if ((p1.getFlags() & 0xC) != 0) {
                            fringe.bevelJoin(p0, p1, lw, rw, lu, ru, 0.0, offset2);
                        } else {
                            fringe.addVertex(p1.getX() + p1.getDmx() * lw, p1.getY() + p1.getDmy() * lw, lu, 1.0, offset2);
                            fringe.addVertex(p1.getX() - p1.getDmx() * rw, p1.getY() - p1.getDmy() * rw, ru, 1.0, offset2);
                        }
                        p0 = p1;
                        if (++p1ptr < points.size()) {
                            p1 = points.get(p1ptr);
                        }
                        ++j;
                    }
                    Vector2 v0 = fringe.vertex(0);
                    Vector2 v1 = fringe.vertex(1);
                    fringe.addVertex(v0.getX(), v0.getY(), lu, 1.0, offset2);
                    fringe.addVertex(v1.getX(), v1.getY(), ru, 1.0, offset2);
                    result2.add(fringe);
                }
            }
            return result2;
        }
        return CollectionsKt.emptyList();
    }

    public Path() {
        boolean bl = false;
        this.contours = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00062\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0006J*\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lorg/openrndr/internal/Path$Companion;", "", "()V", "fromLineLoops", "Lorg/openrndr/internal/Path;", "contours", "", "Lorg/openrndr/math/Vector2;", "corners", "", "fromLineStrip", "segments", "closed", "openrndr-core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path fromLineStrip(@NotNull List<Vector2> segments, @NotNull List<Boolean> corners, boolean closed) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter(segments, "segments");
            Intrinsics.checkNotNullParameter(corners, "corners");
            Path sp = new Path();
            boolean drop2 = closed && CollectionsKt.first(segments).squaredDistanceTo(CollectionsKt.last(segments)) < 1.0E-5;
            Iterable $this$mapIndexed$iv = segments;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void it;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Vector2 vector2 = (Vector2)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                PathPoint pathPoint = new PathPoint();
                boolean bl3 = false;
                boolean bl4 = false;
                PathPoint $this$apply = pathPoint;
                boolean bl5 = false;
                $this$apply.setX(it.getX());
                $this$apply.setY(it.getY());
                $this$apply.setFlags(corners.get((int)index) != false ? 1 : 0);
                PathPoint pathPoint2 = pathPoint;
                collection.add(pathPoint2);
            }
            List path = CollectionsKt.dropLast((List)destination$iv$iv, drop2 ? 1 : 0);
            Collection collection = path;
            boolean bl = false;
            if (!collection.isEmpty()) {
                if (!closed) {
                    ((PathPoint)path.get(0)).setFlags(0);
                    ((PathPoint)path.get(path.size() - 1)).setFlags(0);
                }
                sp.getContours().add(path);
            }
            sp.setClosed(closed);
            return sp;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path fromLineLoops(@NotNull List<? extends List<Vector2>> contours, @NotNull List<? extends List<Boolean>> corners) {
            Intrinsics.checkNotNullParameter(contours, "contours");
            Intrinsics.checkNotNullParameter(corners, "corners");
            Path sp = new Path();
            Iterable $this$forEachIndexed$iv = contours;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$mapIndexedTo$iv$iv;
                void contour2;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list = (List)item$iv;
                int contourIndex = n;
                boolean bl2 = false;
                Iterable $this$mapIndexed$iv = (Iterable)contour2;
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index;
                    void it;
                    int n2 = index$iv$iv++;
                    boolean bl3 = false;
                    if (n2 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Vector2 vector2 = (Vector2)item$iv$iv;
                    int n3 = n2;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    PathPoint pathPoint = new PathPoint();
                    boolean bl5 = false;
                    boolean bl6 = false;
                    PathPoint $this$apply = pathPoint;
                    boolean bl7 = false;
                    $this$apply.setX(it.getX());
                    $this$apply.setY(it.getY());
                    $this$apply.setFlags(corners.get(contourIndex).get((int)index) != false ? 1 : 0);
                    PathPoint pathPoint2 = pathPoint;
                    collection.add(pathPoint2);
                }
                List path = CollectionsKt.dropLast((List)destination$iv$iv, 1);
                sp.getContours().add(path);
            }
            sp.setClosed(true);
            return sp;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

