/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyexr.EXRChannelInfo;
import org.lwjgl.util.tinyexr.EXRHeader;
import org.lwjgl.util.tinyexr.EXRImage;
import org.lwjgl.util.tinyexr.EXRVersion;
import org.lwjgl.util.tinyexr.TinyEXR;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.internal.gl3.ColorBufferDataGL3;
import org.openrndr.internal.gl3.ColorBufferDataGL3$Companion$WhenMappings;
import org.openrndr.internal.gl3.dds.DDSData;
import org.openrndr.internal.gl3.dds.DDSReaderKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\u0018\u0000 #2\u00020\u0001:\u0001#BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\"\u001a\u00020\u000fR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001e\u00a8\u0006$"}, d2={"Lorg/openrndr/internal/gl3/ColorBufferDataGL3;", "", "width", "", "height", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "flipV", "", "data", "Ljava/nio/ByteBuffer;", "destroyFunction", "Lkotlin/Function1;", "", "(IILorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;ZLjava/nio/ByteBuffer;Lkotlin/jvm/functions/Function1;)V", "getData", "()Ljava/nio/ByteBuffer;", "setData", "(Ljava/nio/ByteBuffer;)V", "getDestroyFunction", "()Lkotlin/jvm/functions/Function1;", "setDestroyFunction", "(Lkotlin/jvm/functions/Function1;)V", "getFlipV", "()Z", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "getHeight", "()I", "getType", "()Lorg/openrndr/draw/ColorType;", "getWidth", "destroy", "Companion", "openrndr-gl3"})
public final class ColorBufferDataGL3 {
    private final int width;
    private final int height;
    @NotNull
    private final ColorFormat format;
    @NotNull
    private final ColorType type;
    private final boolean flipV;
    @Nullable
    private ByteBuffer data;
    @Nullable
    private Function1<? super ByteBuffer, Unit> destroyFunction;
    public static final Companion Companion = new Companion(null);

    public final void destroy() {
        ByteBuffer localData = this.data;
        if (localData != null) {
            Function1<? super ByteBuffer, Unit> function1 = this.destroyFunction;
            if (function1 != null) {
                function1.invoke(localData);
            }
            this.data = null;
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final ColorFormat getFormat() {
        return this.format;
    }

    @NotNull
    public final ColorType getType() {
        return this.type;
    }

    public final boolean getFlipV() {
        return this.flipV;
    }

    @Nullable
    public final ByteBuffer getData() {
        return this.data;
    }

    public final void setData(@Nullable ByteBuffer byteBuffer) {
        this.data = byteBuffer;
    }

    @Nullable
    public final Function1<ByteBuffer, Unit> getDestroyFunction() {
        return this.destroyFunction;
    }

    public final void setDestroyFunction(@Nullable Function1<? super ByteBuffer, Unit> function1) {
        this.destroyFunction = function1;
    }

    public ColorBufferDataGL3(int width, int height, @NotNull ColorFormat format, @NotNull ColorType type2, boolean flipV, @Nullable ByteBuffer data2, @Nullable Function1<? super ByteBuffer, Unit> destroyFunction) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this.width = width;
        this.height = height;
        this.format = format;
        this.type = type2;
        this.flipV = flipV;
        this.data = data2;
        this.destroyFunction = destroyFunction;
    }

    public /* synthetic */ ColorBufferDataGL3(int n, int n2, ColorFormat colorFormat, ColorType colorType, boolean bl, ByteBuffer byteBuffer, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x40) != 0) {
            function1 = null;
        }
        this(n, n2, colorFormat, colorType, bl, byteBuffer, function1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000bJ&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/internal/gl3/ColorBufferDataGL3$Companion;", "", "()V", "fromArray", "Lorg/openrndr/internal/gl3/ColorBufferDataGL3;", "bytes", "", "offset", "", "length", "name", "", "formatHint", "Lorg/openrndr/draw/ImageFileFormat;", "fromByteBuffer", "buffer", "Ljava/nio/ByteBuffer;", "fromFile", "filename", "fromStream", "stream", "Ljava/io/InputStream;", "fromUrl", "urlString", "openrndr-gl3"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ColorBufferDataGL3 fromUrl(@NotNull String urlString, @Nullable ImageFileFormat formatHint) {
            Intrinsics.checkNotNullParameter(urlString, "urlString");
            if (StringsKt.startsWith$default(urlString, "data:", false, 2, null)) {
                Base64.Decoder decoder = Base64.getDecoder();
                int commaIndex = StringsKt.indexOf$default((CharSequence)urlString, ",", 0, false, 6, null);
                String base64Data = StringsKt.replace$default(StringsKt.drop(urlString, commaIndex + 1), "\n", "", false, 4, null);
                byte[] decoded = decoder.decode(base64Data);
                ByteBuffer buffer2 = ByteBuffer.allocateDirect(decoded.length);
                buffer2.put(decoded);
                ByteBuffer byteBuffer = buffer2;
                if (byteBuffer == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((Buffer)byteBuffer).rewind();
                return org.openrndr.internal.gl3.ColorBufferDataGL3$Companion.fromByteBuffer$default(this, buffer2, "data-url", null, 4, null);
            }
            URL url = new URL(urlString);
            Closeable closeable = url.openStream();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ByteBuffer buffer3;
                byte[] byteArray;
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                byte[] byArray = byteArray = TextStreamsKt.readBytes(url);
                boolean bl4 = false;
                if (byArray.length == 0) {
                    throw (Throwable)new RuntimeException("read 0 bytes from stream " + urlString);
                }
                ByteBuffer byteBuffer = buffer3 = BufferUtils.createByteBuffer(byteArray.length);
                if (byteBuffer == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((Buffer)byteBuffer).rewind();
                buffer3.put(byteArray);
                ((Buffer)buffer3).rewind();
                ColorBufferDataGL3 colorBufferDataGL3 = org.openrndr.internal.gl3.ColorBufferDataGL3$Companion.fromByteBuffer$default(Companion, buffer3, urlString, null, 4, null);
                return colorBufferDataGL3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }

        @NotNull
        public final ColorBufferDataGL3 fromStream(@NotNull InputStream stream, @Nullable String name, @Nullable ImageFileFormat formatHint) {
            ByteBuffer buffer2;
            Intrinsics.checkNotNullParameter(stream, "stream");
            byte[] byteArray = ByteStreamsKt.readBytes(stream);
            ByteBuffer byteBuffer = buffer2 = BufferUtils.createByteBuffer(byteArray.length);
            if (byteBuffer == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)byteBuffer).rewind();
            buffer2.put(byteArray);
            ((Buffer)buffer2).rewind();
            return this.fromByteBuffer(buffer2, name, formatHint);
        }

        public static /* synthetic */ ColorBufferDataGL3 fromStream$default(Companion companion, InputStream inputStream, String string, ImageFileFormat imageFileFormat, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                imageFileFormat = null;
            }
            return companion.fromStream(inputStream, string, imageFileFormat);
        }

        @NotNull
        public final ColorBufferDataGL3 fromArray(@NotNull byte[] bytes, int offset2, int length2, @Nullable String name, @Nullable ImageFileFormat formatHint) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            ByteBuffer buffer2 = ByteBuffer.allocateDirect(length2);
            buffer2.put(bytes, offset2, length2);
            ByteBuffer byteBuffer = buffer2;
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "buffer");
            return this.fromByteBuffer(byteBuffer, name, formatHint);
        }

        public static /* synthetic */ ColorBufferDataGL3 fromArray$default(Companion companion, byte[] byArray, int n, int n2, String string, ImageFileFormat imageFileFormat, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            if ((n3 & 8) != 0) {
                string = null;
            }
            if ((n3 & 0x10) != 0) {
                imageFileFormat = null;
            }
            return companion.fromArray(byArray, n, n2, string, imageFileFormat);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ColorBufferDataGL3 fromByteBuffer(@NotNull ByteBuffer buffer2, @Nullable String name, @Nullable ImageFileFormat formatHint) {
            ImageFileFormat assumedFormat;
            block86: {
                ColorFormat colorFormat;
                Unit unit;
                Unit unit2;
                Long l;
                Buffer it;
                Buffer buffer3;
                ShortBuffer data16;
                Buffer data8;
                void tdata8;
                ShortBuffer tdata16;
                ColorType targetType2;
                int bitsPerChannel;
                int[] ca;
                int[] ha;
                int[] wa;
                block88: {
                    block87: {
                        Buffer buffer4;
                        int x4;
                        int n;
                        Pair<ByteBuffer, ShortBuffer> pair;
                        Intrinsics.checkNotNullParameter(buffer2, "buffer");
                        assumedFormat = ImageFileFormat.PNG;
                        if (formatHint != null) {
                            assumedFormat = formatHint;
                        }
                        ((Buffer)buffer2).mark();
                        if (assumedFormat != ImageFileFormat.PNG && assumedFormat != ImageFileFormat.JPG) break block86;
                        wa = new int[1];
                        ha = new int[1];
                        ca = new int[1];
                        STBImage.stbi_set_flip_vertically_on_load(true);
                        STBImage.stbi_set_unpremultiply_on_load(false);
                        bitsPerChannel = assumedFormat == ImageFileFormat.PNG ? (STBImage.stbi_is_16_bit_from_memory(buffer2) ? 16 : 8) : 8;
                        ((Buffer)buffer2).reset();
                        targetType2 = null;
                        int mask = 0;
                        int alphaOffset = 3;
                        int redOffset = 0;
                        int greenOffset = 1;
                        int blueOffset = 2;
                        switch (bitsPerChannel) {
                            case 8: {
                                targetType2 = ColorType.UINT8;
                                mask = 255;
                                break;
                            }
                            case 16: {
                                targetType2 = ColorType.UINT16;
                                mask = 65535;
                                break;
                            }
                            default: {
                                String string = "unsupported bits per channel: " + bitsPerChannel;
                                boolean bl = false;
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                        }
                        switch (bitsPerChannel) {
                            case 8: {
                                ByteBuffer byteBuffer = STBImage.stbi_load_from_memory(buffer2, wa, ha, ca, 0);
                                if (byteBuffer == null) {
                                    String string = "stbi_load returned null";
                                    boolean bl = false;
                                    throw (Throwable)new IllegalStateException(string.toString());
                                }
                                pair = new Pair<ByteBuffer, ShortBuffer>(byteBuffer, null);
                                break;
                            }
                            case 16: {
                                ShortBuffer shortBuffer = STBImage.stbi_load_16_from_memory(buffer2, wa, ha, ca, 0);
                                if (shortBuffer == null) {
                                    String string = "stdi_load returned null";
                                    boolean bl = false;
                                    throw (Throwable)new IllegalStateException(string.toString());
                                }
                                pair = new Pair<ByteBuffer, ShortBuffer>(null, shortBuffer);
                                break;
                            }
                            default: {
                                String string = "unsupported bits per channel: " + bitsPerChannel;
                                boolean bl = false;
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                        }
                        Pair<ByteBuffer, ShortBuffer> pair2 = pair;
                        ByteBuffer byteBuffer = pair2.component1();
                        tdata16 = pair2.component2();
                        if (tdata8 != null) {
                            int offset2 = 0;
                            if (ca[0] == 4) {
                                int n2 = 0;
                                n = ha[0];
                                while (n2 < n) {
                                    void y;
                                    int n3 = 0;
                                    int n4 = wa[0];
                                    while (n3 < n4) {
                                        double a2 = (double)(tdata8.get(offset2 + alphaOffset) & mask) / (double)mask;
                                        double r = (double)(tdata8.get(offset2 + redOffset) & mask) * a2;
                                        double g = (double)(tdata8.get(offset2 + greenOffset) & mask) * a2;
                                        double b = (double)(tdata8.get(offset2 + blueOffset) & mask) * a2;
                                        tdata8.put(offset2 + redOffset, (byte)r);
                                        tdata8.put(offset2 + greenOffset, (byte)g);
                                        tdata8.put(offset2 + blueOffset, (byte)b);
                                        offset2 += 4;
                                        ++x4;
                                    }
                                    ++y;
                                }
                            }
                        }
                        void v3 = tdata8;
                        if (v3 != null) {
                            void y = v3;
                            n = 0;
                            x4 = 0;
                            void it2 = y;
                            boolean bl = false;
                            if (ca[0] == 1) {
                                int roffset = 0;
                                int woffset = 0;
                                ByteBuffer data82 = ByteBuffer.allocateDirect(tdata8.capacity() * 3);
                                int g = 0;
                                int n5 = ha[0];
                                while (g < n5) {
                                    void y2;
                                    int b = 0;
                                    int n6 = wa[0];
                                    while (b < n6) {
                                        void x2;
                                        byte r = tdata8.get(roffset);
                                        data82.put(woffset + 0, r);
                                        data82.put(woffset + 1, r);
                                        data82.put(woffset + 2, r);
                                        ++roffset;
                                        woffset += 3;
                                        ++x2;
                                    }
                                    ++y2;
                                }
                                buffer4 = data82;
                            } else {
                                buffer4 = tdata8;
                            }
                        } else {
                            buffer4 = data8 = null;
                        }
                        if (tdata16 != null) {
                            int offset3 = 0;
                            if (ca[0] == 4) {
                                n = 0;
                                x4 = ha[0];
                                while (n < x4) {
                                    void y;
                                    int it2 = 0;
                                    int bl = wa[0];
                                    while (it2 < bl) {
                                        void x3;
                                        double a3 = (double)(tdata16.get(offset3 + alphaOffset) & mask) / (double)mask;
                                        double r = (double)(tdata16.get(offset3 + redOffset) & mask) * a3;
                                        double g = (double)(tdata16.get(offset3 + greenOffset) & mask) * a3;
                                        double b = (double)(tdata16.get(offset3 + blueOffset) & mask) * a3;
                                        tdata16.put(offset3 + redOffset, (short)r);
                                        tdata16.put(offset3 + greenOffset, (short)g);
                                        tdata16.put(offset3 + blueOffset, (short)b);
                                        offset3 += 4;
                                        ++x3;
                                    }
                                    ++y;
                                }
                            }
                        }
                        data16 = tdata16;
                        buffer3 = data8;
                        if (buffer3 == null) break block87;
                        Buffer x4 = buffer3;
                        boolean x3 = false;
                        boolean bl = false;
                        Buffer it3 = x4;
                        boolean bl2 = false;
                        buffer3 = MemoryUtil.memAlloc(it3.capacity());
                        if (buffer3 != null) break block88;
                    }
                    ShortBuffer shortBuffer = data16;
                    if (shortBuffer != null) {
                        ShortBuffer x4 = shortBuffer;
                        boolean x3 = false;
                        boolean bl = false;
                        ShortBuffer it4 = x4;
                        boolean bl3 = false;
                        buffer3 = MemoryUtil.memAlloc(it4.capacity() * 2);
                    } else {
                        buffer3 = null;
                    }
                }
                if (buffer3 == null) {
                    String x4 = "alloc failed, data8: " + data8 + ", data16: " + data16 + ", " + (Object)((Object)assumedFormat) + ", " + bitsPerChannel;
                    boolean x3 = false;
                    throw (Throwable)new IllegalStateException(x4.toString());
                }
                Buffer copyData = buffer3;
                Buffer buffer5 = data8;
                if (buffer5 != null) {
                    Buffer bl = buffer5;
                    boolean it4 = false;
                    boolean bl3 = false;
                    it = bl;
                    boolean bl4 = false;
                    l = MemoryUtil.memAddress((ByteBuffer)it);
                } else {
                    ShortBuffer shortBuffer = data16;
                    if (shortBuffer != null) {
                        ShortBuffer bl = shortBuffer;
                        boolean it4 = false;
                        boolean bl3 = false;
                        it = bl;
                        boolean bl5 = false;
                        l = MemoryUtil.memAddress((ShortBuffer)it);
                    } else {
                        l = null;
                    }
                }
                if (l == null) {
                    String bl = "get address failed";
                    boolean it4 = false;
                    throw (Throwable)new IllegalStateException(bl.toString());
                }
                long source = l;
                long dest = MemoryUtil.memAddress((ByteBuffer)copyData);
                MemoryUtil.memCopy(source, dest, copyData.capacity());
                void v10 = tdata8;
                if (v10 != null) {
                    void bl3 = v10;
                    boolean it5 = false;
                    boolean bl5 = false;
                    void it6 = bl3;
                    boolean bl = false;
                    STBImage.stbi_image_free((ByteBuffer)it6);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                ShortBuffer shortBuffer = tdata16;
                if (shortBuffer != null) {
                    ShortBuffer bl3 = shortBuffer;
                    boolean it5 = false;
                    boolean bl5 = false;
                    ShortBuffer it7 = bl3;
                    boolean bl = false;
                    STBImage.stbi_image_free(it7);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                int n = wa[0];
                int n7 = ha[0];
                switch (ca[0]) {
                    case 1: {
                        colorFormat = ColorFormat.RGB;
                        break;
                    }
                    case 2: {
                        colorFormat = ColorFormat.RG;
                        break;
                    }
                    case 3: {
                        colorFormat = ColorFormat.RGB;
                        break;
                    }
                    case 4: {
                        colorFormat = ColorFormat.RGBa;
                        break;
                    }
                    default: {
                        throw (Throwable)new Exception("invalid component count " + ca[0]);
                    }
                }
                return new ColorBufferDataGL3(n, n7, colorFormat, targetType2, false, (ByteBuffer)copyData, fromByteBuffer.3.INSTANCE);
            }
            if (assumedFormat == ImageFileFormat.DDS) {
                DDSData data2 = DDSReaderKt.loadDDS(buffer2);
                ByteBuffer buffer6 = data2.image(0);
                boolean ca = buffer6.remaining() > 0;
                boolean bitsPerChannel = false;
                boolean targetType2 = false;
                if (!ca) {
                    boolean bl6 = false;
                    String targetType2 = "image buffer " + buffer6 + " has no remaining bytes";
                    throw (Throwable)new IllegalArgumentException(targetType2.toString());
                }
                return new ColorBufferDataGL3(data2.getWidth(), data2.getHeight(), data2.getFormat(), data2.getType(), data2.getFlipV(), data2.image(0), null, 64, null);
            }
            if (assumedFormat == ImageFileFormat.EXR) {
                int it;
                Iterator $this$mapTo$iv$iv;
                boolean bl;
                boolean $i$f$none;
                List order;
                int n;
                List channelImages;
                Object object;
                Collection collection;
                ByteBuffer data3;
                int channels;
                int width;
                int height;
                ColorType type2;
                ColorFormat format;
                EXRImage exrImage;
                EXRHeader exrHeader;
                block85: {
                    List list;
                    void $this$mapTo$iv$iv2;
                    void $this$mapTo$iv$iv3;
                    ColorType colorType;
                    void t2;
                    ColorFormat colorFormat;
                    void c;
                    exrHeader = EXRHeader.create();
                    EXRVersion exrVersion = EXRVersion.create();
                    int versionResult = TinyEXR.ParseEXRVersionFromMemory(exrVersion, buffer2);
                    ((Buffer)buffer2).rewind();
                    if (versionResult != 0) {
                        String bitsPerChannel = "failed to get version";
                        boolean targetType2 = false;
                        throw (Throwable)new IllegalStateException(bitsPerChannel.toString());
                    }
                    PointerBuffer errors = PointerBuffer.allocateDirect(1);
                    int parseResult = TinyEXR.ParseEXRHeaderFromMemory(exrHeader, exrVersion, buffer2, errors);
                    if (parseResult != 0) {
                        String bl6 = "failed to parse file";
                        boolean alphaOffset = false;
                        throw (Throwable)new IllegalStateException(bl6.toString());
                    }
                    int bl6 = 0;
                    int alphaOffset = exrHeader.num_channels();
                    while (bl6 < alphaOffset) {
                        void i;
                        exrHeader.requested_pixel_types().put((int)i, exrHeader.pixel_types().get((int)i));
                        ++i;
                    }
                    exrImage = EXRImage.create();
                    TinyEXR.InitEXRImage(exrImage);
                    TinyEXR.LoadEXRImageFromMemory(exrImage, exrHeader, buffer2, errors);
                    int redOffset = exrImage.num_channels();
                    switch (c) {
                        case 1: {
                            colorFormat = ColorFormat.R;
                            break;
                        }
                        case 3: {
                            colorFormat = ColorFormat.RGB;
                            break;
                        }
                        case 4: {
                            colorFormat = ColorFormat.RGBa;
                            break;
                        }
                        default: {
                            String greenOffset = "unsupported number of channels " + (int)c;
                            boolean blueOffset = false;
                            throw (Throwable)new IllegalStateException(greenOffset.toString());
                        }
                    }
                    format = colorFormat;
                    int greenOffset = exrHeader.requested_pixel_types().get(0);
                    switch (t2) {
                        case 1: {
                            colorType = ColorType.FLOAT16;
                            break;
                        }
                        case 2: {
                            colorType = ColorType.FLOAT32;
                            break;
                        }
                        default: {
                            String blueOffset = "unsupported pixel type [type=" + (int)t2 + ']';
                            boolean tdata8 = false;
                            throw (Throwable)new IllegalStateException(blueOffset.toString());
                        }
                    }
                    type2 = colorType;
                    height = exrImage.height();
                    width = exrImage.width();
                    channels = exrImage.num_channels();
                    data3 = ByteBuffer.allocateDirect(format.getComponentCount() * type2.getComponentSize() * exrImage.width() * exrImage.height()).order(ByteOrder.nativeOrder());
                    Iterable $this$map$iv = RangesKt.until(0, exrHeader.num_channels());
                    boolean $i$f$map = false;
                    Iterable source = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo22 = false;
                    Iterator it4 = $this$mapTo$iv$iv3.iterator();
                    while (it4.hasNext()) {
                        int item$iv$iv;
                        int it5 = item$iv$iv = ((IntIterator)it4).nextInt();
                        collection = destination$iv$iv;
                        boolean bl7 = false;
                        object = ((EXRChannelInfo)exrHeader.channels().get(it5)).nameString();
                        collection.add(object);
                    }
                    List channelNames = (List)destination$iv$iv;
                    PointerBuffer pointerBuffer = exrImage.images();
                    Intrinsics.checkNotNull(pointerBuffer);
                    Intrinsics.checkNotNullExpressionValue(pointerBuffer, "exrImage.images()!!");
                    PointerBuffer images = pointerBuffer;
                    Iterable $this$map$iv2 = RangesKt.until(0, exrHeader.num_channels());
                    boolean $i$f$map2 = false;
                    Iterable $i$f$mapTo22 = $this$map$iv2;
                    Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                    boolean $i$f$mapTo = false;
                    Iterator it8 = $this$mapTo$iv$iv2.iterator();
                    while (it8.hasNext()) {
                        int item$iv$iv;
                        int it7 = item$iv$iv = ((IntIterator)it8).nextInt();
                        collection = destination$iv$iv2;
                        boolean bl8 = false;
                        object = images.getByteBuffer(it7, width * height * type2.getComponentSize());
                        collection.add(object);
                    }
                    channelImages = (List)destination$iv$iv2;
                    switch (ColorBufferDataGL3$Companion$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                        case 1: {
                            Object $this$mapTo$iv$iv4;
                            Iterable $this$map$iv3 = CollectionsKt.listOf("R");
                            boolean $i$f$map3 = false;
                            destination$iv$iv2 = $this$map$iv3;
                            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                            boolean $i$f$mapTo3 = false;
                            Iterator item$iv$iv = $this$mapTo$iv$iv4.iterator();
                            while (item$iv$iv.hasNext()) {
                                void it9;
                                Object item$iv$iv2 = item$iv$iv.next();
                                String bl8 = (String)item$iv$iv2;
                                collection = destination$iv$iv3;
                                boolean bl9 = false;
                                object = channelNames.indexOf(it9);
                                collection.add(object);
                            }
                            list = (List)destination$iv$iv3;
                            break;
                        }
                        case 2: {
                            Iterable $this$map$iv3 = CollectionsKt.listOf("B", "G", "R");
                            boolean $i$f$map3 = false;
                            Object $this$mapTo$iv$iv4 = $this$map$iv3;
                            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                            boolean $i$f$mapTo3 = false;
                            Iterator item$iv$iv = $this$mapTo$iv$iv4.iterator();
                            while (item$iv$iv.hasNext()) {
                                Object item$iv$iv3 = item$iv$iv.next();
                                String it9 = (String)item$iv$iv3;
                                collection = destination$iv$iv3;
                                boolean bl10 = false;
                                object = channelNames.indexOf(it9);
                                collection.add(object);
                            }
                            list = (List)destination$iv$iv3;
                            break;
                        }
                        case 3: {
                            Iterable $this$map$iv3 = CollectionsKt.listOf("B", "G", "R", "A");
                            boolean $i$f$map3 = false;
                            Object $this$mapTo$iv$iv4 = $this$map$iv3;
                            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                            boolean $i$f$mapTo3 = false;
                            Iterator item$iv$iv = $this$mapTo$iv$iv4.iterator();
                            while (item$iv$iv.hasNext()) {
                                Object item$iv$iv4 = item$iv$iv.next();
                                String it10 = (String)item$iv$iv4;
                                collection = destination$iv$iv3;
                                n = 0;
                                object = channelNames.indexOf(it10);
                                collection.add(object);
                            }
                            list = (List)destination$iv$iv3;
                            break;
                        }
                        default: {
                            String $this$map$iv4 = "unsupported channel layout";
                            boolean $i$f$map4 = false;
                            throw (Throwable)new IllegalStateException($this$map$iv4.toString());
                        }
                    }
                    order = list;
                    Iterable $this$none$iv = order;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            int it11 = ((Number)element$iv).intValue();
                            boolean bl11 = false;
                            if (!(it11 == -1)) continue;
                            bl = false;
                            break block85;
                        }
                        bl = true;
                    }
                }
                boolean $this$none$iv = bl;
                $i$f$none = false;
                boolean $this$mapTo$iv$iv52 = false;
                if (!$this$none$iv) {
                    boolean bl12 = false;
                    String $this$mapTo$iv$iv52 = "some channels are not found";
                    throw (Throwable)new IllegalArgumentException($this$mapTo$iv$iv52.toString());
                }
                Iterable $this$map$iv = order;
                boolean $i$f$map = false;
                Iterable bl12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator item$iv$iv4 = $this$mapTo$iv$iv.iterator();
                while (item$iv$iv4.hasNext()) {
                    Object item$iv$iv = item$iv$iv4.next();
                    n = ((Number)item$iv$iv).intValue();
                    collection = destination$iv$iv;
                    boolean bl13 = false;
                    object = (ByteBuffer)channelImages.get(it);
                    collection.add(object);
                }
                List orderedImages = (List)destination$iv$iv;
                Iterable $this$forEach$iv22 = orderedImages;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv22) {
                    ByteBuffer it12 = (ByteBuffer)element$iv;
                    boolean bl14 = false;
                    ByteBuffer byteBuffer = it12;
                    if (byteBuffer == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer).rewind();
                }
                int $this$forEach$iv22 = 0;
                int n8 = exrImage.height();
                while ($this$forEach$iv22 < n8) {
                    void y;
                    int offset4 = (height - 1 - y) * format.getComponentCount() * type2.getComponentSize() * width;
                    ByteBuffer byteBuffer = data3;
                    if (byteBuffer == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer).position(offset4);
                    int element$iv = 0;
                    int n9 = exrImage.width();
                    while (element$iv < n9) {
                        void x;
                        int bl14 = 0;
                        int n10 = channels;
                        while (bl14 < n10) {
                            void c;
                            it = 0;
                            int n11 = type2.getComponentSize();
                            while (it < n11) {
                                void i;
                                data3.put(((ByteBuffer)orderedImages.get((int)c)).get());
                                ++i;
                            }
                            ++c;
                        }
                        ++x;
                    }
                    ++y;
                }
                ByteBuffer byteBuffer = data3;
                if (byteBuffer == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((Buffer)byteBuffer).rewind();
                TinyEXR.FreeEXRHeader(exrHeader);
                TinyEXR.FreeEXRImage(exrImage);
                return new ColorBufferDataGL3(exrImage.width(), exrImage.height(), format, type2, false, data3, null, 64, null);
            }
            String string = "format not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public static /* synthetic */ ColorBufferDataGL3 fromByteBuffer$default(Companion companion, ByteBuffer byteBuffer, String string, ImageFileFormat imageFileFormat, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                imageFileFormat = null;
            }
            return companion.fromByteBuffer(byteBuffer, string, imageFileFormat);
        }

        @NotNull
        public final ColorBufferDataGL3 fromFile(@NotNull String filename) {
            ByteBuffer buffer2;
            byte[] byteArray;
            Intrinsics.checkNotNullParameter(filename, "filename");
            File file = new File(filename);
            byte[] byArray = byteArray = FilesKt.readBytes(file);
            boolean bl = false;
            if (byArray.length == 0) {
                throw (Throwable)new RuntimeException("read 0 bytes from stream " + filename);
            }
            ByteBuffer byteBuffer = buffer2 = BufferUtils.createByteBuffer(byteArray.length);
            if (byteBuffer == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)byteBuffer).rewind();
            buffer2.put(byteArray);
            ((Buffer)buffer2).rewind();
            return this.fromByteBuffer(buffer2, filename, ImageFileFormat.Companion.guessFromExtension(file));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

