/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL40C;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ArrayCubemap;
import org.openrndr.draw.ArrayCubemapAttachment;
import org.openrndr.draw.ArrayTexture;
import org.openrndr.draw.ArrayTextureAttachment;
import org.openrndr.draw.BlendMode;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorAttachment;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferAttachment;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.CubemapAttachment;
import org.openrndr.draw.CubemapSide;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.LayeredArrayCubemapAttachment;
import org.openrndr.draw.LayeredArrayTextureAttachment;
import org.openrndr.draw.LayeredCubemapAttachment;
import org.openrndr.draw.LayeredVolumeTextureAttachment;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.Session;
import org.openrndr.draw.VolumeTexture;
import org.openrndr.draw.VolumeTextureAttachment;
import org.openrndr.internal.gl3.ArrayCubemapGL4;
import org.openrndr.internal.gl3.ArrayTextureGL3;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.CubemapGL3;
import org.openrndr.internal.gl3.CubemapGL3Kt;
import org.openrndr.internal.gl3.DepthBufferGL3;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.RenderTargetGL3;
import org.openrndr.internal.gl3.RenderTargetGL3$WhenMappings;
import org.openrndr.internal.gl3.RenderTargetGL3Kt;
import org.openrndr.internal.gl3.VolumeTextureGL3;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 V2\u00020\u0001:\u0001VBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ2\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u000108H\u0016J*\u0010/\u001a\u0002002\u0006\u00109\u001a\u00020:2\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u000108H\u0016J\"\u0010/\u001a\u0002002\u0006\u0010;\u001a\u00020<2\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u000108H\u0016J*\u0010/\u001a\u0002002\u0006\u0010=\u001a\u00020>2\u0006\u00103\u001a\u0002042\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u000108H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J*\u0010/\u001a\u0002002\u0006\u0010?\u001a\u00020@2\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u000108H\u0016J\"\u0010A\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u000108H\u0016J\"\u0010A\u001a\u0002002\u0006\u00109\u001a\u00020:2\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u000108H\u0016J\"\u0010A\u001a\u0002002\u0006\u0010=\u001a\u00020>2\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u000108H\u0016J\"\u0010A\u001a\u0002002\u0006\u0010?\u001a\u00020@2\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u000108H\u0016J\b\u0010B\u001a\u000200H\u0016J\b\u0010C\u001a\u000200H\u0002J\u0018\u0010D\u001a\u0002002\u0006\u0010E\u001a\u00020\u00032\u0006\u0010D\u001a\u00020FH\u0016J\u0016\u0010\u000f\u001a\u0002002\f\u0010G\u001a\b\u0012\u0004\u0012\u0002000HH\u0002J\b\u0010I\u001a\u000200H\u0002J\u0018\u0010J\u001a\u0002002\u0006\u0010E\u001a\u00020\u00032\u0006\u0010K\u001a\u00020LH\u0016J\u0018\u0010M\u001a\u0002002\u0006\u0010N\u001a\u00020\u00072\u0006\u0010O\u001a\u00020\u0003H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010E\u001a\u00020\u0003H\u0016J\b\u0010P\u001a\u000200H\u0016J\b\u0010Q\u001a\u000200H\u0016J\b\u0010R\u001a\u000200H\u0016J\b\u0010S\u001a\u000200H\u0016J\b\u0010T\u001a\u000208H\u0016J\b\u0010U\u001a\u000200H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010 R\u0014\u0010'\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010 R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010$R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$\u00a8\u0006W"}, d2={"Lorg/openrndr/internal/gl3/RenderTargetGL3;", "Lorg/openrndr/draw/RenderTarget;", "framebuffer", "", "width", "height", "contentScale", "", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "session", "Lorg/openrndr/draw/Session;", "thread", "Ljava/lang/Thread;", "(IIIDLorg/openrndr/draw/BufferMultisample;Lorg/openrndr/draw/Session;Ljava/lang/Thread;)V", "bound", "", "colorAttachments", "", "Lorg/openrndr/draw/ColorAttachment;", "getColorAttachments", "()Ljava/util/List;", "getContentScale", "()D", "depthBuffer", "Lorg/openrndr/draw/DepthBuffer;", "getDepthBuffer", "()Lorg/openrndr/draw/DepthBuffer;", "setDepthBuffer", "(Lorg/openrndr/draw/DepthBuffer;)V", "destroyed", "getDestroyed", "()Z", "setDestroyed", "(Z)V", "getFramebuffer", "()I", "hasColorAttachments", "getHasColorAttachments", "hasDepthBuffer", "getHasDepthBuffer", "getHeight", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "getSession", "()Lorg/openrndr/draw/Session;", "getWidth", "attach", "", "arrayCubemap", "Lorg/openrndr/draw/ArrayCubemap;", "side", "Lorg/openrndr/draw/CubemapSide;", "layer", "level", "name", "", "arrayTexture", "Lorg/openrndr/draw/ArrayTexture;", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "cubemap", "Lorg/openrndr/draw/Cubemap;", "volumeTexture", "Lorg/openrndr/draw/VolumeTexture;", "attachLayered", "bind", "bindTarget", "blendMode", "index", "Lorg/openrndr/draw/BlendMode;", "function", "Lkotlin/Function0;", "checkFramebufferStatus", "clearColor", "color", "Lorg/openrndr/color/ColorRGBa;", "clearDepth", "depth", "stencil", "destroy", "detachColorAttachments", "detachColorBuffers", "detachDepthBuffer", "toString", "unbind", "Companion", "openrndr-gl3"})
public class RenderTargetGL3
implements RenderTarget {
    private boolean destroyed;
    @NotNull
    private final List<ColorAttachment> colorAttachments;
    @Nullable
    private DepthBuffer depthBuffer;
    private boolean bound;
    private final int framebuffer;
    private final int width;
    private final int height;
    private final double contentScale;
    @NotNull
    private final BufferMultisample multisample;
    @Nullable
    private final Session session;
    private final Thread thread;
    public static final Companion Companion = new Companion(null);

    public final boolean getDestroyed() {
        return this.destroyed;
    }

    public final void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    @Override
    @NotNull
    public List<ColorAttachment> getColorAttachments() {
        return this.colorAttachments;
    }

    @Override
    @Nullable
    public DepthBuffer getDepthBuffer() {
        return this.depthBuffer;
    }

    public void setDepthBuffer(@Nullable DepthBuffer depthBuffer) {
        this.depthBuffer = depthBuffer;
    }

    @Override
    public boolean getHasColorAttachments() {
        Collection collection = this.getColorAttachments();
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Override
    public boolean getHasDepthBuffer() {
        return this.getDepthBuffer() != null;
    }

    @Override
    @NotNull
    public ColorBuffer colorBuffer(int index) {
        Object object;
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ColorAttachment colorAttachment = this.getColorAttachments().get(index);
        if (!(colorAttachment instanceof ColorBufferAttachment)) {
            colorAttachment = null;
        }
        if ((object = (ColorBufferAttachment)colorAttachment) == null || (object = ((ColorBufferAttachment)object).getColorBuffer()) == null) {
            String string = "attachment at " + index + " is not a ColorBuffer";
            bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bind() {
        Object object;
        void $this$getOrPut$iv;
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.bound) {
            throw (Throwable)new RuntimeException("already bound");
        }
        Map map2 = RenderTargetGL3Kt.access$getActive$p();
        Long key$iv = GLFW.glfwGetCurrentContext();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl6 = false;
            Stack answer$iv = new Stack();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Stack stack = (Stack)object;
        stack.push(this);
        this.bindTarget();
    }

    /*
     * WARNING - void declaration
     */
    private final void bindTarget() {
        ErrorGL3Kt.debugGLErrors(bindTarget.1.INSTANCE);
        GL33C.glBindFramebuffer(36160, this.framebuffer);
        if (Intrinsics.areEqual(Thread.currentThread(), this.thread) ^ true) {
            throw (Throwable)new IllegalStateException("this render target is created by " + this.thread + " and cannot be bound to " + Thread.currentThread());
        }
        ErrorGL3Kt.debugGLErrors(bindTarget.2.INSTANCE);
        Collection collection = this.getColorAttachments();
        boolean bl = false;
        if (!collection.isEmpty()) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = this.getColorAttachments();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                int n = index$iv$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ColorAttachment colorAttachment = (ColorAttachment)item$iv$iv;
                int n2 = n;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                Integer n3 = 36064 + index;
                collection2.add(n3);
            }
            int[] drawBuffers = CollectionsKt.toIntArray((List)destination$iv$iv);
            GL33C.glDrawBuffers(drawBuffers);
            ErrorGL3Kt.debugGLErrors(bindTarget.3.INSTANCE);
        }
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        int effectiveHeight = (int)((double)this.getHeight() * this.getContentScale());
        RenderTargetGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(effectiveWidth, effectiveHeight){
            final /* synthetic */ int $effectiveWidth;
            final /* synthetic */ int $effectiveHeight;

            @Nullable
            public final Object invoke() {
                return "setting viewport to (0, 0, " + this.$effectiveWidth + ", " + this.$effectiveHeight + ')';
            }
            {
                this.$effectiveWidth = n;
                this.$effectiveHeight = n2;
                super(0);
            }
        });
        GL33C.glViewport(0, 0, effectiveWidth, effectiveHeight);
        ErrorGL3Kt.debugGLErrors(bindTarget.5.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unbind() {
        RenderTargetGL3 previous;
        if (!this.bound) {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = RenderTargetGL3Kt.access$getActive$p();
            Long key$iv = GLFW.glfwGetCurrentContext();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Stack answer$iv = new Stack();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Stack it = (Stack)((Object)map2);
            boolean bl3 = false;
            it.pop();
            previous = (RenderTargetGL3)it.peek();
            if (previous == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
        } else {
            throw (Throwable)new RuntimeException("target not bound");
        }
        RenderTargetGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(previous){
            final /* synthetic */ RenderTargetGL3 $previous;

            @Nullable
            public final Object invoke() {
                return "restoring to previous render target " + this.$previous;
            }
            {
                this.$previous = renderTargetGL3;
                super(0);
            }
        });
        previous.bindTarget();
    }

    @Override
    public void attach(@NotNull ColorBuffer colorBuffer, int level, @Nullable String name) {
        Intrinsics.checkNotNullParameter(colorBuffer, "colorBuffer");
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int div = 1 << level;
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        int effectiveHeight = (int)((double)this.getHeight() * this.getContentScale());
        if (colorBuffer.getEffectiveWidth() / div != effectiveWidth || colorBuffer.getEffectiveHeight() / div != effectiveHeight) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + this.getWidth() + " x " + this.getHeight() + " @" + colorBuffer.getContentScale() + "x, got: (" + colorBuffer.getWidth() / div + " x " + colorBuffer.getHeight() / div + " @" + colorBuffer.getContentScale() + "x level:" + level + ')');
        }
        ColorBufferGL3 cfr_ignored_0 = (ColorBufferGL3)colorBuffer;
        GL33C.glFramebufferTexture2D(36160, 36064 + this.getColorAttachments().size(), ((ColorBufferGL3)colorBuffer).getTarget(), ((ColorBufferGL3)colorBuffer).getTexture(), level);
        ErrorGL3Kt.debugGLErrors(attach.1.INSTANCE);
        this.getColorAttachments().add(new ColorBufferAttachment(this.getColorAttachments().size(), name, colorBuffer, level));
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    @Override
    public void attach(@NotNull ArrayCubemap arrayCubemap, @NotNull CubemapSide side, int layer, int level, @Nullable String name) {
        Intrinsics.checkNotNullParameter(arrayCubemap, "arrayCubemap");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        if (arrayCubemap.getWidth() != effectiveWidth || arrayCubemap.getWidth() != this.getEffectiveHeight()) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + effectiveWidth + " x " + this.getEffectiveHeight() + "), got: (" + arrayCubemap.getWidth() + " x " + arrayCubemap.getWidth());
        }
        ArrayCubemapGL4 cfr_ignored_0 = (ArrayCubemapGL4)arrayCubemap;
        GL33C.glFramebufferTextureLayer(36160, 36064 + this.getColorAttachments().size(), ((ArrayCubemapGL4)arrayCubemap).getTexture(), level, layer * 6 + side.ordinal());
        ErrorGL3Kt.checkGLErrors(attach.2.INSTANCE);
        this.getColorAttachments().add(new ArrayCubemapAttachment(this.getColorAttachments().size(), name, arrayCubemap, side, layer, level));
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    @Override
    public void attach(@NotNull Cubemap cubemap, @NotNull CubemapSide side, int level, @Nullable String name) {
        Intrinsics.checkNotNullParameter(cubemap, "cubemap");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        int div = 1 << level;
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        if (cubemap.getWidth() / div != effectiveWidth || cubemap.getWidth() / div != this.getEffectiveHeight()) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + effectiveWidth + " x " + this.getEffectiveHeight() + "), got: (" + cubemap.getWidth() + " x " + cubemap.getWidth() + ')');
        }
        CubemapGL3 cfr_ignored_0 = (CubemapGL3)cubemap;
        GL33C.glFramebufferTexture2D(36160, 36064 + this.getColorAttachments().size(), CubemapGL3Kt.getGlTextureTarget(side), ((CubemapGL3)cubemap).getTexture(), level);
        ErrorGL3Kt.checkGLErrors(attach.3.INSTANCE);
        this.getColorAttachments().add(new CubemapAttachment(this.getColorAttachments().size(), name, cubemap, side, level));
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    @Override
    public void attach(@NotNull VolumeTexture volumeTexture, int layer, int level, @Nullable String name) {
        Intrinsics.checkNotNullParameter(volumeTexture, "volumeTexture");
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = level >= 0 && level < volumeTexture.getDepth();
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        int effectiveHeight = (int)((double)this.getHeight() * this.getContentScale());
        if (volumeTexture.getWidth() != effectiveWidth || volumeTexture.getHeight() != effectiveHeight) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + effectiveWidth + " x " + effectiveHeight + "), got: (" + volumeTexture.getWidth() + " x " + volumeTexture.getHeight());
        }
        VolumeTextureGL3 cfr_ignored_0 = (VolumeTextureGL3)volumeTexture;
        GL33C.glFramebufferTextureLayer(36160, 36064 + this.getColorAttachments().size(), ((VolumeTextureGL3)volumeTexture).getTexture(), level, layer);
        ErrorGL3Kt.debugGLErrors(attach.4.INSTANCE);
        this.getColorAttachments().add(new VolumeTextureAttachment(this.getColorAttachments().size(), name, volumeTexture, layer, level));
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    @Override
    public void attachLayered(@NotNull ArrayTexture arrayTexture, int level, @Nullable String name) {
        Intrinsics.checkNotNullParameter(arrayTexture, "arrayTexture");
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        int effectiveHeight = (int)((double)this.getHeight() * this.getContentScale());
        if (arrayTexture.getWidth() != effectiveWidth || arrayTexture.getHeight() != effectiveHeight) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + effectiveWidth + " x " + effectiveHeight + "), got: (" + arrayTexture.getWidth() + " x " + arrayTexture.getHeight());
        }
        ArrayTextureGL3 cfr_ignored_0 = (ArrayTextureGL3)arrayTexture;
        GL33C.glFramebufferTexture(36160, 36064 + this.getColorAttachments().size(), ((ArrayTextureGL3)arrayTexture).getTexture(), level);
        ErrorGL3Kt.debugGLErrors(attachLayered.1.INSTANCE);
        this.getColorAttachments().add(new LayeredArrayTextureAttachment(this.getColorAttachments().size(), name, arrayTexture, level));
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    @Override
    public void attachLayered(@NotNull ArrayCubemap arrayCubemap, int level, @Nullable String name) {
        Intrinsics.checkNotNullParameter(arrayCubemap, "arrayCubemap");
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        if (arrayCubemap.getWidth() != effectiveWidth || arrayCubemap.getWidth() != this.getEffectiveHeight()) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + effectiveWidth + " x " + this.getEffectiveHeight() + "), got: (" + arrayCubemap.getWidth() + " x " + arrayCubemap.getWidth());
        }
        ArrayCubemapGL4 cfr_ignored_0 = (ArrayCubemapGL4)arrayCubemap;
        GL33C.glFramebufferTexture(36160, 36064 + this.getColorAttachments().size(), ((ArrayCubemapGL4)arrayCubemap).getTexture(), level);
        ErrorGL3Kt.checkGLErrors(attachLayered.2.INSTANCE);
        this.getColorAttachments().add(new LayeredArrayCubemapAttachment(this.getColorAttachments().size(), name, arrayCubemap, level));
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    @Override
    public void attachLayered(@NotNull Cubemap cubemap, int level, @Nullable String name) {
        Intrinsics.checkNotNullParameter(cubemap, "cubemap");
        int div = 1 << level;
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        if (cubemap.getWidth() / div != effectiveWidth || cubemap.getWidth() / div != this.getEffectiveHeight()) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + effectiveWidth + " x " + this.getEffectiveHeight() + "), got: (" + cubemap.getWidth() + " x " + cubemap.getWidth() + ')');
        }
        CubemapGL3 cfr_ignored_0 = (CubemapGL3)cubemap;
        GL33C.glFramebufferTexture(36160, 36064 + this.getColorAttachments().size(), ((CubemapGL3)cubemap).getTexture(), level);
        ErrorGL3Kt.checkGLErrors(attachLayered.3.INSTANCE);
        this.getColorAttachments().add(new LayeredCubemapAttachment(this.getColorAttachments().size(), name, cubemap, level));
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    @Override
    public void attachLayered(@NotNull VolumeTexture volumeTexture, int level, @Nullable String name) {
        Intrinsics.checkNotNullParameter(volumeTexture, "volumeTexture");
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = level >= 0 && level < volumeTexture.getDepth();
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        int effectiveHeight = (int)((double)this.getHeight() * this.getContentScale());
        if (volumeTexture.getWidth() != effectiveWidth || volumeTexture.getHeight() != effectiveHeight) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + effectiveWidth + " x " + effectiveHeight + "), got: (" + volumeTexture.getWidth() + " x " + volumeTexture.getHeight());
        }
        VolumeTextureGL3 cfr_ignored_0 = (VolumeTextureGL3)volumeTexture;
        GL33C.glFramebufferTexture(36160, 36064 + this.getColorAttachments().size(), ((VolumeTextureGL3)volumeTexture).getTexture(), level);
        ErrorGL3Kt.debugGLErrors(attachLayered.4.INSTANCE);
        this.getColorAttachments().add(new LayeredVolumeTextureAttachment(this.getColorAttachments().size(), name, volumeTexture, level));
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    @Override
    public void attach(@NotNull ArrayTexture arrayTexture, int layer, int level, @Nullable String name) {
        Intrinsics.checkNotNullParameter(arrayTexture, "arrayTexture");
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        int effectiveHeight = (int)((double)this.getHeight() * this.getContentScale());
        if (arrayTexture.getWidth() != effectiveWidth || arrayTexture.getHeight() != effectiveHeight) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + effectiveWidth + " x " + effectiveHeight + "), got: (" + arrayTexture.getWidth() + " x " + arrayTexture.getHeight());
        }
        ArrayTextureGL3 cfr_ignored_0 = (ArrayTextureGL3)arrayTexture;
        GL33C.glFramebufferTextureLayer(36160, 36064 + this.getColorAttachments().size(), ((ArrayTextureGL3)arrayTexture).getTexture(), level, layer);
        ErrorGL3Kt.debugGLErrors(attach.5.INSTANCE);
        this.getColorAttachments().add(new ArrayTextureAttachment(this.getColorAttachments().size(), name, arrayTexture, layer, level));
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    @Override
    public void blendMode(int index, @NotNull BlendMode blendMode) {
        Intrinsics.checkNotNullParameter((Object)blendMode, "blendMode");
        switch (RenderTargetGL3$WhenMappings.$EnumSwitchMapping$0[blendMode.ordinal()]) {
            case 1: {
                GL33C.glEnable(3042);
                GL40C.glBlendEquationi(index, 32774);
                GL40C.glBlendFunci(index, 1, 771);
                break;
            }
            case 2: {
                GL33C.glEnable(3042);
                GL40C.glBlendEquationi(0, 32774);
                GL40C.glBlendFunci(0, 770, 771);
                break;
            }
            case 3: {
                GL33C.glEnable(3042);
                GL40C.glBlendEquationi(index, 32774);
                GL40C.glBlendFunci(index, 1, 0);
                break;
            }
            default: {
                String string = "unsupported blend mode: " + (Object)((Object)blendMode);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
    }

    private final void bound(Function0<Unit> function2) {
        this.bind();
        function2.invoke();
        this.unbind();
    }

    @Override
    public void clearColor(int index, @NotNull ColorRGBa color) {
        Intrinsics.checkNotNullParameter(color, "color");
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.bound(new Function0<Unit>(color, index){
            final /* synthetic */ ColorRGBa $color;
            final /* synthetic */ int $index;

            public final void invoke() {
                float[] ca = new float[]{(float)this.$color.getR(), (float)this.$color.getG(), (float)this.$color.getB(), (float)this.$color.getA()};
                GL33C.glClearBufferfv(6144, this.$index, ca);
            }
            {
                this.$color = colorRGBa;
                this.$index = n;
                super(0);
            }
        });
    }

    @Override
    public void clearDepth(double depth, int stencil) {
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.bound(new Function0<Unit>(depth, stencil){
            final /* synthetic */ double $depth;
            final /* synthetic */ int $stencil;

            public final void invoke() {
                GL33C.glClearBufferfi(34041, 0, (float)this.$depth, this.$stencil);
                ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            }
            {
                this.$depth = d;
                this.$stencil = n;
                super(0);
            }
        });
    }

    @Override
    public void attach(@NotNull DepthBuffer depthBuffer) {
        Intrinsics.checkNotNullParameter(depthBuffer, "depthBuffer");
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (depthBuffer.getWidth() != this.getEffectiveWidth() || depthBuffer.getHeight() != this.getEffectiveHeight()) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch");
        }
        if (Intrinsics.areEqual(depthBuffer.getMultisample(), this.getMultisample()) ^ true) {
            throw (Throwable)new IllegalArgumentException("buffer multisample mismatch");
        }
        this.bound(new Function0<Unit>(this, depthBuffer){
            final /* synthetic */ RenderTargetGL3 this$0;
            final /* synthetic */ DepthBuffer $depthBuffer;

            public final void invoke() {
                DepthBuffer depthBuffer = this.$depthBuffer;
                if (depthBuffer == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.DepthBufferGL3");
                }
                DepthBufferGL3 cfr_ignored_0 = (DepthBufferGL3)depthBuffer;
                GL33C.glFramebufferTexture2D(36160, 36096, ((DepthBufferGL3)this.$depthBuffer).getTarget(), ((DepthBufferGL3)this.$depthBuffer).getTexture(), 0);
                ErrorGL3Kt.checkGLErrors(attach.1.INSTANCE);
                if (this.$depthBuffer.getHasStencil()) {
                    GL33C.glFramebufferTexture2D(36160, 36128, ((DepthBufferGL3)this.$depthBuffer).getTarget(), ((DepthBufferGL3)this.$depthBuffer).getTexture(), 0);
                    ErrorGL3Kt.checkGLErrors(attach.2.INSTANCE);
                }
                this.this$0.setDepthBuffer(this.$depthBuffer);
                RenderTargetGL3.access$checkFramebufferStatus(this.this$0);
            }
            {
                this.this$0 = renderTargetGL3;
                this.$depthBuffer = depthBuffer;
                super(0);
            }
        });
    }

    @Override
    public void detachDepthBuffer() {
        block2: {
            boolean bl = !this.destroyed;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            DepthBuffer depthBuffer = this.getDepthBuffer();
            if (depthBuffer == null) break block2;
            DepthBuffer depthBuffer2 = depthBuffer;
            bl2 = false;
            bl3 = false;
            DepthBuffer it = depthBuffer2;
            boolean bl6 = false;
            DepthBuffer depthBuffer3 = it;
            if (depthBuffer3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.DepthBufferGL3");
            }
            DepthBufferGL3 cfr_ignored_0 = (DepthBufferGL3)depthBuffer3;
            this.bound(new Function0<Unit>(it){
                final /* synthetic */ DepthBuffer $it;

                public final void invoke() {
                    GL33C.glFramebufferTexture2D(36160, 36096, ((DepthBufferGL3)this.$it).getTarget(), 0, 0);
                    GL33C.glFramebufferTexture2D(36160, 36128, ((DepthBufferGL3)this.$it).getTarget(), 0, 0);
                    ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                }
                {
                    this.$it = depthBuffer;
                    super(0);
                }
            });
        }
    }

    private final void checkFramebufferStatus() {
        int status = GL33C.glCheckFramebufferStatus(36160);
        if (status != 36053) {
            switch (status) {
                case 33305: {
                    throw (Throwable)new GL3Exception("Framebuffer undefined");
                }
                case 36054: {
                    throw (Throwable)new GL3Exception("Attachment incomplete");
                }
                case 36055: {
                    throw (Throwable)new GL3Exception("Attachment missing");
                }
                case 36059: {
                    throw (Throwable)new GL3Exception("Incomplete draw buffer");
                }
            }
            throw (Throwable)new GL3Exception("error creating framebuffer " + status);
        }
        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
    }

    @Override
    public void detachColorAttachments() {
        boolean bl = !this.destroyed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.bound(new Function0<Unit>(this){
            final /* synthetic */ RenderTargetGL3 this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                boolean bl = false;
                for (ColorAttachment attachment : (Iterable)this.this$0.getColorAttachments()) {
                    void index;
                    GL33C.glFramebufferTexture2D(36160, 36064 + index, 3553, 0, 0);
                    ++index;
                }
            }
            {
                this.this$0 = renderTargetGL3;
                super(0);
            }
        });
        this.getColorAttachments().clear();
    }

    @Override
    public void detachColorBuffers() {
        this.detachColorAttachments();
    }

    @Override
    public void destroy() {
        Session session = this.getSession();
        if (session != null) {
            session.untrack(this);
        }
        this.destroyed = true;
        GL33C.glDeleteFramebuffers(this.framebuffer);
    }

    @NotNull
    public String toString() {
        return "RenderTargetGL3(framebuffer=" + this.framebuffer + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", contentScale=" + this.getContentScale() + ", multisample=" + this.getMultisample() + ", session=" + this.getSession() + ", destroyed=" + this.destroyed + ", colorAttachments=" + this.getColorAttachments() + ", depthBuffer=" + this.getDepthBuffer() + ')';
    }

    public final int getFramebuffer() {
        return this.framebuffer;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public double getContentScale() {
        return this.contentScale;
    }

    @Override
    @NotNull
    public BufferMultisample getMultisample() {
        return this.multisample;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    public RenderTargetGL3(int framebuffer, int width, int height, double contentScale, @NotNull BufferMultisample multisample, @Nullable Session session, @NotNull Thread thread2) {
        Intrinsics.checkNotNullParameter(multisample, "multisample");
        Intrinsics.checkNotNullParameter(thread2, "thread");
        this.framebuffer = framebuffer;
        this.width = width;
        this.height = height;
        this.contentScale = contentScale;
        this.multisample = multisample;
        this.session = session;
        this.thread = thread2;
        boolean bl = false;
        this.colorAttachments = new ArrayList();
    }

    public /* synthetic */ RenderTargetGL3(int n, int n2, int n3, double d, BufferMultisample bufferMultisample, Session session, Thread thread2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x40) != 0) {
            Thread thread3 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread3, "Thread.currentThread()");
            thread2 = thread3;
        }
        this(n, n2, n3, d, bufferMultisample, session, thread2);
    }

    @Override
    public int getEffectiveHeight() {
        return RenderTarget.DefaultImpls.getEffectiveHeight(this);
    }

    @Override
    public int getEffectiveWidth() {
        return RenderTarget.DefaultImpls.getEffectiveWidth(this);
    }

    @Override
    @Nullable
    public ColorAttachment colorAttachmentByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return RenderTarget.DefaultImpls.colorAttachmentByName(this, name);
    }

    @Override
    @Nullable
    public Integer colorAttachmentIndexByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return RenderTarget.DefaultImpls.colorAttachmentIndexByName(this, name);
    }

    @Override
    public void resolveTo(@NotNull RenderTarget to) {
        Intrinsics.checkNotNullParameter(to, "to");
        RenderTarget.DefaultImpls.resolveTo(this, to);
    }

    public static final /* synthetic */ void access$checkFramebufferStatus(RenderTargetGL3 $this) {
        $this.checkFramebufferStatus();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/openrndr/internal/gl3/RenderTargetGL3$Companion;", "", "()V", "activeRenderTarget", "Lorg/openrndr/internal/gl3/RenderTargetGL3;", "getActiveRenderTarget", "()Lorg/openrndr/internal/gl3/RenderTargetGL3;", "create", "width", "", "height", "contentScale", "", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    public static final class Companion {
        @NotNull
        public final RenderTargetGL3 create(int width, int height, double contentScale, @NotNull BufferMultisample multisample, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(multisample, "multisample");
            RenderTargetGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(width, height, contentScale, multisample){
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ double $contentScale;
                final /* synthetic */ BufferMultisample $multisample;

                @Nullable
                public final Object invoke() {
                    return "created new render target (" + this.$width + '*' + this.$height + ") @ " + this.$contentScale + "x " + this.$multisample;
                }
                {
                    this.$width = n;
                    this.$height = n2;
                    this.$contentScale = d;
                    this.$multisample = bufferMultisample;
                    super(0);
                }
            });
            int framebuffer = GL33C.glGenFramebuffers();
            return new RenderTargetGL3(framebuffer, width, height, contentScale, multisample, session, null, 64, null);
        }

        public static /* synthetic */ RenderTargetGL3 create$default(Companion companion, int n, int n2, double d, BufferMultisample bufferMultisample, Session session, int n3, Object object) {
            if ((n3 & 4) != 0) {
                d = 1.0;
            }
            if ((n3 & 8) != 0) {
                bufferMultisample = BufferMultisample.Disabled.INSTANCE;
            }
            return companion.create(n, n2, d, bufferMultisample, session);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final RenderTargetGL3 getActiveRenderTarget() {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = RenderTargetGL3Kt.access$getActive$p();
            Long key$iv = GLFW.glfwGetCurrentContext();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Stack answer$iv = new Stack();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Stack stack = (Stack)object;
            Object e = stack.peek();
            Intrinsics.checkNotNullExpressionValue(e, "stack.peek()");
            return (RenderTargetGL3)e;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

