/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL33C;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Session;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.VertexBufferGL3;
import org.openrndr.internal.gl3.VertexBufferGL3Kt;
import org.openrndr.internal.gl3.VertexBufferShadowGL3;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020$H\u0016J\u0018\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0006\u0010,\u001a\u00020$J\u0018\u0010-\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006/"}, d2={"Lorg/openrndr/internal/gl3/VertexBufferGL3;", "Lorg/openrndr/draw/VertexBuffer;", "buffer", "", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "vertexCount", "session", "Lorg/openrndr/draw/Session;", "(ILorg/openrndr/draw/VertexFormat;ILorg/openrndr/draw/Session;)V", "getBuffer", "()I", "bufferHash", "getBufferHash$openrndr_gl3", "isDestroyed", "", "isDestroyed$openrndr_gl3", "()Z", "setDestroyed$openrndr_gl3", "(Z)V", "realShadow", "Lorg/openrndr/internal/gl3/VertexBufferShadowGL3;", "getRealShadow$openrndr_gl3", "()Lorg/openrndr/internal/gl3/VertexBufferShadowGL3;", "setRealShadow$openrndr_gl3", "(Lorg/openrndr/internal/gl3/VertexBufferShadowGL3;)V", "getSession", "()Lorg/openrndr/draw/Session;", "shadow", "Lorg/openrndr/draw/VertexBufferShadow;", "getShadow", "()Lorg/openrndr/draw/VertexBufferShadow;", "getVertexCount", "getVertexFormat", "()Lorg/openrndr/draw/VertexFormat;", "bind", "", "destroy", "read", "data", "Ljava/nio/ByteBuffer;", "offset", "toString", "", "unbind", "write", "Companion", "openrndr-gl3"})
public final class VertexBufferGL3
implements VertexBuffer {
    private final int bufferHash;
    @Nullable
    private VertexBufferShadowGL3 realShadow;
    private boolean isDestroyed;
    private final int buffer;
    @NotNull
    private final VertexFormat vertexFormat;
    private final int vertexCount;
    @Nullable
    private final Session session;
    public static final Companion Companion = new Companion(null);

    public final int getBufferHash$openrndr_gl3() {
        return this.bufferHash;
    }

    @Nullable
    public final VertexBufferShadowGL3 getRealShadow$openrndr_gl3() {
        return this.realShadow;
    }

    public final void setRealShadow$openrndr_gl3(@Nullable VertexBufferShadowGL3 vertexBufferShadowGL3) {
        this.realShadow = vertexBufferShadowGL3;
    }

    public final boolean isDestroyed$openrndr_gl3() {
        return this.isDestroyed;
    }

    public final void setDestroyed$openrndr_gl3(boolean bl) {
        this.isDestroyed = bl;
    }

    @NotNull
    public String toString() {
        return "VertexBufferGL3(vertexFormat: " + this.getVertexFormat() + ", vertexCount: " + this.getVertexCount() + ", buffer: " + this.buffer + ", session: " + this.getSession() + ')';
    }

    @Override
    @NotNull
    public VertexBufferShadow getShadow() {
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        if (this.realShadow == null) {
            this.realShadow = new VertexBufferShadowGL3(this);
        }
        VertexBufferShadowGL3 vertexBufferShadowGL3 = this.realShadow;
        Intrinsics.checkNotNull(vertexBufferShadowGL3);
        return vertexBufferShadowGL3;
    }

    @Override
    public void write(@NotNull ByteBuffer data2, int offset2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        if (data2.isDirect()) {
            VertexBufferGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(data2){
                final /* synthetic */ ByteBuffer $data;

                @Nullable
                public final Object invoke() {
                    return "writing to vertex buffer, " + this.$data.remaining() + " bytes";
                }
                {
                    this.$data = byteBuffer;
                    super(0);
                }
            });
            ((Buffer)data2).rewind();
            ErrorGL3Kt.debugGLErrors$default(null, 1, null);
            this.bind();
            ErrorGL3Kt.debugGLErrors$default(null, 1, null);
            GL33C.glBufferSubData(34962, (long)offset2, data2);
            ErrorGL3Kt.checkGLErrors((Function1<? super Integer, String>)new Function1<Integer, String>(this, offset2){
                final /* synthetic */ VertexBufferGL3 this$0;
                final /* synthetic */ int $offset;

                @Nullable
                public final String invoke(int it) {
                    String string;
                    int[] vertexArrayBinding = new int[1];
                    GL33C.glGetIntegerv(34229, vertexArrayBinding);
                    int[] arrayBufferBinding = new int[1];
                    GL33C.glGetIntegerv(34964, arrayBufferBinding);
                    boolean isBuffer = GL33C.glIsBuffer(this.this$0.getBuffer());
                    switch (it) {
                        case 1282: {
                            string = "zero is bound to target. (is buffer: " + isBuffer + ", GL_VERTEX_ARRAY_BINDING: " + vertexArrayBinding[0] + ", GL_ARRAY_BUFFER_BINDING: " + arrayBufferBinding[0] + ')';
                            break;
                        }
                        case 1281: {
                            string = "offset (" + this.$offset + ") or size is negative, or offset+sizeoffset+size is greater than the value of GL_BUFFER_SIZE for the specified buffer object.";
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    return string;
                }
                {
                    this.this$0 = vertexBufferGL3;
                    this.$offset = n;
                    super(1);
                }
            });
        } else {
            ByteBuffer temp = BufferUtils.createByteBuffer(data2.capacity());
            temp.put(data2);
            ByteBuffer byteBuffer = temp;
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "temp");
            this.write(byteBuffer, offset2);
        }
    }

    @Override
    public void read(@NotNull ByteBuffer data2, int offset2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        if (data2.isDirect()) {
            this.bind();
            GL33C.glGetBufferSubData(34962, (long)offset2, data2);
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
        } else {
            ByteBuffer temp;
            ByteBuffer byteBuffer = temp = BufferUtils.createByteBuffer(data2.capacity());
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "temp");
            this.read(byteBuffer, offset2);
            data2.put(temp);
        }
    }

    @Override
    public void destroy() {
        VertexBufferGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(this){
            final /* synthetic */ VertexBufferGL3 this$0;

            @Nullable
            public final Object invoke() {
                return "destroying vertex buffer with id " + this.this$0.getBuffer();
            }
            {
                this.this$0 = vertexBufferGL3;
                super(0);
            }
        });
        Session session = this.getSession();
        if (session != null) {
            session.untrack(this);
        }
        this.isDestroyed = true;
        GL33C.glDeleteBuffers(this.buffer);
        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
        Session.Companion.getActive().untrack(this);
    }

    public final void bind() {
        if (this.isDestroyed) {
            throw (Throwable)new IllegalStateException("buffer is destroyed");
        }
        VertexBufferGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<Object>(this){
            final /* synthetic */ VertexBufferGL3 this$0;

            @Nullable
            public final Object invoke() {
                return "binding vertex buffer " + this.this$0.getBuffer();
            }
            {
                this.this$0 = vertexBufferGL3;
                super(0);
            }
        });
        GL33C.glBindBuffer(34962, this.buffer);
        ErrorGL3Kt.debugGLErrors$default(null, 1, null);
    }

    public final void unbind() {
        VertexBufferGL3Kt.access$getLogger$p().trace(unbind.1.INSTANCE);
        GL33C.glBindBuffer(34962, 0);
        ErrorGL3Kt.debugGLErrors$default(null, 1, null);
    }

    public final int getBuffer() {
        return this.buffer;
    }

    @Override
    @NotNull
    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    public VertexBufferGL3(int buffer2, @NotNull VertexFormat vertexFormat2, int vertexCount2, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(vertexFormat2, "vertexFormat");
        this.buffer = buffer2;
        this.vertexFormat = vertexFormat2;
        this.vertexCount = vertexCount2;
        this.session = session;
        this.bufferHash = VertexBufferGL3Kt.access$getBufferId$p().getAndAdd(1);
    }

    @Override
    public int put(int elementOffset, @NotNull Function1<? super BufferWriter, Unit> putter) {
        Intrinsics.checkNotNullParameter(putter, "putter");
        return VertexBuffer.DefaultImpls.put(this, elementOffset, putter);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/internal/gl3/VertexBufferGL3$Companion;", "", "()V", "createDynamic", "Lorg/openrndr/internal/gl3/VertexBufferGL3;", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "vertexCount", "", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    public static final class Companion {
        @NotNull
        public final VertexBufferGL3 createDynamic(@NotNull VertexFormat vertexFormat2, int vertexCount2, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(vertexFormat2, "vertexFormat");
            ErrorGL3Kt.checkGLErrors(createDynamic.1.INSTANCE);
            int buffer2 = GL33C.glGenBuffers();
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            VertexBufferGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<Object>(buffer2){
                final /* synthetic */ int $buffer;

                @Nullable
                public final Object invoke() {
                    return "created new vertex buffer with id " + this.$buffer;
                }
                {
                    this.$buffer = n;
                    super(0);
                }
            });
            GL33C.glBindBuffer(34962, buffer2);
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            int sizeInBytes = vertexFormat2.getSize() * vertexCount2;
            GL33C.nglBufferData(34962, sizeInBytes, 0L, 35048);
            ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            return new VertexBufferGL3(buffer2, vertexFormat2, vertexCount2, session);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

