/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.LinearType;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\u001aC\u0010\u0000\u001a\u0002H\u0001\"\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0006\u0010\u0003\u001a\u0002H\u00012\u0006\u0010\u0004\u001a\u0002H\u00012\u0006\u0010\u0005\u001a\u0002H\u00012\u0006\u0010\u0006\u001a\u0002H\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u001a;\u0010\u0000\u001a\u0002H\u0001\"\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0006\u0010\u0003\u001a\u0002H\u00012\u0006\u0010\u0004\u001a\u0002H\u00012\u0006\u0010\u0006\u001a\u0002H\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\n\u001a&\u0010\u0000\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0000\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\u0000\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0000\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\u0000\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0000\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\r\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0014\u001a&\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0017"}, d2={"bezier", "T", "Lorg/openrndr/math/LinearType;", "x0", "c0", "c1", "x1", "t", "", "(Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;D)Lorg/openrndr/math/LinearType;", "(Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;D)Lorg/openrndr/math/LinearType;", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "derivative", "p0", "p1", "p2", "p3", "normal", "roots", "", "p", "safeDerivative", "openrndr-math"})
public final class BezierKt {
    public static final double bezier(double x0, double c0, double x1, double t2) {
        double it = 1.0 - t2;
        double it2 = it * it;
        double t22 = t2 * t2;
        return it2 * x0 + 2.0 * it * t2 * c0 + t22 * x1;
    }

    public static final double derivative(double x0, double c0, double x1, double t2) {
        double it = 1.0 - t2;
        return 2.0 * it * (c0 - x0) + 2.0 * t2 * (x1 - c0);
    }

    @NotNull
    public static final Vector2 derivative(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 x1, double t2) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t2;
        return new Vector2((double)2 * it * (c0.getX() - x0.getX()) + (double)2 * t2 * (x1.getX() - c0.getX()), (double)2 * it * (c0.getY() - x0.getY()) + (double)2 * t2 * (x1.getY() - c0.getY()));
    }

    @NotNull
    public static final Vector2 safeDerivative(@NotNull Vector2 p0, @NotNull Vector2 c0, @NotNull Vector2 p1, double t2) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        double epsilon = 1.0E-5;
        double u = t2;
        Vector2 d10 = c0.minus(p0);
        Vector2 d21 = c0.minus(p1);
        if (u < epsilon && d10.getSquaredLength() < epsilon) {
            u = epsilon;
        }
        if (u > 1.0 - epsilon && d21.getSquaredLength() < epsilon) {
            u = 1.0 - epsilon;
        }
        double iu = 1.0 - u;
        return new Vector2((double)2 * iu * (c0.getX() - p0.getX()) + (double)2 * u * (p1.getX() - c0.getX()), (double)2 * iu * (c0.getY() - p0.getY()) + (double)2 * u * (p1.getY() - c0.getY()));
    }

    @NotNull
    public static final Vector3 derivative(@NotNull Vector3 x0, @NotNull Vector3 c0, @NotNull Vector3 x1, double t2) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t2;
        return new Vector3((double)2 * it * (c0.getX() - x0.getX()) + (double)2 * t2 * (x1.getX() - c0.getX()), (double)2 * it * (c0.getY() - x0.getY()) + (double)2 * t2 * (x1.getY() - c0.getY()), (double)2 * it * (c0.getZ() - x0.getZ()) + (double)2 * t2 * (x1.getZ() - c0.getZ()));
    }

    @NotNull
    public static final List<Double> roots(@NotNull List<Double> p) {
        Intrinsics.checkNotNullParameter(p, "p");
        if (p.size() == 3) {
            double c;
            double b;
            double a2 = ((Number)p.get(0)).doubleValue();
            double d = a2 - (double)2 * (b = ((Number)p.get(1)).doubleValue()) + (c = ((Number)p.get(2)).doubleValue());
            if (d != 0.0) {
                double m1 = -Math.sqrt(b * b - a2 * c);
                double m2 = -a2 + b;
                double v1 = -(m1 + m2) / d;
                double v2 = -(-m1 + m2) / d;
                return CollectionsKt.listOf(v1, v2);
            }
            if (b != c && d == 0.0) {
                return CollectionsKt.listOf((double)2 * b * c / ((double)2 * (b - c)));
            }
            return CollectionsKt.emptyList();
        }
        if (p.size() == 2) {
            double b;
            double a3 = ((Number)p.get(0)).doubleValue();
            return a3 != (b = ((Number)p.get(1)).doubleValue()) ? CollectionsKt.listOf(a3 / (a3 - b)) : CollectionsKt.emptyList();
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final Vector3 derivative(@NotNull Vector3 p0, @NotNull Vector3 p1, @NotNull Vector3 p2, @NotNull Vector3 p3, double t2) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        double it = 1.0 - t2;
        return p1.minus(p0).times(3.0 * it * it).plus(p2.minus(p1).times(6.0 * it * t2)).plus(p3.minus(p2).times(3.0 * t2 * t2));
    }

    @NotNull
    public static final Vector2 derivative(@NotNull Vector2 p0, @NotNull Vector2 p1, @NotNull Vector2 p2, @NotNull Vector2 p3, double t2) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        double it = 1.0 - t2;
        return p1.minus(p0).times(3.0 * it * it).plus(p2.minus(p1).times(6.0 * it * t2)).plus(p3.minus(p2).times(3.0 * t2 * t2));
    }

    @NotNull
    public static final Vector2 safeDerivative(@NotNull Vector2 p0, @NotNull Vector2 p1, @NotNull Vector2 p2, @NotNull Vector2 p3, double t2) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        double epsilon = 1.0E-5;
        double u = t2;
        Vector2 d10 = p1.minus(p0);
        Vector2 d32 = p3.minus(p2);
        if (u < epsilon && d10.getSquaredLength() < epsilon) {
            u = epsilon;
        }
        if (u > 1.0 - epsilon && d32.getSquaredLength() < epsilon) {
            u = 1.0 - epsilon;
        }
        double iu = 1.0 - u;
        return d10.times(3.0 * iu * iu).plus(p2.minus(p1).times(6.0 * iu * u)).plus(d32.times(3.0 * u * u));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Vector2 normal(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 x1, double t2) {
        void x;
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        Vector2 vector2 = BezierKt.derivative(x0, c0, x1, t2);
        double d = vector2.component1();
        double y = vector2.component2();
        return new Vector2(-y, (double)x).getNormalized();
    }

    @NotNull
    public static final Vector2 bezier(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 x1, double t2) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t2;
        double it2 = it * it;
        double t22 = t2 * t2;
        return new Vector2(it2 * x0.getX() + (double)2 * it * t2 * c0.getX() + t22 * x1.getX(), it2 * x0.getY() + (double)2 * it * t2 * c0.getY() + t22 * x1.getY());
    }

    @NotNull
    public static final Vector3 bezier(@NotNull Vector3 x0, @NotNull Vector3 c0, @NotNull Vector3 x1, double t2) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t2;
        double it2 = it * it;
        double t22 = t2 * t2;
        return new Vector3(it2 * x0.getX() + (double)2 * it * t2 * c0.getX() + t22 * x1.getX(), it2 * x0.getY() + (double)2 * it * t2 * c0.getY() + t22 * x1.getY(), it2 * x0.getZ() + (double)2 * it * t2 * c0.getZ() + t22 * x1.getZ());
    }

    public static final double bezier(double x0, double c0, double c1, double x1, double t2) {
        double it = 1.0 - t2;
        double it2 = it * it;
        double it3 = it2 * it;
        double t22 = t2 * t2;
        double t3 = t22 * t2;
        return it3 * x0 + 3.0 * it2 * t2 * c0 + 3.0 * it * t22 * c1 + t3 * x1;
    }

    @NotNull
    public static final Vector2 bezier(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 c1, @NotNull Vector2 x1, double t2) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t2;
        double it2 = it * it;
        double it3 = it2 * it;
        double t22 = t2 * t2;
        double t3 = t22 * t2;
        return new Vector2(it3 * x0.getX() + (double)3 * it2 * t2 * c0.getX() + (double)3 * it * t22 * c1.getX() + t3 * x1.getX(), it3 * x0.getY() + (double)3 * it2 * t2 * c0.getY() + (double)3 * it * t22 * c1.getY() + t3 * x1.getY());
    }

    @NotNull
    public static final Vector3 bezier(@NotNull Vector3 x0, @NotNull Vector3 c0, @NotNull Vector3 c1, @NotNull Vector3 x1, double t2) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t2;
        double it2 = it * it;
        double it3 = it2 * it;
        double t22 = t2 * t2;
        double t3 = t22 * t2;
        return new Vector3(it3 * x0.getX() + (double)3 * it2 * t2 * c0.getX() + (double)3 * it * t22 * c1.getX() + t3 * x1.getX(), it3 * x0.getY() + (double)3 * it2 * t2 * c0.getY() + (double)3 * it * t22 * c1.getY() + t3 * x1.getY(), it3 * x0.getZ() + (double)3 * it2 * t2 * c0.getZ() + (double)3 * it * t22 * c1.getZ() + t3 * x1.getZ());
    }

    @NotNull
    public static final <T extends LinearType<T>> T bezier(@NotNull T x0, @NotNull T c0, @NotNull T x1, double t2) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t2;
        double it2 = it * it;
        double t22 = t2 * t2;
        return x0.times(it2).plus(c0.times(2.0 * it * t2)).plus(x1.times(t22));
    }

    @NotNull
    public static final <T extends LinearType<T>> T bezier(@NotNull T x0, @NotNull T c0, @NotNull T c1, @NotNull T x1, double t2) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t2;
        double it2 = it * it;
        double it3 = it2 * it;
        double t22 = t2 * t2;
        double t3 = t22 * t2;
        return x0.times(it3).plus(c0.times((double)3 * it2 * t2)).plus(c1.times((double)3 * it * t22)).plus(x1.times(t3));
    }
}

