/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.CatmullRom2;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/openrndr/math/CatmullRomChain2;", "", "points", "", "Lorg/openrndr/math/Vector2;", "alpha", "", "loop", "", "(Ljava/util/List;DZ)V", "getLoop", "()Z", "segments", "Lorg/openrndr/math/CatmullRom2;", "getSegments", "()Ljava/util/List;", "position", "rt", "positions", "steps", "", "openrndr-math"})
public final class CatmullRomChain2 {
    @NotNull
    private final List<CatmullRom2> segments;
    private final boolean loop;

    @NotNull
    public final List<CatmullRom2> getSegments() {
        return this.segments;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> positions(int steps2) {
        void $this$mapTo$iv$iv;
        int n = 0;
        Iterable $this$map$iv = new IntRange(n, steps2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Vector2 vector2 = this.position((double)it / (double)steps2);
            collection.add(vector2);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List positions$default(CatmullRomChain2 catmullRomChain2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = catmullRomChain2.segments.size() * 4;
        }
        return catmullRomChain2.positions(n);
    }

    @NotNull
    public final Vector2 position(double rt) {
        double st = this.loop ? FunctionsKt.mod(rt, 1.0) : RangesKt.coerceIn(rt, 0.0, 1.0);
        double d = 0.99999999;
        boolean bl = false;
        int segmentIndex = (int)(Math.min(d, st) * (double)this.segments.size());
        double d2 = 0.99999999;
        boolean bl2 = false;
        double t2 = Math.min(d2, st) * (double)this.segments.size() - (double)segmentIndex;
        return this.segments.get(segmentIndex).position(t2);
    }

    public final boolean getLoop() {
        return this.loop;
    }

    /*
     * WARNING - void declaration
     */
    public CatmullRomChain2(@NotNull List<Vector2> points, double alpha, boolean loop2) {
        List list;
        CatmullRomChain2 catmullRomChain2;
        Intrinsics.checkNotNullParameter(points, "points");
        this.loop = loop2;
        CatmullRomChain2 catmullRomChain22 = this;
        if (!this.loop) {
            Collection<CatmullRom2> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<Vector2> startPoints = points.subList(0, 2);
            List<Vector2> endPoints = points.subList(points.size() - 2, points.size());
            Vector2 mirrorStart = CollectionsKt.last(startPoints).minus(CollectionsKt.first(startPoints)).getNormalized().times(-1.0);
            Vector2 mirrorEnd = CollectionsKt.last(endPoints).minus(CollectionsKt.first(endPoints)).getNormalized().times(-1.0);
            Iterable iterable = CollectionsKt.windowed$default(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(mirrorStart), (Iterable)points), (Iterable)CollectionsKt.listOf(mirrorEnd)), 4, 1, false, 4, null);
            CatmullRomChain2 catmullRomChain23 = catmullRomChain22;
            boolean $i$f$map = false;
            void var11_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List list2 = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                CatmullRom2 catmullRom2 = new CatmullRom2((Vector2)it.get(0), (Vector2)it.get(1), (Vector2)it.get(2), (Vector2)it.get(3), alpha);
                collection.add(catmullRom2);
            }
            collection = (List)destination$iv$iv;
            catmullRomChain2 = catmullRomChain23;
            list = collection;
        } else {
            Collection<CatmullRom2> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<Vector2> cleanPoints = this.loop && CollectionsKt.first(points).distanceTo(CollectionsKt.last(points)) <= 1.0E-6 ? CollectionsKt.dropLast(points, 1) : points;
            Iterable endPoints = CollectionsKt.windowed$default(CollectionsKt.plus((Collection)cleanPoints, (Iterable)CollectionsKt.take((Iterable)cleanPoints, 3)), 4, 1, false, 4, null);
            CatmullRomChain2 catmullRomChain24 = catmullRomChain22;
            boolean $i$f$map = false;
            void mirrorEnd = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List $i$f$mapTo2 = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                CatmullRom2 catmullRom2 = new CatmullRom2((Vector2)it.get(0), (Vector2)it.get(1), (Vector2)it.get(2), (Vector2)it.get(3), alpha);
                collection.add(catmullRom2);
            }
            collection = (List)destination$iv$iv;
            catmullRomChain2 = catmullRomChain24;
            list = collection;
        }
        catmullRomChain2.segments = list;
    }

    public /* synthetic */ CatmullRomChain2(List list, double d, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(list, d, bl);
    }
}

