/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.ScalarsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u001a \u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a&\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a.\u0010\t\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\n\u001a\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u001e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\n\u001a\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a&\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\n\u001a\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DISCRIMINANT_EPSILON", "", "EPSILON", "MACHINE_EPSILON", "SOLUTION_EPSILON", "discriminant", "a", "b", "c", "solveCubic", "", "d", "", "acc", "solveLinear", "solveQuadratic", "split", "n", "trim", "len", "openrndr-math"})
public final class EquationsKt {
    private static final double DISCRIMINANT_EPSILON = 1.0E-10;
    private static final double SOLUTION_EPSILON = 1.0E-8;
    private static final double MACHINE_EPSILON = Math.ulp(1.0);
    private static final double EPSILON = 1.0E-14;

    /*
     * WARNING - void declaration
     */
    private static final double[] trim(double[] acc, int len) {
        double[] dArray;
        if (len == acc.length) {
            dArray = acc;
        } else if (len == 0) {
            dArray = new double[]{};
        } else {
            void var2_2;
            double[] result2 = new double[len];
            System.arraycopy(acc, 0, result2, 0, len);
            dArray = var2_2;
        }
        return dArray;
    }

    private static final double[] split(double n) {
        double x = n * (double)0x8000001;
        double y = n - x;
        double hi = y + x;
        double lo = n - hi;
        return new double[]{hi, lo};
    }

    private static final double discriminant(double a2, double b, double c) {
        double D2 = b * b - a2 * c;
        double E = b * b + a2 * c;
        if (StrictMath.abs(D2) * (double)3 < E) {
            double[] ad = EquationsKt.split(a2);
            double[] bd = EquationsKt.split(b);
            double[] cd = EquationsKt.split(c);
            double p = b * b;
            double dp = bd[0] * bd[0] - p + (double)2 * bd[0] * bd[1] + bd[1] * bd[1];
            double q = a2 * c;
            double dq = ad[0] * cd[0] - q + ad[0] * cd[1] + ad[1] * cd[0] + ad[1] * cd[1];
            D2 = p - q + (dp - dq);
        }
        return D2;
    }

    public static final int solveLinear(double a2, double b, @NotNull double[] acc) {
        int n;
        Intrinsics.checkNotNullParameter(acc, "acc");
        if (StrictMath.abs(a2) < 1.0E-14) {
            n = 0;
        } else {
            acc[0] = -b / a2;
            n = 1;
        }
        return n;
    }

    @NotNull
    public static final double[] solveLinear(double a2, double b) {
        double[] acc = new double[1];
        return EquationsKt.trim(acc, EquationsKt.solveLinear(a2, b, acc));
    }

    /*
     * WARNING - void declaration
     */
    public static final int solveQuadratic(double a2, double b, double c, @NotNull double[] acc) {
        int n;
        double k;
        double D2;
        Intrinsics.checkNotNullParameter(acc, "acc");
        double a3 = a2;
        double b2 = b;
        double c2 = c;
        if (StrictMath.abs(a3) < 1.0E-14) {
            return EquationsKt.solveLinear(b2, c2, acc);
        }
        b2 *= -0.5;
        if ((D2 = EquationsKt.discriminant(a3 *= (k = ScalarsKt.normalizationFactor(a3, b2, c2)), b2 *= k, c2 *= k)) >= -1.0E-10) {
            double Q = D2 < 0.0 ? 0.0 : StrictMath.sqrt(D2);
            double R = b2 + (b2 < 0.0 ? -Q : Q);
            if (R == 0.0) {
                acc[0] = c2 / a3;
                acc[1] = -c2 / a3;
            } else {
                acc[0] = R / a3;
                acc[1] = c2 / R;
            }
            int writeIdx = 0;
            boolean bl = false;
            boolean bl2 = true;
            while (bl <= bl2) {
                void readIdx;
                double x = acc[readIdx];
                double y = a3 * x * x + (double)-2 * b2 * x + c2;
                if (StrictMath.abs(y) < 1.0E-8) {
                    acc[writeIdx++] = x;
                }
                ++readIdx;
            }
            n = writeIdx;
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public static final double[] solveQuadratic(double a2, double b, double c) {
        double[] acc = new double[2];
        return EquationsKt.trim(acc, EquationsKt.solveQuadratic(a2, b, c, acc));
    }

    /*
     * WARNING - void declaration
     */
    public static final int solveCubic(double a2, double b, double c, double d, @NotNull double[] acc) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        double a3 = a2;
        double b2 = b;
        double c2 = c;
        double d2 = d;
        double k = ScalarsKt.normalizationFactor(a3, b2, c2, d2);
        a3 *= k;
        b2 *= k;
        c2 *= k;
        d2 *= k;
        double x = 0.0;
        double b1 = 0.0;
        double c22 = 0.0;
        double qd = 0.0;
        double q = 0.0;
        if (StrictMath.abs(a3) < 1.0E-14) {
            return EquationsKt.solveQuadratic(b2, c2, d2, acc);
        }
        if (StrictMath.abs(d2) < 1.0E-14) {
            b1 = b2;
            c22 = c2;
            x = 0.0;
        } else {
            double td;
            double rd;
            x = -(b2 / a3) / (double)3;
            b1 = a3 * x + b2;
            c22 = b1 * x + c2;
            qd = (a3 * x + b1) * x + c22;
            q = c22 * x + d2;
            double t2 = q / a3;
            double r = StrictMath.pow(StrictMath.abs(t2), 0.3333333333333333);
            double s2 = t2 < 0.0 ? (double)-1 : 1.0;
            double x0 = x - s2 * (rd = (td = -qd / a3) > 0.0 ? 1.324717957244746 * StrictMath.max(r, StrictMath.sqrt(td)) : r);
            if (x0 != x) {
                do {
                    x = x0;
                    b1 = a3 * x + b2;
                    c22 = b1 * x + c2;
                    qd = (a3 * x + b1) * x + c22;
                    q = c22 * x + d2;
                } while (s2 * (x0 = qd == 0.0 ? x : x - q / (qd / (1.0 + MACHINE_EPSILON))) > s2 * x);
                if (StrictMath.abs(a3) * x * x > StrictMath.abs(d2 / x)) {
                    c22 = -d2 / x;
                    b1 = (c22 - c2) / x;
                }
            }
        }
        int solutions = EquationsKt.solveQuadratic(a3, b1, c22, acc);
        int n = 0;
        int n2 = solutions;
        while (n < n2) {
            void i;
            if (acc[i] == x) {
                return solutions;
            }
            ++i;
        }
        double y = a3 * x * x * x + b2 * x * x + c2 * x + d2;
        if (StrictMath.abs(y) < 1.0E-8) {
            acc[solutions++] = x;
        }
        return solutions;
    }

    @NotNull
    public static final double[] solveCubic(double a2, double b, double c, double d) {
        double[] acc = new double[3];
        return EquationsKt.trim(acc, EquationsKt.solveCubic(a2, b, c, d, acc));
    }
}

